programName = 'ezCon260214a.py'
programRevision = programName

# ezRA - Easy Radio Astronomy ezCon Data CONdenser program,
#   CONdense one or more frequency spectrum data .txt files into
#   one .ezb text data file, and perhaps GALaxy *Gal.npz and *GLon.npz data files.
# https://github.com/tedcline/ezRA

# Copyright (c) 2026, Ted Cline   TedClineGit@gmail.com

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 3
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

# TTD:
#   dataTimeUtcVlsr2000.mjd = 51544.0
#   add antXTVTCmDop to ezCon191 ?



#check thinning, need raw ?
#createRef
#ezCon089 X axis values

# ezCon260214a, -ezCon087Csv 4 to create a simpler CSV file format for plotly,
#       py  ..\ezRA\ezCon260214a.py  data  -ezCon087Csv  4  -ezConPlotRangeL  87  87
#   then  to process that   ezCon087antRBTVTMsh.csv   file, run
#       py  ..\ezRA\ezPlotly260214b.py
#   to create
#       http://127.0.0.1:52442/
#   then right click to   Save As   to an .html file

# ezPlotly260214a, -ezCon087Csv 4 to create simpler CSV file format for plotly
# ezPlotly260212a, inspired by AyushmanTripathi2602011-hline_3d_interactive.html,
#   the accompanying MathJax.js.download file uses https://en.wikipedia.org/wiki/MathJax,
#   tweaked ezCon087Csv code in ezCon087
#   run
#       py  ..\..\ezPlotly260212a.py  data  -ezCon087Csv 1  -ezConPlotRangeL 87 87
#   then
#       py ..\..\ezPlotly260212a.py -h
#   to create
#       http://127.0.0.1:52442/
#   then right click to Save As to an .html file

# ezCon260122a, massive dusting
# ezCon260121b
# ezCon260121a
# ezCon260118a, combined many into createRefOneRef()
# ezCon260117b
# ezCon260117a, -ezConRefMode31 rearrangement ignored ref samples
# ezCon260115a, ezConAntMaxPluckValL
# ezCon260114a
# ezCon260112b, messy plotEzCon2dSamples() code 
#   but ezCon089 and ezCon099 work? and xticklabels are better
# ezCon260112a, -ezConAntXTVTIntegrate mostly works creating ezCon089 and ezCon099,
#   but xlabels and xticklabels are wrong
# ezCon260111a, ezConAntXTVTFreqBinsClipUpdate flag, :0.2f to rawPlotPrep()
# ezCon260110b
# ezCon260110a
# ezCon260109a, -ezConAntXTVTFreqBinsClipL broke *Gal.npz file frequencies ?
# ezCon260108a, ezCon386, ezCon396 before ezConAntXTVTFreqBinsClipDo()
# ezCon260107a, -ezConAntXTVTFreqBinsClipL,
#   how does freqCenterRaw get to be zero during ezCon000 ????????
# ezCon260106a, ezCon382 gets freqCenter into xlabel
#   freqRaw bug in ezConRawFreqBinTrimLDo ??
# ezCon260104a, -ezConRefMode31 requires raH earlier so
#   split createEzConOutEzb() into createEzConOutEzbA() and createEzConOutEzbB()
# ezCon260103c, -ezConRefMode31 experiments, ezCon088 and ezCon098 gain to 0.1
# ezCon260103b, createRefXByFreqBinAvg for -ezConRefMode 40 and 41 and 44 and 45,
#   ezCon391, ezCon392, fixed several antBT to antXT
#   moved ezCon393 to ezCon394antXTVByFreqMax, created new ezCon393antXTByFreqMax
#   createRef05minimumAntAvg(), createRef07minimumAntBAvg()
# ezCon260102a, createRef05minimumAntAvg for -ezConRefMode 5
# ezCon251227a, if 1 < refQty: ezConAntXInput = 6
# ezCon251205a, -ezCon087Csv to allow long write lines twice
# ezCon251204a, ezCon301B Ant horizontal blue and violet lines, -ezConAntXTVTClipL, -ezConAddMHz
# ezCon251129a, ezCon382 moved y-axis labels to the right
# ezCon251123a, added -ezConAzDeg and -ezConElDeg
# ezCon251120a, when antXTByFreqBinSumAvgSpanD100 is 0 the frequency of {antXNameL[1]}T did not change
# ezCon251119a, -ezConRawLog experiments, always plot ezCon000 and ezCon200 and ezCon300,
#   -ezConHeatVMinMaxL into commandString
# ezCon251118a, set value to -ezConRawFreqBinTrimL and -ezConRawFreqTrimL
# ezCon251117c
# ezCon251117b, -ezConRawFreqBinTrimL, -ezConRawFreqTrimL
# ezCon251116a, ezCon382 rotated 180 degrees to match ezCon081
# ezCon251111a, allow ezConRawFreqBinHideL1 < ezConRawFreqBinHideL0
#    to now allow ezConRawFreqBinHideL unsorted to hide by decreasing freqBin,
#   -ezConAntFreqBinHide and -ezConAntFreqBinHideL,
#   -ezConRefFreqBinHide and -ezConRefFreqBinHideL
# ezCon251110a, freqAntMax
# ezCon251109b, renamed to ezCon301A, ezCon301B with ezConRefMode30L vertical lines
# ezCon251109a, -ezConRefMode30L plots, freqRawPlot, freqCenterRaw, freqCenterRef, dusting,
#   if first character of command word is '#' rest of line is a comment,
#   cmdDirectoryS also into ezConArgumentsFile()
# ezCon251108a, -ezConRefMode30L plots
# ezCon251106a, -ezConRefMode30L freqAnt freqRef bwAnt = Ant beside Ref in each Raw sample,
#   but now Raw bw not equal to Ant and Ref bw
# ezCon251101a, correct -ezConInputdBm to -ezConInputdB
# ezCon251025a, -ezConRawFreqBinHideL
# ezCon250915a, dusting, ezConGalNormalize with max from only gLonP180 180 to 361
# ezCon250914b, dusting
# ezCon250914a, commandString enhancements
# ezCon250913a, ezConGalNormalize,
#   reordered and clarified writeFileGalRaDecNear() writeFileGal() and writeFileGLon(),
#   enforced writeFileGalRaDecNear() and "and only gLonP180 = 0 is written"
#       (appropriate for point-like sky sources),
#   ezConGalNormalize = 1 is probably near 0.0, maybe use mean of used ?
# ezCon250910a, if ezCon510 then write velPowerMax float value into filename like
#   rqv8ezb220218_00a_p3.158891.velPowerMax
#   changed filename ezConStudyrqv8ezb220218_00a.txt to rqv8ezb220218_00a_ezConStudy.txt
#   changed Gal.npz and GLon.npz filenames to use small 'p' and 'n' for sign:
#        rqv8ezb220218_00aP00.0Gal.npz to rqv8ezb220218_00ap00.0Gal.npz
#   enhanced ezConAntXTVTLevelL to 4 values to now multiply and add and divide by and subtract
# ezCon250831a, ezConInputdBm now changes sign of AntB, oops corrected the signs
# ezCon250822a, ezConInputdBm now changes sign of AntB
# ezCon250821a, ezConAntPluckLDo() and if antLen < ezConAntPluckThis
# ezCon250817a, small number 1e-14 too big so use 1e-30
# ezCon250711a, cmdLineSplit ezConGalCrossingGLonCenter can be float
# ezCon250703a, dataFileIdx, plotEzCon201ZantFileIndex(), studyOutString improvements
# ezCon250522a, ezConRawFreqBinHideLDo() hide with freqBin neighbor having lowest average,
#   -ezDefaultsEnd, added 300 to ezConPlotAllL
# ezCon250409a, corrected RaHThis and DecDegThis to raHThis and decDegThis
# ezCon250329a, *Gal.npz file definition from here, ezCon's writeFileGal()
# ezCon250326a, column 9 AntXTVTCmDop Center-of-Mass of the Doppler shift,
#   code from old ezCon220823a,
#   now officially defined in ezbMenu: AzimuthDeg, ElevationDeg, and AntXTVTCmDop as columns 7, 8, and 9
#   plotEzCon198azimuth()   renamed plotEzCon107azimuth()      for azimuthDeg,
#   plotEzCon199elevation() renamed plotEzCon108elevation()    for elevationDeg,
#   new ........................... plotEzCon109antXTVTCmDop() for antXTVTCmDop
# ezCon250323a, Python 3.13 or new Astropy demands locBaseValid flag,
#   dataTimeUtcThis typo in glatdeg
# ezCon250312a, if ezCon087Csv is 2 then downsample antXTVTCsv before ifAvg format files
# ezCon250303a, writeFileGalRaDecNear() remember gLon in RGal.npz,
#   ring bell upon error exit (to alert operator during batch file runs)
# ezCon250302a, -ezConGalRaDecNearNearL for M31 extragalactic study, creates RGal.npz
# ezCon250124b, ezCon087Csv swap X and Y
# ezCon250124a, -ezConAntXTVTSmooth
# ezCon250123b, ezConAntXTVTSmoothDo()
# ezCon250123a, ezConAntXTVTSmoothDo()
# ezCon250122d, -ezCon087Csv 1 ezCon087antRBTVTMsh.csv
# ezCon250122c, -ezCon087Csv 1 ezCon087antRBTVTMsh.csv
# ezCon250122b, -ezCon087Csv 2 dirOut = plotName
# ezCon250122a, average into fewer ifAvg format files
# ezCon250121a, -ezCon087Csv 2 to also write out ezCon087 as one directory of ifAvg format files
# ezCon241024a, writeFileGLon() to before del antXTVT
# ezCon241021a, -ezCon087Csv plot scales
# ezCon241019ax, -ezCon087Csv
#   to see AntRB, to disable TVT, use -ezConAntXTFreqBinsFracL 0 1 -ezConUseVlsr 0 -ezConAntXTVTFreqBinsFracL 0 1
#       python3 ../ezRA/ezCon241019ax.py data/LTO16230416_00.txt -ezConPlotRangeL 87 87  -ezConAntXInput 6
#           -ezConAntXTFreqBinsFracL 0 1  -ezConUseVlsr 0  -ezConAntXTVTFreqBinsFracL 0 1  -ezCon087Csv 1 
#       created 72MB ezCon087antRBTVT.csv file
#   https://www.rinearn.com/en-us/graph3d/guide/launch
#   then in the directory of the 220K RinearnGraph3D.jar file,
#       java -jar RinearnGraph3D.jar
#           and 20 seconds to render 3d plot of 24-hour 3,932 Ant samples
#   sudo cp -r rinearn_graph_3d_5_6_36b_en /usr/local/bin
#   sudo chmod +x /usr/local/bin/rinearn_graph_3d_5_6_36b_en/rinearn_graph_3d_5_6_36b_en/bin/ring3d
#   ls -lh /usr/local/bin/rinearn_graph_3d_5_6_36b_en/rinearn_graph_3d_5_6_36b_en/bin/ring3d
#   nano ~/.bashrc
#       and add
#   export PATH="$PATH:/usr/local/bin/rinearn_graph_3d_5_6_36b_en/rinearn_graph_3d_5_6_36b_en/bin/"
#   log out and log in
#   now command line
#       ring3d --help
#   or command line
#       ring3d --version
#           RINEARN Graph 3D Ver.5.6.36
#   or command line
#       ring3d ezCon087antRBTVT.csv 
#   or command line
#       ring3d ezCon087antRBTVT.csv --overwrite --saveimg ezCon087antRBTVTCsv.png --quit
#   or command line
#       ring3d
# ezCon241018bx, for 3d plots with https://www.rinearn.com/en-us/
#   ezCon087 antXTVT to a .csv file
# ezCon240811a, -ezConAntXTVTFixL to -ezConAntXTVTLevelL
# ezCon240809b, more of "plot if plotNumber not in ezConPlotRequestedL: return(1)"
# ezCon240809a, -ezConAntXTVTFixL hidden in help
#   from ezCon240725a support multiple -ezConPlotRangeL,
#   plot if plotNumber in ezConPlotRequestedL
# ezCon240803a, -ezConAntXTVTFixL
# ezCon240802a, -ezConAntXMult
# ezCon240730a, yTickHeatL and ezCon0* y scale for 10 MHz Airspy
# ezCon240724a, ezCon0* y scale for 10 MHz Airspy
# ezCon240723a, ezCon0* y scale for 10 MHz Airspy
# ezCon240615b, frequency study % warnings also to AntXT
# ezCon240615a, frequency studies to near bottom of ezConStudy file using OutFreqString
# ezCon240613a, dusting
# ezCon240610a, Doppler to Yscale of ezCon382,
#   added to studyOutString for top of ezConStudy file
# ezCon240609b, remove "Bin" from all plot filenames
# ezCon240609a, dusting,
#   ezCon088antBTVTByFreqBinAllFall.png    to ezCon088antBTVTByFreqBinAvgFall.png (name change),
#   ezCon098antBTVTMaxByFreqBinAllFall.png to ezCon098antBTVTByFreqBinMaxFall.png (name change),
#   ezCon388antBTVTByFreqBinAll.png        to ezCon388antBTVTByFreqBinAvgAll.png  (name change),
#   ezCon397antBTVTMaxByFreqBin.png        to ezCon397antBTVTByFreqBinMax.png     (name change),
#   ezCon398antBTVTMaxByFreqBinAll.png     to ezCon398antBTVTByFreqBinMaxAll.png  (name change),
#   ezCon198azimuthDeg.png                 to ezCon198azimuth.png                 (name change),
#   ezCon392antXTVByFreqBinMax.png         to ezCon393antXTVByFreqBinMax.png      (number change),
#   plotCountdown -= 1 in ezCon690,
#   ezCon690GLonDegP180_nnnByFreqBinAvg.png to
#       to 'ezCon690_nnnGLonDegPnnnByFreqBinAvg.png'
#       or 'ezCon690_nnnGLonDegMnnnByFreqBinAvg.png'
#   plotEzCon690gLonDegP180_nnnByFreqBinAvg() to plotEzCon690gLonDegByFreqAvg()
# ezCon240603b, dusting
# ezCon240603a, spectrum fractions to ezCon382
# ezCon240601a, dusting
# ezCon240420a, wallLTO horizon, azDeg bug and capitalization
# ezCon240420a, wallLTO horizon, azDeg bug and capitalization
# ezCon240419a, sys.version
# ezCon240412b, dusting
# ezCon240412a, ezCon088 and antXTVTDLen = min(antLen, antXTVTDLenMax) for less than 100 samples
# ezCon240308a, dusting
# ezCon240225b, support for negative power values,
#   -ezConInputdBm
# ezCon240225a, changed ezRA .txt file format
#       from 'az x.xx el y.yy' also support new 'azDeg x.xx elDeg y.yy',
#       and from (unposted) 'ra x.xx dec y.yy' to 'raH x.xx decDeg y.yy',
#       and from (unposted) 'glat y.yy glon x.xx' to 'gLatDeg y.yy gLonDeg x.xx',
#       so will need updates to ezCon240219b.py and ezColGNSM240219d.py,
#   dropping support for 'c' (Calibration) last data word
# ezCon240219b, support negative power values
# ezCon240219a, with ezColGNSM why AntXTVT inverted ?  Due to negative power values, antXUsedMin,
#   ezConUseSubRef to ezConUseRefSub to match ezCol
# ezCon240204b, explore poor ezSky405 and ezSky505 images
#   data/Skynet_60333_barnard_33-nb_107271_56634.A.cal.txt says in part:
#     #UTC_Time(s)   Ra(deg)  Dec(deg)   Az(deg)   El(deg)        XX1        YY1        XX2        YY2  Cal   Sweeps 
#     11992.000000  83.06220   -4.6685  193.4920   45.8379   136.3469   137.4065   123.8188   148.3731  -1    0  0 
#
#   data/Skynet_60333_barnard_33-nb_107271_56634.A.cal5Az.txt says in part:
#     from ezColGB20m240203a.py
#     lat 38.4368 long -79.8255 amsl 853 name GB20m
#     freqMin 1406.26 freqMax 1421.88 freqBinQty 256
#     #UTC_Time(s)   Ra(deg)  Dec(deg)   Az(deg)   El(deg)        XX1        YY1        XX2        YY2  Cal   Sweeps 
#     az 193.492 el 45.8381
#     2024-01-24T03:19:54.415924 135.4985 135.4985 135.4985 ...
#
#   data/Skynet_60333_barnard_33-nb_107271_56634.A.cal5Ra.txt says in part:
#     from ezColGB20m240203a.py
#     lat 38.4368 long -79.8255 amsl 853 name GB20m
#     freqMin 1406.26 freqMax 1421.88 freqBinQty 256
#     #UTC_Time(s)   Ra(deg)  Dec(deg)   Az(deg)   El(deg)        XX1        YY1        XX2        YY2  Cal   Sweeps 
#     ra 5.53815 dec -4.6683
#     2024-01-24T03:19:54.415924 135.4985 135.4985 135.4985 ...
#
#   Skynet_60333_barnard_33-nb_107271_56634.A.cal5Ra.ezb says in part:
#     #   from ezCon240202a.py
#     #   ../ezRA/ezCon240202a.py  data/Skynet_60333_barnard_33-nb_107271_56634.A.cal5Az.txt  -ezConPlotRangeL  191  191
#     lat 38.4368 long -79.8255 amsl 853.0 name GB20m
#     freqMin 1406.26 freqMax 1421.88 freqBinQty 256
#     ezbMenu: TimeUtcMjd  RaH  DecDeg  GLatDeg  GLonDeg  VLSR  Count  Spare1  Spare2  AntXCMDop    AntAvg  AntMax    RefAvg  RefMax    AntBAvg  AntBMax    #   AntRBAvg  AntRBMax    antXTVTAvg  antXTVTMax
#     #          0           1    2       3        4        5     6      7       8       9            10      11        12      13        14       15         16        17          18           19
#     60333.13882 5.581 -4.859 -19.223 -151.516 3.494e+01 1 193.5 45.8 0.00000e+00 1.35498e+02 1.35499e+02 1.35498e+02 1.35499e+02 1.00000e+00 1.00000e+00 1.00000e+00 1.00000e+00 1.00000e+00 1.00000e+00
#   ... and yet, even with 5-fractional-digit-precision output from ezColGB20m,
#       Skynet_60333_barnard_33-nb_107271_56634.A.cal.txt gives differing X and Y use limits
#       in ezSky405 plots when using GM20m AzEl vs RaDec coordinate columns !
# ezCon240204a, explore astropy azEl to raDec to azEl to raDec to azEl dithering, = good
# ezCon240203a, "ra" line input to dataRightAscensionH
# ezCon240202a, "ra" line input
# ezCon240131b,
#   azimuth, elevation to azimuthDeg, elevationDeg,
#   ezConAstroMath == 2:
#       "ra"   line input
#       "glat" line input
#   dusting
# ezCon240131a, support .txt files with any sky coordinate type,
#       az 227.9 el 42.7
#       ra 22.9 decl 42.7
#       glat 42.7 glon 227.9
#   dataAzimuth, dataElevation, dataElevationRef to dataAzimuthDeg, dataElevationDeg, dataElevationRefDeg
# ezCon240108a, ezCon191 Ant to AntXTVT top-bottom order reversed
# ezCon240107a, Copyright (c) 2024
# ezCon240106b, fixed some Pluck routines
# ezCon240106a, fixed some Pluck routines
# ezCon240105b.py, ezConAntSamplePluck to ezConAntPluck,
#   fixed some Pluck routines
# ezCon240105a.py, dusting, added HH:MM to studyTime() OutString
# ezCon240104a.py, "Snip" might mean shorten, so replaced almost all "Snip" with "Pluck",
#   like   -ezConAntXTVTMaxPluckQtyL and -ezConAntXTVTAvgPluckQtyL,
#   added  -ezConAntXTVTMaxPluckValL and -ezConAntXTVTAvgPluckValL and -ezConAntXTVTPluck,
#   revised ezConAntXTVTMaxPluckDo() and  ezConAntXTVTAvgPluckDo() and  ezConAntXTVTPluckDo(),
#   removed "rawLen-refQty ="
# ezCon240101a.py, ezConAntXTVTMaxSnipQtyL before ezConAntXTVTAvgSnipQtyL,
#   antLen ?= rawLen-refQty
# ezCon231231a.py, fileRawLen
# ezCon231213b.py, plot antXTV and antXTVT after filtering antXTVT
# ezCon231213a.py, ezCon098 and ezCon398 'Downsampled by Maxing',
#   removed dead ezCon386
# ezCon231212c.py, per Ted's Oct 18, 2023 at 8:14 PM email,
#   ezCon511 renamed to ezCon519, to align with the future ezGal519,
#   ezCon521 renamed to ezCon529, to align with the future ezGal529,
#   ezCon560 renamed to ezCon800, to avoid alignment with the ezGal560 Galactic angular velocity plot,
#   ezCon382 now FreqBin increases down
# ezCon231212b.py, continued,
#   ezCon386 to ezCon088antXTVTByFreqBinAllFall    Spectra, Downsampled by Averaging with Time Increasing Down
#               ezCon098antXTVTMaxByFreqBinAllFall Spectra, Downsampled by Averaging with Time Increasing Down
#   ezCon382 to ezCon383antXTVByFreqBinAvg
#   ezCon388 to ezCon382antXTByFreqBinAvgRfi
#   ezCon389 to ezCon388antXTVTByFreqBinAll    Spectra, Downsampled by Averaging
#   ezCon397 to ezCon397antXTVTMaxByFreqBin
#               ezCon398antXTVTMaxByFreqBinAll Spectra, Downsampled by Averaging
# ezCon231212a.py, continued
# ezCon231211b.py, continued
# ezCon231211a.py, 
#   -ezConAntXTVTAvgSnipQtyL,
#   -ezConAntXTVTMaxSnipQtyL
# ezCon231210a.py, 
#   ezCon386 AntXTVT Spectra, Downsampled by Averaging with Time Increasing Up
#   ezCon389 AntXTVT Spectra, Downsampled by Averaging
# ezCon231209a.py, ezConAstroMath default to 1 (seems to work for me)
#   ezSky200 AntXTVT violet needs      best contrast, use green
#   ezSky200 AntB           needs next best contrast, use red
#       AntXTVT violet   becomes newgreen
#       Ref     red      becomes violet
#       AntB    green    becomes red
#               newgreen becomes green
# ezCon231202a.py, ezCon389 had ezCon398 typo
# ezCon231108a.py, hid help of (unfinished??) -ezConUseSubRef,
#   ezCon389antXTVTByFreqBinAll(),
#   ezCon392antXTVByFreqBinMax()
# ezCon231002a.py, -ezConUseSubRef
# ezCon230824a.py, print ezConPlotRangeL in printGoodbye(),
#   trouble using -ezConAntAvgSnipQtyL so always create xTickLabelsHeatAntL
# ezCon230820a.py, removed 'Galaxy plane' from ezCon520 ezCon521 and ezCon690
# ezCon230817c.py, ezCon337 and ezCon357 filenames from Avg to Max
#   ezCon191 plt.yticks from GLatDeg to GLat
# ezCon230806b.py, ezCon399SignalSampleByFreqBinL
# ezCon230806a.py, ezCon399SignalSampleByFreqBinL
# ezCon230728a.py, extracted ezConAntSampleSnipL from
#   ezConAntSamplesUseLDo() into new last Ant filter ezConAntSampleSnipLDo()
# ezCon230629a.py, removed ezConGalCrossingGLatCenterSnap and ezConGalCrossingGLonCenterSnap,
#   output filenames *Nxx.xGal.npz and *Pxx.xGal.npz,
#   output filenames *Nxxx.xGLon.npz and *Pxxx.xGLon.npz
# ezCon230628a.py,
#   ezConGalCrossingGLatCenterL and ezConGalCrossingGLatNear and
#   ezConGalCrossingGLonCenterL and ezConGalCrossingGLonNear are now all floats,
#   but ezConGalCrossingGLonCenterSnap and ezConGalCrossingGLonCenterSnap are integers
# ezCon230627a.py,
# ezCon230625a.py, ezConGalCrossingGLat duplicated with ezConGalCrossingGLatNear
#   added ezConGalCrossingGLonNear and ezConGalCrossingGLonCenterL
# ezCon230624a.py, ezConGalCrossingGLatCenterL to int degrees
#   output filenames *NxxGal.npz and *PxxGal.npz
# ezCon230623a.py, ezConGalCrossingGLatCenterL internally, and -ezConGalCrossingGLatCenterL,
#   output filenames *Nxx.xGal.npz and *Pxx.xGal.npz
# ezCon230610a.py, ezConGalCrossingGLatCenter help typo
# ezCon230603a.py, 'Doppler MHz from' only with samples from Ant
# ezCon230527a.py, ezConGalCrossingGLatCenter, gLatDegThis now a float,
#   ezCon027 no longer says 'Ref:  Doppler MHz from 1420.400 MHz'
# ezCon230410a.py, ezConVelGLonEdgeLevel, ezConGalCrossingGLat
# ezCon230408a.py, commented ezConVelGLonEdgeLevel
# ezCon230407a.py, ezCon105 "receding Velocity of the Local Standard of Rest (VLSR)"
# ezCon230406a.py, -eX
# ezCon230401a.py, from AntXTV changed to AntXTVT into velGLonP180[,],
#   added antXTVTName=antXNameL[1]+'TVT' to *Gal.npz file
# ezCon230323a.py, more ezCon082antXTV formula comments
# ezCon230316c.py, different gst() to fix ezConAstroMath=1 right ascension, fixed -eX
# ezCon230316b.py, ezConAstroMath=1 right ascension
# ezCon230316a.py, ezCon082antXTV formula comments, -eX
# ezCon230314a.py, more AntX choices and improved names and separate filenames,
#   ezConAntXTFreqBinsFracL and ezConAntXTVTFreqBinsFracL defaults
# ezCon230313c.py, ezConAstroMath=1 right ascension
# ezCon230313b.py, ezConAstroMath=1 right ascension
# ezCon230313a.py, ezConAstroMath=1 right ascension
# ezCon230311a.py, commented VLSR prints
# ezCon230310a.py, ezConAstroMath=2 VLSR
# ezCon230309a.py, ezConAstroMath=2 VLSR was Barycentric radial velocity only,
# ezCon230305a.py, boilerplate from ezSky
# ezCon230304a.py, help: 'remove' to 'ignore'
# ezCon230303a.py, improved ezConAntFreqBinSmooth help and comments
# ezCon230302a.py, freqBin study to plotEzCon307antByFreqBinAvg() and plotEzCon327refByFreqBinAvg(),
#   always plotCountdown-=1, print plotting {plotName} only if intending to plot
# ezCon230301a.py, ezConAntAvgSnipNumL to ezConAntAvgSnipQtyL, ezConRefAvgSnipNumL to ezConRefAvgSnipQtyL, 
#   ezConAntAvgKeepFracL to ezConAntAvgSnipFracL, ezConRefAvgKeepFracL to ezConRefAvgSnipFracL,
#   timeUtcMjdDBetweenAnt to timeUtcMjdDBetweenAntRaw, timeUtcMjdDBetweenRef to timeUtcMjdDBetweenRefRaw
# ezCon230228a.py, ezConAntSamplesUseLDo() now forces new xTickLabelsHeatAntL
# ezCon230226e.py, antLen cleanup, works, need a VLSR
# ezCon230226d.py, ezConAntAvgSnipNumL = [] to disable
# ezCon230226d.py, ezConAntAvgKeepFracL = [] to disable
# ezCon230226c.py, update ezConRefAvgTrimFracL parts to ezConRefAvgKeepFracL
# ezCon230226b.py, update ezConRefAvgTrimFracL parts to ezConRefAvgKeepFracL
# ezCon230226a.py, ezConAntAvgTrimFracL to ezConAntAvgKeepFracL, works with "0 0.9999999",
#   ezConAntSamplesUseLDo() and ezConAntAvgKeepFracLDo() now force new xTickLocsAnt
# ezCon230225a.py, in ezConAntAvgTrimFracLDo antAvgTrimMask trimming 2 extra so change < to <=
# ezCon230223a.py, optional ezCon201GrawAntRef connecting lines for ant and ref
# ezCon230209a.py, for ezCon520velGLonPolar.png and ezCon521velGLonPolarCount.png,
#   "MatplotlibDeprecationWarning: Auto-removal of grids by pcolor() and
#   pcolormesh() is deprecated since 3.5 and will be removed two minor releases later;
#   please call grid(False) first.", so put "plt.grid(0)" in front of each "im = plt.pcolormesh("
# ezCon221202a.py, ezConAstroMath=1 calculates wrong Right Ascension values,
#   default changed to the slower ezConAstroMath=2
# ezCon221126a.py, if not start with '-ezCon', allow unrecognized words on command line
# ezCon221125a.py, to ezCon690gLonDegP180_nnnByFreqBinAvg, and to X axis using -byFreqBinX
# ezCon221122a.py, ezCon560antXTVTMaxIdxGLon
# ezCon221121a.py, avoid div by 0 when creating antRA,
#   create antRA only once
# ezCon221118a.py, "Galaxy Crossing" to "Galaxy Plane"
# ezCon221116a.py, add ezCon317, ezCon337, ezCon357, ezCon377, and ezCon397
# ezCon221112a.py, help typo
# ezCon221111a.py, experimentEzc for AzEl into .ezb Spare1 and Spare2,
#   commented openFileSdre() and writeFileSdre(),
#   fixed 'FATAL ERROR:  ezRAObsLon' typo
# ezCon221027a.py, "ezRAObsLat = -999.0 is silly" testing to later
# ezCon221017a.py, tilted xlabel
# ezCon221016a.py, renamed ezCon5xx to match ezGal5xx, polishing
# ezCon221015b.py, removed many global from main()
#   Required:  -90 <= ezRAObsLat <= +90
#   Required: -180 <= ezRAObsLon <= +180
# ezCon221015a.py, from skipped ezCon220927a.py,
#   ezCon220927a, add a thin black horizontal line at zero Doppler on ezCon082antXTV,
#   print status polishing,
#   ezCon220924a, add (unique?) 5-character column string (' 33333') into ezConStudyxxx.txt for
#   easy section searching,
# ezCon221013a.py, allow division by data1dSpanD100, commas to prints
# ezCon220930a.py, prep for Git
# ezCon220917a, polishing, max of 19 thin black vertical lines to plotEzCon191sigProg,
#  raw sample number to input file map to studyOutString to ezConStudy*.txt


import seaborn as sb    # heatmaps

import matplotlib
matplotlib.use('agg')
import matplotlib.pyplot as plt

from astropy.time import Time

import numpy as np
import math
#import datetime
from datetime import datetime, timezone
import os
import sys
import time



def printUsage():

    print()
    print()
    print('##############################################################################################')
    print()
    print('USAGE:')
    print('  Windows:   py      ezCon.py [optional arguments] radioDataFileDirectories')
    print('  Linux:     python3 ezCon.py [optional arguments] radioDataFileDirectories')
    print()
    print('  Easy Radio Astronomy (ezRA) ezCon data Condenser program')
    print('  to read ezCol format .txt radio data file(s),')
    print('  analyse them, optionally creating many .png plot files,')
    print('  and maybe write one Gal.npz Galaxy crossing velocity data file.')
    print()
    print('  "radioDataFileDirectories" may be one or more .txt radio data files:')
    print('         py  ezCon.py  bigDish220320_05.txt')
    print('         py  ezCon.py  bigDish220320_05.txt bigDish220321_00.txt')
    print('         py  ezCon.py  bigDish22032*.txt')
    print('  "radioDataFileDirectories" may be one or more directories:')
    print('         py  ezCon.py  bigDish2203')
    print('         py  ezCon.py  bigDish2203 bigDish2204')
    print('         py  ezCon.py  bigDish22*')
    print('  "radioDataFileDirectories" may be a mix of .txt radio data files and directories')
    print()
    print('  Arguments and "radioDataFileDirectories" may be in any mixed order.')
    print()
    print('  Arguments are read first from inside the ezCon program,')
    print("  then in order from the ezDefaults.txt in the ezCon.py's directory,")
    print('  then in order from the ezDefaults.txt in current directory,')
    print('  then in order from the command line.  For duplicates, last read wins.')
    print()
    print('EXAMPLES:')
    print()
    print('  py ezCon.py -help                  (print this help)')
    print('  py ezCon.py -h                     (print this help)')
    print()
    print('    -ezRAObsName   Lebanon Kansas    (Observatory Name)')
    print('    -ezRAObsLat    39.8282           (Observatory Latitude  (degrees))')
    print('    -ezRAObsLon    -98.5696          (Observatory Longitude (degrees))')
    print('    -ezRAObsAmsl   563.88            (Observatory Above Mean Sea Level (meters))')
    print()
    print("    -ezConAddMHz           0.4       (add MHz to all data file's frequencies)")
    #print('    -ezConAzimuth          180.4     (force Azimuth   (degrees)')
    print('    -ezConAzDeg            180.4     (force Azimuth   (degrees)')
    #print('    -ezConElevation        35.7      (force Elevation (degrees)')
    print('    -ezConElDeg            35.7      (force Elevation (degrees)')
    print("    -ezConAddAzDeg         9.4       (add to data file's recorded Azimuth   (degrees))")
    print("    -ezConAddElDeg         -2.6      (add to data file's recorded Elevation (degrees))")
    print()
    #print('    -ezConInputdBm        1          (interpret power values as dBm (dB of 1 milliwatt)')
    print('    -ezConInputdB          1         (interpret power values as dB')
    print()
    print('    -ezConRawSamplesUseL   0 100     (first Raw sample number    last Raw sample number)')
    #print('    -ezConRawSamplePluck    29        ( Raw sample number)')
    #print('    -ezConRawAvgTrimFracL  .01  .98')
    #print('         (trim Raw samples with RawAvg values outside low high (as fractions of sorted rawLen))')
    print()
    print('    -ezConRawFreqBinTrimL  0 512    1.1 (force freqBin range to value 1.1)')
    print('    -ezConRawFreqTrimL     0 1418.2 0.4 (force frequency range (MHz) to value 0.4)')
    print('    -ezConRawFreqBinHide   125       (hide Raw freqBin 125 by copying from weaker of freqBin 124 or 126)')
    print('    -ezConRawFreqBinHideL  125 127   (hide Raw freqBins 125 thru 127 by copying from weaker neighbor)')
    print('    -ezConRawFreqBinHideL  127 125   (hide Raw freqBins 127 thru 125 by copying from weaker neighbor)')
    ##print('    -ezConRawFreqBinSmooth 1,1       ',
    #    '(RFI spur limiter: maximum muliplier over 4 neighboring freqBin of same Raw sample)')
    print()
    print('    -ezConRefMode                    (Dicke Reference sample creation method, default = 10)')
    print('    -ezConRefMode N < 1: REF = spectrum from -Nth ANT sample')
    print('    -ezConRefMode -1403: REF = spectrum from ANT sample number 1403')
    print('    -ezConRefMode     0: REF = spectrum from first ANT sample, sample number 0')
    print('    -ezConRefMode     1: REF = 1.0 (no REF, neutral spectrum)')
    print('    -ezConRefMode     2: REF = spectrum from rawByFreqBinAvg spectrum average')
    print('    -ezConRefMode     5: REF = the one ant spectrum at sample of minimum of antAvg')
    print('    -ezConRefMode     7: REF = the one antB spectrum at sample of minimum of antBAvg')
    print('    -ezConRefMode    10: REF = last REF sample marked in data, if none will use sample 0')
    #print('    -ezConRefMode    20: REF detection by ezCon software (for refPulser hardware)')
    print('    -ezConRefMode30L  freqAnt  freqRef  bwAnt   = Ant beside Ref in each Raw sample')
    print('    -ezConRefMode31 11.5 REF = the one antB spectrum closest to Right Ascension 11.5 hours')
    print('    -ezConRefMode    40: REF = spectrum from antAvgByFreqBinAvg spectrum average')
    print('    -ezConRefMode    41: REF = spectrum from antMaxByFreqBinAvg spectrum average')
    #print('    -ezConRefMode    42: REF = spectrum from refAvgByFreqBinAvg spectrum average')
    #print('    -ezConRefMode    43: REF = spectrum from refMaxByFreqBinAvg spectrum average')
    print('    -ezConRefMode    44: REF = spectrum from antBAvgByFreqBinAvg spectrum average')
    print('    -ezConRefMode    45: REF = spectrum from antBMaxByFreqBinAvg spectrum average')

    #print('    -ezConRefMode    50: REF = spectrum from smoothed antAvgByFreqBinAvg spectrum average')
    #print('    -ezConRefMode    51: REF = spectrum from smoothed antMaxByFreqBinAvg spectrum average')
    ##print('    -ezConRefMode    52: REF = spectrum from smoothed refAvgByFreqBinAvg spectrum average')
    ##print('    -ezConRefMode    53: REF = spectrum from smoothed refMaxByFreqBinAvg spectrum average')
    #print('    -ezConRefMode    54: REF = spectrum from smoothed antBAvgByFreqBinAvg spectrum average')
    #print('    -ezConRefMode    55: REF = spectrum from smoothed antBMaxByFreqBinAvg spectrum average')

    #print('    -ezConRefSmooth          1 REF = spectrum from antBMaxByFreqBinAvg spectrum average')
    print()
    print('    -ezConAntMaxPluckValL  .01   .03')
    print('         (Pluck (ignore) AntMax samples with Values below .01 or above .03)')
    print('    -ezConAntSamplesUseL    25   102  (first Ant sample number    last Ant sample number)')
    print('    -ezConAntPluck          29        (Pluck (ignore) Ant sample number)')
    print('    -ezConAntAvgPluckQtyL    3    5')
    print('         (Pluck (ignore) Ant samples with the 3 Quantity lowest, and 5 highest, sorted AntAvg values)')
    print('    -ezConAntAvgPluckFracL  .02  .03')
    print('         (Pluck (ignore) Ant samples with the lowest 2% and highest 3% AntAvg values (antLen Fractions))')
    print()
    print('    -ezConAntFreqBinHide  125        (hide Ant freqBin 125 by copying from weaker of freqBin 124 or 126)')
    print('    -ezConAntFreqBinHideL 125 127    (hide Ant freqBins 125 thru 127 by copying from weaker neighbor)')
    print('    -ezConAntFreqBinHideL 127 125    (hide Ant freqBins 127 thru 125 by copying from weaker neighbor)')
    print()
    print('    -ezConAntFreqBinSmooth  1.1       ',
        '(RFI spur limiter: maximum muliplier over 4 neighboring freqBin of same Ant sample)')
    print()
    print('    -ezConRefAvgPluckQtyL    3    5')
    print('         (Pluck (ignore) Ref samples with the 3 Quantity lowest, and 5 highest, sorted RefAvg values)')
    print('    -ezConRefAvgPluckFracL  .02  .03')
    print('         (Pluck (ignore) Ref samples with the lowest 2% and highest 3% RefAvg values (antLen Fractions))')
    print()
    print('    -ezConRefFreqBinHide  125        (hide Ref freqBin 125 by copying from louder of freqBin 124 or 126)')
    print('    -ezConRefFreqBinHideL 125 127    (hide Ref freqBins 125 thru 127 by copying from louder neighbor)')
    print('    -ezConRefFreqBinHideL 127 125    (hide Ref freqBins 127 thru 125 by copying from louder neighbor)')
    #print('    -ezConRefFreqBinSmooth 1.1       ',
    #    '(RFI spur limiter: maximum muliplier over 4 neighboring freqBin of same Ref sample)')
    print()
#    print('    -ezConUseRefSub 1                (use Subtraction of last Reference sample, not Division)')
#    print()
    print('    -ezConAntBaselineFreqBinsFracL   0  0.2344  0.7657  1')
    print('         (AntBaseline        FreqBin bands: start stop start stop (as fractions of bandwidth))')
    print()
    print('    -ezConAntRABaselineFreqBinsFracL 0  0.2344  0.7657  1')
    print('         (AntRABaseline      FreqBin bands: start stop start stop (as fractions of bandwidth))')
    print()
    print('    -ezConAntXInput    6             '
        + '(AntX choice: default -1 for Auto, 0/2/4/5/6 for Ant/Ref/AntB/AntRA/AntRB)')
    #print('    -ezConAntXTVTLevelL  1.3  -3.2   (multiply all AntXTVT sample values and add)')
    #print('    -ezConAntXTVTLevelL  1.3  -3.2  1.0  0.0
    #print('        (on all AntXTVT sample values, multiply and add and divide by and subtract)')
    print()
    print('    -ezConAntXTFreqBinsFracL            0.2344  0.7657')
    print('         (AntXTFreqBinsFrac FreqBin band:  start stop            (as fractions of bandwidth))')
    print()
    print('    -ezConUseVlsr      1             (use VLSR for AntXTV and further processing)')
    print()
    print('    -ezConAntXTVTFreqBinsFracL          0.4     0.6')
    print('         (AntXTVTFreqBinsFrac FreqBin band:  start stop          (as fractions of bandwidth))')
    print()
    print('    -ezConAntXTVTMaxPluckQtyL   3    5')
    print('         (Pluck (ignore) AntXTVTMax samples with the 3 Quantity lowest, and 5 highest, sorted AntXTVTMax)')
    print('    -ezConAntXTVTMaxPluckValL  .01   .03')
    print('         (Pluck (ignore) AntXTVTMax samples with Values below .01 or above .03)')
    print()
    print('    -ezConAntXTVTAvgPluckQtyL   3    5')
    print('         (Pluck (ignore) AntXTVT    samples with the 3 Quantity lowest, and 5 highest, sorted AntXTVT)')
    print('    -ezConAntXTVTAvgPluckValL  .01   .03')
    print('         (Pluck (ignore) AntXTVT    samples with Values below .01 or above .03)')
    print()
    print('    -ezConAntXTVTPluck          33')
    print('         (Pluck (ignore) AntXTVTMax and AntXTVT sample 33)')
    print()
    print('    -ezConAntXTVTClipL         .01   .03')
    print('         (Clip all AntXTVT values to be between .01 and .03)')
    print()
    print('    -ezConAntXTVTSmooth         2')
    print('         (smooth antXTVT heatmap data as an image, with choice of filters)')
    print()
    print('    -ezConAntXTVTFreqBinsClipL  203  407')
    print('         (reduce AntXTVT to only FreqBin from 203 to 407)')
    print()
    print('    -ezConAntXTVTIntegrate      1')
    print("         (integrate AntXTVT into one day's drift-scan, 1 for RA, 4 for GLon)")
    print()
    print('    -ezCon087Csv         1           (create CSV file of ezCon087 for 3d plots with rinearn.com/en-us/graph3d)')
    print('    -ezCon087Csv         2           (... and also write out ezCon087 as one directory of ifAvg format files)')
    print('    -ezCon087Csv         4           (create simpler CSV file format for plotly)')
    print()
    print('    -ezConPlotRangeL     0  300      (save only this range of ezCon plots to file, to save time)')
    print('    -ezConRawDispIndex   1           (also Display the Raw sample Index on x axis)')
    print('    -ezConDispGrid       1           (turn on graphical display plot grids)')
    print('    -ezConDispFreqBin    1           (1 for display FreqBin numbers on Y axis, 2 for 0.0 to 1.0)')
    print('    -ezConHeatVMinMaxL   1.0 1.4     (heat map z scale)')
    print()
    print('    -ezConAstroMath      0           (astroMath choice)')
    print('      -ezConAstroMath  0:    no math (good for faster plots of most signals, but AntXTV is wrong)')
    print('      -ezConAstroMath  1:    using math from MIT Haystack SRT')
    print('      -ezConAstroMath  2:    using math from authoritative slower AstroPy library')
    print()
    print('    -ezConVelGLonEdgeFrac         0.5    ')
    print('         (velGLon level fraction for plotEzCon430velGLonEdges)')
    #print('    -ezConVelGLonEdgeLevel  0.5    ')
    #print('         (velGLon level for plotEzCon430velGLonEdges, if 0 then use only ezConVelGLonEdgeFrac)')
    print()
    print('    -ezConGalCrossingGLatCenter   2.4')
    print('         (add spectra to Gal.npz, the center of GLat crossing, in Galactic Latitude degrees)')
    print('    -ezConGalCrossingGLatCenterL  -5.2  6.3  11')
    print('         (adds centers of GLat crossings in Galactic Latitude degrees, as np.linspace(-5.2, 6.3, num=11))')
    print('    -ezConGalCrossingGLatNear     2.3')
    print('         (defines "close to GLat crossing" in Galactic Latitude degrees)')
    print()
    print('    -ezConGalCrossingGLonCenter   72.4')
    print('         (add spectra to GLon.npz, the center of GLon crossing, in Galactic Longitude degrees)')
    print('    -ezConGalCrossingGLonCenterL  69.6  82.4  13')
    print('         (adds centers of GLon crossings in Galactic Longitude degrees, as np.linspace(69.6,  82.4, num=13))')
    print('    -ezConGalCrossingGLonNear     2.7')
    print('         (defines "close to GLon crossing" in Galactic Longitude degrees)')
    print()
    print('    -ezConGalRaDecNearNearL       0.8  41.3  0.1  0.2')
    print('         (add spectra to RGal.npz, from RaDec span 0.8 +/-0.1 hours, 41.3 +/-0.2 degrees)')
    print()
    print('    -ezConGalNormalize            2')
    print('         (normalize each .npz file, 0/1/2 for None/Average/Maximum of its AntXTVT samples)')
    print()
    print('    -ezCon399SignalSampleByFreqBinL     18  1423')
    print('         (plot antenna sample 1423 spectrum By FreqBin of signal 18 (of ezbMenu columns 10, 12, 14, 16, 18))')
    print()
    print('    -ezDefaultsFile ../bigDish8.txt     (additional file of ezRA arguments)')
    print('    -ezDefaultsEnd                      (ignore the rest of this ezDefaults file')
    print()
    print('    -eXXXXXXXXXXXXXXzIgonoreThisWholeOneWord')
    print('         (any one word starting with -eX is ignored, handy for long command line editing)')
    print()
    print()
    print(' programRevision =', programRevision)
    print()
    print()
    print()
    print()
    print()
    print('       The Society of Amateur Radio Astronomers (SARA)')
    print('                    radio-astronomy.org')
    print()
    print()
    print()
    print()
    print()
    print('##############################################################################################')
    print()





    # py -m pip install plotly

    #import plotly.express as px

    if 0:
        fig = px.bar(x=["a", "b", "c"], y=[1, 3, 2])
        fig.show()

    if 0:
        #import plotly
        #from plotly import __version__
        #print(__version__)
        

        import plotly.graph_objs as go
        import numpy as np
        import plotly.io as pio

        x = np.random.randn(2000)
        y = np.random.randn(2000)

        #iplot([go.Histogram2dContour(x=x, y=y, contours=dict(coloring='heatmap')),
        #    go.Scatter(x=x, y=y, mode='markers', marker=dict(color='white', size=3, opacity=0.3))], show_link=False)

        #fig = ([go.Histogram2dContour(x=x, y=y, contours=dict(coloring='heatmap')),
        #    go.Scatter(x=x, y=y, mode='markers', marker=dict(color='white', size=3, opacity=0.3))])

        #fig = go.Histogram2dContour(x=x, y=y, contours=dict(coloring='heatmap'))
        #fig = go.Scatter(x=x, y=y, mode='markers', marker=dict(color='white', size=3, opacity=0.3))
        
        #print [go.Histogram2dContour(x=x, y=y, contours=dict(coloring='heatmap')),
        #    px.go.Scatter(x=x, y=y, mode='markers', marker=dict(color='white', size=3, opacity=0.3))])

        #print(fig)
        #fig.plot()
        #fig.show()
        
        #pio.show([go.Histogram2dContour(x=x, y=y, contours=dict(coloring='heatmap')),
        #    go.Scatter(x=x, y=y, mode='markers', marker=dict(color='white', size=3, opacity=0.3))], show_link=False)
        
        #pio.show(go.Histogram2dContour(x=x, y=y, contours=dict(coloring='heatmap')))
        #pio.show(go.Scatter(x=x, y=y, mode='markers', marker=dict(color='white', size=3, opacity=0.3)), show_link=False)
        print(x)
        print('--------')
        print(go.Scatter(x=x, y=y))

        #fig = px.bar(y=y)
        print('--------')
        print(px.bar(y=y))
        #fig.show()
        #pio.show(fig)
        ##pio.show(px.bar(y=y))

        #pio.show(go.Scatter(x=x, y=y))
        
        
    if 0:
        import plotly.express as px
        fig = px.bar(x=["a", "b", "c"], y=[1, 3, 2])

        import plotly.graph_objects as go
        fig_widget = go.FigureWidget(fig)
        fig_widget


    if 0:
        #import plotly.io as pio
        #print(pio.renderers)

        import plotly.graph_objects as go
        fig = go.Figure(
            data=[go.Bar(y=[2, 1, 3])],
            layout_title_text="A Figure Displayed with fig.show()"
        )
        fig.show()
        
        
        
    if 0:
        # https://plotly.com/python/3d-axes/
        import plotly.graph_objects as go
        import numpy as np
        np.random.seed(1)

        N = 70

        fig = go.Figure(data=[go.Mesh3d(x=(70*np.random.randn(N)),
                           y=(55*np.random.randn(N)),
                           z=(40*np.random.randn(N)),
                           opacity=0.5,
                           color='rgba(244,22,100,0.6)'
                          )])

        fig.update_layout(
            scene = dict(
                xaxis = dict(nticks=4, range=[-100,100],),
                             yaxis = dict(nticks=4, range=[-50,100],),
                             zaxis = dict(nticks=4, range=[-100,100],),),
            width=700,
            margin=dict(r=20, l=10, b=10, t=10))

        fig.show()
        
        
    if 0:
        # https://plotly.com/python/3d-surface-plots/
        import plotly.graph_objects as go

        import pandas as pd

        # Read data from a csv
        z_data = pd.read_csv('https://raw.githubusercontent.com/plotly/datasets/master/api_docs/mt_bruno_elevation.csv')

        fig = go.Figure(data=[go.Surface(z=z_data.values)])

        fig.update_layout(title=dict(text='Mt Bruno Elevation'), autosize=False,
                          width=500, height=500,
                          margin=dict(l=65, r=50, b=65, t=90))

        fig.show()
        

    if 0:

        import plotly.graph_objects as go
        import pandas as pd
        import numpy as np
        # Read data from a csv
        z_data = pd.read_csv('https://raw.githubusercontent.com/plotly/datasets/master/api_docs/mt_bruno_elevation.csv')
        z = z_data.values
        sh_0, sh_1 = z.shape
        x, y = np.linspace(0, 1, sh_0), np.linspace(0, 1, sh_1)
        fig = go.Figure(data=[go.Surface(z=z, x=x, y=y)])
        fig.update_layout(title=dict(text='Mt Bruno Elevation'), autosize=False,
                          width=500, height=500,
                          margin=dict(l=65, r=50, b=65, t=90))
        fig.show()


    if 1:

        import plotly.graph_objects as go

        import pandas as pd

        # Read data from a csv
        #z_data = pd.read_csv('https://raw.githubusercontent.com/plotly/datasets/master/api_docs/mt_bruno_elevation.csv')
        #z_data = pd.read_csv('file:C:/Users/hm555/OneDrive/Documents/Astronomy/Astronomy Radio/SARA/SARA ezRA/ezRABase/plotly/ezCon087antRBTVTMsh.csv')
        z_data = pd.read_csv('file:ezCon087antRBTVTMsh.csv')

        fig = go.Figure(data=[go.Surface(z=z_data.values)])
        if 1:
            fig.update_traces(contours_z=dict(show=True, usecolormap=True,
                                              highlightcolor="limegreen", project_z=True))

            #fig.update_layout(title=dict(text='Mt Bruno Elevation'), autosize=False,
            fig.update_layout(title=dict(text='ezCon087 from N0RQV-8230209_00'), autosize=True,
                              scene_camera_eye=dict(x=1.87, y=0.88, z=-0.64),
                              width=500, height=500,
                              margin=dict(l=65, r=50, b=65, t=90)
            )

        fig.show()

    '''
    https://raw.githubusercontent.com/plotly/datasets/master/api_docs/mt_bruno_elevation.csv
    says
    ,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23
    0,27.80985,49.61936,83.08067,116.6632,130.414,150.7206,220.1871,156.1536,148.6416,203.7845,206.0386,107.1618,68.36975,45.3359,49.96142,21.89279,17.02552,11.74317,14.75226,13.6671,5.677561,3.31234,1.156517,-0.147662
    1,27.71966,48.55022,65.21374,95.27666,116.9964,133.9056,152.3412,151.934,160.1139,179.5327,147.6184,170.3943,121.8194,52.58537,33.08871,38.40972,44.24843,69.5786,4.019351,3.050024,3.039719,2.996142,2.967954,1.999594
    2,30.4267,33.47752,44.80953,62.47495,77.43523,104.2153,102.7393,137.0004,186.0706,219.3173,181.7615,120.9154,143.1835,82.40501,48.47132,74.71461,60.0909,7.073525,6.089851,6.53745,6.666096,7.306965,5.73684,3.625628
    3,16.66549,30.1086,39.96952,44.12225,59.57512,77.56929,106.8925,166.5539,175.2381,185.2815,154.5056,83.0433,62.61732,62.33167,60.55916,55.92124,15.17284,8.248324,36.68087,61.93413,20.26867,68.58819,46.49812,0.2360095
    4,8.815617,18.3516,8.658275,27.5859,48.62691,60.18013,91.3286,145.7109,116.0653,106.2662,68.69447,53.10596,37.92797,47.95942,47.42691,69.20731,44.95468,29.17197,17.91674,16.25515,14.65559,17.26048,31.22245,46.71704
    5,6.628881,10.41339,24.81939,26.08952,30.1605,52.30802,64.71007,76.30823,84.63686,99.4324,62.52132,46.81647,55.76606,82.4099,140.2647,81.26501,56.45756,30.42164,17.28782,8.302431,2.981626,2.698536,5.886086,5.268358
    6,21.83975,6.63927,18.97085,32.89204,43.15014,62.86014,104.6657,130.2294,114.8494,106.9873,61.89647,55.55682,86.80986,89.27802,122.4221,123.9698,109.0952,98.41956,77.61374,32.49031,14.67344,7.370775,0.03711011,0.6423392
    7,53.34303,26.79797,6.63927,10.88787,17.2044,56.18116,79.70141,90.8453,98.27675,80.87243,74.7931,75.54661,73.4373,74.11694,68.1749,46.24076,39.93857,31.21653,36.88335,40.02525,117.4297,12.70328,1.729771,0.0
    8,25.66785,63.05717,22.1414,17.074,41.74483,60.27227,81.42432,114.444,102.3234,101.7878,111.031,119.2309,114.0777,110.5296,59.19355,42.47175,14.63598,6.944074,6.944075,27.74936,0.0,0.0,0.09449376,0.07732264
    9,12.827,69.20554,46.76293,13.96517,33.88744,61.82613,84.74799,121.122,145.2741,153.1797,204.786,227.9242,236.3038,228.3655,79.34425,25.93483,6.944074,6.944074,6.944075,7.553681,0.0,0.0,0.0,0.0
    10,0.0,68.66396,59.0435,33.35762,47.45282,57.8355,78.91689,107.8275,168.0053,130.9597,212.5541,165.8122,210.2429,181.1713,189.7617,137.3378,84.65395,8.677168,6.956576,8.468093,0.0,0.0,0.0,0.0
    11,0.0,95.17499,80.03818,59.89862,39.58476,50.28058,63.81641,80.61302,66.37824,198.7651,244.3467,294.2474,264.3517,176.4082,60.21857,77.41475,53.16981,56.16393,6.949235,7.531059,3.780177,0.0,0.0,0.0
    12,0.0,134.9879,130.3696,96.86325,75.70494,58.86466,57.20374,55.18837,78.128,108.5582,154.3774,319.1686,372.8826,275.4655,130.2632,54.93822,25.49719,8.047439,8.084393,5.115252,5.678269,0.0,0.0,0.0
    13,0.0,48.08919,142.5558,140.3777,154.7261,87.9361,58.11092,52.83869,67.14822,83.66798,118.9242,150.0681,272.9709,341.1366,238.664,190.2,116.8943,91.48672,14.0157,42.29277,5.115252,0.0,0.0,0.0
    14,0.0,54.1941,146.3839,99.48143,96.19411,102.9473,76.14089,57.7844,47.0402,64.36799,84.23767,162.7181,121.3275,213.1646,328.482,285.4489,283.8319,212.815,164.549,92.29631,7.244015,1.167,0.0,0.0
    15,0.0,6.919659,195.1709,132.5253,135.2341,89.85069,89.45549,60.29967,50.33806,39.17583,59.06854,74.52159,84.93402,187.1219,123.9673,103.7027,128.986,165.1283,249.7054,95.39966,10.00284,2.39255,0.0,0.0
    16,0.0,21.73871,123.1339,176.7414,158.2698,137.235,105.3089,86.63255,53.11591,29.03865,30.40539,39.04902,49.23405,63.27853,111.4215,101.1956,40.00962,59.84565,74.51253,17.06316,2.435141,2.287471,-0.0003636982,0.0
    17,0.0,0.0,62.04672,136.3122,201.7952,168.1343,95.2046,58.90624,46.94091,49.27053,37.10416,17.97011,30.93697,33.39257,44.03077,55.64542,78.22423,14.42782,9.954997,7.768213,13.0254,21.73166,2.156372,0.5317867
    18,0.0,0.0,79.62993,139.6978,173.167,192.8718,196.3499,144.6611,106.5424,57.16653,41.16107,32.12764,13.8566,10.91772,12.07177,22.38254,24.72105,6.803666,4.200841,16.46857,15.70744,33.96221,7.575688,-0.04880907
    19,0.0,0.0,33.2664,57.53643,167.2241,196.4833,194.7966,182.1884,119.6961,73.02113,48.36549,33.74652,26.2379,16.3578,6.811293,6.63927,6.639271,8.468093,6.194273,3.591233,3.81486,8.600739,5.21889,0.0
    20,0.0,0.0,29.77937,54.97282,144.7995,207.4904,165.3432,171.4047,174.9216,100.2733,61.46441,50.19171,26.08209,17.18218,8.468093,6.63927,6.334467,6.334467,5.666687,4.272203,0.0,0.0,0.0,0.0
    21,0.0,0.0,31.409,132.7418,185.5796,121.8299,185.3841,160.6566,116.1478,118.1078,141.7946,65.56351,48.84066,23.13864,18.12932,10.28531,6.029663,6.044627,5.694764,3.739085,3.896037,0.0,0.0,0.0
    22,0.0,0.0,19.58994,42.30355,96.26777,187.1207,179.6626,221.3898,154.2617,142.1604,148.5737,67.17937,40.69044,39.74512,26.10166,14.48469,8.65873,3.896037,3.571392,3.896037,3.896037,3.896037,1.077756,0.0
    23,0.001229679,3.008948,5.909858,33.50574,104.3341,152.2165,198.1988,191.841,228.7349,168.1041,144.2759,110.7436,57.65214,42.63504,27.91891,15.41052,8.056102,3.90283,3.879774,3.936718,3.968634,0.1236256,3.985531,-0.1835741
    24,0.0,5.626141,7.676256,63.16226,45.99762,79.56688,227.311,203.9287,172.5618,177.1462,140.4554,123.9905,110.
    '''


    if 0:
        import plotly.graph_objects as go

        fig = go.Figure(go.Surface(
            contours = {
                "x": {"show": True, "start": 1.5, "end": 2, "size": 0.04, "color":"white"},
                "z": {"show": True, "start": 0.5, "end": 0.8, "size": 0.05}
            },
            x = [1,2,3,4,5],
            y = [1,2,3,4,5],
            z = [
                [0, 1, 0, 1, 0],
                [1, 0, 1, 0, 1],
                [0, 1, 0, 1, 0],
                [1, 0, 1, 0, 1],
                [0, 1, 0, 1, 0]
            ]))
        fig.update_layout(
                scene = {
                    "xaxis": {"nticks": 20},
                    "zaxis": {"nticks": 4},
                    'camera_eye': {"x": 0, "y": -1, "z": 0.5},
                    "aspectratio": {"x": 1, "y": 1, "z": 0.2}
                })
        fig.show()


    if 0:
        import plotly.graph_objects as go
        from plotly.subplots import make_subplots

        # Equation of ring cyclide
        # see https://en.wikipedia.org/wiki/Dupin_cyclide
        import numpy as np
        a, b, d = 1.32, 1., 0.8
        c = a**2 - b**2
        u, v = np.mgrid[0:2*np.pi:100j, 0:2*np.pi:100j]
        x = (d * (c - a * np.cos(u) * np.cos(v)) + b**2 * np.cos(u)) / (a - c * np.cos(u) * np.cos(v))
        y = b * np.sin(u) * (a - d*np.cos(v)) / (a - c * np.cos(u) * np.cos(v))
        z = b * np.sin(v) * (c*np.cos(u) - d) / (a - c * np.cos(u) * np.cos(v))

        fig = make_subplots(rows=1, cols=2,
                            specs=[[{'is_3d': True}, {'is_3d': True}]],
                            subplot_titles=['Color corresponds to z', 'Color corresponds to distance to origin'],
                            )

        fig.add_trace(go.Surface(x=x, y=y, z=z, colorbar_x=-0.07), 1, 1)
        fig.add_trace(go.Surface(x=x, y=y, z=z, surfacecolor=x**2 + y**2 + z**2), 1, 2)
        fig.update_layout(title_text="Ring cyclide")
        fig.show()



    exit()



def printHello():

    global programRevision          # string

    print()
    print('         For help, run')
    print('            ezCon.py -help')

    print()
    print('=================================================')
    print(' Local time =', time.asctime(time.localtime()))
    print(' programRevision =', programRevision)
    print()

    commandLineString = '  '.join(sys.argv)
    print(' This Python command = ' + commandLineString)



def ezConArgumentsFile(ezDefaultsFileNameInput):
    # process arguments from file

    global commandString                    # string
    global cmdDirectoryS                    # string            creation

    global ezRAObsLat                       # float
    global ezRAObsLon                       # float
    global ezRAObsAmsl                      # float
    global ezRAObsName                      # string

    global ezConAddMHz                      # float - correction factor, add to all file's frequencies (MHz)
    global ezConAzDeg                       # float - force Azimuth   (Degrees)
    global ezConElDeg                       # float - force Elevation (Degrees)
    global ezConAddAzDeg                    # float - correction factor, add to file's Azimuth   (Degrees)
    global ezConAddElDeg                    # float - correction factor, add to file's Elevation (Degrees)

    global ezConInputdB                     # integer
    global ezConUseRefSub                   # integer
    global ezConAntXInput                   # integer
    global ezConUseVlsr                     # integer

    global ezConRawSamplesUseL              # integer list
    global ezConRawFreqBinTrimL             # list of (integer pair, float)
    global ezConRawFreqTrimL                # list of (float pair, float)
    global ezConRawFreqBinHideL             # integer list
    global ezConAntFreqBinHideL             # integer list
    global ezConRefFreqBinHideL             # integer list

    global ezConAntMaxPluckValL             # float list
    global ezConAntSamplesUseL              # integer list
    global ezConAntPluckL                   # integer list
    global ezConAntAvgPluckQtyL             # integer list
    global ezConAntAvgPluckFracL            # float list
    global ezConAntFreqBinSmooth            # float - RFI spur limiter: max muliplier over 4 neighboring freqBin

    global ezConRefAvgPluckQtyL             # integer list
    global ezConRefAvgPluckFracL            # float list
    global ezConRefMode                     # integer
    global ezConRefMode30L                  # float list
    global ezConRefMode31                   # float

    global ezConAntBaselineFreqBinsFracL    # float list
    global ezConAntRABaselineFreqBinsFracL  # float list
    global ezConAntXTFreqBinsFracL          # float list
    global ezConAntXTVTFreqBinsFracL        # float list

    global ezConAntXTVTMaxPluckQtyL         # integer list
    global ezConAntXTVTMaxPluckValL         # float list
    global ezConAntXTVTAvgPluckQtyL         # integer list
    global ezConAntXTVTAvgPluckValL         # float list
    global ezConAntXTVTPluckL               # integer list
    global ezConAntXTVTClipL                # float list
    global ezConAntXTVTSmooth               # integer
    global ezConAntXTVTFreqBinsClipL        # float list
    global ezConAntXTVTIntegrate            # integer
    global ezCon087Csv                      # integer
    global ezConAntXTVTLevelL               # float list
    global ezConGalNormalize                # integer

    global ezCon399SignalSampleByFreqBinL   # integer list
    global ezConHeatVMinMaxL                # float list

    global ezConAstroMath                   # integer

    global ezConDispGrid                    # integer
    global ezConDispFreqBin                 # integer
    global ezConRawDispIndex                # integer
    global ezConPlotRangeL                  # integer list

    global ezConVelGLonEdgeFrac             # float
    #global ezConVelGLonEdgeLevel            # float

    global ezConGalCrossingGLatCenterL      # float list
    global ezConGalCrossingGLatNear         # float
    global ezConGalCrossingGLonCenterL      # float list
    global ezConGalCrossingGLonNear         # float
    global ezConGalRaDecNearNearL           # float list

    print()
    print('   ezConArgumentsFile(' + ezDefaultsFileNameInput + ') ===============')

    # https://www.zframez.com/tutorials/python-exception-handling.html
    try:
        fileDefaults = open(ezDefaultsFileNameInput, 'r')
        print('      success opening ' + ezDefaultsFileNameInput)

        while 1:
            fileLine = fileDefaults.readline()

            # LF always present: 0=EOF  1=LF  2=1Character
            if not fileLine:              # if end of file
                break                     # get out of while loop

            thisLine = fileLine.split()
            if not thisLine:              # if line all whitespace
                continue                  # skip to next line

            if thisLine[0][0] == '#':    # ignoring whitespace, if first character of first word
                continue                  # it is a comment, skip to next line


            # be kind, ignore argument keyword capitalization
            #thisLine0Lower = thisLine[0].lower()
            thisLine0 = thisLine[0]
            thisLine0Lower = thisLine0.lower()

            # ezRA arguments used by multiple programs:
            if thisLine0Lower == '-ezRAObsLat'.lower():
                ezRAObsLat  = float(thisLine[1])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            elif thisLine0Lower == '-ezRAObsLon'.lower():
                ezRAObsLon  = float(thisLine[1])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            elif thisLine0Lower == '-ezRAObsAmsl'.lower():
                ezRAObsAmsl = float(thisLine[1])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            elif thisLine0Lower == '-ezRAObsName'.lower():
                ezRAObsName = thisLine[1]
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            # integer arguments:
            #elif thisLine0Lower == '-ezConInputdBm'.lower():
            #                        01234567890123
            elif thisLine0Lower[:13] == '-ezConInputdB'.lower():
                ezConInputdB = int(thisLine[1])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            elif thisLine0Lower == '-ezConUseRefSub'.lower():
                ezConUseRefSub = int(thisLine[1])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            elif thisLine0Lower == '-ezConAntXInput'.lower():
                ezConAntXInput = int(thisLine[1])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            elif thisLine0Lower == '-ezConUseVlsr'.lower():
                ezConUseVlsr = int(thisLine[1])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            elif thisLine0Lower == '-ezConRawDispIndex'.lower():
                ezConRawDispIndex = int(thisLine[1])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            elif thisLine0Lower == '-ezConDispGrid'.lower():
                ezConDispGrid = int(thisLine[1])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            elif thisLine0Lower == '-ezConDispFreqBin'.lower():
                ezConDispFreqBin = int(thisLine[1])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            elif thisLine0Lower == '-ezConAstroMath'.lower():
                ezConAstroMath = int(thisLine[1])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            elif thisLine0Lower == '-ezConRefMode'.lower():
                ezConRefMode = int(thisLine[1])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            elif thisLine0Lower == '-ezConRefMode30L'.lower():
                # -ezConRefMode30L freqAnt freqRef bwAnt
                ezConRefMode = 30
                ezConRefMode30L = [float(thisLine[1])]
                ezConRefMode30L.append(float(thisLine[2]))
                ezConRefMode30L.append(float(thisLine[3]))
                commandString += ' ' + thisLine0 + ' ' + thisLine[1] + ' ' + thisLine[2] + ' ' + thisLine[3]

            elif thisLine0Lower == '-ezConRefMode31'.lower():
                # -ezConRefMode31 RAHours
                ezConRefMode = 31
                ezConRefMode31 = float(thisLine[1])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            elif thisLine0Lower == '-ezConAntPluck'.lower():
                ezConAntPluckL.append(int(thisLine[1]))
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            elif thisLine0Lower == '-ezConGalNormalize'.lower():
                ezConGalNormalize = int(thisLine[1])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]


            # float arguments:
            elif thisLine0Lower == '-ezConAddMHz'.lower():
                ezConAddMHz = float(thisLine[1])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]
            elif thisLine0Lower == '-ezConAzimuth'.lower() or thisLine0Lower == '-ezConAzDeg'.lower():
                ezConAzDeg = float(thisLine[1])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]
            elif thisLine0Lower == '-ezConElevation'.lower() or thisLine0Lower == '-ezConElDeg'.lower():
                ezConElDeg = float(thisLine[1])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]
            elif thisLine0Lower == '-ezConAddAzDeg'.lower():
                ezConAddAzDeg = float(thisLine[1])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]
            elif thisLine0Lower == '-ezConAddElDeg'.lower():
                ezConAddElDeg = float(thisLine[1])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            elif thisLine0Lower == '-ezConAntFreqBinSmooth'.lower():
                ezConAntFreqBinSmooth = float(thisLine[1])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            elif thisLine0Lower == '-ezConGalCrossingGLatCenter'.lower():
                #ezConGalCrossingGLatCenterL.append(int(thisLine[1]))
                ezConGalCrossingGLatCenterL += [float(thisLine[1])]
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            elif thisLine0Lower == '-ezConGalCrossingGLatCenterL'.lower():
                ezConGalCrossingGLatCenterL += np.linspace(float(thisLine[1]), float(thisLine[2]), num=int(thisLine[3])).tolist()
                commandString += ' ' + thisLine0 \
                    + ' ' + thisLine[1] + ' ' + thisLine[2] + ' ' + thisLine[3]
                #ezConGalCrossingGLatCenterL += range(int(thisLine[1]), int(thisLine[2]))

            # grandfather -ezConGalCrossingGLat as -ezConGalCrossingGLatNear
            elif thisLine0Lower == '-ezConGalCrossingGLat'.lower():
                ezConGalCrossingGLatNear = float(thisLine[1])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            elif thisLine0Lower == '-ezConGalCrossingGLatNear'.lower():
                ezConGalCrossingGLatNear = float(thisLine[1])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]


            elif thisLine0Lower == '-ezConGalCrossingGLonCenter'.lower():
                #ezConGalCrossingGLonCenterL.append(int(thisLine[1]))
                ezConGalCrossingGLonCenterL += [float(thisLine[1])]
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            elif thisLine0Lower == '-ezConGalCrossingGLonCenterL'.lower():
                ezConGalCrossingGLonCenterL += np.linspace(float(thisLine[1]), float(thisLine[2]), num=int(thisLine[3])).tolist()
                commandString += ' ' + thisLine0 \
                    + ' ' + thisLine[1] + ' ' + thisLine[2] + ' ' + thisLine[3]

                #ezConGalCrossingGLonCenterL += range(int(thisLine[1]), int(thisLine[2]))

            elif thisLine0Lower == '-ezConGalCrossingGLonNear'.lower():
                ezConGalCrossingGLonNear = float(thisLine[1])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]


            elif thisLine0Lower == '-ezConVelGLonEdgeFrac'.lower():
                ezConVelGLonEdgeFrac = float(thisLine[1])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            #elif thisLine0Lower == '-ezConVelGLonEdgeLevel'.lower():
            #    ezConVelGLonEdgeLevel = float(thisLine[1])



            elif thisLine0Lower == '-ezConRawFreqBinTrimL'.lower():
                ezConRawFreqBinTrimL0 = int(thisLine[1])
                ezConRawFreqBinTrimL1 = int(thisLine[2])
                ezConRawFreqBinTrimL2 = float(thisLine[3])
                if ezConRawFreqBinTrimL0 <= ezConRawFreqBinTrimL1:
                    ezConRawFreqBinTrimL.append(ezConRawFreqBinTrimL0)
                    ezConRawFreqBinTrimL.append(ezConRawFreqBinTrimL1)
                else:
                    ezConRawFreqBinTrimL.append(ezConRawFreqBinTrimL1)
                    ezConRawFreqBinTrimL.append(ezConRawFreqBinTrimL0)
                ezConRawFreqBinTrimL.append(ezConRawFreqBinTrimL2)
                commandString += ' ' + thisLine0 + ' ' + thisLine[1] + ' ' + thisLine[2] + ' ' + thisLine[3]

            elif thisLine0Lower == '-ezConRawFreqTrimL'.lower():
                ezConRawFreqTrimL0 = float(thisLine[1])
                ezConRawFreqTrimL1 = float(thisLine[2])
                ezConRawFreqTrimL2 = float(thisLine[3])
                if ezConRawFreqTrimL0 <= ezConRawFreqTrimL1:
                    ezConRawFreqTrimL.append(ezConRawFreqTrimL0)
                    ezConRawFreqTrimL.append(ezConRawFreqTrimL1)
                else:
                    ezConRawFreqTrimL.append(ezConRawFreqTrimL1)
                    ezConRawFreqTrimL.append(ezConRawFreqTrimL0)
                ezConRawFreqTrimL.append(ezConRawFreqTrimL2)
                commandString += ' ' + thisLine0 + ' ' + thisLine[1] + ' ' + thisLine[2] + ' ' + thisLine[3]

            elif thisLine0Lower == '-ezConRawFreqBinHide'.lower():
                ezConRawFreqBinHideL.append(int(thisLine[1]))
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            elif thisLine0Lower == '-ezConRawFreqBinHideL'.lower():
                ezConRawFreqBinHideL0 = int(thisLine[1])
                ezConRawFreqBinHideL1 = int(thisLine[2])
                if ezConRawFreqBinHideL0 <= ezConRawFreqBinHideL1:
                    ezConRawFreqBinHideL += range(ezConRawFreqBinHideL0, ezConRawFreqBinHideL1 + 1)
                else:
                    ezConRawFreqBinHideL += range(ezConRawFreqBinHideL1, ezConRawFreqBinHideL0 + 1)[::-1]
                commandString += ' ' + thisLine0 + ' ' + thisLine[1] + ' ' + thisLine[2]

            elif thisLine0Lower == '-ezConAntFreqBinHide'.lower():
                ezConAntFreqBinHideL.append(int(thisLine[1]))
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            elif thisLine0Lower == '-ezConAntFreqBinHideL'.lower():
                ezConAntFreqBinHideL0 = int(thisLine[1])
                ezConAntFreqBinHideL1 = int(thisLine[2])
                if ezConAntFreqBinHideL0 <= ezConAntFreqBinHideL1:
                    ezConAntFreqBinHideL += range(ezConAntFreqBinHideL0, ezConAntFreqBinHideL1 + 1)
                else:
                    ezConAntFreqBinHideL += range(ezConAntFreqBinHideL1, ezConAntFreqBinHideL0 + 1)[::-1]
                commandString += ' ' + thisLine0 + ' ' + thisLine[1] + ' ' + thisLine[2]

            elif thisLine0Lower == '-ezConRefFreqBinHide'.lower():
                ezConRefFreqBinHideL.append(int(thisLine[1]))
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            elif thisLine0Lower == '-ezConRefFreqBinHideL'.lower():
                ezConRefFreqBinHideL0 = int(thisLine[1])
                ezConRefFreqBinHideL1 = int(thisLine[2])
                if ezConRefFreqBinHideL0 <= ezConRefFreqBinHideL1:
                    ezConRefFreqBinHideL += range(ezConRefFreqBinHideL0, ezConRefFreqBinHideL1 + 1)
                else:
                    ezConRefFreqBinHideL += range(ezConRefFreqBinHideL1, ezConRefFreqBinHideL0 + 1)[::-1]
                commandString += ' ' + thisLine0 + ' ' + thisLine[1] + ' ' + thisLine[2]

            elif thisLine0Lower == '-ezConRawSamplesUseL'.lower():
                ezConRawSamplesUseL.append(int(thisLine[1]))
                ezConRawSamplesUseL.append(int(thisLine[2]))
                commandString += ' ' + thisLine0 + ' ' + thisLine[1] + ' ' + thisLine[2]

            elif thisLine0Lower == '-ezConAntMaxPluckValL'.lower():
                ezConAntMaxPluckValL = []
                ezConAntMaxPluckValL.append(int(thisLine[1]))
                ezConAntMaxPluckValL.append(int(thisLine[2]))
                commandString += ' ' + thisLine0 + ' ' + thisLine[1] + ' ' + thisLine[2]

            elif thisLine0Lower == '-ezConAntSamplesUseL'.lower():
                ezConAntSamplesUseL.append(int(thisLine[1]))
                ezConAntSamplesUseL.append(int(thisLine[2]))
                commandString += ' ' + thisLine0 + ' ' + thisLine[1] + ' ' + thisLine[2]

            elif thisLine0Lower == '-ezConAntAvgPluckQtyL'.lower():
                ezConAntAvgPluckQtyL.append(int(thisLine[1]))
                ezConAntAvgPluckQtyL.append(int(thisLine[2]))
                commandString += ' ' + thisLine0 + ' ' + thisLine[1] + ' ' + thisLine[2]

            elif thisLine0Lower == '-ezConAntAvgPluckFracL'.lower():
                ezConAntAvgPluckFracL.append(float(thisLine[1]))
                ezConAntAvgPluckFracL.append(float(thisLine[2]))
                commandString += ' ' + thisLine0 + ' ' + thisLine[1] + ' ' + thisLine[2]

            elif thisLine0Lower == '-ezConRefAvgPluckQtyL'.lower():
                ezConRefAvgPluckQtyL.append(int(thisLine[1]))
                ezConRefAvgPluckQtyL.append(int(thisLine[2]))
                commandString += ' ' + thisLine0 + ' ' + thisLine[1] + ' ' + thisLine[2]

            elif thisLine0Lower == '-ezConRefAvgPluckFracL'.lower():
                ezConRefAvgPluckFracL.append(float(thisLine[1]))
                ezConRefAvgPluckFracL.append(float(thisLine[2]))
                commandString += ' ' + thisLine0 + ' ' + thisLine[1] + ' ' + thisLine[2]

            elif thisLine0Lower == '-ezConAntBaselineFreqBinsFracL'.lower():
                ezConAntBaselineFreqBinsFracL[0] = float(thisLine[1])
                ezConAntBaselineFreqBinsFracL[1] = float(thisLine[2])
                ezConAntBaselineFreqBinsFracL[2] = float(thisLine[3])
                ezConAntBaselineFreqBinsFracL[3] = float(thisLine[4])
                commandString += ' ' + thisLine0 \
                    + ' ' + thisLine[1] + ' ' + thisLine[2] + ' ' + thisLine[3] + ' ' + thisLine[4]

            elif thisLine0Lower == '-ezConAntRABaselineFreqBinsFracL'.lower():
                ezConAntRABaselineFreqBinsFracL[0] = float(thisLine[1])
                ezConAntRABaselineFreqBinsFracL[1] = float(thisLine[2])
                ezConAntRABaselineFreqBinsFracL[2] = float(thisLine[3])
                ezConAntRABaselineFreqBinsFracL[3] = float(thisLine[4])
                commandString += ' ' + thisLine0 \
                    + ' ' + thisLine[1] + ' ' + thisLine[2] + ' ' + thisLine[3] + ' ' + thisLine[4]

            elif thisLine0Lower == '-ezConAntXTFreqBinsFracL'.lower():
                ezConAntXTFreqBinsFracL[0] = float(thisLine[1])
                ezConAntXTFreqBinsFracL[1] = float(thisLine[2])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1] + ' ' + thisLine[2]

            elif thisLine0Lower == '-ezConAntXTVTFreqBinsFracL'.lower():
                ezConAntXTVTFreqBinsFracL[0] = float(thisLine[1])
                ezConAntXTVTFreqBinsFracL[1] = float(thisLine[2])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1] + ' ' + thisLine[2]

            elif thisLine0Lower == '-ezConAntXTVTFreqBinsClipL'.lower():
                ezConAntXTVTFreqBinsClipL = []
                ezConAntXTVTFreqBinsClipL.append(int(thisLine[1]))
                ezConAntXTVTFreqBinsClipL.append(int(thisLine[2]))
                commandString += ' ' + thisLine0 + ' ' + thisLine[1] + ' ' + thisLine[2]

            elif thisLine0Lower == '-ezConAntXTVTIntegrate'.lower():
                ezConAntXTVTIntegrate = int(float(thisLine[1]))
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            elif thisLine0Lower == '-ezConAntXTVTMaxPluckQtyL'.lower():
                ezConAntXTVTMaxPluckQtyL.append(int(thisLine[1]))
                ezConAntXTVTMaxPluckQtyL.append(int(thisLine[2]))
                commandString += ' ' + thisLine0 + ' ' + thisLine[1] + ' ' + thisLine[2]

            elif thisLine0Lower == '-ezConAntXTVTMaxPluckValL'.lower():
                ezConAntXTVTMaxPluckValL.append(float(thisLine[1]))
                ezConAntXTVTMaxPluckValL.append(float(thisLine[2]))
                commandString += ' ' + thisLine0 + ' ' + thisLine[1] + ' ' + thisLine[2]

            elif thisLine0Lower == '-ezConAntXTVTAvgPluckQtyL'.lower():
                ezConAntXTVTAvgPluckQtyL.append(int(thisLine[1]))
                ezConAntXTVTAvgPluckQtyL.append(int(thisLine[2]))

            elif thisLine0Lower == '-ezConAntXTVTAvgPluckValL'.lower():
                ezConAntXTVTAvgPluckValL.append(float(thisLine[1]))
                ezConAntXTVTAvgPluckValL.append(float(thisLine[2]))
                commandString += ' ' + thisLine0 + ' ' + thisLine[1] + ' ' + thisLine[2]

            elif thisLine0Lower == '-ezConAntXTVTPluck'.lower():
                ezConAntXTVTPluckL.append(int(thisLine[1]))
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            elif thisLine0Lower == '-ezConAntXTVTClipL'.lower():
                ezConAntXTVTClipL = []
                ezConAntXTVTClipL.append(float(thisLine[1]))
                ezConAntXTVTClipL.append(float(thisLine[2]))
                commandString += ' ' + thisLine0 + ' ' + thisLine[1] + ' ' + thisLine[2]

            elif thisLine0Lower == '-ezConAntXTVTSmooth'.lower():
                ezConAntXTVTSmooth = int(thisLine[1])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            elif thisLine0Lower == '-ezCon087Csv'.lower():
                ezCon087Csv = int(thisLine[1])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1]

            elif thisLine0Lower == '-ezConAntXTVTLevelL'.lower():
                ezConAntXTVTLevelL[0] = float(thisLine[1])
                ezConAntXTVTLevelL[1] = float(thisLine[2])
                ezConAntXTVTLevelL[2] = float(thisLine[3])
                ezConAntXTVTLevelL[3] = float(thisLine[4])
                commandString += ' ' + thisLine0 \
                    + ' ' + thisLine[1] + ' ' + thisLine[2] + ' ' + thisLine[3] + ' ' + thisLine[4]

            elif thisLine0Lower == '-ezCon399SignalSampleByFreqBinL'.lower():
                ezCon399SignalSampleByFreqBinL[0] = int(thisLine[1])
                ezCon399SignalSampleByFreqBinL[1] = int(thisLine[2])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1] + ' ' + thisLine[2]

            elif thisLine0Lower == '-ezConHeatVMinMaxL'.lower():
                ezConHeatVMinMaxL[0] = float(thisLine[1])
                ezConHeatVMinMaxL[1] = float(thisLine[2])
                commandString += ' ' + thisLine0 + ' ' + thisLine[1] + ' ' + thisLine[2]

            elif thisLine0Lower == '-ezConPlotRangeL'.lower():
                #ezConPlotRangeL[0] = int(thisLine[1])
                #ezConPlotRangeL[1] = int(thisLine[2])
                #ezConPlotRangeL0 = int(thisLine[1])
                #ezConPlotRangeL1 = int(thisLine[2])
                #ezConPlotRangeL.append(range(ezConPlotRangeL0, ezConPlotRangeL1 + 1))
                ezConPlotRangeL += [int(thisLine[1]), int(thisLine[2])]
                commandString += ' ' + thisLine0 + ' ' + thisLine[1] + ' ' + thisLine[2]

            elif thisLine0Lower == '-ezConGalRaDecNearNearL'.lower():
                ezConGalRaDecNearNearL = []
                ezConGalRaDecNearNearL.append(float(thisLine[1]))
                ezConGalRaDecNearNearL.append(float(thisLine[2]))
                ezConGalRaDecNearNearL.append(float(thisLine[3]))
                ezConGalRaDecNearNearL.append(float(thisLine[4]))
                commandString += ' ' + thisLine0 \
                    + ' ' + thisLine[1] + ' ' + thisLine[2] + ' ' + thisLine[3] + ' ' + thisLine[4]


            elif thisLine0Lower[:6] == '-ezCon'.lower():
                print()
                print()
                print()
                print()
                print()
                print(' ========== FATAL ERROR:  Defaults file ( ' + ezDefaultsFileNameInput + ' )')
                print(" has this line's unrecognized first word:")
                print(fileLine)
                print()
                print()
                print()
                print()
                print('\a')     # ring bell
                exit()

            elif thisLine0Lower == '-ezDefaultsEnd'.lower():
                # ignore the rest of this defaults file
                fileDefaults.close()        #   then have processed all available lines in this defaults file
                return

            elif thisLine0Lower[:2] == '-e':
                pass    # unrecognized first word, but no error, allows for other ezRA programs

            else:
                # must be a data directory or file, remember it
                commandString += ' ' + thisLine0
                cmdDirectoryS += thisLine0 + ' '






    except (FileNotFoundError, IOError):
    	pass

    else:
        fileDefaults.close()                #   then have processed all available lines in this defaults file



def ezConArgumentsCommandLine():
    # process arguments from command line

    global commandString                    # string
    global cmdDirectoryS                    # string            creation

    global ezRAObsLat                       # float
    global ezRAObsLon                       # float
    global ezRAObsAmsl                      # float
    global ezRAObsName                      # string

    global ezConAddMHz                      # float - correction factor, add to all file's frequencies (MHz)
    global ezConAzDeg                       # float - force Azimuth   (Degrees)
    global ezConElDeg                       # float - force Elevation (Degrees)
    global ezConAddAzDeg                    # float - correction factor, add to file's Azimuth   (Degrees)
    global ezConAddElDeg                    # float - correction factor, add to file's Elevation (Degrees)

    global ezConInputdB                     # integer
    global ezConUseRefSub                   # integer
    global ezConAntXInput                   # integer
    global ezConUseVlsr                     # integer

    global ezConRawSamplesUseL              # integer list
    global ezConRawFreqBinTrimL             # list of (integer pair, float)
    global ezConRawFreqTrimL                # list of (float pair, float)
    global ezConRawFreqBinHideL             # integer list
    global ezConAntFreqBinHideL             # integer list
    global ezConRefFreqBinHideL             # integer list

    global ezConAntMaxPluckValL             # float list
    global ezConAntSamplesUseL              # integer list
    global ezConAntPluckL                   # integer list
    global ezConAntAvgPluckQtyL             # integer list
    global ezConAntAvgPluckFracL            # float list
    global ezConAntFreqBinSmooth            # float - RFI spur limiter: max muliplier over 4 neighboring freqBin

    global ezConRefAvgPluckQtyL             # integer list
    global ezConRefAvgPluckFracL            # float list
    global ezConRefMode                     # integer
    global ezConRefMode30L                  # float list
    global ezConRefMode31                   # float

    global ezConAntBaselineFreqBinsFracL    # float list
    global ezConAntRABaselineFreqBinsFracL  # float list
    global ezConAntXTFreqBinsFracL          # float list
    global ezConAntXTVTFreqBinsFracL        # float list

    global ezConAntXTVTMaxPluckQtyL         # integer list
    global ezConAntXTVTMaxPluckValL         # float list
    global ezConAntXTVTAvgPluckQtyL         # integer list
    global ezConAntXTVTAvgPluckValL         # float list
    global ezConAntXTVTPluckL               # integer list
    global ezConAntXTVTClipL                # float list
    global ezConAntXTVTSmooth               # integer
    global ezConAntXTVTFreqBinsClipL        # float list
    global ezConAntXTVTIntegrate            # integer
    global ezCon087Csv                      # integer
    global ezConAntXTVTLevelL               # float list
    global ezConGalNormalize                # integer

    global ezCon399SignalSampleByFreqBinL   # integer list
    global ezConHeatVMinMaxL                # float list

    global ezConAstroMath                   # integer

    global ezConDispGrid                    # integer
    global ezConDispFreqBin                 # integer
    global ezConRawDispIndex                # integer
    global ezConPlotRangeL                  # integer list

    global ezConVelGLonEdgeFrac             # float
    #global ezConVelGLonEdgeLevel            # float

    global ezConGalCrossingGLatCenterL      # float list
    global ezConGalCrossingGLatNear         # float
    global ezConGalCrossingGLonCenterL      # float list
    global ezConGalCrossingGLonNear         # float
    global ezConGalRaDecNearNearL           # float list

    print()
    print('   ezConArgumentsCommandLine ===============')

    #cmdLineSplit = commandString.split()
    cmdLineSplit = sys.argv[1:]
    cmdLineSplitLen = len(cmdLineSplit)
    #print(' cmdLineSplit =', cmdLineSplit)
        
    # need at least one data directory or file
    #if cmdLineSplitLen < 2:
    if cmdLineSplitLen < 1:
        printUsage()

    #cmdLineSplitIndex = 1
    cmdLineSplitIndex = 0
    #cmdDirectoryS = ''

    while cmdLineSplitIndex < cmdLineSplitLen:

        # be kind, ignore argument keyword capitalization
        #cmdLineArgLower = cmdLineSplit[cmdLineSplitIndex].lower()
        cmdLineArg = cmdLineSplit[cmdLineSplitIndex]
        cmdLineArgLower = cmdLineArg.lower()


        if cmdLineArgLower == '-help':
            printUsage()                    # will exit()

        elif cmdLineArgLower == '--help':
            printUsage()                    # will exit()

        elif cmdLineArgLower == '-h':
            printUsage()                    # will exit()

        elif cmdLineArgLower == '--h':
            printUsage()                    # will exit()

        elif cmdLineArgLower[0] == '#':     # ignoring whitespace, if first character of word
            commandString += ' ' + ' '.join(cmdLineSplit[cmdLineSplitIndex:])
            break                           # rest of line is a comment (automatic trim in Linux)

        elif 2 <= len(cmdLineArgLower) and cmdLineArgLower[:2] == '-e':

            # Ignoring whitespace, first characters of cmdLineSplit word are '-e'.
            # Not a data directory or file.

            # ezRA arguments used by multiple programs:
            if cmdLineArgLower == '-ezRAObsLat'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezRAObsLat  = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezRAObsLon'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezRAObsLon  = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezRAObsAmsl'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezRAObsAmsl = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezRAObsName'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezRAObsName = cmdLineSplit[cmdLineSplitIndex]   # cmd line allows only one ezRAObsName word
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
            

            # integer arguments:
            #elif cmdLineArgLower == '-ezConInputdBm'.lower():
            #                         01234567890123
            elif cmdLineArgLower[:13] == '-ezConInputdB'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConInputdB = int(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
            
            elif cmdLineArgLower == '-ezConUseRefSub'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConUseRefSub = int(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
            
            elif cmdLineArgLower == '-ezConAntXInput'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAntXInput = int(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConUseVlsr'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConUseVlsr = int(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConRawDispIndex'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConRawDispIndex = int(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConDispGrid'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConDispGrid = int(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConDispFreqBin'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConDispFreqBin = int(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConAstroMath'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAstroMath = int(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConRefMode'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConRefMode = int(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConRefMode30L'.lower():
                # -ezConRefMode30L freqAnt freqRef bwAnt
                ezConRefMode = 30
                cmdLineSplitIndex += 1      # point to first argument value
                ezConRefMode30L = []
                ezConRefMode30L.append(float(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConRefMode30L.append(float(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConRefMode30L.append(float(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConRefMode31'.lower():
                # -ezConRefMode31 RAHours
                ezConRefMode = 31
                cmdLineSplitIndex += 1      # point to first argument value
                ezConRefMode31 = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConAntPluck'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAntPluckL.append(int(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConGalNormalize'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConGalNormalize = int(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]


            # float arguments:
            elif cmdLineArgLower == '-ezConAddMHz'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAddMHz = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConAzimuth'.lower() or cmdLineArgLower == '-ezConAzDeg'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAzDeg = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConElevation'.lower() or cmdLineArgLower == '-ezConElDeg'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConElDeg = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConAddAzDeg'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAddAzDeg = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConAddElDeg'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAddElDeg = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConAntFreqBinSmooth'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAntFreqBinSmooth = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConGalCrossingGLatCenter'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConGalCrossingGLatCenterL += [int(cmdLineSplit[cmdLineSplitIndex])]
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConGalCrossingGLatCenterL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConGalCrossingGLatCenterL0 = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConGalCrossingGLatCenterL1 = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConGalCrossingGLatCenterL2 = int(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]
                ezConGalCrossingGLatCenterL += np.linspace(ezConGalCrossingGLatCenterL0, \
                    ezConGalCrossingGLatCenterL1, num=ezConGalCrossingGLatCenterL2).tolist()
                #ezConGalCrossingGLatCenterL += range(ezConGalCrossingGLatCenterL0, ezConGalCrossingGLatCenterL1)

            # grandfather -ezConGalCrossingGLat as -ezConGalCrossingGLatNear
            elif cmdLineArgLower == '-ezConGalCrossingGLat'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConGalCrossingGLatNear = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConGalCrossingGLatNear'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConGalCrossingGLatNear = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]


            elif cmdLineArgLower == '-ezConGalCrossingGLonCenter'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConGalCrossingGLonCenterL += [float(cmdLineSplit[cmdLineSplitIndex])]
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConGalCrossingGLonCenterL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConGalCrossingGLonCenterL0 = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConGalCrossingGLonCenterL1 = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConGalCrossingGLonCenterL2 = int(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]
                ezConGalCrossingGLonCenterL += np.linspace(ezConGalCrossingGLonCenterL0, \
                    ezConGalCrossingGLonCenterL1, num=ezConGalCrossingGLonCenterL2).tolist()
                #ezConGalCrossingGLatCenterL += range(ezConGalCrossingGLatCenterL0, ezConGalCrossingGLatCenterL1)

            elif cmdLineArgLower == '-ezConGalCrossingGLonNear'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConGalCrossingGLonNear = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConVelGLonEdgeFrac'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConVelGLonEdgeFrac = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            #elif cmdLineArgLower == '-ezConVelGLonEdgeLevel'.lower():
            #    cmdLineSplitIndex += 1      # point to first argument value
            #    ezConVelGLonEdgeLevel = float(cmdLineSplit[cmdLineSplitIndex])


            elif cmdLineArgLower == '-ezConRawFreqBinTrimL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConRawFreqBinTrimL0 = int(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConRawFreqBinTrimL1 = int(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]
                if ezConRawFreqBinTrimL0 <= ezConRawFreqBinTrimL1:
                    ezConRawFreqBinTrimL.append(ezConRawFreqBinTrimL0)
                    ezConRawFreqBinTrimL.append(ezConRawFreqBinTrimL1)
                else:
                    ezConRawFreqBinTrimL.append(ezConRawFreqBinTrimL1)
                    ezConRawFreqBinTrimL.append(ezConRawFreqBinTrimL0)
                cmdLineSplitIndex += 1
                ezConRawFreqBinTrimL.append(float(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConRawFreqTrimL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConRawFreqTrimL0 = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConRawFreqTrimL1 = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]
                if ezConRawFreqTrimL0 <= ezConRawFreqTrimL1:
                    ezConRawFreqTrimL.append(ezConRawFreqTrimL0)
                    ezConRawFreqTrimL.append(ezConRawFreqTrimL1)
                else:
                    ezConRawFreqTrimL.append(ezConRawFreqTrimL1)
                    ezConRawFreqTrimL.append(ezConRawFreqTrimL0)
                cmdLineSplitIndex += 1
                ezConRawFreqTrimL.append(float(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConRawFreqBinHide'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConRawFreqBinHideL.append(int(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConRawFreqBinHideL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConRawFreqBinHideL0 = int(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConRawFreqBinHideL1 = int(cmdLineSplit[cmdLineSplitIndex])
                if ezConRawFreqBinHideL0 <= ezConRawFreqBinHideL1:
                    ezConRawFreqBinHideL += range(ezConRawFreqBinHideL0, ezConRawFreqBinHideL1 + 1)
                else:
                    ezConRawFreqBinHideL += range(ezConRawFreqBinHideL1, ezConRawFreqBinHideL0 + 1)[::-1]
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConAntFreqBinHide'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAntFreqBinHideL.append(int(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConAntFreqBinHideL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAntFreqBinHideL0 = int(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConAntFreqBinHideL1 = int(cmdLineSplit[cmdLineSplitIndex])
                if ezConAntFreqBinHideL0 <= ezConAntFreqBinHideL1:
                    ezConAntFreqBinHideL += range(ezConAntFreqBinHideL0, ezConAntFreqBinHideL1 + 1)
                else:
                    ezConAntFreqBinHideL += range(ezConAntFreqBinHideL1, ezConAntFreqBinHideL0 + 1)[::-1]
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConRefFreqBinHide'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConRefFreqBinHideL.append(int(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConRefFreqBinHideL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConRefFreqBinHideL0 = int(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConRefFreqBinHideL1 = int(cmdLineSplit[cmdLineSplitIndex])
                if ezConRefFreqBinHideL0 <= ezConRefFreqBinHideL1:
                    ezConRefFreqBinHideL += range(ezConRefFreqBinHideL0, ezConRefFreqBinHideL1 + 1)
                else:
                    ezConRefFreqBinHideL += range(ezConRefFreqBinHideL1, ezConRefFreqBinHideL0 + 1)[::-1]
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConRawSamplesUseL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConRawSamplesUseL.append(int(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConRawSamplesUseL.append(int(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConAntMaxPluckValL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAntMaxPluckValL = []
                ezConAntMaxPluckValL.append(int(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConAntMaxPluckValL.append(int(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConAntSamplesUseL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAntSamplesUseL.append(int(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConAntSamplesUseL.append(int(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConAntAvgPluckQtyL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAntAvgPluckQtyL.append(int(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConAntAvgPluckQtyL.append(int(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConAntAvgPluckFracL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAntAvgPluckFracL.append(float(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConAntAvgPluckFracL.append(float(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConRefAvgPluckQtyL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConRefAvgPluckQtyL.append(int(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConRefAvgPluckQtyL.append(int(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConRefAvgPluckFracL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConRefAvgPluckFracL.append(float(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConRefAvgPluckFracL.append(float(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConAntBaselineFreqBinsFracL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAntBaselineFreqBinsFracL[0] = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConAntBaselineFreqBinsFracL[1] = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConAntBaselineFreqBinsFracL[2] = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConAntBaselineFreqBinsFracL[3] = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConAntRABaselineFreqBinsFracL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAntRABaselineFreqBinsFracL[0] = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConAntRABaselineFreqBinsFracL[1] = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConAntRABaselineFreqBinsFracL[2] = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConAntRABaselineFreqBinsFracL[3] = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConAntXTFreqBinsFracL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAntXTFreqBinsFracL[0] = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConAntXTFreqBinsFracL[1] = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConAntXTVTFreqBinsFracL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAntXTVTFreqBinsFracL[0] = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConAntXTVTFreqBinsFracL[1] = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConAntXTVTFreqBinsClipL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAntXTVTFreqBinsClipL.append(int(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConAntXTVTFreqBinsClipL.append(int(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConAntXTVTIntegrate'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAntXTVTIntegrate = int(float(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConAntXTVTMaxPluckQtyL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAntXTVTMaxPluckQtyL.append(int(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConAntXTVTMaxPluckQtyL.append(int(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConAntXTVTMaxPluckValL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAntXTVTMaxPluckValL.append(float(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConAntXTVTMaxPluckValL.append(float(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConAntXTVTAvgPluckQtyL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAntXTVTAvgPluckQtyL.append(int(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConAntXTVTAvgPluckQtyL.append(int(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConAntXTVTAvgPluckValL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAntXTVTAvgPluckValL.append(float(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConAntXTVTAvgPluckValL.append(float(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConAntXTVTPluck'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAntXTVTPluckL.append(int(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConAntXTVTClipL'.lower():
                ezConAntXTVTClipL = []
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAntXTVTClipL.append(float(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConAntXTVTClipL.append(float(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConAntXTVTSmooth'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAntXTVTSmooth = int(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezCon087Csv'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezCon087Csv = int(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConAntXTVTLevelL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConAntXTVTLevelL[0] = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConAntXTVTLevelL[1] = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConAntXTVTLevelL[2] = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConAntXTVTLevelL[3] = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezCon399SignalSampleByFreqBinL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezCon399SignalSampleByFreqBinL[0] = int(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezCon399SignalSampleByFreqBinL[1] = int(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConHeatVMinMaxL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                ezConHeatVMinMaxL[0] = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConHeatVMinMaxL[1] = float(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezConPlotRangeL'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                #ezConPlotRangeL[0] = int(cmdLineSplit[cmdLineSplitIndex])
                #cmdLineSplitIndex += 1
                #ezConPlotRangeL[1] = int(cmdLineSplit[cmdLineSplitIndex])
                ezConPlotRangeL0 = int(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConPlotRangeL1 = int(cmdLineSplit[cmdLineSplitIndex])
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]
                #ezConPlotRangeL.append(range(ezConPlotRangeL0, ezConPlotRangeL1 + 1))
                ezConPlotRangeL += [ezConPlotRangeL0, ezConPlotRangeL1]

            elif cmdLineArgLower == '-ezConGalRaDecNearNearL'.lower():
                ezConGalRaDecNearNearL = []
                cmdLineSplitIndex += 1      # point to first argument value
                ezConGalRaDecNearNearL.append(float(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConGalRaDecNearNearL.append(float(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConGalRaDecNearNearL.append(float(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]
                cmdLineSplitIndex += 1
                ezConGalRaDecNearNearL.append(float(cmdLineSplit[cmdLineSplitIndex]))
                commandString += ' ' + cmdLineSplit[cmdLineSplitIndex]

            elif cmdLineArgLower == '-ezDefaultsFile'.lower():
                cmdLineSplitIndex += 1      # point to first argument value
                commandString += ' ' + cmdLineArg + ' ' + cmdLineSplit[cmdLineSplitIndex]
                ezConArgumentsFile(cmdLineSplit[cmdLineSplitIndex])

            # ignore silly -eX* arguments, for handy neutralization of command line arguments,
            #   but remove spaces before argument numbers
            #   (can not use '-x' which is a preface to a negative hexadecimal number)
            elif 3 <= len(cmdLineArgLower) and cmdLineArgLower[:3] == '-ex':
                commandString += ' ' + cmdLineArg

            # before -eX, old spelling:
            # ignore silly -ezez* arguments, for handy neutralization of command line arguments,
            #   but remove spaces before argument numbers
            elif 5 <= len(cmdLineArgLower) and cmdLineArgLower[:5] == '-ezez':
                commandString += ' ' + cmdLineArg

            elif cmdLineArgLower[:6] == '-ezCon'.lower():
                print()
                print()
                print()
                print()
                print()
                print(' ========== FATAL ERROR:  Command line has this unrecognized word:')
                print(cmdLineSplit[cmdLineSplitIndex])
                print()
                print()
                print()
                print()
                print('\a')     # ring bell
                exit()

            else:
                pass    # unrecognized first word, but no error, allows for other ezRA programs

        else:
            # must be a data directory or file, remember it
            commandString += ' ' + cmdLineArg
            cmdDirectoryS += cmdLineSplit[cmdLineSplitIndex] + ' '

        cmdLineSplitIndex += 1



def ezConArguments():
    # argument: (Computing) a value or address passed to a procedure or function at the time of call

    global programRevision                  # string
    global commandString                    # string
    global cmdDirectoryS                    # string            creation

    global ezRAObsLat                       # float
    global ezRAObsLon                       # float
    global ezRAObsAmsl                      # float
    global ezRAObsName                      # string

    global ezConAddMHz                      # float - correction factor, add to all file's frequencies (MHz)
    global ezConAzDeg                       # float - force Azimuth   (Degrees)
    global ezConElDeg                       # float - force Elevation (Degrees)
    global ezConAddAzDeg                    # float - correction factor, add to file's Azimuth   (Degrees)
    global ezConAddElDeg                    # float - correction factor, add to file's Elevation (Degrees)

    global ezConInputdB                     # integer
    global ezConUseRefSub                   # integer
    global ezConAntXInput                   # integer
    global ezConUseVlsr                     # integer

    global ezConRawSamplesUseL              # integer list
    global ezConRawFreqBinTrimL             # list of (integer pair, float)
    global ezConRawFreqTrimL                # list of (float pair, float)
    global ezConRawFreqBinHideL             # integer list
    global ezConAntFreqBinHideL             # integer list
    global ezConRefFreqBinHideL             # integer list

    global ezConAntMaxPluckValL             # float list
    global ezConAntSamplesUseL              # integer list
    global ezConAntPluckL                   # integer list
    global ezConAntAvgPluckQtyL             # integer list
    global ezConAntAvgPluckFracL            # float list
    global ezConAntFreqBinSmooth            # float - RFI spur limiter: max muliplier over 4 neighboring freqBin

    global ezConRefAvgPluckQtyL             # integer list
    global ezConRefAvgPluckFracL            # float list
    global ezConRefMode                     # integer
    global ezConRefMode30L                  # float list
    global ezConRefMode31                   # float

    global ezConAntBaselineFreqBinsFracL    # float list
    global ezConAntRABaselineFreqBinsFracL  # float list
    global ezConAntXTFreqBinsFracL          # float list
    global ezConAntXTVTFreqBinsFracL        # float list

    global ezConAntXTVTMaxPluckQtyL         # integer list
    global ezConAntXTVTMaxPluckValL         # float list
    global ezConAntXTVTAvgPluckQtyL         # integer list
    global ezConAntXTVTAvgPluckValL         # float list
    global ezConAntXTVTPluckL               # integer list
    global ezConAntXTVTClipL                # float list
    global ezConAntXTVTSmooth               # integer
    global ezConAntXTVTFreqBinsClipL        # float list
    global ezConAntXTVTFreqBinsClipUpdate   # integer
    global ezConAntXTVTIntegrate            # integer
    global ezCon087Csv                      # integer
    global ezConAntXTVTLevelL               # float list
    global ezConGalNormalize                # integer

    global ezCon399SignalSampleByFreqBinL   # integer list
    global ezCon399SignalSampleByFreqBin1d  # float list or numpy

    global ezConHeatVMinMaxL                # float list

    global ezConAstroMath                   # integer

    global fileNameLast                     # string
    global plotCountdown                    # integer

    global ezConDispGrid                    # integer
    global ezConDispFreqBin                 # integer
    global ezConRawDispIndex                # integer
    global ezConPlotRangeL                  # integer list
    global ezConPlotRequestedL              # integer list

    global ezConVelGLonEdgeFrac             # float
    global ezConVelGLonEdgeLevel            # float

    global ezConGalCrossingGLatCenterL      # float list
    global ezConGalCrossingGLatNear         # float
    global ezConGalCrossingGLonCenterL      # float list
    global ezConGalCrossingGLonNear         # float
    global ezConGalRaDecNearNearL           # float list

    # defaults
    if 1:
        ezRAObsLat  = -999.                 # silly number
        ezRAObsLon  = -999.                 # silly number
        ezRAObsAmsl = -999.                 # silly number
        #ezRAObsName = 'LebanonKS'
        ezRAObsName = ''                    # silly name

        ezConInputdB      =  0
        ezConUseRefSub    =  0
        ezConAntXInput    = -1              # default = -1 for auto choice: AntB, or if 1 < refQty then AntRB
        ezConUseVlsr      =  1
        ezConRawDispIndex =  0

        ezConAddMHz    = 0.
        ezConAzDeg     = -999               # float - silly value for simulate Azimuth (Degrees)
        ezConElDeg     = -999               # float - silly value for simulate Elevation (Degrees)
        ezConAddAzDeg  = 0.
        ezConAddElDeg  = 0.

        ezConRawSamplesUseL   = []          # empty to disable
        ezConRawFreqBinTrimL  = []          # empty to disable
        ezConRawFreqTrimL     = []          # empty to disable
        ezConRawFreqBinHideL  = []          # empty to disable
        ezConAntFreqBinHideL  = []          # empty to disable
        ezConRefFreqBinHideL  = []          # empty to disable

        ezConAntMaxPluckValL  = []          # empty to disable
        ezConAntSamplesUseL   = []          # empty to disable
        ezConAntPluckL        = []          # empty to disable
        ezConAntAvgPluckQtyL  = []          # empty to disable
        ezConAntAvgPluckFracL = []          # empty to disable
        ezConAntFreqBinSmooth = 999999.     # RFI spur limiter: max muliplier over 4 neighboring freqBin

        ezConRefAvgPluckQtyL  = []          # empty to disable
        ezConRefAvgPluckFracL = []          # empty to disable

        # to average, specify low and high freqBin of total freqBin,
        # 60 low of 256 freqBin like (60 / 256 = 0.2344) or (150 / 1024 = 0.1465),
        #   and 60 high of 256 like (1 - 0.2344 = 0.7656) or (1 - 0.1465 = 0.8535)
        #   (1 / 256 = 0.00390625) or (1 / 1024 = 0.0009765625)
        ezConAntBaselineFreqBinsFracL   = [0, 0.2344, 0.7656, 1]
        ezConAntRABaselineFreqBinsFracL = [0, 0.2344, 0.7656, 1]

        # for a bandwidth of 2.4 desired Doppler x, try (2.4 / 2 + x) / 2.4
        #   like for Doppler -0.5, (2.4 / 2 + (-0.5 )) / 2.4 = 0.2917,
        #   like for Doppler  4.5, (2.4 / 2 + ( 0.45)) / 2.4 = 0.6888
        ezConAntXTFreqBinsFracL         = [   0.15,   0.85      ]

        ezConAntXTVTFreqBinsFracL       = [   0.25,   0.75      ]

        ezConAntXTVTMaxPluckQtyL  = []       # to disable
        ezConAntXTVTMaxPluckValL  = []       # to disable
        ezConAntXTVTAvgPluckQtyL  = []       # to disable
        ezConAntXTVTAvgPluckValL  = []       # to disable
        ezConAntXTVTPluckL        = []       # to disable
        ezConAntXTVTClipL         = []       # to disable
        ezConAntXTVTSmooth        = 0        # to disable
        ezConAntXTVTFreqBinsClipL = []       # to disable
        ezConAntXTVTFreqBinsClipUpdate = 0   # to disable
        ezConAntXTVTIntegrate     = 0        # to disable
        ezCon087Csv               = 0        # to disable
        ezConAntXTVTLevelL = [1., 0., 1., 0.]   # to disable
        ezConGalNormalize         = 0        # to disable

        ezCon399SignalSampleByFreqBinL = [10, 0]    # Ant, antenna sample 0
        ezCon399SignalSampleByFreqBin1d = []        # flag as empty

        ezConHeatVMinMaxL = [0., 0.]        # default is to autoscale heatVMin of heatmaps

        ezConDispGrid    = 0
        ezConDispFreqBin = 0

        #ezConAstroMath = 2                  # 2 = astropy math = slow but authoritative
        ezConAstroMath = 1                  # 1 = math from MIT Haystack SRT

        ezConRefMode = 10
        ezConRefMode30L = []
        ezConRefMode31 = -1

        ezConGalCrossingGLatCenterL = []    # empty for default Galactic plane
        # defines 'close to GLat crossing" in Galactic Latitude degrees
        ezConGalCrossingGLatNear    = 5.

        ezConGalCrossingGLonCenterL = []    # empty to disable
        # defines 'close to GLon crossing" in Galactic Longitude degrees
        ezConGalCrossingGLonNear    = 0.5

        ezConGalRaDecNearNearL = []         # empty to disable

        ezConVelGLonEdgeFrac =  0.5     # velGLon level fraction for plotEzCon430velGLonEdges()
        ezConVelGLonEdgeLevel = 0.      # velGLon level for plotEzCon430velGLonEdges(), if not 0 then
                                        #   ezConVelGLonEdgeFrac ignored

        ezConPlotRangeL = []

    plotCountdown = 97                  # number of plots still to print

    # Program argument priority:
    #    Start with the argument value defaults inside the programs.
    #    Then replace those values with any arguments from the ezDefaults.txt in the program's directory.
    #    Then replace values with any arguments from the ezDefaults.txt in the current
    #       directory (where you are standing).
    #    Then replace values (in order) with any arguments from the command line (including
    #       any -ezDefaultsFile).
    #    Each last defined value wins.
    # The top (and bottom ?) of the program printout should list the resultant argument values.
    # Eventually support -ezez argument preface, to allow ignoring.

    commandString = sys.argv[0]
    cmdDirectoryS = ''

    # process arguments from ezDefaults.txt file in the same directory as this ezCon program
    ezConArgumentsFile(os.path.dirname(__file__) + os.path.sep + 'ezDefaults.txt')

    # process arguments from ezDefaults.txt file in the current directory
    ezConArgumentsFile('ezDefaults.txt')

    # process arguments from command line
    ezConArgumentsCommandLine()

    #ezConRawFreqBinHideL  = sorted(set(ezConRawFreqBinHideL))   # unique and increasing
 
    # sanity tests

    if ezConAntXInput not in [-1, 0, 2, 4, 5, 6]:
        print()
        print()
        print()
        print()
        print()
        print(' ========== FATAL ERROR: ', ezConAntXInput, 'is an unrecognized value for ezConAntXInput')
        print('                            Allowed values = -1, 0, 2, 4, 5, or 6')
        print()
        print()
        print()
        print()
        print('\a')     # ring bell
        exit()

    if ezConAntXTVTIntegrate not in [0, 1, 4]:
        print()
        print()
        print()
        print()
        print()
        print(' ========== FATAL ERROR: ', ezConAntXTVTIntegrate, 'is an unrecognized value for ezConAntXTVTIntegrate')
        print('                            Allowed values = 0, 1, or 4')
        print()
        print()
        print()
        print()
        print('\a')     # ring bell
        exit()

    if ezCon399SignalSampleByFreqBinL[0] not in [10, 12, 14, 16, 18]:
        print()
        print()
        print()
        print()
        print()
        print(' ========== FATAL ERROR: ', ezCon399SignalSampleByFreqBinL[0], 'is an unrecognized value for ezCon399SignalSampleByFreqBinL[0]')
        print('                            Allowed values = 10, 12, 14, 16, or 18')
        print()
        print()
        print()
        print()
        print('\a')     # ring bell
        exit()

    if ezConGalCrossingGLatCenterL == []:
        ezConGalCrossingGLatCenterL = [0.]

    # create ezConPlotAllL list of all possible ezCon plot numbers
    ezConPlotAllL  = [0, 1, 2, 7, 17, 27, 37, 47, 57, 61, 67, 77, 81, 82, 86, 87, 88, 89, 96, 97, 98, 99]
    ezConPlotAllL += [100, 101, 102, 103, 104, 105, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 191]
    ezConPlotAllL += [200, 201, 202, 207, 217, 227, 237, 241, 247, 257, 261, 262, 267, 277, 281, 282, 287, 297]
    ezConPlotAllL += [300, 301, 302, 307, 317, 327, 337, 347, 357, 361, 367, 377, 381, 382, 383, 386, 387, 388, 391, 392, 393, 394, 396, 397, 398, 399]
    ezConPlotAllL += [510, 519, 520, 529, 530, 541, 550]
    ezConPlotAllL += [690]
    ezConPlotAllL += [800]
    # create ezConPlotRequestedL list of requested ezCon plot numbers
    print('================== ezConPlotRangeL =', ezConPlotRangeL)
    print('================== len(ezConPlotRangeL) =', len(ezConPlotRangeL))
    if ezConPlotRangeL:
        ezConPlotRequestedL = []
        for i in range(0, len(ezConPlotRangeL), 2):                            # ezConPlotRangeL comes in pairs
            #for j in range(ezConPlotRangeL[i], ezConPlotRangeL[i+1]):
            #    if j in ezConPlotAllL:
            #        ezConPlotRequestedL.append(j)
            ezConPlotRequestedL += list(set(range(ezConPlotRangeL[i], ezConPlotRangeL[i+1]+1)) & set(ezConPlotAllL))
        ezConPlotRequestedL = list(set(ezConPlotRequestedL))                    # in to a unique list
    else:
        ezConPlotRequestedL = ezConPlotAllL
    print('================== ezConPlotRequestedL =', sorted(ezConPlotRequestedL))
    print('================== len(ezConPlotRequestedL) =', len(ezConPlotRequestedL))

    if 1:
        # print status
        print()
        print('   ezRAObsName =', ezRAObsName)
        print('   ezRAObsLat  =', ezRAObsLat)
        print('   ezRAObsLon  =', ezRAObsLon)
        print('   ezRAObsAmsl =', ezRAObsAmsl)
        print()
        print('   ezConAddMHz =', ezConAddMHz)
        print('   ezConAzDeg =', ezConAzDeg)
        print('   ezConElDeg =', ezConElDeg)
        print('   ezConAddAzDeg =', ezConAddAzDeg)
        print('   ezConAddElDeg =', ezConAddElDeg)
        print()
        print('   ezConInputdB  =', ezConInputdB)
        print()
        print('   ezConRawSamplesUseL   =', ezConRawSamplesUseL)
        print('   ezConRawFreqBinTrimL  =', ezConRawFreqBinTrimL)
        print('   ezConRawFreqTrimL     =', ezConRawFreqTrimL)
        print('   ezConRawFreqBinHideL  =', ezConRawFreqBinHideL)
        print('   ezConAntFreqBinHideL  =', ezConAntFreqBinHideL)
        print('   ezConRefFreqBinHideL  =', ezConRefFreqBinHideL)
        print()
        print('   ezConRefMode          =', ezConRefMode)
        print('   ezConRefMode30L       =', ezConRefMode30L)
        print('   ezConRefMode31        =', ezConRefMode31)
        print()
        print('   ezConAntMaxPluckValL  =', ezConAntMaxPluckValL)
        print('   ezConAntSamplesUseL   =', ezConAntSamplesUseL)
        print('   ezConAntPluckL        =', ezConAntPluckL)
        print('   ezConAntAvgPluckQtyL  =', ezConAntAvgPluckQtyL)
        print('   ezConAntAvgPluckFracL =', ezConAntAvgPluckFracL)
        print('   ezConAntFreqBinSmooth =', ezConAntFreqBinSmooth)
        print()
        print('   ezConRefAvgPluckQtyL  =', ezConRefAvgPluckQtyL)
        print('   ezConRefAvgPluckFracL =', ezConRefAvgPluckFracL)
        print()
        print('   ezConUseRefSub        =', ezConUseRefSub)
        print()
        print('   ezConAntBaselineFreqBinsFracL   =', ezConAntBaselineFreqBinsFracL)
        print('   ezConAntRABaselineFreqBinsFracL =', ezConAntRABaselineFreqBinsFracL)
        print()
        print('   ezConAntXInput                  =', ezConAntXInput)
        print('   ezConAntXTVTLevelL              =', ezConAntXTVTLevelL)
        print()
        print('   ezConAntXTFreqBinsFracL         =', ezConAntXTFreqBinsFracL)
        print('   ezConUseVlsr                    =', ezConUseVlsr)
        print('   ezConAntXTVTFreqBinsFracL       =', ezConAntXTVTFreqBinsFracL)
        print()
        print('   ezConAntXTVTMaxPluckQtyL        =', ezConAntXTVTMaxPluckQtyL)
        print('   ezConAntXTVTMaxPluckValL        =', ezConAntXTVTMaxPluckValL)
        print('   ezConAntXTVTAvgPluckQtyL        =', ezConAntXTVTAvgPluckQtyL)
        print('   ezConAntXTVTAvgPluckValL        =', ezConAntXTVTAvgPluckValL)
        print('   ezConAntXTVTPluckL              =', ezConAntXTVTPluckL)
        print('   ezConAntXTVTClipL               =', ezConAntXTVTClipL)
        print('   ezConAntXTVTSmooth              =', ezConAntXTVTSmooth)
        print('   ezConAntXTVTFreqBinsClipL       =', ezConAntXTVTFreqBinsClipL)
        print('   ezConAntXTVTIntegrate           =', ezConAntXTVTIntegrate)
        print('   ezConGalNormalize               =', ezConGalNormalize)
        print('   ezCon087Csv                     =', ezCon087Csv)
        print()
        print('   ezCon399SignalSampleByFreqBinL  =', ezCon399SignalSampleByFreqBinL)
        print()
        print('   ezConRawDispIndex     =', ezConRawDispIndex)
        print('   ezConDispGrid         =', ezConDispGrid)
        print('   ezConDispFreqBin      =', ezConDispFreqBin)
        print('   ezConHeatVMinMaxL     =', ezConHeatVMinMaxL)
        print()
        print('   ezConAstroMath        =', ezConAstroMath)
        print()
        print('   ezConGalCrossingGLatCenterL =', ezConGalCrossingGLatCenterL)
        print('   ezConGalCrossingGLatNear    =', ezConGalCrossingGLatNear)
        print()
        print('   ezConGalCrossingGLonCenterL =', ezConGalCrossingGLonCenterL)
        print('   ezConGalCrossingGLonNear    =', ezConGalCrossingGLonNear)
        print()
        print('   ezConGalRaDecNearNearL      =', ezConGalRaDecNearNearL)
        print()
        print('   ezConVelGLonEdgeFrac  =', ezConVelGLonEdgeFrac)
        print('   ezConVelGLonEdgeLevel =', ezConVelGLonEdgeLevel)
        print()
        print('   ezConPlotRangeL       =', ezConPlotRangeL)



def readDataDir():
    # Open each .txt radio file in each directory and read individual lines.
    # Creates ezRAObsLat, ezRAObsLon, ezRAObsAmsl, ezRAObsName,
    #   fileFreqMin, fileFreqMax, fileFreqBinQty,
    #   azimuthDeg, elevationDeg, dataFileIdx, dataTimeUtc, raw, rawLen, fileNameLast

    global cmdDirectoryS            # string

    global ezRAObsLat               # float
    global ezRAObsLon               # float
    global ezRAObsAmsl              # float
    global ezRAObsName              # string
    
    global fileNameLast             # string                                    creation
    global fileFreqMin              # float                                     creation
    global fileFreqMax              # float                                     creation
    global fileFreqBinQty           # integer                                   creation

    global ezConInputdB             # integer

    global ezConRawSamplesUseL      # integer list
    global ezConRefMode             # integer
    global ezConRefMode30L          # float list
    global ezConRefMode31           # float

    global dataFileIdx              # integer array                             creation
    global dataTimeUtc              # 'astropy.time.core.Time' object array     creation
    global azimuthDeg               # float array                               creation
    global elevationDeg             # float array                               creation

    global ezConAddMHz              # float
    global ezConAzDeg               # float
    global ezConElDeg               # float
    global ezConAddAzDeg            # float
    global ezConAddElDeg            # float
    global raw                      # float 2d array                            creation
    global rawLen                   # integer                                   creation
    global refQty                   # integer                                   creation

    global ezConAntXInput           # integer
    global studyOutString           # string                                    creation
    global commandString            # string

    print()
    print('   readDataDir ===============')

    rawLen  = 0
    refQty  = 0
    feedRefOnThis = 0
    dataFileIdxThis = -1
    pointingLineSplitNew = False    # flag
    locBaseValid = False            # flag locBase as empty (for astropy)

    if ezConRawSamplesUseL:
        # start with first pair of ezConRawSamplesUseL list elements
        useSamplesRawLast  = ezConRawSamplesUseL[-1]
        useSamplesRawStart = ezConRawSamplesUseL[0]
        useSamplesRawStop  = ezConRawSamplesUseL[1]
        useSamplesRawIndex = 2                          # point to next start/stop pair, if any
    else:
        # ezConRawSamplesUseL empty
        useSamplesRawLast  = 99999999999                # silly big number
        useSamplesRawStart = 0
        useSamplesRawStop  = useSamplesRawLast          # silly big number
    sampleCount = 0         # increments whether or not the data line was collected (ezConRawSamplesUseL)


    directoryList = cmdDirectoryS.split()
    directoryListLen = len(directoryList)
    
    ezRAObsNameFile = ''
    studyOutString = '\n'
    studyOutString += f'now = UTC time {datetime.now(timezone.utc).strftime("%Y-%m-%dT%H:%M:%S")}\n'
    studyOutString += f'programRevision = {programRevision}\n'
    studyOutString += f'Python sys.version = {sys.version}\n'
    studyOutString += f'matplotlib.__version__ = {matplotlib.__version__}\n\n'
    # record the (complex?) ezCon command line
    studyOutString += f'Python commandString = {commandString}\n\n'
    dataElevationRefDeg = np.array([999.9])             # silly value to mark as a REF sample
    for directoryCounter in range(directoryListLen):
        directory = directoryList[directoryCounter]

        # if arguments are .txt filenames,
        # pass each of them through together as a mini directory list of .txt files.
        # Allows one .txt file from a directory of .txt files.
        # Allows .bat batch file control.
        if directory.lower().endswith('.txt'):
            fileList = [directory]
            directory = '.'
        else:
            fileList = sorted(os.listdir(directory))    # each directory sorted alphabetically
        fileListLen = len(fileList)
        for fileCounter in range(fileListLen):
            fileReadName = fileList[fileCounter]

            if not fileReadName.lower().endswith('.txt'):
                continue            # skip to next file

            if fileReadName[0] == os.path.sep or fileReadName[0] == '.':
                fileReadNameFull = fileReadName
            else:
                fileReadNameFull = directory + os.path.sep + fileReadName
            print()
            print(' inspecting', fileReadNameFull)
            fileRead = open(fileReadNameFull, 'r')
            if fileRead.mode == 'r':

                ## 220301 new format
                ## ezRA ezCol .txt daily data file with 3-line non-comment header and
                ##   1-line samples each with timestamp and 256 values:
                ##
                ## from ezCol04b5ea.py
                ## lat 40.299512 long -105.084491 amsl 1524 name N0RQV8 ezb
                ## freqMin 1419.205 freqMax 1421.605 freqBinQty 256
                ## az 227.9 el 42.7 
                ## # times are in UTC
                ## 2022-02-15T05:30:55 10.523690382 10.570080895 10.535587705 10.527403187 ... C
                ## 2022-02-15T05:30:56 10.558290361 10.551762452 10.545512521 10.539835481 ...
                ## ...



                fileRawLen = 0          # reset with each new file
                
                # read line 1
                ## from ezCol10z05p.py (Jul-13-2022a N0RQV)
                #  01234567890
                # find next non-End-Of-File non-blank non-comment line of .txt file
                # fetch a new line
                fileLine = fileRead.readline()
                # len(fileLine): 0=EOF  1=LFonly  2=1CharacterWithLF
                fileLineSplit = fileLine.split()
                # len(fileLineSplit): 0=EOF  0=LFonly  1=1CharacterWithLF
                # ignore blank and comment lines
                # while ((not EOF) and ((LFonly) or (first char == '#'))):
                while(fileLine and ((not fileLineSplit) or (fileLineSplit[0][0] == '#'))):
                    # fetch a new line
                    fileLine = fileRead.readline()
                    fileLineSplit = fileLine.split()
                if not fileLine:                     # if end of file
                    fileRead.close()                 #   then have processed all lines in this data file
                    continue                         #   skip to next file

                # skip to next data file if fileLine has less than 10 characters
                if len(fileLine) < 10:               # if not a valid data file
                    fileRead.close()                 #   then have processed all lines in this data file
                    continue                         #   skip to next data file
                # skip to next data file if fileLine not start with 'from ezCol'
                if fileLine[:10] != 'from ezCol':    # if not a valid data file
                    fileRead.close()                 #   then have processed all lines in this data file
                    continue                         #   skip to next data file

                # now assume a valid ezCol .txt data file

                dataFileIdxThis += 1
                #studyOutString += f'file = {fileCounter:,} = ' \
                #    + directory + os.path.sep + fileReadName + '\n'
                studyOutStringThis = f'data file = {dataFileIdxThis:,} = ' \
                    + directory + os.path.sep + fileReadName
                print(' ' + studyOutStringThis)
                studyOutString += studyOutStringThis + '\n'

                # read line 2
                ## lat 40.299512 long -105.084491 amsl 1524 name N0RQV8 ezb
                # find next non-End-Of-File non-blank non-comment line of .txt file
                # fetch a new line
                fileLine = fileRead.readline()
                # len(fileLine): 0=EOF  1=LFonly  2=1CharacterWithLF
                fileLineSplit = fileLine.split()
                # len(fileLineSplit): 0=EOF  0=LFonly  1=1CharacterWithLF
                # ignore blank and comment lines
                # while ((not EOF) and ((LFonly) or (first char == '#'))):
                while(fileLine and ((not fileLineSplit) or (fileLineSplit[0][0] == '#'))):
                    # fetch a new line
                    fileLine = fileRead.readline()
                    fileLineSplit = fileLine.split()
                if not fileLine:                   # if end of file
                    fileRead.close()                 #   then have processed all lines in this data file
                    continue                            #   skip to next file
                ezRAObsLatFile = float(fileLineSplit[1])
                print('   ezRAObsLatFile  = ', ezRAObsLatFile)
                ezRAObsLonFile = float(fileLineSplit[3])
                print('   ezRAObsLonFile  = ', ezRAObsLonFile)
                ezRAObsAmslFile = float(fileLineSplit[5])
                print('   ezRAObsAmslFile = ', ezRAObsAmslFile)
                if 7 < len(fileLineSplit):
                    # bug: replace with fileLine[qqqq:] (to allow double spaces in name?)
                    ezRAObsNameFile = ' '.join(fileLineSplit[7:])
                print('   ezRAObsNameFile = ', ezRAObsNameFile)



                # read line 3
                ## freqMin 1419.205 freqMax 1421.605 freqBinQty 256
                # find next non-End-Of-File non-blank non-comment line of .txt file
                # fetch a new line
                fileLine = fileRead.readline()
                # len(fileLine): 0=EOF  1=LFonly  2=1CharacterWithLF
                fileLineSplit = fileLine.split()
                # len(fileLineSplit): 0=EOF  0=LFonly  1=1CharacterWithLF
                # ignore blank and comment lines
                # while ((not EOF) and ((LFonly) or (first char == '#'))):
                while(fileLine and ((not fileLineSplit) or (fileLineSplit[0][0] == '#'))):
                    # fetch a new line
                    fileLine = fileRead.readline()
                    fileLineSplit = fileLine.split()
                if not fileLine:                   # if end of file
                    fileRead.close()                 #   then have processed all lines in this data file
                    continue                            #   skip to next file
                fileFreqMin    = float(fileLineSplit[1]) + ezConAddMHz
                #print('   fileFreqMin    = ', fileFreqMin)
                fileFreqMax    = float(fileLineSplit[3]) + ezConAddMHz
                #print('   fileFreqMax    = ', fileFreqMax)
                fileFreqBinQty = int  (fileLineSplit[5])
                #print('   fileFreqBinQty = ', fileFreqBinQty)


                # az line not required
                ## az 227.9 el 42.7 
                # so, until replaced by an az line,
                # add correction factor to file's Azimuth   (Degrees)
                dataAzimuthDeg   = ezConAzDeg   + ezConAddAzDeg
                # add correction factor to file's Elevation (Degrees)
                dataElevationDeg = ezConElDeg + ezConAddElDeg
                #print('   dataAzimuthDeg   =', dataAzimuthDeg)
                #print('   dataElevationDeg =', dataElevationDeg)


                # read blank, and comment, az, and data lines
                ## az 227.9 el 42.7 
                ## # times are in UTC
                ## 2022-02-15T05:30:55 10.523690382 10.570080895 10.535587705 10.527403187 ... C
                ## 2022-02-15T05:30:56 10.558290361 10.551762452 10.545512521 10.539835481 ...
                ## ...
                while(fileLine and sampleCount <= useSamplesRawLast):
                    # fetch a new line
                    fileLine = fileRead.readline()
                    # len(fileLine): 0=EOF  1=LFonly  2=1CharacterWithLF
                    if not fileLine:                    # if end of file
                        fileRead.close()                #   then have processed all lines in this data file
                        continue                        #   skip to next file

                    fileLineSplit = fileLine.split()
                    #print('========== fileLineSplit =', fileLineSplit)
                    # len(fileLineSplit): 0=EOF  0=LFonly  1=1CharacterWithLF
                    # ignore blank line
                    if fileLineSplit:               # if not blank line
                        fileLineSplit0Low = fileLineSplit[0].lower()    # to ignore capitalization

                        # ignore comment line
                        if fileLineSplit[0][0] == '#':    # if first non-white character is '#'
                            pass                            #   flow on to fetch next line

                        elif fileLineSplit0Low == 'azdeg' or fileLineSplit0Low == 'az' or fileLineSplit0Low == 'rah' or fileLineSplit0Low == 'glatdeg':
                            ## azDeg 227.9 elDeg 42.7 
                            ## az 227.9 el 42.7 
                            ## raH 22.9 decDeg 42.7
                            ## gLatDeg 42.7 gLonDeg 227.9

                            # assume a valid pointing line
                            # gather split pointing line to use after have a timeStamp
                            pointingLineSplit = fileLineSplit
                            pointingLineSplit0Low = fileLineSplit0Low
                            pointingLineSplitNew = True

                        else:
                            # assume a valid data line
                            print(f'\r file = {fileCounter:,} of {fileListLen:,}' \
                                + f' in dir {directoryCounter + 1:,} of {directoryListLen:,} = ' \
                                + directory + os.path.sep + fileReadName, end='')   # allow append to print line

                            # need to update useSamplesRawStop and useSamplesRawStart ?
                            if useSamplesRawStop < sampleCount:
                                useSamplesRawStart = ezConRawSamplesUseL[useSamplesRawIndex]
                                useSamplesRawStop  = ezConRawSamplesUseL[useSamplesRawIndex + 1]
                                useSamplesRawIndex += 2        # point to next Start/Stop pair, if any

                            # is sampleCount inside a RAW want-to-use section ?
                            if useSamplesRawStart <= sampleCount and sampleCount <= useSamplesRawStop:
                                # use this sample
                                # collect the data line

                                # Bases: astropy.time.TimeString
                                # FITS format: “[±Y]YYYY-MM-DD[THH:MM:SS[.sss]]”.
                                # https://docs.astropy.org/en/stable/time/#id3
                                #print('\n========== fileLineSplit[0] =', fileLineSplit[0])
                                dataTimeUtcThis = Time(fileLineSplit[0], format='fits', scale='utc')

                                # without astropy ???????????????????????????????????
                                # https://gist.github.com/jiffyclub/1294443
                                #timeStampUtc  = datetime.now(timezone.utc)
                                #timeStampUtcS = timeStampUtc.strftime('%Y-%m-%dT%H:%M:%S ')

                                #radDataL = list(map(float, fileLineSplit[1:fileFreqBinQty + 1]))
                                #print('radDataL =')
                                #print(radDataL)
                                #print(len(fileLineSplit))

                                if ezConInputdB:
                                    # https://www.omnicalculator.com/conversion/dbm-to-watts#formula-for-dbm-to-watts-conversion
                                    # pW = 0.001 * (10. ** (pdBm / 10.))
                                    # https://www.rapidtables.com/convert/power/dBm_to_Watt.html
                                    # P(W) = 0.001 * (10 ** (P(dBm) / 10)) = 10 ** ((P(dBm) - 30) / 10)
                                    radData = 0.001 * (10. ** (0.1 * np.array([list(map(float, fileLineSplit[1:fileFreqBinQty + 1]))])))
                                else:
                                    radData = np.array([list(map(float, fileLineSplit[1:fileFreqBinQty + 1]))])
                                #print('radData =')
                                #print(radData)
                                #print(len(fileLineSplit))

                                if ezConRefMode == 10:
                                    # is there an 'r' or 'c' in last data word ?
                                    # (changed the format from Calibration 'c' to Reference 'r')
                                    dataFlags = fileLineSplit[-1].lower()
                                    #feedRefOnThis = 'r' in dataFlags or 'c' in dataFlags
                                    feedRefOnThis = 'r' in dataFlags

                                if pointingLineSplitNew:
                                    # now have a timeStamp
                                    if pointingLineSplit0Low == 'azdeg' or pointingLineSplit0Low == 'az':
                                        print()
                                        # assume a valid azDeg or az line
                                        ## azDeg 227.9 elDeg 42.7 
                                        ## az 227.9 el 42.7 
                                        dataAzimuthDeg   = float(pointingLineSplit[1])
                                        dataElevationDeg = float(pointingLineSplit[3])

                                    # precision study:
                                    #
                                    #   #UTC_Time(s)   Ra(deg)  Dec(deg)   Az(deg)   El(deg)
                                    #   11992.000000  83.06220   -4.6685  193.4920   45.8379
                                    #   6             5           4       4          4
                                    #
                                    #
                                    # data/Skynet_60333_barnard_33-nb_107271_56634.A.cal5Az.txt says in part:
                                    #   az 193.492 el 45.8381
                                    # ezColGB20m code     says "az {dataAzimuth:g} el {dataElevation:g}"
                                    #   so with maybe fractional digits:
                                    #      3          4
                                    # ezColGB20m code now says "az {dataAzimuth:.5g} el {dataElevation:.5g}"
                                    #      5          5
                                    #
                                    # data/Skynet_60333_barnard_33-nb_107271_56634.A.cal5Ra.txt says in part:
                                    #   ra 5.53815 dec -4.6683
                                    # ezColGB20m code     says "ra {dataRaH:g} dec {dataDecDeg:g}"
                                    #   so with maybe fractional digits:
                                    #      5          4
                                    # ezColGB20m code now says "ra {dataRaH:.5g} dec {dataDecDeg:.5g}"
                                    #      5          5
                                    #
                                    #
                                    # Skynet_60333_barnard_33-nb_107271_56634.A.cal5Ra.ezb says in part:
                                    #   ezbMenu: TimeUtcMjd  RaH  DecDeg  GLatDeg  GLonDeg  ...
                                    #   60333.13882 5.581 -4.859 -19.223 -151.516 ...
                                    # ezCon code says "'%0.5f %0.3f %0.3f %0.3f %0.3f"
                                    #   so with fractional digits:
                                    #   5           3     3      3       3

                                    elif pointingLineSplit0Low == 'rah':
                                        # assume a valid raH line
                                        ## raH 22.9 decDeg 42.7
                                        print()
                                        dataRightAscensionH = float(pointingLineSplit[1])
                                        dataDeclinationDeg  = float(pointingLineSplit[3])
                                        #if ezConAstroMath == 1:
                                        if 0:
                                            # use math from MIT Haystack SRT
                                            # radec_azel()      from MIT Haystack SRT, geom.c
                                            print()
                                            print()
                                            print()
                                            print()
                                            print()
                                            print(' ========== FATAL ERROR:  ezConAstroMath == 1 does not yet support "raH" line input.')
                                            print()
                                            print()
                                            print()
                                            print()
                                            print('\a')     # ring bell
                                            exit()
                                        #elif ezConAstroMath == 2:
                                        if 1:
                                            # use math from astropy
                                            if not locBaseValid:
                                                print(' ========== not locBaseValid =======================')
                                                from astropy import units as u
                                                from astropy.coordinates import EarthLocation
                                                from astropy.coordinates import SkyCoord

                                                locBase = EarthLocation(lat = ezRAObsLatFile*u.deg, lon = ezRAObsLonFile*u.deg,
                                                    height = ezRAObsAmslFile*u.m)
                                                locBaseValid = True
                                                
                                            # Coordinate of sky target at the UTC time from the data file
                                            # SkyCoord() wants time = Time('1991-06-06 12:00:00')
                                            pointingTelescope = SkyCoord(ra = dataRightAscensionH*u.hour, dec = dataDeclinationDeg*u.deg,
                                                obstime = dataTimeUtcThis, frame = 'icrs', location = locBase)
                                            # extract AzEl coordinates
                                            dataAzimuthDeg = float(pointingTelescope.altaz.az.degree)
                                            #print(' dataAzimuthDeg =', dataAzimuthDeg, 'degrees')
                                            dataElevationDeg = float(pointingTelescope.altaz.alt.degree)
                                            #print(' dataElevationDeg =', dataElevationDeg, 'degrees')
                                        print('   "raH" line input to dataAzimuthDeg   =', dataAzimuthDeg)
                                        print('                       dataElevationDeg =', dataElevationDeg)

                                    elif pointingLineSplit0Low == 'glatdeg':
                                        # assume a valid gLatDeg line
                                        ## gLatDeg 42.7 gLonDeg 227.9
                                        print()
                                        dataGLatDeg = float(pointingLineSplit[1])
                                        dataGLonDeg = float(pointingLineSplit[3])
                                        #if ezConAstroMath == 1:
                                        if 0:
                                            # use math from MIT Haystack SRT
                                            # radec_azel()      from MIT Haystack SRT, geom.c
                                            print()
                                            print()
                                            print()
                                            print()
                                            print()
                                            print(' ========== FATAL ERROR:  ezConAstroMath == 1 does not yet support "raH" line input.')
                                            print()
                                            print()
                                            print()
                                            print()
                                            print('\a')     # ring bell
                                            exit()
                                        #elif ezConAstroMath == 2:
                                        if 1:
                                            # use math from astropy
                                            if not locBaseValid:
                                                print(' ========== not locBaseValid =======================')
                                                from astropy import units as u
                                                from astropy.coordinates import EarthLocation
                                                from astropy.coordinates import SkyCoord

                                                locBase = EarthLocation(lat = ezRAObsLatFile*u.deg, lon = ezRAObsLonFile*u.deg,
                                                    height = ezRAObsAmslFile*u.m)
                                                locBaseValid = True

                                            # Coordinate of sky target at the UTC time from the data file
                                            # SkyCoord() wants time = Time('1991-06-06 12:00:00')
                                            pointingTelescope = SkyCoord(b = dataGLatDeg*u.deg, l = dataGLonDeg*u.deg,
                                                obstime = dataTimeUtcThis, frame = 'galactic', location = locBase)
                                            # extract AzEl coordinates
                                            dataAzimuthDeg = float(pointingTelescope.altaz.az.degree)
                                            #print(' raHThis =', raHThis, 'Hours')
                                            dataElevationDeg = float(pointingTelescope.altaz.alt.degree)
                                            #print(' decDegThis =', decDegThis, 'degrees')
                                        print()
                                        print('   "gLatDeg" line input to dataAzimuthDeg   =', dataAzimuthDeg)
                                        print('                           dataElevationDeg =', dataElevationDeg)

                                    # add correction factor to file's Azimuth   (Degrees)
                                    dataAzimuthDeg   += ezConAddAzDeg
                                    # add correction factor to file's Elevation (Degrees)
                                    dataElevationDeg += ezConAddElDeg

                                    if 90. < dataElevationDeg:
                                        # to allow calculations, simulate rotating dish
                                        dataElevationDeg =  180. - dataElevationDeg
                                        dataAzimuthDeg   -= 180.
                                        print('   after Azimuth rotation, using dataAzimuthDeg   =', dataAzimuthDeg)
                                        print('   after Azimuth rotation, using dataElevationDeg =', dataElevationDeg)
                                    if dataAzimuthDeg < 0.:
                                        dataAzimuthDeg += 360.
                                    if 360. <= dataAzimuthDeg:
                                        dataAzimuthDeg -= 360.

                                    print('   dataAzimuthDeg   =', dataAzimuthDeg)
                                    print('   dataElevationDeg =', dataElevationDeg)

                                    pointingLineSplitNew = False

                                # create or append to numpys
                                if rawLen:
                                    # append to numpys
                                    dataFileIdx = np.concatenate([dataFileIdx, np.array([dataFileIdxThis])])
                                    dataTimeUtc = np.concatenate([dataTimeUtc, np.array([dataTimeUtcThis])])
                                    azimuthDeg  = np.concatenate([azimuthDeg , np.array([dataAzimuthDeg])])
                                    raw         = np.concatenate([raw        , radData])
                                    if feedRefOnThis:
                                        # mark as a REF sample
                                        elevationDeg = np.concatenate([elevationDeg, dataElevationRefDeg])
                                        refQty += 1
                                    else:
                                        elevationDeg = np.concatenate([elevationDeg, np.array([dataElevationDeg])])
                                else:
                                    # create numpys
                                    dataFileIdx = np.array([dataFileIdxThis])
                                    dataTimeUtc = np.array([dataTimeUtcThis])
                                    azimuthDeg  = np.array([dataAzimuthDeg])
                                    raw         = radData
                                    if feedRefOnThis:
                                        # mark as a REF sample
                                        elevationDeg = dataElevationRefDeg
                                        refQty += 1
                                    else:
                                        elevationDeg = np.array([dataElevationDeg])

                                # increments when the data line was collected (ezConRawSamplesUseL)
                                fileRawLen += 1
                                rawLen += 1

                            # increments whether or not the data line was collected (ezConRawSamplesUseL)
                            sampleCount += 1

                            # allow append to print line
                            #print(f'    number of samples read = {sampleCount:,}',
                            print(f' samplesRead= {sampleCount:,}',
                                f'  fileRawLen= {fileRawLen:,}',
                                f'  rawLen= {rawLen:,}',
                                f'  antLen ?= {rawLen - refQty:,}             ', end='')

                    # flow on to fetch next file line

                #while(sampleCount <= useSamplesRawLast):

                #studyOutString += f'Local time = {time.asctime(time.localtime())}\n'
                #studyOutString += f'UTC time = {datetime.now(timezone.utc).strftime("%Y%m%d")}\n'
                ##studyOutString += f'UTC time = {datetime.now(timezone.utc).strftime("%Y-%m-%dT%H:%M:%S")}\n'
                ##studyOutString += f'Python sys.version = {sys.version}\n'
                ##studyOutString += f'matplotlib.__version__ = {matplotlib.__version__}\n'
                ##studyOutString += f'programRevision = {programRevision}\n\n'
                ## # record the (complex?) ezCon command line
                ##studyOutString += f'Python commandString = {commandString}\n\n'
                ##studyOutString += f'file = {fileCounter:,} = ' \
                ##    + directory + os.path.sep + fileReadName + f' ,  Total raw samples = {rawLen:,}\n'
                studyOutString += '                                         ' \
                    + f'Total raw samples = {rawLen:,}, fileRawLen = {fileRawLen:,}\n'

                fileNameLast = fileReadName

            # now have processed all lines in that file that allows read
            #if fileRead.mode == 'r':
            fileRead.close()
            print()

        # now have processed all files in that directory
        #for fileCounter in range(fileListLen):

    # now have processed all lines in all directories
    #for directoryCounter in range(directoryListLen):

    # blank out the last printed filename
    print('\r                                                                              ' \
        + '                                                                                ')

    if not rawLen:
        print()
        print()
        print(' ========== FATAL ERROR: no data file loaded')
        print()
        print()
        print()
        print('\a')     # ring bell
        exit()

    ###################################################################################

    print(f'                         Total           samples read   = {rawLen:,}')
    print(f'                         Total Reference samples read   = {refQty:,}')
    print(f'                         Total Antenna   samples read   = {rawLen - refQty:,}')
    print()
    studyOutString += f'\n Total           samples read   = {rawLen:,}'
    studyOutString += f'\n Total Reference samples read   = {refQty:,}'
    studyOutString += f'\n Total Antenna   samples read   = {rawLen - refQty:,}\n'


    # prepare to process data

    if ezRAObsLat  == -999:                         # if still silly program default
        ezRAObsLat  = ezRAObsLatFile                # ezRAObsLatFile is better than nothing
    print('   ezRAObsLat  = ', ezRAObsLat)

    if ezRAObsLon  == -999:                         # if still silly program default
        ezRAObsLon  = ezRAObsLonFile                # ezRAObsLonFile is better than nothing
    print('   ezRAObsLon  = ', ezRAObsLon)

    if ezRAObsAmsl == -999:                         # if still silly program default
        ezRAObsAmsl = ezRAObsAmslFile               # ezRAObsAmslFile is better than nothing
    print('   ezRAObsAmsl = ', ezRAObsAmsl)

    if not ezRAObsName:                             # if still silly program default
        ezRAObsName = ezRAObsNameFile               # ezRAObsNameFile is better than nothing
    print('   ezRAObsName = ', ezRAObsName)
    
    if ezRAObsLat < -90 or 90 < ezRAObsLat:
        print()
        print()
        print()
        print(f' ========== FATAL ERROR:  ezRAObsLat = {ezRAObsLat} is silly')
        print('                            Required: -90 <= ezRAObsLat <= +90')
        print()
        print()
        print()
        print('\a')     # ring bell
        exit()

    if ezRAObsLon < -180 or 180 < ezRAObsLon:
        print()
        print()
        print()
        print(f' ========== FATAL ERROR:  ezRAObsLon = {ezRAObsLon} is silly')
        print('                            Required: -180 <= ezRAObsLon <= +180')
        print()
        print()
        print()
        print('\a')     # ring bell
        exit()

    if ezConAzDeg != -999:                            # if not silly program default
        print('   ezConAzDeg = ', ezConAzDeg)
        # add correction factor to simulated file's Azimuth   (Degrees)
        dataAzimuthDeg = ezConAzDeg + ezConAddAzDeg
        # force dataAzimuthDeg into every RAW sample
        azimuthDeg.fill(dataAzimuthDeg)

    if ezConElDeg != -999:                          # if not silly program default
        print('   ezConElDeg = ', ezConElDeg)
        # add correction factor to simulated file's Elevation (Degrees)
        dataElevationDeg = ezConElDeg + ezConAddElDeg
        # force dataElevationDeg into every non-REF RAW sample
        for n in range(rawLen):
            if elevationDeg[n] != dataElevationRefDeg:  # if not marked as a REF sample
                elevationDeg[n] = dataElevationDeg

    # Status after data files: Now have ezRAObsLat ezRAObsLon ezRAObsAmsl ezRAObsName
    # fileFreqMin fileFreqMax fileFreqBinQty fileNameLast rawLen refQty
    # azimuthDeg[rawLen] elevationDeg[rawLen] dataTimeUtc[rawLen] raw[fileFreqBinQty * rawLen]

    # reshape into raw[n, fileFreqBinQty]
    raw = raw.reshape(-1, fileFreqBinQty)
    #print('raw.shape = ', raw.shape)

    # make into raw[fileFreqBinQty, n] to match what is needed for Seaborn heatmap plots
    raw = raw.T
    #print('raw.shape = ', raw.shape)



def openFileSdre():
    # In case it will eventually error.  Creates fileWriteNameSdre, fileWriteSdre

    global fileNameLast             # string
    global fileWriteNameSdre        # string                creation
    global fileWriteSdre            # file handle           creation

    print()
    print('   openFileSdre ===============')

    ## data/rqv8ezb220218_00a.txt
    #                        4321-
    fileWriteNameSdre = fileNameLast.split(os.path.sep)[-1][:-4] + '.sdre'
    print('   opening', fileWriteNameSdre)

    # before much calculating, get proof can open output file
    fileWriteSdre = open(fileWriteNameSdre, 'w')
    if not (fileWriteSdre.mode == 'w'):
        print()
        print()
        print()
        print()
        print()
        print(' ========== FATAL ERROR:  Can not open ')
        print(' ' + fileWriteNameSdre)
        print(' file to write data out')
        print()
        print()
        print()
        print()
        print('\a')     # ring bell
        exit()



def openFileEzb():
    # In case it will eventually error.  Creates fileWriteNameEzb, fileWriteEzb

    global fileNameLast             # string
    global fileWriteNameEzb         # string                creation
    global fileWriteEzb             # file handle           creation

    print()
    print('   openFileEzb ===============')

    ## data/rqv8ezb220218_00a.txt
    #                        4321-
    fileWriteNameEzb = fileNameLast.split(os.path.sep)[-1][:-4] + '.ezb'
    print('   opening', fileWriteNameEzb)

    # before much calculating, get proof can open output file
    fileWriteEzb = open(fileWriteNameEzb, 'w')
    if not (fileWriteEzb.mode == 'w'):
        print()
        print()
        print()
        print()
        print()
        print(' ========== FATAL ERROR:  Can not open ')
        print(' ' + fileWriteNameEzb)
        print(' file to write data out')
        print()
        print()
        print()
        print()
        print('\a')     # ring bell
        exit()



def openFileStudy():
    # In case it will eventually error.  Creates fileWriteNameStudy, fileWriteStudy

    global fileNameLast             # string
    global fileWriteNameStudy       # string                creation
    global fileWriteStudy           # file handle           creation
    global studyOutString           # string

    print()
    print('   openFileStudy ===============')

    ## data/rqv8ezb220218_00a.txt
    #                        4321-
    ##      rqv8ezb220218_00a_ezConStudy.txt
    #fileWriteNameStudy = 'ezConStudy' + fileNameLast.split(os.path.sep)[-1][:-4] + '.txt'
    fileWriteNameStudy = fileNameLast.split(os.path.sep)[-1][:-4] + '_ezConStudy.txt'
    print('   opening', fileWriteNameStudy)

    # before much calculating, get proof can open output file
    fileWriteStudy = open(fileWriteNameStudy, 'w')
    if not (fileWriteStudy.mode == 'w'):
        print()
        print()
        print()
        print()
        print()
        print(' ========== FATAL ERROR:  Can not open ')
        print(' ' + fileWriteNameStudy)
        print(' file to write data out')
        print()
        print()
        print()
        print()
        print('\a')     # ring bell
        exit()
        
    fileWriteStudy.write(studyOutString)        # finally have file to write to

    # free studyOutString global memory
    studyOutString = []
    studyOutString = None
    del studyOutString



def rawPlotPrep():
    # creates rawLenM1, freqStep, dopplerSpanD2, freqCenter, titleS,
    #   yTickHeatRawL, yTickHeatAntL, byFreqBinX

    global rawLen                   # integer
    global rawLenM1                 # integer               creation

    global ezRAObsName              # string
    global fileNameLast             # string
    global fileFreqMin              # float
    global fileFreqMax              # float
    global fileFreqBinQty           # integer
    global freqBinQty               # integer

    global freqStep                 # float                 creation
    global dopplerSpanRawD2         # float                 creation
    global dopplerSpanD2            # float                 creation
    global freqCenterRaw            # float                 creation
    global freqCenter               # float                 creation
    global freqCenterRef            # float                 creation
    global titleS                   # string                creation

    global ezConRefMode             # integer
    global ezConRefMode30L          # float list
    global ezConAntXTVTFreqBinsClipUpdate   # integer

    global yTickHeatRawL            # string list           creation
    global yTickHeatL               # string list           creation
    global byFreqBinRawX            # float array           creation
    global byFreqBinX               # float array           creation

    print()
    print('   rawPlotPrep ===============')

    rawLenM1 = rawLen - 1

    print('                         fileFreqBinQty =', fileFreqBinQty)
    print('                         fileFreqMin =', fileFreqMin)
    print('                         fileFreqMax =', fileFreqMax)

    freqStep = (fileFreqMax - fileFreqMin) / (fileFreqBinQty - 1)
    print('                         freqStep =', freqStep)

    freqCenterRaw = (fileFreqMin + fileFreqMax) / 2.
    print('                         freqCenterRaw =', freqCenterRaw)

    # DopplerRaw spans -dopplerSpanRawD2 thru +dopplerSpanRawD2
    dopplerSpanRawD2 = (fileFreqMax - fileFreqMin) / 2.
    print('                         dopplerSpanRawD2 =', dopplerSpanRawD2)

    print('\n                         ezConAntXTVTFreqBinsClipUpdate =', ezConAntXTVTFreqBinsClipUpdate)
    # if ezConAntXTVTFreqBinsClipUpdate then freqCenter, dopplerSpanD2, and freqBinQty may have changed
    if not ezConAntXTVTFreqBinsClipUpdate:
        if ezConRefMode == 30:
            freqCenter = ezConRefMode30L[0]
            freqCenterRef = ezConRefMode30L[1]
            dopplerSpanD2 = ezConRefMode30L[2] / 2.
            freqBinQty = int(ezConRefMode30L[2] / freqStep + 0.5)
        else:
            freqCenter = freqCenterRaw
            freqCenterRef = freqCenterRaw
            dopplerSpanD2 = dopplerSpanRawD2
            freqBinQty = fileFreqBinQty

    print('                         ezConRefMode =', ezConRefMode)
    print('                         freqCenter    =', freqCenter)
    print('                         freqCenterRef =', freqCenterRef)
    print('                         dopplerSpanD2 =', dopplerSpanD2)
    print('                         fileFreqBinQty =', fileFreqBinQty)
    print('                         freqBinQty     =', freqBinQty)

    # plot titles
    titleS = '  ' + fileNameLast.split(os.path.sep)[-1] + '           ' + ezRAObsName \
        + '          (' + programName + ')'

    # heatmap Doppler Y scale labels
    yTickHeatRawL = \
        [f'{-dopplerSpanRawD2:0.1f}',        f'{-dopplerSpanRawD2*11./12.:0.1f}',
        f'{-dopplerSpanRawD2*10./12.:0.1f}', f'{-dopplerSpanRawD2*9./12.:0.1f}',
        f'{-dopplerSpanRawD2*8./12.:0.1f}',  f'{-dopplerSpanRawD2*7./12.:0.1f}',
        f'{-dopplerSpanRawD2*6./12.:0.1f}',  f'{-dopplerSpanRawD2*5./12.:0.1f}',
        f'{-dopplerSpanRawD2*4./12.:0.1f}',  f'{-dopplerSpanRawD2*3./12.:0.1f}',
        f'{-dopplerSpanRawD2*2./12.:0.1f}',  f'{-dopplerSpanRawD2*1./12.:0.1f}',
        f'0.', f'{dopplerSpanRawD2*1./12.:0.1f}',
        f'{dopplerSpanRawD2*2./12.:0.1f}',   f'{dopplerSpanRawD2*3./12.:0.1f}',
        f'{dopplerSpanRawD2*4./12.:0.1f}',   f'{dopplerSpanRawD2*5./12.:0.1f}',
        f'{dopplerSpanRawD2*6./12.:0.1f}',   f'{dopplerSpanRawD2*7./12.:0.1f}',
        f'{dopplerSpanRawD2*8./12.:0.1f}',   f'{dopplerSpanRawD2*9./12.:0.1f}',
        f'{dopplerSpanRawD2*10./12.:0.1f}',  f'{dopplerSpanRawD2*11./12.:0.1f}',
        f'{dopplerSpanRawD2:0.1f}', '']

    # dopplerSpanD2 = 1.2
    # dopplerSpanD2 = 5.0
    if f'{dopplerSpanD2:0.1f}' == '1.2':
        yTickHeatL = \
            ['-1.2', '', '-1.',
            '',  '', '',  '', '-0.5',
            '',  '',  '',  '',  '0.',
            '',  '', '',  '',  '0.5',
            '',  '',  '',  '',  '1.', '', '1.2', '']
    else:
        if dopplerSpanD2 < 1.2:
            yTickHeatL = \
                [f'{-dopplerSpanD2:0.2f}',        f'{-dopplerSpanD2*11./12.:0.2f}',
                f'{-dopplerSpanD2*10./12.:0.2f}', f'{-dopplerSpanD2*9./12.:0.2f}',
                f'{-dopplerSpanD2*8./12.:0.2f}',  f'{-dopplerSpanD2*7./12.:0.2f}',
                f'{-dopplerSpanD2*6./12.:0.2f}',  f'{-dopplerSpanD2*5./12.:0.2f}',
                f'{-dopplerSpanD2*4./12.:0.2f}',  f'{-dopplerSpanD2*3./12.:0.2f}',
                f'{-dopplerSpanD2*2./12.:0.2f}',  f'{-dopplerSpanD2*1./12.:0.2f}',
                f'0.', f'{dopplerSpanD2*1./12.:0.2f}',
                f'{dopplerSpanD2*2./12.:0.2f}',   f'{dopplerSpanD2*3./12.:0.2f}',
                f'{dopplerSpanD2*4./12.:0.2f}',   f'{dopplerSpanD2*5./12.:0.2f}',
                f'{dopplerSpanD2*6./12.:0.2f}',   f'{dopplerSpanD2*7./12.:0.2f}',
                f'{dopplerSpanD2*8./12.:0.2f}',   f'{dopplerSpanD2*9./12.:0.2f}',
                f'{dopplerSpanD2*10./12.:0.2f}',  f'{dopplerSpanD2*11./12.:0.2f}',
                f'{dopplerSpanD2:0.2f}', '']
        else:
            yTickHeatL = \
                [f'{-dopplerSpanD2:0.1f}',        f'{-dopplerSpanD2*11./12.:0.1f}',
                f'{-dopplerSpanD2*10./12.:0.1f}', f'{-dopplerSpanD2*9./12.:0.1f}',
                f'{-dopplerSpanD2*8./12.:0.1f}',  f'{-dopplerSpanD2*7./12.:0.1f}',
                f'{-dopplerSpanD2*6./12.:0.1f}',  f'{-dopplerSpanD2*5./12.:0.1f}',
                f'{-dopplerSpanD2*4./12.:0.1f}',  f'{-dopplerSpanD2*3./12.:0.1f}',
                f'{-dopplerSpanD2*2./12.:0.1f}',  f'{-dopplerSpanD2*1./12.:0.1f}',
                f'0.', f'{dopplerSpanD2*1./12.:0.1f}',
                f'{dopplerSpanD2*2./12.:0.1f}',   f'{dopplerSpanD2*3./12.:0.1f}',
                f'{dopplerSpanD2*4./12.:0.1f}',   f'{dopplerSpanD2*5./12.:0.1f}',
                f'{dopplerSpanD2*6./12.:0.1f}',   f'{dopplerSpanD2*7./12.:0.1f}',
                f'{dopplerSpanD2*8./12.:0.1f}',   f'{dopplerSpanD2*9./12.:0.1f}',
                f'{dopplerSpanD2*10./12.:0.1f}',  f'{dopplerSpanD2*11./12.:0.1f}',
                f'{dopplerSpanD2:0.1f}', '']
    #print('========================= dopplerSpanD2 =', dopplerSpanD2)
    #print('========================= yTickHeatL =', yTickHeatL)

    # increasing freq
    byFreqBinRawX = np.arange(fileFreqBinQty) * freqStep - dopplerSpanRawD2
    byFreqBinX = np.arange(freqBinQty) * freqStep - dopplerSpanD2



def ezConRefAvgPluckQtyLDo():

    global ref                      # float 2d array
    global antLen                   # integer

    global ezConRefAvgPluckQtyL     # float list

    if not ezConRefAvgPluckQtyL:    # if empty, no plucking needed
        return(1)

    print()
    print('   ezConRefAvgPluckQtyLDo ===============')

    print('   np.shape(ref)[0] =', np.shape(ref)[0])
    print('   np.shape(ref)[1] =', np.shape(ref)[1])

    # create refAvg
    refAvg = np.mean(ref, axis=0)
    #print('   refAvg =', refAvg)
    print(f'   len(refAvg) = {len(refAvg):,}')
    print()

    # get indexes of refAvg with increasing values
    refAvgIdxByIncreasing = refAvg.argsort()
    #print('   refAvgIdxByIncreasing =', refAvgIdxByIncreasing)
    print(f'   len(refAvgIdxByIncreasing) = {len(refAvgIdxByIncreasing):,}')
    print()

    print('   ezConRefAvgPluckQtyL =', ezConRefAvgPluckQtyL)
    print()

    # assume want to keep all refAvg samples
    refAvgPluckNumKeepMask = np.ones(antLen, dtype=bool)

    # mask off requested lowest-valued refAvg samples
    for i in range(ezConRefAvgPluckQtyL[0]):                 # i increases up from 0
        refAvgPluckNumKeepMask[refAvgIdxByIncreasing[i]] = False

    # mask off requested highest-valued refAvg samples
    for i in reversed(range(ezConRefAvgPluckQtyL[1])):       # i decreases down to 0
        refAvgPluckNumKeepMask[refAvgIdxByIncreasing[-1-i]] = False

    # replace the Ref of not-kept REF samples
    if not refAvgPluckNumKeepMask[0]:
        # Ref index is 0
        # Matching ANT needs to use next future kept REF sample.
        # Use Ref from lowest index of True in refAvgPluckNumKeepMask.
        indexFirstKept = np.where(refAvgPluckNumKeepMask)[0][0]
        print('   indexFirstKept =', indexFirstKept)
        ref[:, 0] = ref[:, indexFirstKept]
    for i in range(1, len(refAvgPluckNumKeepMask)):          # i increases up from 1
        # Ref index is greater than 0
        if not refAvgPluckNumKeepMask[i]:                    # if Ref not to be kept
            # replace the Ref with next older REF sample
            ref[:, i] = ref[:, i-1]

    #print('   refAvgPluckNumKeepMask =', refAvgPluckNumKeepMask)
    print('   refAvgPluckNumKeepMask.sum() =', refAvgPluckNumKeepMask.sum())
    print(f'   len(refAvgPluckNumKeepMask) = {len(refAvgPluckNumKeepMask):,}')

    refLen   = ref.shape[1]
    print(f'   antLen = {antLen:,}')
    print(f'   refLen = {refLen:,}')



def ezConRefAvgPluckFracLDo():

    global ref                      # float 2d array
    global xTickLocsAnt             # float array

    global ezConRefAvgPluckFracL    # float list

    if not ezConRefAvgPluckFracL:   # if empty, no plucking needed
        return(1)

    #print(f'   before ezConRefAvgPluckFracLDo, antLen = ', {antLen:,}')

    print()
    print('   ezConRefAvgPluckFracLDo ===============')

    print('   np.shape(ref)[0] =', np.shape(ref)[0])
    print('   np.shape(ref)[1] =', np.shape(ref)[1])

    refAvg = np.mean(ref, axis=0)
    #print('   refAvg =', refAvg)
    print(f'   len(refAvg) = {len(refAvg):,}')
    print()

    # get indexes of increasing refAvg
    refAvgIdxByIncreasing = refAvg.argsort()
    #print('   refAvgIdxByIncreasing =', refAvgIdxByIncreasing)
    print(f'   len(refAvgIdxByIncreasing) = {len(refAvgIdxByIncreasing):,}')
    print()

    print('   ezConRefAvgPluckFracL =', ezConRefAvgPluckFracL)
    print()

    # snap down to next integer
    refLenM1 = ref.shape[1] - 1
    refAvgPluckFracQty0 = int(refLenM1 * ezConRefAvgPluckFracL[0])
    refAvgPluckFracQty1 = int(refLenM1 * ezConRefAvgPluckFracL[1])

    # assume want to keep all refAvg samples
    refAvgPluckFracKeepMask = np.ones(antLen, dtype=bool)

    # mask off requested lowest-valued refAvg samples
    for i in range(refAvgPluckFracQty0):     # i starts with 0
        refAvgPluckFracKeepMask[refAvgIdxByIncreasing[i]] = False
    # mask off requested highest-valued refAvg samples
    for i in range(refAvgPluckFracQty1):     # i starts with 0
        refAvgPluckFracKeepMask[refAvgIdxByIncreasing[-1-i]] = False

    # replace the Ref of not-kept REF samples
    if not refAvgPluckFracKeepMask[0]:
        # Ref index is 0
        # Matching ANT needs to use next future kept REF sample.
        # Use Ref from lowest index of True in refAvgPluckFracKeepMask.
        indexFirstKept = np.where(refAvgPluckFracKeepMask)[0][0]
        print('   indexFirstKept =', indexFirstKept)
        ref[:, 0] = ref[:, indexFirstKept]
    for i in range(1, len(refAvgPluckFracKeepMask)):          # i increases up from 1
        # Ref index is greater than 0
        if not refAvgPluckFracKeepMask[i]:                    # if Ref not to be kept
            # replace the Ref with next older REF sample
            ref[:, i] = ref[:, i-1]

    print('   refAvgPluckFracKeepMask =', refAvgPluckFracKeepMask)
    print('   refAvgPluckFracKeepMask.sum() =', refAvgPluckFracKeepMask.sum())
    print(f'   len(refAvgPluckFracKeepMask) = {len(refAvgPluckFracKeepMask):,}')

    refLen   = ref.shape[1]
    print(f'   antLen = {antLen:,}')
    print(f'   refLen = {refLen:,}')



def ezConRawLogDo():
    # change raw value scale

    global raw                      # float 2d array
    global ezConRawLog              # integer

    print()
    print(f'   ezConRawLogDo {ezConRawLog} ===============')

    for i in range(ezConRawLog):
        #rawMin = raw.min()
        #raw = np.log10(raw - rawMin + 0.1 * abs(rawMin) + 1e20)
        #raw = np.log10(raw - raw.min() + 1e-40) + 40.
        raw = np.log10(raw - raw.min() + 1e-40)     # allow for zero difference
        raw = np.where(raw == -40., 0., raw)        # remove evidence of that handling
        print('============= raw =', raw)
        print('============= raw.max() =', raw.max())
        print('============= raw.min() =', raw.min())
        print('============= raw.max() - raw.min() =', raw.max() - raw.min())
        print()



def ezConRawFreqBinTrimLDo():
    # trim raw freq bins

    global ezConRawFreqBinTrimL     # list of (integer pair, float)
    global ezConRawFreqTrimL        # list of (float pair, float)
    global freqCenterRaw            # float
    global raw                      # float 2d array
    global rawLen                   # integer
    global byFreqBinRawX            # float array
    global fileFreqBinQty           # integer

    if ezConRawFreqBinTrimL:
        print()
        print('   ezConRawFreqBinTrimLDo ===============')

        # Trim the freqBin within the pairs of ezConRawFreqBinTrimL.
        freqBinAll = np.array(range(fileFreqBinQty))            # all freqBin indices
        for i in range(0, len(ezConRawFreqBinTrimL), 3):        # ezConRawFreqBinTrimL come in 3 values
            ezConRawFreqBinTrimLDoL = np.nonzero(np.logical_and(ezConRawFreqBinTrimL[i] <= freqBinAll,
                freqBinAll <= ezConRawFreqBinTrimL[i+1]))[0].tolist()
            ezConRawFreqBinTrimLDoL = list(set(ezConRawFreqBinTrimLDoL))    # in to a unique list
            freqBinRawSetValue = ezConRawFreqBinTrimL[i+2]
            freqBinRawSet = np.full(rawLen, freqBinRawSetValue)
            for i in ezConRawFreqBinTrimLDoL:
                print(f'                         FreqBin {i} set to {freqBinRawSetValue}')
                raw[i, :] = freqBinRawSet

    if ezConRawFreqTrimL:
        print()
        print('   ezConRawFreqTrimLDo ===============')

        # Trim frequencies within the pairs of ezConRawFreqTrimL.
        # Find the freqBin within the pairs of ezConRawFreqTrimL.
        freqRaw = freqCenterRaw + byFreqBinRawX                 # all freqBin frequencies
        for i in range(0, len(ezConRawFreqTrimL), 3):           # ezConRawFreqTrimL come in 3 values
            ezConRawFreqBinTrimLDoL = np.nonzero(np.logical_and(ezConRawFreqTrimL[i] <= freqRaw,
                freqRaw <= ezConRawFreqTrimL[i+1]))[0].tolist()
            ezConRawFreqBinTrimLDoL = list(set(ezConRawFreqBinTrimLDoL))    # in to a unique list
            freqBinRawSetValue = ezConRawFreqTrimL[i+2]
            freqBinRawSet = np.full(rawLen, freqBinRawSetValue)
            for i in ezConRawFreqBinTrimLDoL:
                print(f'                         FreqBin {i} = {freqRaw[i]} MHz set to {freqBinRawSetValue}')
                raw[i, :] = freqBinRawSet



def ezConRawFreqBinHideLDo():
    # filter raw freq bins

    global ezConRawFreqBinHideL     # integer list
    global raw                      # float 2d array
    global fileFreqBinQty           # integer

    print()
    print('   ezConRawFreqBinHideLDo ===============')

    # Hide frequency bin numbers in ezConRawFreqBinHideL.
    # If bin > 0, copy from weaker neighbor freq bin.
    print()
    for i in range(len(ezConRawFreqBinHideL)):
        ezConRawFreqBinHide = ezConRawFreqBinHideL[i]

        # 110% increase a frequency bin, to raise as a freqBin marker
        #raw[ezConRawFreqBinHide, :] = 1.1 * raw[ezConRawFreqBinHide, :]

        # find averages of freqBin neighbors
        # give non-existing freqBin neighbors very loud averages, to ignore later
        if ezConRawFreqBinHide <= 0:
            freqBinLowerAvg  = 999999.
        else:
            freqBinLowerAvg  = np.mean(raw[ezConRawFreqBinHide - 1, :], axis=0)
        if ezConRawFreqBinHide >= fileFreqBinQty - 1:
            freqBinHigherAvg = 999999.
        else:
            freqBinHigherAvg = np.mean(raw[ezConRawFreqBinHide + 1, :], axis=0)

        # hide with the freqBin neighbor having weaker average
        if freqBinLowerAvg < freqBinHigherAvg:
            #print('   ezConRawFreqBinHideL[' + str(i) + '] = ' + str(ezConRawFreqBinHide))
            print(f'   ezConRawFreqBinHideL[{i:d}] = {ezConRawFreqBinHide:d}, using lower  freqBin neighbor')
            raw[ezConRawFreqBinHide, :] = raw[ezConRawFreqBinHide - 1, :]
        else:
            #print('   ezConRawFreqBinHideL[' + str(i) + '] = ' + str(ezConRawFreqBinHide))
            print(f'   ezConRawFreqBinHideL[{i:d}] = {ezConRawFreqBinHide:d}, using higher freqBin neighbor')
            raw[ezConRawFreqBinHide, :] = raw[ezConRawFreqBinHide + 1, :]

    if ezConRawFreqBinHideL:        # if just printed any in ezConRawFreqBinHideL
        print()



def ezConAntFreqBinHideLDo():
    # filter ant freq bins

    global ezConAntFreqBinHideL     # integer list
    global ant                      # float 2d array
    global fileFreqBinQty           # integer

    print()
    print('   ezConAntFreqBinHideLDo ===============')

    # Hide frequency bin numbers in ezConAntFreqBinHideL.
    # If bin > 0, copy from weaker neighbor freq bin.
    print()
    for i in range(len(ezConAntFreqBinHideL)):
        ezConAntFreqBinHide = ezConAntFreqBinHideL[i]

        # 110% increase a frequency bin, to raise as a freqBin marker
        #ant[ezConAntFreqBinHide, :] = 1.1 * ant[ezConAntFreqBinHide, :]

        # find averages of freqBin neighbors
        # give non-existing freqBin neighbors very loud averages, to ignore later
        if ezConAntFreqBinHide <= 0:
            freqBinLowerAvg  = 999999.
        else:
            freqBinLowerAvg  = np.mean(ant[ezConAntFreqBinHide - 1, :], axis=0)
        if ezConAntFreqBinHide >= fileFreqBinQty - 1:
            freqBinHigherAvg = 999999.
        else:
            freqBinHigherAvg = np.mean(ant[ezConAntFreqBinHide + 1, :], axis=0)

        # hide with the freqBin neighbor having weaker average
        if freqBinLowerAvg < freqBinHigherAvg:
            #print('   ezConAntFreqBinHideL[' + str(i) + '] = ' + str(ezConAntFreqBinHide))
            print(f'   ezConAntFreqBinHideL[{i:d}] = {ezConAntFreqBinHide:d}, using lower  freqBin neighbor')
            ant[ezConAntFreqBinHide, :] = ant[ezConAntFreqBinHide - 1, :]
        else:
            #print('   ezConAntFreqBinHideL[' + str(i) + '] = ' + str(ezConAntFreqBinHide))
            print(f'   ezConAntFreqBinHideL[{i:d}] = {ezConAntFreqBinHide:d}, using higher freqBin neighbor')
            ant[ezConAntFreqBinHide, :] = ant[ezConAntFreqBinHide + 1, :]

    if ezConAntFreqBinHideL:        # if just printed any in ezConAntFreqBinHideL
        print()



def ezConRefFreqBinHideLDo():
    # filter ref freq bins

    global ezConRefFreqBinHideL     # integer list
    global ref                      # float 2d array
    global fileFreqBinQty           # integer

    print()
    print('   ezConRefFreqBinHideLDo ===============')

    # Hide frequency bin numbers in ezConRefFreqBinHideL.
    # If bin > 0, copy from louder neighbor freq bin.
    print()
    for i in range(len(ezConRefFreqBinHideL)):
        ezConRefFreqBinHide = ezConRefFreqBinHideL[i]

        # 110% increase a frequency bin, to raise as a freqBin marker
        #ref[ezConRefFreqBinHide, :] = 1.1 * ref[ezConRefFreqBinHide, :]

        # find averages of freqBin neighbors
        # give non-existing freqBin neighbors very weak averages, to ignore later
        if ezConRefFreqBinHide <= 0:
            freqBinLowerAvg  = -999999.
        else:
            freqBinLowerAvg  = np.mean(ref[ezConRefFreqBinHide - 1, :], axis=0)
        if ezConRefFreqBinHide >= fileFreqBinQty - 1:
            freqBinHigherAvg = -999999.
        else:
            freqBinHigherAvg = np.mean(ref[ezConRefFreqBinHide + 1, :], axis=0)

        # hide with the freqBin neighbor having louder average
        if freqBinHigherAvg < freqBinLowerAvg:
            #print('   ezConRefFreqBinHideL[' + str(i) + '] = ' + str(ezConRefFreqBinHide))
            print(f'   ezConRefFreqBinHideL[{i:d}] = {ezConRefFreqBinHide:d}, using lower  freqBin neighbor')
            ref[ezConRefFreqBinHide, :] = ref[ezConRefFreqBinHide - 1, :]
        else:
            #print('   ezConRefFreqBinHideL[' + str(i) + '] = ' + str(ezConRefFreqBinHide))
            print(f'   ezConRefFreqBinHideL[{i:d}] = {ezConRefFreqBinHide:d}, using higher freqBin neighbor')
            ref[ezConRefFreqBinHide, :] = ref[ezConRefFreqBinHide + 1, :]

    if ezConRefFreqBinHideL:        # if just printed any in ezConRefFreqBinHideL
        print()



def createRef():

    global ezConRawSamplesUseL      # integer list
    global rawIndex                 # integer array       creation
    global rawLen                   # integer    
    global fileFreqMin              # float
    global fileFreqMax              # float
    global freqAntMin               # float
    global freqAntMax               # float
    global ezConRefMode31           # float

    # Create ref according to ezConRefMode
    #   ezConRefMode N < 0: REF = spectrum from -Nth ANT sample')
    #   ezConRefMode -1403: REF = spectrum from ANT sample number 1403')
    #
    #   ezConRefMode     0: REF = 1.0 (no REF, neutral spectrum)')
    #   ezConRefMode     1: REF = spectrum from first ANT sample, number 0')
    #   ezConRefMode     2: REF = spectrum from rawByFreqBinAvg')
    #
    #   ezConRefMode xxx 4: REF = ANT spectrum of closest (quiet) RA=refWantedRaDegA or refWantedRaDegB
    #                                   degrees, depending on declination ====== need RA
    #   ezConRefMode xxx 5: REF = ANT spectrum of (minimum average of ANT in last 0.5 days) (champion)
    #                                   ======= need RA
    #   ezConRefMode ??? 7: REF = ANT spectrum where antB is minimum for all antB in the time window
    #
    #   ezConRefMode    10: REF = last REF marked in data')
    #
    #   ezConRefMode ?? 20: REF detection by software (for refPulser hardware)
    #
    #   ezConRefMode30L  freqAnt  freqRef  bwAnt   = Ant beside Ref in each Raw sample

    print()
    print('   createRef ===============')

    print('   calculating Ref with ezConRefMode =', ezConRefMode)

    freqAntMin = fileFreqMin    # may be changed by createRef30
    freqAntMax = fileFreqMax

    if ezConRawSamplesUseL:
        rawIndex = np.array(range(rawLen)) + ezConRawSamplesUseL[0]
    else:
        rawIndex = np.array(range(rawLen))

    #if ezConRefMode < 0:
    #    createRefNeg(ezConRefMode)
    ##elif ezConRefMode == 0:
    ##    createRef00rawSampleZero()
    #elif ezConRefMode == 1:
    #    createRef01refIsOne()
    #elif ezConRefMode == 2:
    #    createRef02rawByFreqBinAvg()
    ##elif ezConRefMode == 4:
    ##    createRef04closestQuietRAAnt()      # xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
    #elif ezConRefMode == 5:
    #    createRef05minimumAntAvg()
    #elif ezConRefMode == 7:
    #    createRef07minimumAntBAvg()

    if ezConRefMode <= 2 or ezConRefMode in [5, 7, 31, 40, 41, 44, 45]:
        createRefOneRef()

    elif ezConRefMode == 10:                # need REF marked in data, otherwise uses sample 0
        createRef10lastRefMarkedInData()

    #elif ezConRefMode == 20:               # need refPulser hardware
    #    createRef20refPulser()

    elif ezConRefMode == 30:                # -ezConRefMode30L freqAnt freqRef bwAnt
        createRef30AntBesideRef()
    #elif ezConRefMode == 31:                # -ezConRefMode31 RAHours
    #    createRef31RA()

    #elif ezConRefMode == 40:
    #    createRefXByFreqBinAvg(0, 0)        # ezConRefMode == 40: all ref is the one antAvgByFreqBinAvg spectrum
    #elif ezConRefMode == 41:
    #    createRefXByFreqBinAvg(1, 0)        # ezConRefMode == 41: all ref is the one antMaxByFreqBinAvg spectrum
    #### ezConRefMode == 42: all ref is the one refAvgByFreqBinAvg spectrum
    #### ezConRefMode == 43: all ref is the one refMaxByFreqBinAvg spectrum
    #elif ezConRefMode == 44:
    #    createRefXByFreqBinAvg(4, 0)        # ezConRefMode == 44: all ref is the one antBAvgByFreqBinAvg spectrum
    #elif ezConRefMode == 45:
    #    createRefXByFreqBinAvg(5, 0)        # ezConRefMode == 45: all ref is the one antBMaxByFreqBinAvg spectrum

    #elif ezConRefMode == 50:
    #    createRefXByFreqBinAvg(0, 1)        # ezConRefMode == 50: all ref is the one smoothed antAvgByFreqBinAvg spectrum
    #elif ezConRefMode == 51:
    #    createRefXByFreqBinAvg(1, 1)        # ezConRefMode == 51: all ref is the one smoothed antMaxByFreqBinAvg spectrum
    #### ezConRefMode == 52: all ref is the one refAvgByFreqBinAvg spectrum
    #### ezConRefMode == 53: all ref is the one refMaxByFreqBinAvg spectrum
    #elif ezConRefMode == 54:
    #    createRefXByFreqBinAvg(4, 1)        # ezConRefMode == 54: all ref is the one smoothed antBAvgByFreqBinAvg spectrum
    #elif ezConRefMode == 55:
    #    createRefXByFreqBinAvg(5, 1)        # ezConRefMode == 55: all ref is the one smoothed antBMaxByFreqBinAvg spectrum

    else:
        print()
        print()
        print()
        print(' ========== FATAL ERROR: ezConRefMode = ', ezConRefMode, ' not supported')
        print()
        print()
        print()
        print('\a')     # ring bell
        exit()



def createRefOneRef():
    # ignore raw ref samples, all ref to same spectrum

    global ezConRefMode             # integer
    global raw                      # float 2d array
    global ant                      # float 2d array    creation
    global ref                      # float 2d array    creation
    global rawLen                   # integer
    global antLen                   # integer           creation
    global antLenM1                 # integer           creation
    global ezConOut                 # float and int 2d array
    global freqBinQty               # integer
    global ezConRefMode31           # float
    global ezConAntBaselineFreqBinsFracL        # float list
    global dataFileIdx              # integer array

    global maskRawAnt               # Boolean array     creation
    global maskRawRef               # Boolean array     creation

    print()
    print('   createRefOneRef ===============')
    print(f'                         ezConRefMode = {ezConRefMode:,}')

    # creation: all ant samples are ANT samples
    #maskRawRef = 400. < elevationDeg            # creation: mark true if is a raw ref sample (see dataElevationRefDeg)
    maskRawRef = 400. < ezConOut[:, 8]          # creation: mark true if is a REF raw sample (see dataElevationRefDeg)
    maskRawAnt = np.logical_not(maskRawRef)     # creation: mark true if is not a raw ref sample

    #ant = (raw + 0.)[maskRawAnt, :]             # creation
    ant = raw[:, maskRawAnt]                    # creation
    antLen = np.shape(ant)[1]                   # creation
    print(f'                         antLen = {antLen:,}')
    antLenM1 = antLen - 1                       # creation

    if ezConRefMode <= 0:
        oneRefIndex = min(-ezConRefMode, rawLen - 1)    # remember, ezConRefMode is negative
        oneRef = ant[:, oneRefIndex]
    elif ezConRefMode == 1:
        oneRef = np.ones_like(freqBinQty)               # all ones
    elif ezConRefMode == 2:
        oneRef = np.mean(raw, axis=1)                   # rawByFreqBinAvg
    elif ezConRefMode == 5:
        antAvg = np.mean(ant, axis=0)
        antAvgMinIndex = np.argmin(antAvg)
        oneRef = ant[:, antAvgMinIndex]                 # ant spectrum at antAvgMin
    elif ezConRefMode == 40:
        oneRef = np.mean(ant, axis=1)                   # antAvgByFreqBinAvg
    elif ezConRefMode == 41:
        oneRef = np.max(ant, axis=1)                    # antMaxByFreqBinAvg
    elif ezConRefMode in [7, 31, 44, 45]:
        # create antB
        ezConAntBaselineFreqBin = np.empty(4, dtype=int)
        for i in range(4):
            ezConAntBaselineFreqBin[i] = int(ezConAntBaselineFreqBinsFracL[i] * (freqBinQty - 1))
        antBaseline = (np.sum(ant[ezConAntBaselineFreqBin[0]:ezConAntBaselineFreqBin[1], :], axis=0) \
            + np.sum(ant[ezConAntBaselineFreqBin[2]:ezConAntBaselineFreqBin[3], :], axis=0)) \
            / ((ezConAntBaselineFreqBin[1] - ezConAntBaselineFreqBin[0]) \
            + (ezConAntBaselineFreqBin[3] - ezConAntBaselineFreqBin[2]))
        #if ezConUseRefSub:
        if 0:
            antB = ant - antBaseline                    # creation
        else:
            # before division, if any antBaseline is zero, then add tiny number to all antBaseline
            if not antBaseline.all():
                antBaseline += 1e-30
            #if ezConInputdB:
            #    antB = -ant / antBaseline
            #else:
            antB = ant / antBaseline                    # creation

        if ezConRefMode == 7:
            antBAvg = np.mean(antB, axis=0)
            antBAvgMinIndex = np.argmin(antBAvg)
            print(f'                         antBAvgMinIndex = {antBAvgMinIndex:,}')
            oneRef = ant[:, antAvgMinIndex]             # ant spectrum at antBAvgMin
        elif ezConRefMode == 31:
            print(f'                         ezConRefMode31 =', ezConRefMode31)
            raHDiff = np.abs(ezConOut[:, 1] - ezConRefMode31)
            raHClosest = np.min(raHDiff)
            raHIndex = np.where(raHDiff == raHClosest)
            if not len(raHIndex[0]):
                raHIndex = np.where(raHDiff == -raHClosest)
            raHIndex = raHIndex[0][0]
            print(f'                         raHIndex =', raHIndex)
            print(f'                         closest raH =', ezConOut[raHIndex, 1])
            oneRef = antB[:, raHIndex]                  # antB spectrum at raHIndex
        elif ezConRefMode == 44:
            oneRef = np.mean(antB, axis=1)               # antBAvgByFreqBinAvg
        else: # ezConRefMode == 45
            oneRef = np.max(antB, axis=1)              # antBMaxByFreqBinAvg

    ref = np.empty_like(ant)
    for n in range(antLen):
        ref[:, n] = oneRef                      # creation

    plotEzCon201GrawAntRef()                    # using raw, maskRawAnt and maskRawRef
    plotEzCon201HtimeUtcMjdDBetweenRaw()        # using raw and dataTimeUtc
    plotEzCon201ItimeUtcMjdDBetweenAntRaw()     # using raw, dataTimeUtc, and maskRawAnt

    # done with raw data, thin most data arrays to only ANT samples
    ezConOut    = ezConOut   [maskRawAnt, :]    # from raw to only ant
    dataFileIdx = dataFileIdx[maskRawAnt]       # from raw to only ant



def createRef10lastRefMarkedInData():
    # ezConRefMode == 10: REF = last REF marked in raw

    global dataFileIdx              # integer array

    global raw                      # float 2d array
    global ant                      # float 2d array    creation
    global ref                      # float 2d array    creation
    global rawLen                   # integer
    global antLen                   # integer           creation
    global antLenM1                 # integer           creation
    global ezConOut                 # float and int 2d array

    global maskRawAnt               # Boolean array     creation
    global maskRawRef               # Boolean array     creation

    # for ezConRefMode == 10, create maskRawRef and maskRawAnt
    print()
    print('   createRef10lastRefMarkedInData ===============')

    #maskRawRef = 400. < elevationDeg       # creation: mark true if is a REF raw sample (see dataElevationRefDeg)
    maskRawRef = 400. < ezConOut[:, 8]     # creation: mark true if is a REF raw sample (see dataElevationRefDeg)
    maskRawAnt = np.logical_not(maskRawRef) # creation: ezConRefMode == 10, so otherwise is an ANT raw sample
    antLen = sum((maskRawAnt + 0))              # creation
    print(f'                         antLen = {antLen:,}')
    antLenM1 = antLen - 1                       # creation

    #if ezConRefAvgKeepFracL:                    # if plucking requested
    if 0:
        # remove those bad raw samples which would be REF samples, using ezConRefAvgKeepFracL
        
        print()
        print(f'   before refAvgKeepFrac, rawLen = {len(maskRawRef):,}')
        refLen = sum((maskRawRef + 0))          # temporary refLen,   ignored later
        refLenM1 = refLen - 1                   # temporary refLenM1, ignored later
        print(f'   before refAvgKeepFrac, refLen = {refLen:,}')

        print()
        print('   === refAvgKeepFrac ===============')

        ref = raw[:, maskRawRef]                # temporary ref array, ignored later
        print('   np.shape(ref)[0] =', np.shape(ref)[0])
        print('   np.shape(ref)[1] =', np.shape(ref)[1])

        # on spectrum of refAvg values, find ezConRefAvgKeepFracL fraction values
        refAvg = np.mean(ref, axis=0)
        print(f'   len(refAvg) = {len(refAvg):,}')
        refAvgSort = np.sort(refAvg)            # sorted by value
        print('   refAvgSort =', refAvgSort)
        print(f'   len(refAvgSort) = {len(refAvgSort):,}')

        refAvgKeepValue0 = refAvgSort[int(antLenM1 * ezConRefAvgKeepFracL[0])]
        refAvgKeepValue1 = refAvgSort[int(antLenM1 * ezConRefAvgKeepFracL[1])]
        print('   refAvgKeepValue0 =', refAvgKeepValue0)
        print('   refAvgKeepValue1 =', refAvgKeepValue1)

        # find RAW samples whose rawAvg is between refAvgKeepValue0 and refAvgKeepValue1
        rawAvg = np.mean(raw, axis=0)
        refAvgKeepMask = np.logical_and(refAvgKeepValue0 < rawAvg, rawAvg < refAvgKeepValue1)
        # and is a REF sample
        refAvgKeepMask = np.logical_and(refAvgKeepMask, maskRawRef)     # but only REF samples
        # but allow all ANT samples
        refAvgKeepMask = np.logical_or(refAvgKeepMask, maskRawAnt)
        print('   refAvgKeepMask =', refAvgKeepMask)
        print(f'   refAvgKeepMask.sum() = {refAvgKeepMask.sum():,}')
        print(f'   len(refAvgKeepMask) = {len(refAvgKeepMask):,}')

        # thin most data arrays to only refAvgKeepMask samples
        ezConOut     = ezConOut    [refAvgKeepMask, :]
        dataFileIdx  = dataFileIdx [refAvgKeepMask]
        dataTimeUtc  = dataTimeUtc [refAvgKeepMask]
        maskRawAnt   = maskRawAnt  [refAvgKeepMask]
        maskRawRef   = maskRawRef  [refAvgKeepMask]
        raw          = raw      [:, refAvgKeepMask]
        rawLen       = np.shape(raw)[1]
        print(f'   rawLen = {rawLen:,}')

        print()
        print(f'   after  refAvgKeepFrac, rawLen = {len(maskRawRef):,}')
        refLen = sum((maskRawRef + 0))          # temporary refLen, ignored later
        print(f'   after  refAvgKeepFrac, refLen = {refLen:,}')


    # raw plots for ezConRefMode == 10 (before data thinning soon)
    plotEzCon201GrawAntRef()                    # using raw, maskRawAnt and maskRawRef
    plotEzCon201HtimeUtcMjdDBetweenRaw()        # using raw and dataTimeUtc
    plotEzCon201ItimeUtcMjdDBetweenAntRaw()     # using raw, dataTimeUtc, and maskRawAnt
    plotEzCon201JtimeUtcMjdDBetweenRefRaw()     # using raw, dataTimeUtc, and maskRawRef

    # create ref: for every ant, the last REF raw spectrum
    ref = np.empty_like(raw)                    # to be thinned soon, to just the ANT samples
    refLast = raw[:, 0]                         # temporary refLast spectrum, backfilled soon
    refIndexFirst = -1                          # silly value, assumes at least one REF
    for n in range(rawLen):
        if maskRawAnt[n]:
            # n is an ANT sample
            ref[:, n] = refLast
        else:
            # ezConRefMode == 10, so n is a REF sample
            refLast = raw[:, n]
            # remember index and spectrum of first REF
            if refIndexFirst < 0:
                refIndexFirst = n
                refFirst = refLast
    # backfill first REF spectrum into ref[0] to ref[refIndexFirst]
    print(f'     refIndexFirst = {refIndexFirst:,}')
    for n in range(refIndexFirst):
        if maskRawAnt[n]:
            ref[:, n] = refFirst

    # done with raw data, thin most data arrays to only ANT samples
    ezConOut    = ezConOut   [maskRawAnt, :]    # from raw to only ant
    dataFileIdx = dataFileIdx[maskRawAnt]       # from raw to only ant
    ant         = raw    [:,  maskRawAnt]           # creation
    ref         = ref    [:,  maskRawAnt]           # creation



def createRef30AntBesideRef():
    # ezConRefMode == 30: -ezConRefMode30L  freqAnt  freqRef  bwAnt
    # Create maskRawAnt, maskRawRef, ant, ref, antLen, antLenM1 .
    # Thin data arrays to only ANT samples: dataFileIdx, raw .

    global dataFileIdx              # integer array
    global dataTimeUtc              # 'astropy.time.core.Time' object array

    global fileFreqMin              # float
    global fileFreqMax              # float
    global fileFreqBinQty           # integer
    global freqAntMin               # float             creation
    global freqAntMax               # float             creation
    global freqBinQty               # integer           creation

    global raw                      # float 2d array
    global ant                      # float 2d array    creation
    global ref                      # float 2d array    creation
    global rawLen                   # integer
    global antLen                   # integer           creation
    global antLenM1                 # integer           creation
    global ezConOut                 # float and int 2d array
    
    global ezConRefMode30L          # float list
    global byFreqBinX               # float array       creation
    global maskRawAnt               # Boolean array     creation
    global maskRawRef               # Boolean array     creation

    print()
    print('   createRef30AntBesideRef ===============')

    # sanity tests
    # -ezConRefMode30L  freqAnt  freqRef  bwAnt
    bwAntD2 = ezConRefMode30L[2] / 2.
    freqAntMin = ezConRefMode30L[0] - bwAntD2
    freqAntMax = ezConRefMode30L[0] + bwAntD2
    freqRefMin = ezConRefMode30L[1] - bwAntD2
    freqRefMax = ezConRefMode30L[1] + bwAntD2

    fileBw = fileFreqMax - fileFreqMin
    print('\n                         fileFreqMin    =', fileFreqMin)
    print('                         fileFreqMax    =', fileFreqMax)
    print('                         fileBw         =', fileBw)
    print('                         fileFreqBinQty =', fileFreqBinQty)

    print('\n                         freqAntMin =', freqAntMin)
    print('                         freqAnt    =', ezConRefMode30L[0])
    print('                         freqAntMax =', freqAntMax)
    print('                         freqAntbw  =', ezConRefMode30L[2])
    
    print('\n                         freqRefMin =', freqRefMin)
    print('                         freqRef    =', ezConRefMode30L[1])
    print('                         freqRefMax =', freqRefMax)
    
    if freqAntMin < fileFreqMin or freqRefMin < fileFreqMin \
        or fileFreqMax < freqAntMax or fileFreqMax < freqRefMax:
            print()
            print()
            print()
            print()
            print()
            print(' ========== FATAL ERROR:  ezConRefMode30L parameters [freqAnt,  freqRef,  bwAnt],')
            print(f'                  {ezConRefMode30L}  ')
            print("            does not fit inside the data file's fileFreqMin and fileFreqMax,")
            print(f'                  {fileFreqMin} and {fileFreqMax}')
            print()
            print()
            print()
            print()
            print('\a')     # ring bell
            exit()

    fileFreqStep = fileBw / (fileFreqBinQty - 1)

    freqBinAntMin = int(max(0, fileFreqBinQty * (freqAntMin - fileFreqMin) / fileBw))
    freqBinAntMax = int(min(fileFreqBinQty, fileFreqBinQty * (freqAntMax - fileFreqMin) / fileBw))
    freqBinAntQty = freqBinAntMax - freqBinAntMin

    freqBinRefMin = int(max(0, fileFreqBinQty * (freqRefMin - fileFreqMin) / fileBw))
    freqBinRefMax = int(min(fileFreqBinQty, fileFreqBinQty * (freqRefMax - fileFreqMin) / fileBw))
    freqBinRefQty = freqBinRefMax - freqBinRefMin

    print('\n                         freqBinAntQty =', freqBinAntQty)
    print('                         freqBinRefQty =', freqBinRefQty)
    freqBinQty = min(freqBinAntQty, freqBinRefQty)
    freqBinAntMax = freqBinAntMin + freqBinQty
    freqBinRefMax = freqBinRefMin + freqBinQty

    print('\n                         freqBinQty    =', freqBinQty)
    print('                         fileFreqStep =', fileFreqStep)

    print('\n                         freqBinAntMin =', freqBinAntMin)
    print('                         freqBinAntMax =', freqBinAntMax)

    print('\n                         freqBinRefMin =', freqBinRefMin)
    print('                         freqBinRefMax =', freqBinRefMax)

    ant = raw[freqBinAntMin:freqBinAntMax, :]   # creation
    ref = raw[freqBinRefMin:freqBinRefMax, :]   # creation
    byFreqBinX = np.arange(freqBinQty) * fileFreqStep - ezConRefMode30L[2] / 2.

    maskRawAnt = np.ones(rawLen, dtype=bool)
    maskRawRef = np.ones(rawLen, dtype=bool)

    antLen = rawLen                             # creation
    print(f'\n                         antLen = {antLen:,}')
    print(f'                         rawLen = {rawLen:,}')
    antLenM1 = antLen - 1                       # creation

    # raw plots for ezConRefMode == 30 (before data thinning soon)
    #plotEzCon201GrawAntRef()                    # using raw, maskRawAnt and maskRawRef
    #plotEzCon201HtimeUtcMjdDBetweenRaw()        # using raw and dataTimeUtc
    plotEzCon201ItimeUtcMjdDBetweenAntRaw()     # using raw, dataTimeUtc, and maskRawAnt
    plotEzCon201JtimeUtcMjdDBetweenRefRaw()     # using raw, dataTimeUtc, and maskRawRef

    # done with raw data, thin most data arrays to only ANT samples
    ezConOut    = ezConOut   [maskRawAnt, :]    # from raw to only ant
    dataFileIdx = dataFileIdx[maskRawAnt]       # from raw to only ant



#XXXXXXXXXXXXXXXXXXXXXXXX incomplete XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
def createRef04closestQuietRAAnt(): #XXXXXXXXXXXXXXXXXXXXXXXX
##########################################################################################
# I broke ezConRefMode == 4 with 'sdrVel08g7.py' (no RA available)
##########################################################################################
    # ezConRefMode == 4: no REF samples, ref = ANT spectrum of average of closest (quiet)
    #      RA=refWantedRaDegA or refWantedRaDegB degrees, depending on declination

    global raw                      # float 2d array
    global ant                      # float 2d array    creation
    global ref                      # float 2d array    creation
    global rawLen                   # integer
    global antLen                   # integer           creation
    #global antLenM1                 # integer           creation

    global maskRawAnt               # Boolean array     creation
    global maskRawRef               # Boolean array     creation

    print()
    print('   createRef04closestQuietRAAnt ===============')

    #print('1111111111111111')
    #refWantedRaDeg = 165.     # RA in degrees (11   hours), for ezConRefMode = 2
    refWantedRaDeg  = 172.5      # RA in degrees (11.5 hours), for ezConRefMode = 2
    refWantedRaDegA = 172.5     # RA in degrees (11.5 hours) for -45 <= Dec
    refWantedRaDegB =   0.      # RA in degrees (11.5 hours) for Dec <= 40

    ref = np.empty_like(ant)
    refLast = ant[:, 0]        # in case do not find refWantedRaDeg
    refWantedRaDeg180 = refWantedRaDeg + 180.
    refIndexStart = 0
    while (refIndexStart < antLen):
        #print('2222222222')
        # find first index where refWantedRaDeg<=RA
        refIndex = refIndexStart

        # find first index where RA<=refWantedRaDeg
        while refIndex < antLen:
            #print('7777777777777777')
            if  ezConOut[refIndex, 1] <= refWantedRaDeg:
                break
            refIndex += 1

        #while ezConOut[refIndex, 1] < refWantedRaDeg and refIndex < antLen:
        #    refIndexThis += 1
        # find first index where refWantedRaDeg<=RA
        while refIndex < antLen:
            #print('333333333333')
            if  refWantedRaDeg <= ezConOut[refIndex, 1]:
                break
            refIndex += 1
            
        #if refWantedRaDeg <= ezConOut[refIndex, 1]:
        #print('44444444444444 ezConOut[refIndex, 1]=', ezConOut[refIndex, 1])
        #print('44444444444444  refIndex=', refIndex)
        if refIndex < antLen:
            #print('44444444444444 ezConOut[refIndex, 1]=', ezConOut[refIndex, 1])
            # if found refWantedRaDeg, record ant from (RA=refWantedRaDeg index) as refLast
            # else use the previous refLast
            refLast = ant[:, refIndex]
            
        # find first index where refWantedRaDeg180<=RA
        #while ezConOut[refIndex, 1] < refWantedRaDeg180 and refIndex < antLen:
        #    refIndex += 1
        #print('555555555555555')
        while refIndex < antLen:
            if  refWantedRaDeg180 <= ezConOut[refIndex, 1]:
                break
            refIndex += 1

        # record either refWantedRaDeg180<=RA index or antLen
        refIndexStop = refIndex

        # paint ref section with refLast spectrum
        #print('66666666666666666')
        for n in range(refIndexStart, refIndexStop):
            #print('66666666666666666aaaaaaaaaaaa')
            ref[:, n] = refLast
            
        # prepare for hunt in next section
        refIndexStart = refIndexStop

        #print('888888888888888 refIndexStart=', refIndexStart)
        #print('                antLen=', antLen)
        #print('                refIndexStop=', refIndexStop)
        #print('                refIndex=', refIndex)



#XXXXXXXXXXXXXXXXXXXXXXXX incomplete XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
def createRef05MinimumAvgAntAvg(): #XXXXXXXXXXXXXXXXXXXXXXXX
##########################################################################################
# Did I break ezConRefMode == 5 with 'sdrVel08g7.py' ????????????
##########################################################################################
    # ezConRefMode == 5: no REF samples, ref = champion list: ant spectrum of
    #   (minimum average of ant in last 0.5 days)
    #   (ezConRefMode=2 was ref within 1.0 days, but want more often.  0.5 days seems achievable)
    
    global ezConBaselineLowFreqBin  # integer
    global ezConBaselineHighFreqBin # integer

    print()
    print('   createRef05minimumAntAvg ===============')

    dayFraction       = 10.
    ref = ant + 0.                  # copy ant[:]
    timeUtcMjdLast    = 0.          # silly value
    azimuthDegLast    = 99999.9     # silly value
    elevationDegLast  = 99999.9     # silly value
    #availableScoreMin = 99999.9     # silly value
    for n in range(antLen):
        #print('1111111111111 n =', n)
        timeUtcMjdThis   = ezConOut[n, 0]
        azimuthDegThis   = azimuthDeg[n]
        elevationDegThis = elevationDeg[n]
        # average of center of this spectrum, smaller is better score
        #scoreThis = ant[ezConBaselineLowFreqBin:-ezConBaselineHighFreqBin, n].sum() \
        #    / (samplesQty - ezConBaselineLowFreqBin - ezConBaselineHighFreqBin)
        scoreThis = ant[ezConBaselineLowFreqBin:-ezConBaselineHighFreqBin, n].sum() \
            / (antLen - ezConBaselineLowFreqBin - ezConBaselineHighFreqBin)

        #print('1111111111111 azimuthDegThis =', azimuthDegThis)
        #print('1111111111111 azimuthDegLast =', azimuthDegLast)
        #print('1111111111111111 elevationDegThis  =', elevationDegThis)
        #print('1111111111111111 elevationDegLast  =', elevationDegLast)
        #print('1111111111111111111 timeUtcMjdThis =', timeUtcMjdThis)
        #print('1111111111111111111 timeUtcMjdLast =', timeUtcMjdLast)
        if ((azimuthDegThis == azimuthDegLast) and (elevationDegThis == elevationDegLast) \
            and ((timeUtcMjdThis - timeUtcMjdLast) <= dayFraction)):

            #print('2222222222')
            # repeatedly: if 0.5 days old is < oldest available, remove oldest available
            while dayFraction < timeUtcMjdThis - availableTimeUtcMjd[-1]:
                #print('333333333')
                #availableIndexL   = availableIndexL[:-1]        # ordered new to old
                #availableFavoredL = availableFavoredL[:-1]      # ordered new to old
                #availableScoreL   = availableScoreL[:-1]        # ordered new to old
                del availableTimeUtcMjd[0]  # ordered new to old
                del availableScoreL[0]      # ordered new to old
                del availableIndexL[0]      # ordered new to old

            # is scoreThis better than all in availableScoreL ?
            # improve every ref of availableIndexL ?
            availableScoreMin = min(availableScoreL + [99999.9])     # with silly value for empty list
            if scoreThis < availableScoreMin:
                #print('4444444444')
                #availableScoreMin = scoreThis
                spectrumThis = ant[:, n]
                for i in availableIndexL:
                    #print('55555555555')
                    ref[:, i] = spectrumThis
            else:
                #print('666666666666')
                availableBest = availableScoreL.index(availableScoreMin) # index of first match in list
                ref[:, n] = ant[:, availableIndexL[availableBest]]

            # add new to front of available lists
            #print('77777777777')
            availableTimeUtcMjd = [timeUtcMjdThis] + availableTimeUtcMjd      # ordered new to old
            availableScoreL     = [scoreThis]      + availableScoreL          # ordered new to old
            availableIndexL     = [n]              + availableIndexL          # ordered new to old

        else:
            # reset timeUtcMjdLast, azimuthDegLast, elevationDegLast, and available records
            #print('88888888888')
            timeUtcMjdLast      = timeUtcMjdThis
            azimuthDegLast      = azimuthDegThis
            elevationDegLast    = elevationDegThis
            availableTimeUtcMjd = [timeUtcMjdThis]
            availableScoreL     = [scoreThis]
            availableIndexL     = [n]
            #availableScoreMin   = scoreThis
            #indexReset          = n
            # already ref[:, n]  = ant[:, n]
            #print('8888888888 timeUtcMjdLast =', timeUtcMjdLast)



#XXXXXXXXXXXXXXXXXXXXXXXX incomplete XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
def createRef20refPulser(): #XXXXXXXXXXXXXXXXXXXXXXXX
    # ezConRefMode == 20: no REF samples, ref = refPulser hardware REF detection by software
    # a@u18-200107a:~/rqv3$   python3 EzRA/ezCon10g4L.py   data/n0rqv3ez220319_00.txt

    global azimuthDeg               # float array
    global elevationDeg             # float array
    global dataFileIdx              # integer array
    global dataTimeUtc              # 'astropy.time.core.Time' object array
    global raw                      # float 2d array
    global ant                      # float 2d array    creation
    global ref                      # float 2d array    creation
    global rawIndex                 # integer array     may be thinned ??????????????????????????????????????
    global rawLen                   # integer
    global antLen                   # integer           creation
    global antLenM1                 # integer           creation

    global maskRawAnt               # Boolean array     creation
    global maskRawRef               # Boolean array     creation

    global xLabelSRaw               # string
    global xTickLocsRaw             # float array
    global xTickLabelsRaw           # string list

    print()
    print('   createRef20refPulser ===============')

    refPositive = 1                     # are REF sample values > ANT sample values ?
    rawAvg = np.mean(raw, axis=0)
    #print('rawAvg')
    #print(rawAvg)
    # refPulser hardware tries to REF 1 of every 8 samples

    # define 'recent' as a time duration in days
    #recentDurationDays = 1.1 / 24     # history long enough to span between REFs
    recentDurationDays = 0.3 / 24     # history long enough to span between REFs
    print('recentDurationDays =', recentDurationDays)

    # find recentLen index, recentDurationDays in time into the data file samples
    recentLen = 0
    dataTimeUtcZero = dataTimeUtc[0]
    for i in range(1, min(500, rawLen)):
        #print('   i =', recentLen, '   dataTimeUtc[i] - dataTimeUtcZero =', dataTimeUtc[i] - dataTimeUtcZero)
        if recentDurationDays <= (dataTimeUtc[i] - dataTimeUtcZero):
            recentLen = i
            break
    if not recentLen:
        print()
        print('  *** FATAL ERROR:    recentLen = 0')
        print()
        print('\a')     # ring bell
        exit()
    print('recentLen =', recentLen)

    # For each sample value, express the value as a fraction between its recent min and max.
    rawAvgRecentFrac = np.empty(rawLen)
    rawAvgRecentMinA = np.empty(rawLen)
    rawAvgRecentMaxA = np.empty(rawLen)
    for n in range(1, rawLen):
        # In the last recentLen samples, what is the max value ?
        # Find the max of (history long enough to span between REFs)
        # last recentLen samples of rawAvg
        rawAvgRecent = rawAvg[max(0, n - recentLen):n]
        if refPositive:
            rawAvgRecentMax = rawAvgRecent.max()                    # max of those recent samples
            rawAvgRecentMaxA[n] = rawAvgRecentMax                   # remember those maximums

            # In the last recentLen/3 samples, what is the min value ?
            # Find the min of (history only long enough to span across one REF)
            # last recentLen/3 samples of rawAvg
            rawAvgRecent = rawAvg[max(0, int(n - (recentLen / 3))):n]
            rawAvgRecentMin = rawAvgRecent.min()                    # min of those recent samples
            rawAvgRecentMinA[n] = rawAvgRecentMin                   # remember those minimums

            # How different is the current sample value from its recent past ?
            # For the current sample value, express the value as a fraction between its recent min and max.
            rawAvgRecentMaxMin = rawAvgRecentMax - rawAvgRecentMin      # span between max and min
            # avoid division by zero
            if rawAvgRecentMaxMin <= 0.:
                rawAvgRecentFrac[n] = 0.       # startup case?  Safer to be not a REF
            else:
                # For the current sample value, express the value as a fraction between its recent min and max.
                rawAvgRecentFrac[n] = (rawAvg[n] - rawAvgRecentMin) / rawAvgRecentMaxMin
        else:
            rawAvgRecentMax = rawAvgRecent.min()                    # min of those recent samples
            rawAvgRecentMaxA[n] = rawAvgRecentMax                   # remember those maximums

            # In the last recentLen/3 samples, what is the min value ?
            # Find the min of (history only long enough to span across one REF)
            # last recentLen/3 samples of rawAvg
            rawAvgRecent = rawAvg[max(0, int(n - (recentLen / 3))):n]
            rawAvgRecentMin = rawAvgRecent.max()                    # max of those recent samples
            rawAvgRecentMinA[n] = rawAvgRecentMin                   # remember those minimums

            # How different is the current sample value from its recent past ?
            # For the current sample value, express the value as a fraction between its recent min and max.
            rawAvgRecentMaxMin = rawAvgRecentMin - rawAvgRecentMax      # span between max and min
            # avoid division by zero
            if rawAvgRecentMaxMin <= 0.:
                rawAvgRecentFrac[n] = 0.       # startup case?  Safer to be not a REF
            else:
                # For the current sample value, express the value as a fraction between its recent min and max.
                rawAvgRecentFrac[n] = (rawAvgRecentMin - rawAvg[n]) / rawAvgRecentMaxMin

    # But the for loop skipped the first sample.  Fill in the skipped zero index from neighbor.
    rawAvgRecentFrac[0] = 0.                    # startup case.  Not a REF
    rawAvgRecentMinA[0] = rawAvgRecentMinA[1]
    rawAvgRecentMaxA[0] = rawAvgRecentMaxA[1]



    #def plotEzCon105ArawAvgMinMax():
    if 1:
        # Plot the REF detection progress so far.
        # Plot rawAvg in connected green, rawAvgRecentMinA in blue, and rawAvgRecentMaxA in violet.
        # The green rawAvg should rattle up and down between the recent blue min and the recent violet max.
        plotName = 'ezCon105ArawAvgMinMax.png'     #
        print()
        print('   plotting ' + plotName + ' ================================')

        print('                         rawAvgMaxMax =', rawAvg.max())
        print('                         rawAvgAvg =', np.mean(rawAvg))
        print('                         rawAvgMinMin =', rawAvg.min())

        if 105 in ezConPlotRequestedL:
            plt.clf()

            plt.plot(rawAvg, 'go-')
            #if refPositive:
            #    plt.plot(rawAvgCM10RecentMinA, 'bo')
            #    plt.plot(rawAvgCM10RecentMaxA, 'ro')
            #else:
            #    plt.plot(-rawAvgCM10RecentMinA, 'bo')
            #    plt.plot(-rawAvgCM10RecentMaxA, 'ro')
            plt.plot(rawAvgRecentMinA, 'bo')
            plt.plot(rawAvgRecentMaxA, 'o', c='violet')

            # Also plot each rawAvg sample as a fraction between the recent min and recent max.
            #rawAvgRecentMinAMin = rawAvgRecentMinA.min()
            #plt.plot(np.clip((rawAvgRecentFrac / 1000.) + rawAvgRecentMinAMin - 0.003,
            #    0, 0.99 * rawAvgRecentMinAMin), 'mo-')

            plt.title(titleS)
            plt.grid(ezConDispGrid)

            plt.xlabel(xLabelSRaw)
            plt.xlim(0, rawLenM1)
            plt.xticks(xTickLocsRaw, xTickLabelsRaw, rotation=45, ha='right', rotation_mode='anchor')

            plt.ylabel('Raw Antenna Spectrum Average with Recent Min and Max' \
                + '\n\n ezConRawSamplesUseL = ' + str(ezConRawSamplesUseL))
            #plt.ylim(-90, 90)

            if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
                os.remove(plotName)
            plt.savefig(plotName, dpi=300, bbox_inches='tight')


    # Define the trigger level for a REF.  If above this, the sample is defined as a possible REF sample.
    #rawAvgRecentFracTrig = 0.5
    rawAvgRecentFracTrig = 0.6

    #def plotEzCon201CrawAvgRecentFrac():
    if 1:
        # Plot the REF detection progress so far.
        # Plot horizontal line at rawAvgRecentFracTrig in violet, and rawAvgAvgRecentFrac in connected green.
        # The green rawAvgAvgRecentFrac should rattle up and down above and below violet rawAvgRecentFracTrig.
        plotName = 'ezCon201CrawAvgRecentFrac.png'
        print()
        print('   plotting ' + plotName + ' ================================')

        print('                         rawAvgRecentFracMax =', rawAvgRecentFrac.max())
        print('                         rawAvgRecentFracAvg =', np.mean(rawAvgRecentFrac))
        print('                         rawAvgRecentFracMin =', rawAvgRecentFrac.min())

        if 201 in ezConPlotRequestedL:
            plt.clf()

            # horizontal line at rawAvgRecentFracTrig in violet
            plt.plot([0, rawLenM1], [rawAvgRecentFracTrig, rawAvgRecentFracTrig], '-', c='violet')

            # rawAvgAvgRecentFrac in connected green
            plt.plot(rawAvgRecentFrac, 'go-')

            plt.title(titleS)
            plt.grid(ezConDispGrid)

            plt.xlabel(xLabelSRaw)
            plt.xlim(0, rawLenM1)
            plt.xticks(xTickLocsRaw, xTickLabelsRaw, rotation=45, ha='right', rotation_mode='anchor')

            plt.ylabel('RawAvg Recent Fraction vs REF Trigger' \
                + '\n ')
            plt.ylim(-0.5, 2)     # clip silly start up values

            if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
                os.remove(plotName)
            plt.savefig(plotName, dpi=300, bbox_inches='tight')



    # rawAvgRecentFrac is an array of fractions.  Which ones are above the trigger value ?
    # If sampleRef[i] == 1 means that i sample is a possible REF sample
    sampleRef = (rawAvgRecentFracTrig <= rawAvgRecentFrac) + 0    # sampleRef = 1 means possible REF sample
    #print(' sampleRef =')
    #print(sampleRef.tolist())
    sampleRefSum = sampleRef.sum()
    print(' sampleRefSum =', sampleRefSum)

    #def plotEzCon201DsampleRef():
    if 1:
        plotName = 'ezCon201DsampleRef.png'
        print()
        print('   plotting ' + plotName + ' ================================')

        #print('                         sampleRefMax =', sampleRef.max())
        sampleRefAvg = np.mean(sampleRef)
        print('                         sampleRefAvg =', sampleRefAvg)
        #print('                         sampleRefMin =', sampleRef.min())

        if 201 in ezConPlotRequestedL:
            plt.clf()

            # sampleRef in connected green
            plt.plot(sampleRef, 'go-')

            ## plot a blue dot on sampleRef which are 0
            #temp = sampleRef + 0.
            #temp[sampleRef] = np.nan                    # mark True  sampleRef as np.nan, which will not plot
            #plt.plot(temp, 'bo')

            # plot a violet dot on sampleRef which are 1
            temp = sampleRef + 0.
            temp[np.logical_not(sampleRef)] = np.nan    # mark False sampleRef as np.nan, which will not plot
            plt.plot(temp, 'o', c='violet')

            plt.title(titleS)
            plt.grid(ezConDispGrid)

            plt.xlabel(xLabelSRaw)
            plt.xlim(0, rawLenM1)
            plt.xticks(xTickLocsRaw, xTickLabelsRaw, rotation=45, ha='right', rotation_mode='anchor')

            plt.ylabel('Possible REF in Violet\n\nSampleRef = ' + str(sampleRefSum) \
                + ' = ' + str(int(100. * sampleRefAvg)) + ' %')
            #    + '\n\n rawLen = ' + str(rawLen))
            #plt.ylim(-90, 90)
            plt.ylim(-0.5, 2)     # same scale as previous plot
            
            if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
                os.remove(plotName)
            plt.savefig(plotName, dpi=300, bbox_inches='tight')


    # Samples on both sides of a REF transition edge are assumed BAD (corrupted), so find them.

    #      123456
    #   ====CCCC====
    #   000100000000 = sampleBad0
    #   000010000000 = sampleBad1
    # Mark a non-REF BAD if it has a possible REF to its right.
    # non-REF samples on left side of a possible REF are assumed BAD (corrupted), so find them (sampleBad1).
    # REF samples to the right of sampleBad1 are assumed BAD (corrupted), so find them (sampleBad2).
    sampleRefLeft = np.concatenate([sampleRef[1:], [0]])       # shift sampleRef left
    sampleBad1 = np.logical_and(np.logical_not(sampleRef), sampleRefLeft) + 0
    #print(' sampleBad1 =')
    #print(sampleBad1.tolist())
    sampleBad2 = np.concatenate([[0], sampleBad1[:-1]])       # shift sampleBad1 right
    #print(' sampleBad2 =')
    #print(sampleBad2.tolist())

    #      123456
    #   ====CCCC====
    #   000000001000 = sampleBad6
    #   000000010000 = sampleBad5
    # Mark a non-REF BAD if it has a possible REF to its left.
    # non-REF samples on right side of a possible REF are assumed BAD (corrupted), so find them (sampleBad6).
    # REF samples to the left of sampleBad6 are assumed BAD (corrupted), so find them (sampleBad5).
    sampleRefRight = np.concatenate([[0], sampleRef[:-1]])       # shift sampleRef right
    sampleBad6 = np.logical_and(sampleRefRight, np.logical_not(sampleRef)) + 0
    #print(' sampleBad6 =')
    #print(sampleBad6.tolist())
    sampleBad5 = np.concatenate([sampleBad6[1:], [0]])       # shift sampleBad6 left
    #print(' sampleBad5 =')
    #print(sampleBad5.tolist())

    # combine sampleBad1, sampleBad2, sampleBad5, and sampleBad6 into sampleBad
    sampleBad = np.logical_or(sampleBad1, sampleBad2)
    sampleBad = np.logical_or(sampleBad,  sampleBad5)
    sampleBad = np.logical_or(sampleBad,  sampleBad6) + 0


    # But REF which were only 2 long were just both marked as BAD.
    # Of the 2 trailing REF neighbors (sample4 and sample5), mark the one more REFish as non-BAD.
    #      123456
    #   ====CCCC====
    #   000000010000 = sampleBad5 (created above)
    for i in np.nonzero(sampleBad5)[0]:
        if i:                                                       # ignore if sample5 index is 0
            if sampleRef[i-1]:                                      # insure sample4 is a REF
                if rawAvgRecentFrac[i-1] < rawAvgRecentFrac[i]:     # if sample4 is less REFish than sample5
                    sampleBad[i]   = 0                              # mark the more REFish sample5 as non-BAD
                else:
                    sampleBad[i-1] = 0                              # mark the more REFish sample4 as non-BAD


    # insist first recentLen sampleBad are True
    for i in range(recentLen):
        sampleBad[i] = 1
    #print(' sampleBad =')
    #print(sampleBad.tolist())


    #def plotEzCon201FsampleBad():
    if 1:
        plotName = 'ezCon201FsampleBad.png'
        print()
        print('   plotting ' + plotName + ' ================================')

        #print('                         sampleBadMax =', sampleBad.max())
        sampleBadSum = np.sum(sampleBad)
        sampleBadAvg = sampleBadSum / rawLen
        print('                         sampleBadAvg =', sampleBadAvg)
        #print('                         sampleBadMin =', sampleBad.min())

        if 201 in ezConPlotRequestedL:
            plt.clf()

            # sampleBad in connected green
            plt.plot(sampleBad, 'go-')

            plt.title(titleS)
            plt.grid(ezConDispGrid)

            plt.xlabel(xLabelSRaw)
            plt.xlim(0, rawLenM1)
            plt.xticks(xTickLocsRaw, xTickLabelsRaw, rotation=45, ha='right', rotation_mode='anchor')

            plt.ylabel('Samples Marked Invalid\n\nSampleBad = ' + str(sampleBadSum) \
                + ' = ' + str(int(100. * sampleBadAvg)) + ' %')
            #    + '\n\n rawLen = ' + str(rawLen))
            #plt.ylim(-90, 90)
            plt.ylim(-0.5, 2)     # same scale as previous plot
            
            if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
                os.remove(plotName)
            plt.savefig(plotName, dpi=300, bbox_inches='tight')


    # maskRawRef = sampleRef and not(sampleBad)
    maskRawRef = np.logical_and(sampleRef, np.logical_not(sampleBad))
    #print(' maskRawRef =')
    #print(maskRawRef.tolist())

    # maskRawAnt = not maskRawRef and not(sampleBad)
    maskRawAnt = np.logical_and(np.logical_not(maskRawRef), np.logical_not(sampleBad))
    #print(' maskRawAnt =')
    #print(maskRawAnt.tolist())
    antLen = np.sum(maskRawAnt + 0)
    antLenM1 = antLen - 1

    #print(' maskRawAnt =', maskRawAnt)
    #print(' maskRawAnt + 0 =', maskRawAnt + 0)
    #print(' maskRawRef + 0 =', maskRawRef + 0)

    # raw plots for ezConRefMode == 20 (before data thinning soon)
    plotEzCon201GrawAntRef()                    # using raw, maskRawAnt and maskRawRef
    plotEzCon201HtimeUtcMjdDBetweenRaw()        # using raw and dataTimeUtc
    plotEzCon201ItimeUtcMjdDBetweenAntRaw()     # using raw, dataTimeUtc, and maskRawAnt
    plotEzCon201JtimeUtcMjdDBetweenRefRaw()     # using raw, dataTimeUtc, and maskRawRef

    #    # for a REF next to a REF, mark the lesser deviation REF as BAD.
    #    # Find REFs that follow a REF
    #    sampleRefAgain = np.concatenate([[0], sampleRef[:-1]])      # shift sampleRef right
    #    print(' sampleRefAgain =')
    #    print(sampleRefAgain.tolist())
    #    sampleRefAgain = np.logical_and(sampleRef, sampleRefAgain) + 0
    #    print(' sampleRefAgain =')
    #    print(sampleRefAgain.tolist())
    #    sampleRefAgainIndex = np.nonzero(sampleRefAgain)
    #    print(' sampleRefAgainIndex[0] =')
    #    print(sampleRefAgainIndex[0])

    #    for i in range(len(sampleRefAgainIndex[0])):
    #        # if the later REF has greater rawAvgAvgRecentFrac than the earlier REF
    #        if    rawAvg[sampleRefAgainIndex[0][i]] \
    #            > rawAvg[sampleRefAgainIndex[0][i] - 1]:
    #                       sampleRef[sampleRefAgainIndex[0][i] - 1] = 0      # mark earlier REF as non-REF
    #        else:
    #                       sampleRef[sampleRefAgainIndex[0][i]    ] = 0      # mark later   REF as non-REF

    #def plotEzCon105ErawAvgMaskRawAnt():
    if 0:
        plotName = 'ezCon105ErawAvgMaskRawAnt.png'
        print()
        print('   plotting ' + plotName + ' ================================')

        #print('                         maskRawAntMax =', maskRawAnt.max())
        maskRawAntSum = np.sum(maskRawAnt)
        maskRawAntAvg = maskRawAntSum / rawLen
        print('                         maskRawAntAvg =', maskRawAntAvg)
        #print('                         maskRawAntMin =', maskRawAnt.min())

        if 105 in ezConPlotRequestedL:
            plt.clf()

            # raw in connected green
            plt.plot(rawAvg, 'go-')

            # plot a blue dot on raw where maskAnt is True
            temp = rawAvg + 0.
            temp[np.logical_not(maskRawAnt)] = np.nan   # mark False maskRawAnt as np.nan, which will not plot
            plt.plot(temp, 'bo')

            # plot a violet dot on raw where maskRef is True
            temp = rawAvg + 0.
            temp[np.logical_not(maskRawRef)] = np.nan   # mark False maskRawRef as np.nan, which will not plot
            plt.plot(temp, 'o', c='violet')

            plt.title(titleS)
            plt.grid(ezConDispGrid)

            plt.xlabel(xLabelSRaw)
            plt.xlim(0, rawLenM1)
            plt.xticks(xTickLocsRaw, xTickLabelsRaw, rotation=45, ha='right', rotation_mode='anchor')

            plt.ylabel('maskRawAnt = ' + str(maskRawAntSum) \
                + ' = ' + str(int(100. * maskRawAntAvg)) + ' %' \
                + '\n\n rawLen = ' + str(rawLen))
            #plt.ylim(-90, 90)
            
            if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
                os.remove(plotName)
            plt.savefig(plotName, dpi=300, bbox_inches='tight')


    # create ref: for every ant, the last REF raw spectrum
    ref = np.empty_like(raw)                    # to be thinned soon, to just the ANT samples
    refLast = raw[:, 0]                         # temporary refLast spectrum, backfilled soon
    refIndexFirst = -1                          # silly value, assumes at least one REF
    for n in range(rawLen):
        #print(' maskRawAnt[n] + 0 =', maskRawAnt[n] + 0)
        if maskRawAnt[n]:
            # n is an ANT sample
            ref[:, n] = refLast
        elif maskRawRef[n]:
            # n is an REF sample
            refLast = raw[:, n]
            #print(' np.shape(refLast) =', np.shape(refLast))
            # remember index and spectrum of first REF
            if refIndexFirst < 0:
                refIndexFirst = n
                #print('     refIndexFirst =', refIndexFirst)
                refFirst = refLast
                #print(' np.shape(refFirst) =', np.shape(refFirst))
    # backfill first REF spectrum into ref[0] to ref[refIndexFirst]
    print('     refIndexFirst =', refIndexFirst)
    for n in range(refIndexFirst):
        if maskRawAnt[n]:
            ref[:, n] = refFirst

    # done with raw data, thin most data arrays to only ANT samples
    azimuthDeg   = azimuthDeg  [maskRawAnt]
    elevationDeg = elevationDeg[maskRawAnt]
    dataFileIdx  = dataFileIdx [maskRawAnt]
    dataTimeUtc  = dataTimeUtc [maskRawAnt]
    rawIndex     = rawIndex    [maskRawAnt]
    ant          = raw     [:,  maskRawAnt]           # creation
    ref          = ref     [:,  maskRawAnt]           # creation
    #print(' np.shape(ant) =', np.shape(ant))

    #raw    = ant + 0. ######################################################## needed ?
    #raw = []                       # free global memory
    #raw = None
    #del raw
    #rawLen = antLen + 0 ######################################################## needed ?



def ezConAntMaxPluckValLDo():

    global dataFileIdx              # integer array
    global ezConOut                 # float and int 2d array
    global ant                      # float 2d array
    global antLen                   # integer
    global antLenM1                 # integer
    global ref                      # float 2d array
    global refLen                   # integer
    global xTickLocsAnt             # float array

    global ezConAntMaxPluckValL     # float list

    if not ezConAntMaxPluckValL:    # if empty, no plucking needed
        return(1)

    print()
    print('   ezConAntMaxPluckValL ===============')

    print('   np.shape(ant)[0] =', np.shape(ant)[0])
    print('   np.shape(ant)[1] =', np.shape(ant)[1])

    antMax = np.max(ant, axis=0)
    #print('   antMax =', antMax)
    print(f'   len(antMax) = {len(antMax):,}')
    print()

    # assume want to keep all antMax samples
    antMaxPluckValKeepMask = np.ones(antLen, dtype=bool)

    #if ezConAntMaxPluckValL:
    if 1:
        print('   ezConAntMaxPluckValL =', ezConAntMaxPluckValL)
        print()

        # mask off antMax samples with values equal or less than requested low
        antMaxPluckValKeepMask[antMax <= ezConAntMaxPluckValL[0]] = False
        # mask off antMax samples with values equal or greater than requested high
        antMaxPluckValKeepMask[ezConAntMaxPluckValL[1] <= antMax] = False

    #print('   antMaxPluckValKeepMask =', antMaxPluckValKeepMask)
    print(f'   antMaxPluckValKeepMask.sum() =', antMaxPluckValKeepMask.sum())
    print(f'   len(antMaxPluckValKeepMask) = {len(antMaxPluckValKeepMask):,}')

    # thin most data arrays to keep only antMaxPluckValKeepMask samples
    dataFileIdx = dataFileIdx[antMaxPluckValKeepMask]
    ezConOut    = ezConOut   [antMaxPluckValKeepMask, :]
    ant      = ant        [:, antMaxPluckValKeepMask]
    antLen   = ant.shape[1]
    antLenM1 = antLen - 1
    ref      = ref        [:, antMaxPluckValKeepMask]
    refLen   = ref.shape[1]
    print(f'   antLen = {antLen:,}')
    print(f'   refLen = {refLen:,}')
    xTickLocsAnt = []               # probably just changed antLen, force new xTickLocsAnt



def ezConAntAvgPluckQtyLDo():

    global dataFileIdx              # integer array
    global ezConOut                 # float and int 2d array
    global ant                      # float 2d array
    global ref                      # float 2d array
    global antLen                   # integer
    global antLenM1                 # integer
    global xTickLocsAnt             # float array

    global ezConAntAvgPluckQtyL     # float list

    if not ezConAntAvgPluckQtyL:    # if empty, no plucking needed
        return(1)

    #print(f'   before ezConAntAvgPluckQtyL, antLen = ', {antLen:,}')

    print()
    print('   ezConAntAvgPluckQtyLDo ===============')

    print('   np.shape(ant)[0] =', np.shape(ant)[0])
    print('   np.shape(ant)[1] =', np.shape(ant)[1])

    antAvg = np.mean(ant, axis=0)
    #print('   antAvg =', antAvg)
    print(f'   len(antAvg) = {len(antAvg):,}')
    print()

    # get indexes of increasing antAvg
    antAvgIdxByIncreasing = antAvg.argsort()
    #print('   antAvgIdxByIncreasing =', antAvgIdxByIncreasing)
    print(f'   len(antAvgIdxByIncreasing) = {len(antAvgIdxByIncreasing):,}')
    print()

    print('   ezConAntAvgPluckQtyL =', ezConAntAvgPluckQtyL)
    print()

    # assume want to keep all antAvg samples
    antAvgPluckNumKeepMask = np.ones(antLen, dtype=bool)
    # mask off requested lowest-valued antAvg samples
    for i in range(ezConAntAvgPluckQtyL[0]):     # i starts with 0
        antAvgPluckNumKeepMask[antAvgIdxByIncreasing[i]] = False
    # mask off requested highest-valued antAvg samples
    for i in range(ezConAntAvgPluckQtyL[1]):     # i starts with 0
        antAvgPluckNumKeepMask[antAvgIdxByIncreasing[-1-i]] = False

    #print('   antAvgPluckNumKeepMask =', antAvgPluckNumKeepMask)
    print(f'   antAvgPluckNumKeepMask.sum() =', antAvgPluckNumKeepMask.sum())
    print(f'   len(antAvgPluckNumKeepMask) = {len(antAvgPluckNumKeepMask):,}')

    # thin most data arrays to keep only antAvgPluckNumKeepMask samples
    dataFileIdx = dataFileIdx[antAvgPluckNumKeepMask]
    ezConOut    = ezConOut   [antAvgPluckNumKeepMask, :]
    ant         = ant     [:, antAvgPluckNumKeepMask]
    ref         = ref     [:, antAvgPluckNumKeepMask]
    antLen    = ant.shape[1]
    antLenM1  = antLen - 1
    refLen    = ref.shape[1]
    print(f'   antLen = {antLen:,}')
    print(f'   refLen = {refLen:,}')
    xTickLocsAnt = []               # probably just changed antLen, force new xTickLocsAnt



def ezConAntAvgPluckFracLDo():

    global dataFileIdx              # integer array
    global ezConOut                 # float and int 2d array
    global ant                      # float 2d array
    global ref                      # float 2d array
    global antLen                   # integer
    global antLenM1                 # integer
    global xTickLocsAnt             # float array

    global ezConAntAvgPluckFracL    # float list

    if not ezConAntAvgPluckFracL:   # if empty, no plucking needed
        return(1)

    #print(f'   before ezConAntAvgPluckFracLDo, antLen = ', {antLen:,}')

    print()
    print('   ezConAntAvgPluckFracLDo ===============')

    print('   np.shape(ant)[0] =', np.shape(ant)[0])
    print('   np.shape(ant)[1] =', np.shape(ant)[1])

    antAvg = np.mean(ant, axis=0)
    #print('   antAvg =', antAvg)
    print(f'   len(antAvg) = {len(antAvg):,}')
    print()

    # get indexes of increasing antAvg
    antAvgIdxByIncreasing = antAvg.argsort()
    #print('   antAvgIdxByIncreasing =', antAvgIdxByIncreasing)
    print(f'   len(antAvgIdxByIncreasing) = {len(antAvgIdxByIncreasing):,}')
    print()

    print('   ezConAntAvgPluckFracL =', ezConAntAvgPluckFracL)
    print()

    # snap down to next integer
    antAvgPluckFracQty0 = int(antLenM1 * ezConAntAvgPluckFracL[0])
    antAvgPluckFracQty1 = int(antLenM1 * ezConAntAvgPluckFracL[1])

    # assume want to keep all antAvg samples
    antAvgPluckFracKeepMask = np.ones(antLen, dtype=bool)

    # mask off requested lowest-valued antAvg samples
    for i in range(antAvgPluckFracQty0):     # i starts with 0
        antAvgPluckFracKeepMask[antAvgIdxByIncreasing[i]] = False
    # mask off requested highest-valued antAvg samples
    for i in range(antAvgPluckFracQty1):     # i starts with 0
        antAvgPluckFracKeepMask[antAvgIdxByIncreasing[-1-i]] = False

    #print('   antAvgPluckFracKeepMask =', antAvgPluckFracKeepMask)
    print(f'   antAvgPluckFracKeepMask.sum() =', antAvgPluckFracKeepMask.sum())
    print(f'   len(antAvgPluckFracKeepMask) = {len(antAvgPluckFracKeepMask):,}')

    # thin most data arrays to keep only antAvgPluckFracKeepMask samples
    dataFileIdx = dataFileIdx[antAvgPluckFracKeepMask]
    ezConOut    = ezConOut   [antAvgPluckFracKeepMask, :]
    ant         = ant     [:, antAvgPluckFracKeepMask]
    ref         = ref     [:, antAvgPluckFracKeepMask]
    antLen   = ant.shape[1]
    antLenM1 = antLen - 1
    refLen   = ref.shape[1]
    print(f'   antLen = {antLen:,}')
    print(f'   refLen = {refLen:,}')
    xTickLocsAnt = []               # probably just changed antLen, force new xTickLocsAnt



def ezConAntFreqBinSmoothDo():
    # ant RFI spur removal with ezConAntFreqBinSmooth
    # for each Ant sample, no freqBin should be > ezConAntFreqBinSmooth * average of its 4 freqBin neighbor values

    global fileFreqBinQty           # integer
    global ant                      # float 2d array
    global antLen                   # integer
    global ezConAntFreqBinSmooth    # float

    print()
    print('   ezConAntFreqBinSmoothDo ===============')

    antZero = ant + 0.

    # if ezConAntFreqBinSmooth not a silly number
    if ezConAntFreqBinSmooth < 98.:
        print(' hide the RFI spectrum spurs ...')
        for n in range(antLen):
            # process the first 2 freqBin and the last 2 freqBin later, ignore them in this loop
            for f in range(2, fileFreqBinQty - 2):
                freqBinMax = ezConAntFreqBinSmooth \
                    * (antZero[f - 2, n] + antZero[f - 1, n] + antZero[f + 1, n] + antZero[f + 2, n]) / 4.
                if freqBinMax < antZero[f, n]:
                    ant[f, n] = min(antZero[f - 1, n], ant[f - 1, n])
                    print('        freqBinMax =', freqBinMax,
                        '           antZero[', f, ',', n, '] = ', antZero[f, n],
                        '           to ant[', f, ',', n, '] = ', ant[f, n])

        # process first freqBin
        for n in range(antLen):
            freqBinMax = ezConAntFreqBinSmooth * (antZero[1, n] + antZero[2, n]) / 2.
            if freqBinMax < antZero[0, n]:
                ant[0, n] = min(antZero[1, n], ant[1, n])
                print('        freqBinMax =', freqBinMax,
                    '           antZero[0,', n, '] = ', antZero[0, n],
                    '           to ant[0,', n, '] = ', ant[0, n])

        # process second freqBin
        for n in range(antLen):
            freqBinMax = ezConAntFreqBinSmooth \
                * (antZero[0, n] + antZero[2, n] + antZero[3, n] / 3.)
            if freqBinMax < antZero[1, n]:
                ant[1, n] = min(antZero[0, n], ant[0, n])
                print('        freqBinMax =', freqBinMax,
                    '           antZero[1,', n, '] = ', antZero[1, n],
                    '           to ant[1,', n, '] = ', ant[1, n])

        # process next to last freqBin
        for n in range(antLen):
            freqBinMax = ezConAntFreqBinSmooth \
                * (antZero[-4, n] + antZero[-3, n] + antZero[-1, n] / 3.)
            if freqBinMax < antZero[-2, n]:
                ant[-2, n] = min(antZero[-3, n], ant[-3, n])
                print('        freqBinMax =', freqBinMax,
                    '           antZero[-2,', n, '] = ', antZero[-2, n],
                    '           to ant[-2,', n, '] = ', ant[-2, n])

        # process last freqBin
        for n in range(antLen):
            freqBinMax = ezConAntFreqBinSmooth \
                * (antZero[-3, n] + antZero[-2, n] / 2.)
            if freqBinMax < antZero[-1, n]:
                ant[-1, n] = min(antZero[-2, n], ant[-2, n])
                print('        freqBinMax =', freqBinMax,
                    '           antZero[-1,', n, '] = ', antZero[-1, n],
                    '           to ant[-1,', n, '] = ', ant[-1, n])
        print()



def ezConAntSamplesUseLDo():

    global dataFileIdx              # integer array
    global ezConOut                 # float and int 2d array
    global ant                      # float 2d array
    global ref                      # float 2d array
    global antLen                   # integer
    global antLenM1                 # integer

    global xTickLabelsHeatAntL      # string list
    global xTickLocsAnt             # float array

    global ezConAntSamplesUseL      # integer list
    global ezConAntPluckL           # integer list

    #print(f'   before ezConAntSamplesUseLDo, antLen = ', {antLen:,}')
    
    print()
    print('   ezConAntSamplesUseLDo ===============')

    print('                         np.shape(ant)[1] =', np.shape(ant)[1])

    # ezConAntSamplesUseL allows more than one pair of list elements
    useSamplesAntStart = ezConAntSamplesUseL[0]
    useSamplesAntStop  = ezConAntSamplesUseL[1]
    useSamplesAntIndex = 2                         # point to next start/stop pair, if any
    # assume do  not  want to keep all Ant samples
    useSamplesAntMask = np.zeros([antLen], dtype = bool)
    for n in range(min(ezConAntSamplesUseL[-1] + 1, antLen)):
        # need to update useSamplesAntStop and useSamplesAntStart ?
        if useSamplesAntStop < n:
            useSamplesAntStart = ezConAntSamplesUseL[useSamplesAntIndex]
            useSamplesAntStop  = ezConAntSamplesUseL[useSamplesAntIndex + 1]
            useSamplesAntIndex += 2        # point to next Start/Stop pair, if any

        # is n inside an ANT want-to-use section ?
        if useSamplesAntStart <= n and n <= useSamplesAntStop:
            useSamplesAntMask[n] = True

    #print('                         useSamplesAntMask =', useSamplesAntMask)
    print('                         useSamplesAntMask.sum() =', (useSamplesAntMask + 0).sum())
    print('                         len(useSamplesAntMask) =', len(useSamplesAntMask))

    # thin most data arrays to only antAvgKeepMask samples
    dataFileIdx = dataFileIdx[useSamplesAntMask]
    ezConOut    = ezConOut   [useSamplesAntMask, :]
    ant         = ant     [:, useSamplesAntMask]
    ref         = ref     [:, useSamplesAntMask]
    antLen   = ant.shape[1]
    antLenM1 = antLen - 1
    refLen   = ref.shape[1]
    print(f'                         antLen = {antLen:,}')
    print(f'                         refLen = {refLen:,}')
    xTickLabelsHeatAntL = []        # probably just changed antLen, force new xTickLabelsHeatAntL
    xTickLocsAnt        = []        # probably just changed antLen, force new xTickLocsAnt



def ezConAntPluckLDo():

    global dataFileIdx              # integer array
    global ezConOut                 # float and int 2d array
    global ant                      # float 2d array
    global ref                      # float 2d array
    global antLen                   # integer
    global antLenM1                 # integer

    global xTickLabelsHeatAntL      # string list
    global xTickLocsAnt             # float array

    global ezConAntSamplesUseL      # integer list
    global ezConAntPluckL           # integer list

    print()
    print('   ezConAntPluckLDo ===============')

    #print('   ant =', ant)
    print('                         np.shape(ant)[0] =', np.shape(ant)[0])
    print('                         np.shape(ant)[1] =', np.shape(ant)[1])
    print()

    # assume want to keep all Ant samples
    antPluckKeepMask = np.ones(antLen, dtype=bool)

    print('   ezConAntPluckL =', ezConAntPluckL)
    print()

    # This ezConAntPluckLDo() starts with the current indices of AntXT.
    # This loop processes the requests in given order.
    # Each pluck changes the index of the higher indexes (all higher samples move left).
    # Like a chain anchored at the left, and removing one link, the total chain is shortened and the right side of the chain moves left by one link.
    # This why it is easier to request ezConAntPluckL values in decreasing order !
    for i in range(len(ezConAntPluckL)):
        ezConAntPluckThis = ezConAntPluckL[i]
        if antLen < ezConAntPluckThis:
            print()
            print()
            print()
            print(f' ========== FATAL ERROR: ezConAntPluckL[{i}] is too large a number.')
            print(f'                         ezConAntPluckL =', ezConAntPluckL)
            print(f'                         current length of Ant < ezConAntPluckL[{i}]')
            print(f'                         {antLen} < {ezConAntPluckThis}')
            print()
            print()
            print()
            print('\a')     # ring bell
            exit()
        else:
            antPluckKeepMask[ezConAntPluckThis] = False
    
    #print('                         antPluckKeepMask =', antPluckKeepMask)
    print('                         antPluckKeepMask.sum() =', (antPluckKeepMask + 0).sum())
    print('                         len(antPluckKeepMask) =', len(antPluckKeepMask))

    # thin most data arrays to only antPluckKeepMask samples
    dataFileIdx = dataFileIdx[antPluckKeepMask]
    ezConOut    = ezConOut   [antPluckKeepMask, :]
    ant         = ant     [:, antPluckKeepMask]
    ref         = ref     [:, antPluckKeepMask]
    antLen   = ant.shape[1]
    antLenM1 = antLen - 1
    print(f'                         antLen = {antLen:,}')
    xTickLabelsHeatAntL = []        # probably just changed antLen, force new xTickLabelsHeatAntL
    xTickLocsAnt        = []        # probably just changed antLen, force new xTickLocsAnt



def ezConAntXTVTMaxPluckDo():

    global ezConOut                 # float and int 2d array
    global antXTV                   # float 2d array
    global antXTVT                  # float 2d array
    global antLen                   # integer
    global antLenM1                 # integer
    global xTickLocsAnt             # float array

    global ezConAntXTVTMaxPluckQtyL         # integer list
    global ezConAntXTVTMaxPluckValL         # float list

    if not ezConAntXTVTMaxPluckQtyL and not ezConAntXTVTMaxPluckValL:    # if both empty, no plucking needed
        return(1)

    #print(f'   before ezConAntXTVTMaxPluckQtyL, antLen = ', {antLen:,}')

    print()
    print('   ezConAntXTVTMaxPluckDo ===============')

    print('   np.shape(antXTVT)[0] =', np.shape(antXTVT)[0])
    print('   np.shape(antXTVT)[1] =', np.shape(antXTVT)[1])

    antXTVTMax = np.max(antXTVT, axis=0)
    #print('   antXTVTMax =', antXTVTMax)
    print(f'   len(antXTVTMax) = {len(antXTVTMax):,}')
    print()

    # assume want to keep all antXTVTMax samples
    antXTVTMaxPluckQtyKeepMask = np.ones(antLen, dtype=bool)

    if ezConAntXTVTMaxPluckQtyL:
        # get indexes of increasing antXTVTMax
        antXTVTMaxIdxByIncreasing = antXTVTMax.argsort()
        #print('   antXTVTMaxIdxByIncreasing =', antXTVTMaxIdxByIncreasing)
        print(f'   len(antXTVTMaxIdxByIncreasing) = {len(antXTVTMaxIdxByIncreasing):,}')
        print()

        print('   ezConAntXTVTMaxPluckQtyL =', ezConAntXTVTMaxPluckQtyL)
        print()

        # mask off requested lowest-valued antXTVTMax samples
        for i in range(ezConAntXTVTMaxPluckQtyL[0]):     # i starts with 0
            antXTVTMaxPluckQtyKeepMask[antXTVTMaxIdxByIncreasing[i]] = False
        # mask off requested highest-valued antXTVTMax samples
        for i in range(ezConAntXTVTMaxPluckQtyL[1]):     # i starts with 0
            antXTVTMaxPluckQtyKeepMask[antXTVTMaxIdxByIncreasing[-1-i]] = False

    if ezConAntXTVTMaxPluckValL:
        print('   ezConAntXTVTMaxPluckValL =', ezConAntXTVTMaxPluckValL)
        print()

        # mask off antXTVTMax samples with values equal or less than requested low
        antXTVTMaxPluckQtyKeepMask[antXTVTMax <= ezConAntXTVTMaxPluckValL[0]] = False
        # mask off antXTVTMax samples with values equal or greater than requested high
        antXTVTMaxPluckQtyKeepMask[ezConAntXTVTMaxPluckValL[1] <= antXTVTMax] = False

    #print('   antXTVTMaxPluckQtyKeepMask =', antXTVTMaxPluckQtyKeepMask)
    print(f'   antXTVTMaxPluckQtyKeepMask.sum() =', antXTVTMaxPluckQtyKeepMask.sum())
    print(f'   len(antXTVTMaxPluckQtyKeepMask) = {len(antXTVTMaxPluckQtyKeepMask):,}')

    # thin most data arrays to keep only antXTVTMaxPluckQtyKeepMask samples
    dataFileIdx = dataFileIdx[antXTVTMaxPluckQtyKeepMask]
    ezConOut    = ezConOut   [antXTVTMaxPluckQtyKeepMask, :]
    antXTV      = antXTV  [:, antXTVTMaxPluckQtyKeepMask]    # keep antXTV for Galaxy crossing plots
    antXTVT     = antXTVT [:, antXTVTMaxPluckQtyKeepMask]
    antLen   = antXTVT.shape[1]
    antLenM1 = antLen - 1
    print(f'   antLen = {antLen:,}')
    xTickLocsAnt = []               # probably just changed antLen, force new xTickLocsAnt



def ezConAntXTVTAvgPluckDo():

    global ezConOut                 # float and int 2d array
    global antXTV                   # float 2d array
    global antXTVT                  # float 2d array
    global antLen                   # integer
    global antLenM1                 # integer
    global xTickLocsAnt             # float array

    global ezConAntXTVTAvgPluckQtyL         # integer list
    global ezConAntXTVTAvgPluckValL         # float list

    if not ezConAntXTVTAvgPluckQtyL and not ezConAntXTVTAvgPluckValL:    # if both empty, no plucking needed
        return(1)

    #print(f'   before ezConAntXTVTAvgPluckQtyL, antLen = ', {antLen:,}')

    print()
    print('   ezConAntXTVTAvgPluckDo ===============')

    print('   np.shape(antXTVT)[0] =', np.shape(antXTVT)[0])
    print('   np.shape(antXTVT)[1] =', np.shape(antXTVT)[1])

    antXTVTAvg = np.mean(antXTVT, axis=0)
    #print('   antXTVTAvg =', antXTVTAvg)
    print(f'   len(antXTVTAvg) = {len(antXTVTAvg):,}')
    print()

    # assume want to keep all antXTVTAvg samples
    antXTVTAvgPluckQtyKeepMask = np.ones(antLen, dtype=bool)

    if ezConAntXTVTAvgPluckQtyL:
        # get indexes of increasing antXTVTAvg
        antXTVTAvgIdxByIncreasing = antXTVTAvg.argsort()
        #print('   antXTVTAvgIdxByIncreasing =', antXTVTAvgIdxByIncreasing)
        print(f'   len(antXTVTAvgIdxByIncreasing) = {len(antXTVTAvgIdxByIncreasing):,}')
        print()

        print('   ezConAntXTVTAvgPluckQtyL =', ezConAntXTVTAvgPluckQtyL)
        print()

        # mask off requested lowest-valued antXTVTAvg samples
        for i in range(ezConAntXTVTAvgPluckQtyL[0]):     # i starts with 0
            antXTVTAvgPluckQtyKeepMask[antXTVTAvgIdxByIncreasing[i]] = False
        # mask off requested highest-valued antXTVTAvg samples
        for i in range(ezConAntXTVTAvgPluckQtyL[1]):     # i starts with 0
            antXTVTAvgPluckQtyKeepMask[antXTVTAvgIdxByIncreasing[-1-i]] = False

    if ezConAntXTVTAvgPluckValL:
        print('   ezConAntXTVTAvgPluckValL =', ezConAntXTVTAvgPluckValL)
        print()

        # mask off antXTVTAvg samples with values equal or less than requested low
        antXTVTAvgPluckQtyKeepMask[antXTVTAvg <= ezConAntXTVTAvgPluckValL[0]] = False
        # mask off antXTVTAvg samples with values equal or greater than requested high
        antXTVTAvgPluckQtyKeepMask[ezConAntXTVTAvgPluckValL[1] <= antXTVTAvg] = False

    #print('   antXTVTAvgPluckQtyKeepMask =', antXTVTAvgPluckQtyKeepMask)
    print(f'   antXTVTAvgPluckQtyKeepMask.sum() =', antXTVTAvgPluckQtyKeepMask.sum())
    print(f'   len(antXTVTAvgPluckQtyKeepMask) = {len(antXTVTAvgPluckQtyKeepMask):,}')

    # thin most data arrays to keep only antXTVTAvgPluckQtyKeepMask samples
    dataFileIdx = dataFileIdx[antXTVTAvgPluckQtyKeepMask]
    ezConOut    = ezConOut   [antXTVTAvgPluckQtyKeepMask, :]
    antXTV      = antXTV  [:, antXTVTAvgPluckQtyKeepMask]    # keep antXTV for Galaxy crossing plots
    antXTVT     = antXTVT [:, antXTVTAvgPluckQtyKeepMask]
    antLen   = antXTVT.shape[1]
    antLenM1 = antLen - 1
    print(f'   antLen = {antLen:,}')
    xTickLocsAnt = []               # probably just changed antLen, force new xTickLocsAnt



def ezConAntXTVTPluckDo():

    global ezConOut                 # float and int 2d array
    global antXTV                   # float 2d array
    global antXTVT                  # float 2d array
    global antLen                   # integer
    global antLenM1                 # integer
    global xTickLocsAnt             # float array

    global ezConAntXTVTPluckL       # integer list

    #print(f'   before ezConAntXTVTPluckDo, antLen = ', {antLen:,}')

    print()
    print('   ezConAntXTVTPluckDo ===============')

    #print('   antXTVT =', antXTVT)
    print('                         np.shape(antXTVT)[0] =', np.shape(antXTVT)[0])
    print('                         np.shape(antXTVT)[1] =', np.shape(antXTVT)[1])
    print()

    # assume want to keep all AntXTVT samples
    antXTVTPluckKeepMask = np.ones(antLen, dtype=bool)

    print('   ezConAntXTVTPluckL =', ezConAntXTVTPluckL)
    print()

    # This ezConAntXTVTPluckLDo() starts with the current indices of AntXT.
    # This loop processes the requests in given order.
    # Each pluck changes the index of the higher indexes (all higher samples move left).
    # Like a chain anchored at the left, and removing one link, the total chain is shortened and the right side of the chain moves left by one link.
    # This why it is easier to request ezConAntXTVTPluckL values in decreasing order !
    for i in range(len(ezConAntXTVTPluckL)):
        ezConAntXTVTPluckThis = ezConAntXTVTPluckL[i]
        if antLen <= ezConAntXTVTPluckThis:
            print()
            print()
            print()
            print(f' ========== FATAL ERROR: ezConAntXTVTPluckL[{i}] is too large a number.')
            print(f'                         ezConAntXTVTPluckL =', ezConAntXTVTPluckL)
            print(f'                         current length of Ant <= ezConAntXTVTPluckL[{i}]')
            print(f'                         {antLen} <= {ezConAntXTVTPluckThis}')
            print()
            print()
            print()
            print('\a')     # ring bell
            exit()
        else:
            antXTVTPluckKeepMask[ezConAntXTVTPluckThis] = False

    #print('                         antXTVTPluckKeepMask =', antXTVTPluckKeepMask)
    print(f'                         len(antXTVTPluckKeepMask) = {len(antXTVTPluckKeepMask):,}')
    print(f'                         antXTVTPluckKeepMask.sum() =', antXTVTPluckKeepMask.sum())

    # thin most data arrays to keep only antXTVTPluckKeepMask samples
    dataFileIdx = dataFileIdx[antXTVTPluckKeepMask]
    ezConOut    = ezConOut   [antXTVTPluckKeepMask, :]
    antXTV      = antXTV  [:, antXTVTPluckKeepMask]    # keep antXTV for Galaxy crossing plots
    antXTVT     = antXTVT [:, antXTVTPluckKeepMask]
    antLen   = antXTVT.shape[1]
    antLenM1 = antLen - 1
    print(f'   antLen = {antLen:,}')
    xTickLocsAnt = []               # probably just changed antLen, force new xTickLocsAnt



def ezConAntXTVTClipDo():

    global antXTVT                  # float 2d array
    global ezConAntXTVTClipL        # float list

    print('\n   ezConAntXTVTClipDo ===============')

    #print('   antXTVT =', antXTVT)
    print('\n                         np.shape(antXTVT)[0] =', np.shape(antXTVT)[0])
    print('                         np.shape(antXTVT)[1] =', np.shape(antXTVT)[1])

    print('\n                         antXTVTMin =', antXTVT.min())
    print('                         antXTVTMax =', antXTVT.max())

    print('\n                         ezConAntXTVTClipL =', ezConAntXTVTClipL)
    antXTVT = np.clip(antXTVT, ezConAntXTVTClipL[0], ezConAntXTVTClipL[1])

    print('\n                         antXTVTMin =', antXTVT.min())
    print('                         antXTVTMax =', antXTVT.max())



def ezConAntXTVTSmoothDo():
    # smooth antXTVT heatmap image

    global antXTVT                  # float 2d array

    print()
    print('   ezConAntXTVTSmoothDo ===============')

    #print('   antXTVT =', antXTVT)
    print('                         np.shape(antXTVT)[0] =', np.shape(antXTVT)[0])
    print('                         np.shape(antXTVT)[1] =', np.shape(antXTVT)[1])
    print()

    # Ubuntu22 cv2 install:
    #   sudo apt-get install python3-opencv
    # Windows10 cv2 install (may work but not tried):
    #   https://docs.opencv.org/4.x/d5/de5/tutorial_py_setup_in_windows.html
    #       https://github.com/opencv/opencv/releases
    #           opencv-4.11.0-windows.exe
    # Windows10 cv2 install (provided too much):
    #   https://docs.opencv.org/4.x/d3/d52/tutorial_windows_install.html
    #       https://sourceforge.net/projects/opencvlibrary/files/
    #       https://sourceforge.net/projects/opencvlibrary/files/4.11.0/
    #       https://sourceforge.net/projects/opencvlibrary/files/latest/download
    #           ran that opencv-4.11.0-windows.exe
    # Windows10 cv2 install (worked on Win10):
    #   https://github.com/opencv/opencv-python?tab=readme-ov-file#supported-python-versions
    #       py -m pip install opencv-python
    #
    # https://opencv24-python-tutorials.readthedocs.io/en/latest/py_tutorials/py_imgproc/py_filtering/py_filtering.html

    #img = cv2.imread('opencv_logo.png')

    if ezConAntXTVTSmooth == 1:
        import cv2
        #from cv2 import blur
        antXTVT = cv2.blur(antXTVT, (5,5))

    elif ezConAntXTVTSmooth == 2:
        import cv2
        antXTVT = cv2.GaussianBlur(antXTVT, (5,5),0)

    elif ezConAntXTVTSmooth == 11:
        import cv2
        antXTVT = cv2.blur(antXTVT, (5,5))
        antXTVT = cv2.blur(antXTVT, (5,5))

    elif ezConAntXTVTSmooth == 22:
        import cv2
        antXTVT = cv2.GaussianBlur(antXTVT, (5,5),0)
        antXTVT = cv2.GaussianBlur(antXTVT, (5,5),0)

    elif ezConAntXTVTSmooth == 111:
        import cv2
        antXTVT = cv2.blur(antXTVT, (5,5))
        antXTVT = cv2.blur(antXTVT, (5,5))
        antXTVT = cv2.blur(antXTVT, (5,5))

    elif ezConAntXTVTSmooth == 222:
        import cv2
        antXTVT = cv2.GaussianBlur(antXTVT, (5,5),0)
        antXTVT = cv2.GaussianBlur(antXTVT, (5,5),0)
        antXTVT = cv2.GaussianBlur(antXTVT, (5,5),0)

    #antXTVT = cv2.medianBlur(antXTVT,5)             # Median Filtering 1 === "Unsupported format"

    #antXTVT = cv2.bilateralFilter(antXTVT,9,75,75)  # Bilateral Filtering 1 === "only 8u and 32f images"



def ezConAntXTVTFreqBinsClipDo():
    # reduce AntXTVT to only ezConAntXTVTFreqBinsClipL span FreqBin

    global ezConAntXTVTFreqBinsClipL    # float list
    global ezConAntXTVTFreqBinsClipUpdate   # integer
    global antXTVT                  # float 2d array

    global fileFreqBinQty           # integer
    global freqBinQty               # integer
    #global fileFreqMin              # float
    #global fileFreqMax              # float
    global freqCenter               # float
    global freqStep                 # float
    
    global freqAntMin               # float
    global freqAntMax               # float
    global dopplerSpanRawD2         # float
    global dopplerSpanD2            # float
    #global byFreqBinX               # float array

    print('\n   ezConAntXTVTFreqBinsClipDo ===============')

    #print('   antXTVT =', antXTVT)
    print('\n                         np.shape(antXTVT)[0] =', np.shape(antXTVT)[0])
    print('                         np.shape(antXTVT)[1] =', np.shape(antXTVT)[1])

    print('\n                         antXTVTMax =', antXTVT.max())
    print('                         antXTVTMin =', antXTVT.min())

    print('\n                         freqBinQty =', freqBinQty)

    print('\n                               ezConAntXTVTFreqBinsClipL =', ezConAntXTVTFreqBinsClipL)

    if ezConAntXTVTFreqBinsClipL[0] < 0:
        print(f' ========== FATAL ERROR: ezConAntXTVTFreqBinsClipL[0] < 0')
        print()
        print()
        print()
        print('\a')     # ring bell
        exit()
        #freqAntMinNew = freqAntMin - ezConAntXTVTFreqBinsClipL[0] * freqStep

    if freqBinQty <= ezConAntXTVTFreqBinsClipL[1]:
        print(f' ========== FATAL ERROR: freqBinQty < ezConAntXTVTFreqBinsClipL[1]')
        print()
        print()
        print()
        print('\a')     # ring bell
        exit()
    else:
        antXTVT = antXTVT[ezConAntXTVTFreqBinsClipL[0]:ezConAntXTVTFreqBinsClipL[1], :]
        #freqBinQtyNew = ezConAntXTVTFreqBinsClipL[1] - ezConAntXTVTFreqBinsClipL[0] + 1
        #fileFreqSpan = freqAntMax - freqAntMin
        #freqAntMinNew = ezConAntXTVTFreqBinsClipL[0] * freqSpan / freqBinQty + freqAntMin
        #freqAntMaxNew = ezConAntXTVTFreqBinsClipL[1] * freqSpan / freqBinQty + freqAntMin
        freqAntMinNew = ezConAntXTVTFreqBinsClipL[0] * freqStep + freqAntMin
        freqAntMax = ezConAntXTVTFreqBinsClipL[1] * freqStep + freqAntMin

    print('\n                         np.shape(antXTVT)[0] =', np.shape(antXTVT)[0])
    print('                         np.shape(antXTVT)[1] =', np.shape(antXTVT)[1])

    print('\n                         antXTVTMax =', antXTVT.max())
    print('                         antXTVTMin =', antXTVT.min())

    print('\n                         freqBinQty =', freqBinQty)

    freqAntMin = freqAntMinNew
    freqCenter = (freqAntMin + freqAntMax) / 2.
    dopplerSpanD2 = (freqAntMax - freqAntMin) / 2.
    freqBinQty = ezConAntXTVTFreqBinsClipL[1] - ezConAntXTVTFreqBinsClipL[0]
    print('\n                         freqAntMax    =', freqAntMax)
    print('                         freqCenter    =', freqCenter)
    print('                         freqAntMin    =', freqAntMin)
    print('                         dopplerSpanD2 =', dopplerSpanD2)
    print('                         freqBinQty    =', freqBinQty)

    # freqCenter, dopplerSpanD2, and freqBinQty may have changed
    ezConAntXTVTFreqBinsClipUpdate = 1
    rawPlotPrep()



def ezConAntXTVTIntegrateDo():
    # integrate AntXTVT into one day's drift-scan, 1 for RA, 4 for GLon

    global ezConAntXTVTIntegrate                # integer
    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global antXNameL                            # list of strings
    global antXTVT                              # float 2d array
    global antLen                               # integer
    global antLenM1                             # integer
    global freqCenter                           # float
    global freqBinQty                           # integer

    print('\n   ezConAntXTVTIntegrateDo ===============')

    if 89 not in ezConPlotRequestedL and 99 not in ezConPlotRequestedL:
        return(1)

    antXTVTInteg = np.zeros([freqBinQty, 721], dtype = float)    # fileFreqBinQty by 721 half degrees RA
    antXTVTIntegCount = np.zeros([721], dtype = float)           # count of saved spectrums by half degrees RA

    if ezConAntXTVTIntegrate == 1:
        plotNameEnd    = 'TVTIRa'
        plotNameEndMax = 'TVTMaxIRa'
        #hDeg = int(ezConOut[:, ezConAntXTVTIntegrate] * 30. + 0.5).astype(int)    # RaH into half degrees
        hDeg = (ezConOut[:, ezConAntXTVTIntegrate] * 30. + 0.5).astype(int) # RaH into half degrees
    else:
        plotNameEnd    = 'TVTIGLon'
        plotNameEndMax = 'TVTMaxIGLon'
        hDeg = (ezConOut[:, ezConAntXTVTIntegrate] * 2. + 0.5).astype(int)  # GLonDeg into half degrees

    for n in range(antLen):
        antXTVTInteg[:,   hDeg[n]] += antXTVT[:, n]
        antXTVTIntegCount[hDeg[n]] += 1
    print(' ================== antXTVTInteg.shape =', antXTVTInteg.shape)
    print(' ================== antXTVTIntegCount.shape =', antXTVTIntegCount.shape)

    antXTVTIntegEmptyMask = (antXTVTIntegCount == 0)        # true if empty (not filled)
    print(' ================== antXTVTIntegEmptyMask.shape =', antXTVTIntegEmptyMask.shape)
    print(' ================== antXTVTIntegEmptyMask.sum() =', antXTVTIntegEmptyMask.sum())
    antXTVTIntegCount[antXTVTIntegEmptyMask] = np.nan       # now count value is nan not zero
    print(' ================== antXTVTIntegCount.shape =', antXTVTIntegCount.shape)

    antXTVTInteg /= antXTVTIntegCount                       # div by nan is nan and is not plotted

    print(' ================== antXTVTInteg.shape =', antXTVTInteg.shape)
    # replace antXTVTInteg zero values with the antXTVTInteg minimum value
    hDegMin = np.full(freqBinQty, np.nanmin(antXTVTInteg))  # np.nanmin ignores nan
    print(' ================== hDegMin =', hDegMin)
    print(' ================== hDegMin.shape =', hDegMin.shape)
    print(' ================== hDegMin.T.shape =', hDegMin.T.shape)


    for n in range(721):
        if antXTVTIntegEmptyMask[n]:
            print(' ================== n =', n)
            antXTVTInteg[:, n] = hDegMin

    #import cv2
    #antXTVT = cv2.blur(antXTVTInteg, (5,5))
    #antXTVT = cv2.blur(antXTVTInteg, (5,5))
    #antXTVT = cv2.blur(antXTVTInteg, (5,5))

    #antXTVTInteg[:, antXTVTIntegEmptyMask] = hDegMin.T      # replace empty hDeg with that minimum value
    print(' ================== antXTVTInteg =', antXTVTInteg)
    print(' ================== antXTVTInteg.shape =', antXTVTInteg.shape)

    if 89 in ezConPlotRequestedL:
        #plotName = 'ezCon089antXTVTIRa.png'
        plotName = 'ezCon089' + antXNameL[0] + plotNameEnd + '.png'
        #plotCountdown -= 1

        print()
        print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')
        plotEzCon2dSamples(plotName, antXTVTInteg, 'Ant', antLenM1, antXNameL[1]+plotNameEnd+f':  Doppler MHz from {freqCenter:.3f} MHz', 0, 0)

    if 99 in ezConPlotRequestedL:
        #plotName = 'ezCon099antXTVTMaxIRa.png'
        plotName = 'ezCon099' + antXNameL[0] + plotNameEndMax + '.png'
        #plotCountdown -= 1

        print()
        print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')
        plotEzCon2dSamples(plotName, antXTVTInteg, 'Ant', antLenM1, antXNameL[1]+plotNameEndMax+f':  Doppler MHz from {freqCenter:.3f} MHz', 1, 0)



def createEzConOutEzbA():
    # creates columns 0 through 8 in ezConOut[n, 20]
    # ezbMenu: TimeUtcMjd  RaH  DecDeg  GLatDeg  GLonDeg  VLSR  Count  AzimuthDeg  ElevationDeg  AntXTVTCmDop
    #          0           1    2       3        4        5     6      7           8             9
    #   AntAvg  AntMax    RefAvg  RefMax
    #   10      11        12      13
    #   AntBAvg  AntBMax    AntRBAvg  AntRBMax    AntXTVTAvg  AntXTVTMax
    #   14       15          16        17         18          19

    global ezRAObsLat               # float
    global ezRAObsLon               # float
    global ezRAObsAmsl              # float

    global dataTimeUtc              # 'astropy.time.core.Time' object array
    global azimuthDeg               # float array
    global elevationDeg             # float array

    global ezConAstroMath           # integer

    global rawLen                   # integer

    global ezConOut                 # float and int 2d array        creation

    global fileNameLast             # string

    print()
    print('   createEzConOutEzbA ===============')
    print('                         ezConAstroMath =', ezConAstroMath)

    # for each sample in ant, create and collect .ezb coordinate numbers

    # calculate constants

    if ezConAstroMath == 1:
        # use Python port from MIT Haystack Small Radio Telescope (SRT) from vlsr() in geom.c
        # https://www.haystack.mit.edu/haystack-public-outreach/srt-the-small-radio-telescope-for-education/
        # VLSR = receding Velocity of the Local Standard of Rest
        #   to remove Doppler effects of earth and Sun Galactic movements
        # "/* sun 20km/s towards ra=18h dec=30.0 */"
        # https://en.wikipedia.org/wiki/Solar_apex

        #decc = -(28. + 56. / 60.) * math.pi / 180.
        #print(' decc =', decc)
        #rac = (17. + 45.5 / 60.) * math.pi / 12.
        #print(' rac =', rac)
        #dp = 27.1 * math.pi / 180.
        #print(' dp =', dp)
        #rp = (12. + 51.4 / 60.) * math.pi / 12.
        #print(' rp =', rp)
        #x0 = 20. * math.cos(18. * math.pi / 12.) * math.cos(30. * math.pi / 180.)
        #print(' x0 =', x0)
        #y0 = 20.0 * math.sin(18.0 * math.pi / 12.0) * math.cos(30.0 * math.pi / 180.0)
        #print(' y0 =', y0)
        #z0 = 20.0 * math.sin(30.0 * math.pi / 180.0)        # sun 20km/s towards ra=18h dec=30.
        #print(' z0 =', z0)

        #decc = -0.5049819302436926
        #cosDecc = math.cos(decc)
        #print(' cosDecc =', cosDecc)
        #sinDecc = math.sin(decc)
        #print(' sinDecc =', sinDecc)
        cosDecc = 0.875183216565868
        sinDecc = -0.48379162605549625

        rac = 4.649120794999895

        #dp = 0.4729842272904633
        #sinDp = math.sin(dp)
        #print(' sinDp =', sinDp)
        #cosDp = math.cos(dp)
        #print(' cosDp =', cosDp)
        sinDp = 0.45554490723351554
        cosDp = 0.8902128046111265

        rp = 3.3658674624710643

        #cosRpMRac = math.cos(rp - rac)
        #print(' cosRpMRac =', cosRpMRac)
        #sinRpMRac = math.sin(rp - rac)
        #print(' sinRpMRac =', sinRpMRac)
        cosRpMRac = 0.28359695364827764
        sinRpMRac = -0.958943568663671

        # readclock() from SRT's time.c
        # says
        # t = gmtime(&now);
        # // gmtime Jan 1 is day 0
        # secs = tosecs(t->tm_year + 1900, t->tm_yday + 1, t->tm_hour, t->tm_min, t->tm_sec);

        # FITS format: “[±Y]YYYY-MM-DD[THH:MM:SS[.sss]]”.
        # dataTimeUtcVlsr1900 = Time('1900-01-01T00:00:00', format='fits', scale='utc')
        #   gives a warning: 
        #       WARNING: ErfaWarning: ERFA function "dtf2d" yielded 1 of "dubious year (Note 6)"
        #        [astropy._erfa.core]
        # OK, use year 2000 and add a year of seconds:
        # print(' (dataTimeUtcVlsr2000.mjd - dataTimeUtcVlsr1900.mjd) * 24. * 60. * 60. =',
        #    (dataTimeUtcVlsr2000.mjd - dataTimeUtcVlsr1900.mjd) * 24. * 60. * 60.)
        # gives (dataTimeUtcVlsr2000.mjd - dataTimeUtcVlsr1900.mjd) * 24. * 60. * 60. = 3155673600.0
        # check: 365.25 * 100 * 24. * 60. * 60. = 3155760000 seconds = yup, close
        # diff = 3155760000 - 3155673600.0 = 86400 = 24. * 60. * 60. = 1 day, so use 3155673600. below
        #
        #from astropy.time import Time
        dataTimeUtcVlsr2000 = Time('2000-01-01T00:00:00', format='fits', scale='utc')
        #print(' dataTimeUtcVlsr2000.mjd =', dataTimeUtcVlsr2000.mjd)

    elif ezConAstroMath == 2:
        # use astropy
        from astropy import units as u
        from astropy.coordinates import EarthLocation
        from astropy.coordinates import SkyCoord

        locBase = EarthLocation(lat = ezRAObsLat*u.deg, lon = ezRAObsLon*u.deg, height = ezRAObsAmsl*u.m)
        # for testing:  https://www.gb.nrao.edu/~fghigo/gbt/setups/radvelcalc.html
        #   which assumes location is the Green Bank Telescope at 38.432964328895835, -79.83969457195226,
        #locBase = EarthLocation(lat = 38.432964328895835*u.deg, lon = -79.83969457195226*u.deg, height = 807.43*u.m)

        # By studying the telescope's received frequency information, the telescope can measure the radial (line-of-sight) velocity of Galactic hydrogen,
        #
        #     Telescope <========== moving-relative-to ==========>  Galactic hydrogen
        #
        # The MIT Haystack Small Radio Telescope (SRT) system suggests that ezRA divide that moving-relative-to velocity measurement into 2 parts,
        # both relative to a "Local Standard of Reference (LSR)" in the middle,
        #
        #     Telescope <==== moving-relative-to ====> LSR <==== moving-relative-to ====> Galactic hydrogen
        # 
        # That MIT Haystack system says that "Local Standard of Reference (LSR)"
        # "is the average [motion] for a group of stars that are in the vicinity of our solar system",
        #     http://web.mit.edu/8.13/www/srt_software/vlsr.pdf
        #
        # ezRA should study that velocity part on the right, the radial velocity of the Galactic hydrogen relative to the LSR.
        #
        # ezRA should calculate and subtract that velocity part on the left, the radial velocity of the telescope relative to the LSR.
        # That ezRA telescope is on the moving Earth, with the Earth moving around the Sun, with the Sun moving relative to the Local Standard of Rest.
        # Considering those motions in the opposite order, ezRA could calculate
        #     1. the Sun motion relative to the LSR
        #     2. the Earth motion revolving around the Sun once a year
        #     3. the motion of the telescope location on the Earth which rotates once a day

        # What is the fastest the telescope can move toward a star ?
        # If everything aligns, the notes below say 20.0 + 29.86  + 0.463 = 50.323 km/s
        #
        # 1. The Sun is moving toward a particular star: vStarSunMax = 20 km/s:
        # Direction of motion of the Sun from
        # http://herschel.esac.esa.int/hcss-doc-15.0/load/hifi_um/html/hifi_ref_frame.html#hum_lsr_frame
        # https://en.wikipedia.org/wiki/Solar_apex
        pointingSun = SkyCoord(ra = "18:03:50.29", dec = "+30:00:16.8",frame = "icrs",unit = (u.hourangle,u.deg))
        vStarSunMax = -20.0*u.km/u.s        # toward a direction is negative velocity
        #
        # 2. The Earth is revolving around the Sun once a year: vStarEarthAroundSunMax = 29.86 km/s:
        # Earth is 150e6 km from Sun.
        # Circumference = 2 * pi * r = 2 * pi * 150e6 = 942,477,796 km.
        # Speed to travel that distance in 365.25 days
        # = 942,477,796 / 365.25 / 24 / 60 / 60 = 29.86 km/s
        #
        # 3. The Earth is rotating on its north-south axis: vStarEarthOnAxisMax = 0.463 km/s:
        # At equator, Earth radius is 6371 km.
        # Circumference = 2 * pi * r = 2 * pi * 6371 = 40,030 km.
        # Speed to travel that distance in 24 hours
        # = 40,030 / 24 / 60 / 60 = 0.463 km/s ====== which is relatively so small that ezCol will ignore.

        # https://www.cosmos.esa.int/documents/12133/1028864/HCSS+User%27s+Reference+Manual+Herschel+Data+Processing
        # "The sign of the radial velocity is negative towards the target and positive otherwise (Doppler effect sign convention)"

        # https://gitlab.camras.nl/dijkema/HPIB/blob/185d241ad9bd7507ed90c9fa91fe0a63009d3eee/vlsr.py

        # https://public.nrao.edu/ask/velocity-reference-used-in-radio-astronomy/
        # https://www.atnf.csiro.au/people/Tobias.Westmeier/tools_hihelpers.php#restframes
        # says 'alternative “kinematical definition” (referred to as LSRK) which results in a slightly
        #     higher velocity of about 20 km/s in the direction of (α,δ)=(270∘,30∘) in the B1900 system'.
        # https://science.nrao.edu/facilities/gbt/observing/GBTog.pdf
        # says "‘lsrk’ (Local Standard of Rest kinematical definition, i.e. typical LSR definition)".
        # https://encyclopedia2.thefreedictionary.com/local+standard+of+rest

    ## calculate and fill missing ezConOut[n, 20] signal columns

    samplesQtyProcessed = 0

    for n in range(rawLen):

        dataTimeUtcStrThis = dataTimeUtc[n].iso
        # '2023-02-09 00:01:20.000'
        
        if ezConAstroMath == 1:
            # use Python port from MIT Haystack Small Radio Telescope (SRT) geom.c and time.c,
            # derivation comments last in ezCon220825b.py

            # pre-calculations
            pie    = math.pi
            piD180 = pie / 180.
            piPPi  = pie + pie
            oneEightZeroDPi = 180. / pie
            secsPerYear = 31536000.0 # 365 * 24 * 60 * 60 = seconds per year

            #print()
            #print()
            #print(' dataTimeUtcStrThis =', dataTimeUtcStrThis)

            azimuthRadThis   = azimuthDeg[n]   * piD180         # to radians
            elevationRadThis = elevationDeg[n] * piD180         # to radians
            cosElRad = math.cos(elevationRadThis)
            north = math.cos(azimuthRadThis) * cosElRad
            west = -math.sin(azimuthRadThis) * cosElRad
            zen = math.sin(elevationRadThis)

            d1lat = ezRAObsLat * piD180                         # to radians
            d1lon = ezRAObsLon * piD180                         # to radians
            #print(' ezRAObsLon =', ezRAObsLon, 'degrees')
            #print(' d1lon =', d1lon, 'radians')

            cosD1lat = math.cos(d1lat)
            sinD1lat = math.sin(d1lat)
            pole = north * cosD1lat + zen * sinD1lat
            rad = zen * cosD1lat - north * sinD1lat
            #print(' rad =', rad, 'radians')                        # right ascension (radians)

            dec = math.atan2(pole, math.sqrt(rad * rad + west * west))
            #print(' dec =', dec, 'radians')                        # declination (radians)
            
            ha = math.atan2(west, rad)
            #print(' ha =', ha, 'radians')                          # hour angle (radians)
            #print(' ha * 24./piPPi =', ha*24./piPPi, 'hours')
            #https://clearskytonight.com/projects/astronomycalculator/coordinate/rightascension_hourangle.html
            
            # try gst() with Haystack code
            if 0:
                # srt's readclock() (which calls tosecs()) to define secs as "Seconds since New Year 1970", 
                #   = seconds since start of 1970
                #
                # https://linux.die.net/man/3/modf
                #   The modf() function returns the fractional part of x
                #
                # gst() from SRT's time.c
                # double gst(double ttime)
                # {
                #     double secs, pdum;
                #     int i;
                # //    secs = (1999 - 1970) * 31536000.0 + 17.0 * 3600.0 + 16.0 * 60.0 + 20.1948;
                # //    secs = (2011 - 1970) * 31536000.0 + 17.0 * 3600.0 + 15.0 * 60.0 + 58.0778;
                #     secs = (2020 - 1970) * 31536000.0 + 17.0 * 3600.0 + 16.0 * 60.0 + 40.5;
                #     for (i = 1970; i < 2020; i++) {
                #         if ((i % 4 == 0 && i % 100 != 0) || i % 400 == 0)
                #             secs += 86400.0;
                #     }
                #
                #     return (modf((ttime - secs) / 86164.09053, &pdum) * TWOPI);
                # /* 17 16 20.1948 UT at 0hr newyear1999 */
                # /* 17 15 58.0778 UT at 0hr newyear2011 */
                # /* 17 16 40.5    UT at 0hr newyear2020 */
                # } 
                #
                # tosecs() from SRT's time.c
                # /* Convert to Seconds since New Year 1970 */
                # double tosecs(int yr, int day, int hr, int min, int sec)
                # {
                #     int i;
                #     double secs;
                #     secs = (yr - 1970) * 31536000.0 + (day - 1) * 86400.0 + hr * 3600.0 + min * 60.0 + sec;
                #     for (i = 1970; i < yr; i++) {
                #         if ((i % 4 == 0 && i % 100 != 0) || i % 400 == 0)
                #             secs += 86400.0;
                #     }
                #     if (secs < 0.0)
                #         secs = 0.0;
                #     return secs;
                # }
                #
                # readclock() from SRT's time.c
                # double readclock(void)
                # {
                #     time_t now;
                #     double secs;
                #     struct tm *t;
                #     now = time(NULL);
                #     t = gmtime(&now);
                # // gmtime Jan 1 is day 0
                #     secs = tosecs(t->tm_year + 1900, t->tm_yday + 1, t->tm_hour, t->tm_min, t->tm_sec);
                #     if (d1.azelsim) {
                #         if (d1.start_time == 0.0)
                #             d1.start_time = secs;
                #         if (d1.start_sec)
                #             secs = d1.start_sec + (secs - d1.start_time) * d1.speed_up;
                #         else {
                #             if (d1.speed_up > 0)
                #                 secs = d1.start_time + (secs - d1.start_time) * d1.speed_up;
                #             else
                #                 secs += -d1.speed_up * 3600.0; // advance by hours
                #         }
                #     }
                #     sprintf(d1.timsource, "PC ");
                #     return (secs);
                # }

                # python version of the gst() above
                #   valid only during 2020 through 2024
                # assuming data not earlier than 2020, start with
                #   latest seed of "17 16 40.5 UT at 0hr newyear2020"
                secsGst2020 = 1577899000.5
                # calculate that number
                if 0:
                    secsGst2020 = (2020. - 1970.) * 31536000.0 + 17.0 * 3600.0 + 16.0 * 60.0 + 40.5
                    print()
                    print(' secsGst2020 =', secsGst2020, 'seconds')      # says secsGst2020 = 1576862200.5
                    # add leap year days 1970 through 1999
                    for i in range(1970, 2020):
                        #if ((i % 4 == 0 and i % 100 != 0) or (i % 400 == 0)):
                        if ((not i % 4 and i % 100) or not i % 400):
                            print(' i =', i)
                            secsGst2020 += 86400.0             # seconds in a non-leap year
                    print(' secsGst2020 =', secsGst2020, 'radians')
                    print()
                    exit()

                # Calculate seconds since 1577899000.5 (start of 1970).
                ttimeSecGst = dataTimeUtc[n].mjd * 86400. - 1577899000.5  # in seconds
                #print(' ttimeSecGst =', ttimeSecGst, 'seconds')

                # Calculate GST fractional sidereal day
                # Sidereal day on Earth is approximately 86164.0905 seconds ?????????????????????????????? why sidereal ?
                ##gstSidVlsr = (ttimeSecVlsr - secsVlsr2020) / 86164.09053 % 1.
                ###print(' gstSidVlsr =', gstSidVlsr, 'seconds')
                ##gstSidVlsrRad = gstSidVlsr * piPPi      # in radians
                ##print(' gstSidVlsrRad =', gstSidVlsrRad, 'radians')
                ##print(' gstSidVlsrRad * 24./piPPi =', gstSidVlsrRad*24./piPPi, 'hours')
                gstDay = (ttimeSecVlsr - secsVlsr2020) / 86164.09053 % 1.
                #print(' gstDay =', gstDay, 'days')
                gstDayRad = gstDay * piPPi      # in radians
                print(' gstDayRad =', gstDayRad, 'radians')
                print(' gstDayRad * 24./piPPi =', gstDayRad*24./piPPi, 'hours')

            # try gst() with https://www.astro.umd.edu/~jph/GST_eqn.pdf
            
            #dataTimeUtcStrThis = '1999-12-31 00:00:00.000'  # gstHoursThis = 6.598809806000002 hours
            #                                                       vs table=6.5988098 yup
            #                                                                 gstHoursThis = 6 35 55.715301600007194
            #                                                     vs table= 2000 * 6.5988098 6 35 55.72 yup

            #dataTimeUtcStrThis = '2000-01-01 00:00:00.000'  # gstHoursThis = 6.6645196304000045 hours
            #                           vs math = 6.5988098 + 0.0657098244 = 6.6645196244 yup ???????????
            #                                                                 gstHoursThis = 6 39 52.270669440016206
            # https://dc.zah.uni-heidelberg.de/apfs/times/q/form says 2000-01-01 00:00:00	06 39 52.2717 yup

            #dataTimeUtcStrThis = '2000-12-31 00:00:00.000'  # gstHoursThis = 6.648605536400005 hours
            #                                                       vs table=6.6486056 yup

            #dataTimeUtcStrThis = '2001-12-31 00:00:00.000'  # gstHoursThis = 6.632691442400002 hours
            #                                                       vs table=6.6326915 yup

            #dataTimeUtcStrThis = '2010-12-31 00:00:00.000'  # gstHoursThis = 6.620884245200045 hours
            #                                                       vs table=6.6208844 yup

            #dataTimeUtcStrThis = '2022-12-31 00:00:00.000'  # gstHoursThis = 6.627044590400033 hours
            #                                                                 gstHoursThis = 6 37 37.36052544011727
            # https://dc.zah.uni-heidelberg.de/apfs/times/q/form says 2022-12-31 00:00:00	06 37 37.3628 yup

            #print(' dataTimeUtcStrThis =', dataTimeUtcStrThis)

            # Calculate GST fractional sidereal day
            # https://www.astro.umd.edu/~jph/GST_eqn.pdf
            # gstHours = G2001 + 0.0657098244 * yearDay + 1.00273791 * hoursThis
            # gstHours = 6.6486056 + 0.0657098244 * yearDay + 1.00273791 * hoursThis

            #dataTimeUtcStrThis = dataTimeUtc[n].iso
            #   '2023-02-09 00:01:20.000'
            #    yyyy mm dd hh mm ssssss
            #    012345678901234567890123
            yearThis = int(dataTimeUtcStrThis[0:4])
            #print(' yearThis =', yearThis)
            monthThis = int(dataTimeUtcStrThis[5:7])
            #print(' monthThis =', monthThis)
            MonthDayThis   = int(dataTimeUtcStrThis[8:10])     # round up: fully count partial days
            #print(' MonthDayThis =', MonthDayThis)

            hoursThis = float(dataTimeUtcStrThis[11:13]) + float(dataTimeUtcStrThis[14:16]) / 60. + float(dataTimeUtcStrThis[17:]) / 3600.
            #print(' hoursThis =', hoursThis, 'hours')

            # round up yearDayThis: yearDayThis fully counts partial days
            if ((not yearThis % 4 and yearThis % 100) or not yearThis % 400):       # if leap year
                yearDayThis = [-1, 0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335][monthThis] + MonthDayThis   # leap year
            else:
                yearDayThis = [-1, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334][monthThis] + MonthDayThis   # non-leap year
            #print(' yearDayThis =', yearDayThis)

            # round up daysFromStartOf1999: daysFromStartOf1900 fully counts partial days
            daysFromStartOf1999 = (yearThis - 1999) * 365 + yearDayThis
            #print(' daysFromStartOf1999 =', daysFromStartOf1999, 'days')
            # add one day for each leap year Feb-29 since start of 1999, but not yearThis
            for i in range(1999, yearThis):
                #if ((i % 4 == 0 and i % 100 != 0) or (i % 400 == 0)):
                if ((not i % 4 and i % 100) or not i % 400):        # if leap year
                    #print(' i =', i)    
                    daysFromStartOf1999 += 1            # leap year
            #print(' daysFromStartOf1999 =', daysFromStartOf1999, 'days')

            gstHoursThis = 6.6147239 + 0.0657098244 * daysFromStartOf1999 + 1.00273791 * hoursThis
            #print(' gstHoursThis =', gstHoursThis, 'hours')
            gstHoursThis = gstHoursThis % 24.
            #print(' gstHoursThis =', gstHoursThis, 'hours')
            gstMinThis = gstHoursThis %1. * 60.
            gstSecThis = gstMinThis %1. * 60.
            #print('                                 gstHoursThis =', int(gstHoursThis), int(gstMinThis), gstSecThis)
            gstDayRad = gstHoursThis * piPPi / 24.      # in radians
            #print(' gstDayRad =', gstDayRad, 'radians')

            # https://dc.zah.uni-heidelberg.de/apfs/times/q/form
            # https://astronomy.stackexchange.com/questions/21002/how-to-find-greenwich-mean-sideral-time

            #ra = gstDayRad - ha - d1lon                 # in radians
            # Haystack srt.cat file stored Longitude as positive, ezRA stores as negative
            ra = gstDayRad - ha + d1lon                 # in radians
             
            if ra < 0.:
                ra += piPPi
            elif piPPi < ra:
                ra -= piPPi
            #print(' ra =', ra, 'radians')
            raDegThis = ra * oneEightZeroDPi            # in degrees
            #print(' raDegThis =', raDegThis, 'degrees')
            raHThis = raDegThis / 15.       # 24 / 360 = 1 / 15
            #print(' raHThis =', raHThis, 'hours')

            decDegThis = dec * oneEightZeroDPi          # in degrees
            #print(' decDegThis =', decDegThis, 'degrees')

            cosRa = math.cos(ra)
            cosDec = math.cos(dec)
            sinRa = math.sin(ra)
            sinDec = math.sin(dec)
            vsun = 3.1817257161747205e-15 * cosRa * cosDec \
                + 17.320508075688775 * sinRa * cosDec - 9.999999999999998 * sinDec

            x0 = cosRa * cosDec
            y0 = sinRa * cosDec
            z0 = sinDec
            y = y0 * 0.9170600744802925 + z0 * 0.3987490687063738

            z = z0 * 0.9170600744802925 - y0 * 0.3987490687063738
            soulat = math.atan2(z, np.sqrt(x0 * x0 + y * y))
            soulong = math.atan2(y, x0)

            # timeVlsr = for this sample n, seconds since start of 1900
            timeVlsr = (dataTimeUtc[n].mjd - dataTimeUtcVlsr2000.mjd) * 86400. + 3155673600.
            sunlong = (timeVlsr * 0.00001140795 + 280.) * piD180            # long=280 day 1

            vearth = -30. * math.cos(soulat) * math.sin(sunlong - soulong)
            gwest = cosDecc * math.cos(rp - rac)

            grad = cosDecc * math.sin(rp - rac)

            ggwest = gwest * sinDp + 0.43067750027824064

            gpole = gwest * cosDp - 0.22038881141180267

            lon0 = (math.atan2(ggwest, grad)) * oneEightZeroDPi
            gwest = cosDec * math.cos(rp - ra)

            grad = cosDec * math.sin(rp - ra)

            ggwest = gwest * sinDp - sinDec * cosDp

            gpole = gwest * cosDp + sinDec * sinDp

            d1glat = (math.atan2(gpole, math.sqrt(ggwest * ggwest + grad * grad))) * oneEightZeroDPi
            gLatDegThis = d1glat            # in degrees

            d1glon = (math.atan2(ggwest, grad)) * oneEightZeroDPi - lon0

            # map d1glon into (-180 to +180) degrees
            gLonDegThis = d1glon
            if gLonDegThis < -180.:
                gLonDegThis += 360.
            elif 180. < gLonDegThis:        # in degrees (+180 to +540) to (0 to +360)
                gLonDegThis -= 360.

            if ezConUseVlsr:
                vlsrThis = vsun + vearth    # km/s
                #print()
                #print()
                #print(' vsun =', vsun, 'km/s')
                #print(' vearth =', vearth, 'km/s')
                #print(' vlsrThis =', vlsrThis, 'km/s')
            else:
                vlsrThis = 0.               # km/s

            #exit()

        elif ezConAstroMath == 2:
            # use astropy

            # Coordinate of sky target at the UTC time from the data file
            # SkyCoord() wants time = Time('1991-06-06 12:00:00')
            pointingTelescope = SkyCoord(az = azimuthDeg[n]*u.deg, alt = elevationDeg[n]*u.deg,
                obstime = dataTimeUtcStrThis, frame = 'altaz', location = locBase)
            #print()
            #print()
            #print(' dataTimeUtcStrThis =', dataTimeUtcStrThis)

            # extract RaDec coordinates
            raDegThis = float(pointingTelescope.icrs.ra.degree)
            raHThis = raDegThis / 15.       # 24 / 360 = 1 / 15
            #print(' raHThis =', raHThis, 'Hours')
            decDegThis = float(pointingTelescope.icrs.dec.degree)
            #print(' decDegThis =', decDegThis, 'degrees')

            # extract Galactic coordinates
            gLatDegThis = float(pointingTelescope.galactic.b.degree)
            gLonDegThis = float(pointingTelescope.galactic.l.degree)
            if 180. < gLonDegThis:
                gLonDegThis -= 360.

            if ezConUseVlsr:        # astropy
                # https://gitlab.camras.nl/dijkema/HPIB/blob/185d241ad9bd7507ed90c9fa91fe0a63009d3eee/vlsr.py
                # https://astropy-cjhang.readthedocs.io/en/latest/api/
                #   astropy.coordinates.SkyCoord.html#astropy.coordinates.SkyCoord.radial_velocity_correction
                # brvc = barycentric radial velocity correction = velocity of solar system barycenter toward star
                #vStarEarthAroundSun = pointingTelescope.radial_velocity_correction(kind='barycentric')    # in m/sec
                # print(pointingTelescope.radial_velocity_correction(kind='barycentric'))   # says -17469.223186040872 m / s
                vStarEarthAroundSun = -float(pointingTelescope.radial_velocity_correction(kind='barycentric') / (1000. * u.m / u.s))   # into km/s
                #print(' pointingTelescope =', pointingTelescope)
                #print(' vStarEarthAroundSun =', vStarEarthAroundSun, 'km/s')

                # Projection of solar velocity towards the pointingTelescope star
                # https://www.khanacademy.org/math/multivariable-calculus/thinking-about-multivariable-function/x786f2022:vectors-and-matrices/a/dot-products-mvc
                #vsun_proj = psrc.cartesian.dot(psun.cartesian)*vsun

                # pointingTelescope currently contains (az, alt) in deg
                # For dot product, need pointingTelescope also containing (ra, dec) in deg
                pointingTelescope = SkyCoord(ra = raDegThis*u.deg, dec = decDegThis*u.deg,
                    obstime = dataTimeUtcStrThis, frame = 'icrs', location = locBase)
                #print(' pointingTelescope =', pointingTelescope)
                #print(pointingTelescope.cartesian.dot(pointingSun.cartesian) * vStarSunMax)     # says -17.46922318604087  km/s
                vStarSun = -float(pointingTelescope.cartesian.dot(pointingSun.cartesian) * vStarSunMax / (u.km / u.s))  # in km/s
                # and vStarSun has positive max is near ra=18.0567000180526 Hours
                #print(' pointingTelescope.cartesian =', pointingTelescope.cartesian)
                #print(' pointingSun =', pointingSun)    # <SkyCoord (ICRS): (ra, dec) in deg (270.95954167, 30.00466667)>
                #print(' pointingSun.cartesian =', pointingSun.cartesian)
                #vStarSun = 0
                #print(' vStarSun =', vStarSun, 'km/s')

                # VLSR = receding Velocity of the Local Standard of Rest (km/s)
                #vlsrThis = -float((vStarSun - vStarEarthAroundSun) / (1000. * u.m / u.s))   # to extract from units as km/s
                #vlsrThis = vStarSun - vStarEarthAroundSun
                vlsrThis = vStarEarthAroundSun - vStarSun
                #print(' vlsrThis =', vlsrThis, 'km/s')

                # for that last sample of N0RQV-8230209_00.txt,
                #   dataTimeUtcStrThis = 2023-02-09 23:58:56.000
                #   raHThis = 23.405257531500908  Hours
                #   decDegThis = 8.007827205726938  degrees
                #   vStarEarthAroundSun = -17.206217294776792  km/s
                #   vStarSun = -18.037474540029592  km/s
                #   vlsrThis = -0.8312572452528002  km/s
                # HawkRAO VLSR Calculator,
                # http://f4klo.ampr.org/vlsrKLO.php
                #   Radial Velocity Calculator
                #   UTC (DD/MM/YYYY hh:mm:ss):	
                #   09/02/2023 23:58:56
                #   RA (hh.hhhhh):	
                #   23.4052575
                #   DEC (±dd.ddddd):	
                #   8.00782720
                #   Latitude (±dd.ddddd):	
                #   40.299512
                #   Longitude (±dd.ddddd):	
                #   -105.08449
                #   ---
                #   Radial Velocity (±km/s):	
                #   +12.68 ======================================================================================= +12.68
                #   Local Sidereal Time (day):	
                #   0.095736

                # for the first sample of N0RQV-8230209_00.txt,
                #    dataTimeUtcStrThis = 2023-02-09 00:01:20.000
                #    raHThis = 23.379665787029346  Hours
                #    decDegThis = 8.007942475940645  degrees
                #    vStarEarthAroundSun = -17.46922318604087  km/s
                #    vStarSun = 0  km/s
                #    vlsrThis = 17.46922318604087  km/s
                #      data/N0RQV-8230209_00.txt   Total samples processed for signals     = 1 of 908

                # for the first and last samples of N0RQV-8230209_00.txt, with -ezConAstroMath 1
                #    # from ezCon230309a.py
                #    lat 40.299512 long -105.084491 amsl 1524.0 name N0RQV-8
                #    freqMin 1419.2 freqMax 1421.61 freqBinQty 256
                #    ezbMenu: TimeUtcMjd  RaH  DecDeg  GLatDeg  GLonDeg  VLSR  Count  ...
                #    #        0           1    2       3        4        5     6      ...
                #    59984.00093 23.415 8.132 -49.006 89.145 1.352e+01 1 ... ======================================= 13.52
                #    59984.99926 23.440 8.132 -49.195 89.649 1.338e+01 1 ... ======================================= 13.38
                #       vsun = -3.9173568308658924
                #       vearth = 17.29853211404944
            else:
                vlsrThis = 0.       # km/s

        else:
            # ezConAstroMath == 0:
            # fill with suspicious harmless values, to be ignored, faster if not needed for plots ?
            raHThis     = 0.        # hours
            decDegThis  = 0.        # degrees
            gLatDegThis = 0.        # degrees
            gLonDegThis = 0.        # degrees
            vlsrThis    = 0.        # km/s


        # store in ezConOut[n, column] coordinate columns (0.0 for unfinished antXTVLdDop and antXTVUdDop)
        # ezbMenu: TimeUtcMjd  RaH  DecDeg  GLatDeg  GLonDeg  VLSR  Count  AzimuthDeg  ElevationDeg  AntXTVTCmDop
        #          0           1    2       3        4        5     6      7           8             9
        #   AntAvg  AntMax    RefAvg  RefMax
        #   10      11        12      13
        #   AntBAvg  AntBMax    AntRBAvg  AntRBMax    AntXTVTAvg  AntXTVTMax
        #   14       15          16        17         18          19
        if not samplesQtyProcessed:
            #ezConOut = np.array([
            #    dataTimeUtc[n].mjd, raHThis, decDegThis, gLatDegThis, gLonDegThis, vlsrThis,
            #    1., azimuthDeg[n], elevationDeg[n], 0.,
            #    antAvg[n], antMax[n], refAvg[n], refMax[n],
            #    antBAvg[n], antBMax[n], antRBAvg[n], antRBMax[n], 0., 0.])
            ezConOut = np.array([
                dataTimeUtc[n].mjd, raHThis, decDegThis, gLatDegThis, gLonDegThis, vlsrThis,
                1., azimuthDeg[n], elevationDeg[n], 0.,
                0., 0., 0., 0.,
                0., 0., 0., 0., 0., 0.]) 
        else:
            #ezConOut = np.concatenate([ezConOut, np.array([
            #    dataTimeUtc[n].mjd, raHThis, decDegThis, gLatDegThis, gLonDegThis, vlsrThis,
            #    1., azimuthDeg[n], elevationDeg[n], 0.,
            #    antAvg[n], antMax[n], refAvg[n], refMax[n],
            #    antBAvg[n], antBMax[n], antRBAvg[n], antRBMax[n], 0., 0.]) ])
            ezConOut = np.concatenate([ezConOut, np.array([
                dataTimeUtc[n].mjd, raHThis, decDegThis, gLatDegThis, gLonDegThis, vlsrThis,
                1., azimuthDeg[n], elevationDeg[n], 0.,
                0., 0., 0., 0.,
                0., 0., 0., 0., 0., 0.]) ])

        samplesQtyProcessed += 1

        # allow append to line
        print('\r  ', fileNameLast, '  Total samples processed for signals     =',
            f'{samplesQtyProcessed:,} of {rawLen:,}', end='')

    print()
    ezConOut = np.reshape(ezConOut, (-1, 20))



def createEzConOutEzbB():
    # writes over columns 10 through 17 in ezConOut[n, 20]
    # deletes antAvg, antMax, refAvg, refMax, antBAvg, antBMax, antRBAvg, antRBMax

    # ezbMenu: TimeUtcMjd  RaH  DecDeg  GLatDeg  GLonDeg  VLSR  Count  AzimuthDeg  ElevationDeg  AntXTVTCmDop
    #          0           1    2       3        4        5     6      7           8             9
    #   AntAvg  AntMax    RefAvg  RefMax
    #   10      11        12      13
    #   AntBAvg  AntBMax    AntRBAvg  AntRBMax    AntXTVTAvg  AntXTVTMax
    #   14       15          16        17         18          19

    global antAvg                   # float array
    global antMax                   # float array
    global refAvg                   # float array
    global refMax                   # float array
    global antBAvg                  # float array
    global antBMax                  # float array
    global antRBAvg                 # float array
    global antRBMax                 # float array

    global ezConOut                 # float and int 2d array        creation

    print()
    print('   createEzConOutEzbB ===============')
    print('                         ezConAstroMath =', ezConAstroMath)

    ezConOut[:, 10] = antAvg
    ezConOut[:, 11] = antMax

    ezConOut[:, 12] = refAvg
    ezConOut[:, 13] = refMax

    ezConOut[:, 14] = antBAvg
    ezConOut[:, 15] = antBMax
    
    ezConOut[:, 16] = antRBAvg
    ezConOut[:, 17] = antRBMax
    

    # free antAvg global memory
    antAvg = []
    antAvg = None
    del antAvg
    # free antMax global memory
    antMax = []
    antMax = None
    del antMax


    # free refAvg global memory
    refAvg = []
    refAvg = None
    del refAvg
    # free refMax global memory
    refMax = []
    refMax = None
    del refMax


    # free antBAvg global memory
    antBAvg = []
    antBAvg = None
    del antBAvg
    # free antBMax global memory
    antBMax = []
    antBMax = None
    del antBMax


    # free antRBAvg global memory
    antRBAvg = []
    antRBAvg = None
    del antRBAvg
    # free antRBMax global memory
    antRBMax = []
    antRBMax = None
    del antRBMax



def writeFileSdre():

    global programRevision          # string
    global commandString            # string
    global ezRAObsName              # string
    global fileWriteSdre            # file handle

    global ezConOut                 # float and int 2d array
    global antLen                   # integer

    print()
    print('   writeFileSdre ===============')

    # record the (complex?) ezCon command line as a comment at the top of .sdre file
    fileWriteSdre.write('\n# from ' + programRevision)
    fileWriteSdre.write('\n# ' + commandString)
    fileWriteSdre.write('\n\ndataFreqMin ' + str(fileFreqMin) + ' dataFreqMax ' + str(fileFreqMax) \
        + ' name ' + ezRAObsName)
    fileWriteSdre.write('\n' \
        + 'sdreMenu: TimeUtcMjd  RaDeg  DecDeg  GLatDeg  GLonDeg  VLSR  Count' \
        + '  AntAvg  RefAvg  AntBAvg  AntXTVTAvg' \
        + '  AntMax  RefMax  AntBMax  AntXTVTMax' \
        + '  AntXTVTCmDop  AntXTVTLdDop  AntXTVTUdDop')
    fileWriteSdre.write('\n' \
        + '#         0           1      2       3        4        5     6    ' \
        + '  7       8       9        10        ' \
        + '  11      12      13       14        ' \
        + '  15            16            17')
    fileWriteSdre.write('\n')

    # save ezConOut[] in columns
    ezConOutFmtS = \
        '%0.5f %0.3f %0.3f %0.3f %0.3f %0.3e %d ' + \
        '%0.5e %0.5e %0.5e %0.5e ' + \
        '%0.5e %0.5e %0.5e %0.5e ' + \
        '%0.3e %0.3e %0.3e'

    # ezbMenu: TimeUtcMjd  RaH  DecDeg  GLatDeg  GLonDeg  VLSR  Count  AzimuthDeg  ElevationDeg  AntXTVTCmDop
    #          0           1    2       3        4        5     6      7           8             9
    #   AntAvg  AntMax    RefAvg  RefMax
    #   10      11        12      13
    #   AntBAvg  AntBMax    AntRBAvg  AntRBMax    AntXTVTAvg  AntXTVTMax
    #   14       15          16        17         18          19

    # to

    # sdreMenu: TimeUtcMjd  RaDeg  DecDeg  GLatDeg  GLonDeg  VLSR  Count  
    #           0           1      2       3        4        5     6      
    #   AntAvg  RefAvg  AntBAvg  AntXTVTAvg  
    #   7       8       9        10          
    #   AntMax  RefMax  AntBMax  AntXTVTMax      AntXTVTCmDop  AntXTVTLdDop  AntXTVTUdDop
    #   11      12      13       14              15            16            17

    # sdre columns <- ezb columns
    # ezb  columns = 0 1 2 3 4 5 6   10 12 14 18   11 13 15 19    0  0  0
    # sdre columns = 0 1 2 3 4 5 6    7  8  9 10   11 12 13 14   15 16 17
    for n in range(antLen):
        ezConOutThisSdre = ezConOut[n, :] + 0                   # copy all 20 ezb columns of one row
        ezConOutThisSdre[ 7] = ezConOutThisSdre[10]
        ezConOutThisSdre[ 8] = ezConOutThisSdre[12]
        ezConOutThisSdre[ 9] = ezConOutThisSdre[14]
        ezConOutThisSdre[10] = ezConOutThisSdre[18]

        #ezConOutThisSdre[11] = ezConOutThisSdre[11]
        ezConOutThisSdre[12] = ezConOutThisSdre[13]
        ezConOutThisSdre[13] = ezConOutThisSdre[15]
        ezConOutThisSdre[14] = ezConOutThisSdre[19]
        
        ezConOutThisSdre[15:18] = 0.

        ezConOutThisSdre = ezConOutThisSdre[:18]                # trim off last 2 columns
        ezConOutThisSdre[1] = ezConOutThisSdre[1] * 15.         # convert: RaDeg  <-  RaH (360 / 24 = 15)

        np.savetxt(fileWriteSdre, [ezConOutThisSdre], fmt = ezConOutFmtS)

    fileWriteSdre.write('\n')
    fileWriteSdre.close()   



def writeFileEzb():

    global programRevision          # string
    global commandString            # string
    global ezRAObsName              # string
    global fileWriteEzb             # file handle

    global ezConOut                 # float and int 2d array
    global antLen                   # integer

    print()
    print('   writeFileEzb ===============')

    # record the (complex?) ezCon command line as a comment at the top of .ezb file
    fileWriteEzb.write(f'\n# from {programRevision}\n')
    fileWriteEzb.write(f'# {commandString}\n\n')
    fileWriteEzb.write(f'lat {ezRAObsLat} long {ezRAObsLon} amsl {ezRAObsAmsl} name {ezRAObsName}\n')
    fileWriteEzb.write(f'freqMin {fileFreqMin} freqMax {fileFreqMax} freqBinQty {fileFreqBinQty}\n')
    fileWriteEzb.write( \
        'ezbMenu: TimeUtcMjd  RaH  DecDeg  GLatDeg  GLonDeg  VLSR  Count  AzimuthDeg  ElevationDeg  AntXTVTCmDop' \
        + '    AntAvg  AntMax    RefAvg  RefMax' \
        + '    AntBAvg  AntBMax    AntRBAvg  AntRBMax    '+antXNameL[1]+'TVTAvg  '+antXNameL[1]+'TVTMax\n')
    #    + '    AntBAvg  AntBMax    AntRBAvg  AntRBMax    AntXTVTAvg  AntXTVTMax\n')
    fileWriteEzb.write( \
        '#        0           1    2       3        4        5     6      7           8             9           ' \
        + '    10      11        12      13    ' \
        + '    14       15         16        17          18           19\n')

    # save ezConOut[] in columns
    # experimentEzc for AzEl into .ezb Spare1 and Spare2
    #    '%0.5f %0.3f %0.3f %0.3f %0.3f %0.3e %d %d %d %d ' + \
    ezConOutFmtS = \
        '%0.5f %0.3f %0.3f %0.3f %0.3f %0.3e %d %0.1f %0.1f %0.5e ' + \
        '%0.5e %0.5e %0.5e %0.5e ' + \
        '%0.5e %0.5e %0.5e %0.5e %0.5e %0.5e'
    for n in range(antLen):
        np.savetxt(fileWriteEzb, [ezConOut[n, :]], fmt = ezConOutFmtS)
    fileWriteEzb.write('\n')
    fileWriteEzb.close()   



def writeFileStudy():

    global fileWriteStudy           # file handle
    global antXNameL                # list of strings

    fileWriteStudy.write( \
        '\n\n\n============================================================================ ant\n\n\n')
    fileWriteStudy.write(studyTime(10, 'AntAvg'))
    fileWriteStudy.write(studyTime(11, 'AntMax'))

    fileWriteStudy.write( \
        '\n\n\n============================================================================ ref\n\n\n')
    fileWriteStudy.write(studyTime(12, 'RefAvg'))
    fileWriteStudy.write(studyTime(13, 'RefMax'))
    
    fileWriteStudy.write( \
        '\n\n\n============================================================================ antB\n\n\n')
    fileWriteStudy.write(studyTime(14, 'AntBAvg'))
    fileWriteStudy.write(studyTime(15, 'AntBMax'))
    
    fileWriteStudy.write( \
        '\n\n\n============================================================================ antRB\n\n\n')
    fileWriteStudy.write(studyTime(16, 'AntRBAvg'))
    fileWriteStudy.write(studyTime(17, 'AntRBMax'))

    fileWriteStudy.write( \
        '\n\n\n============================================================================ antXTVT\n\n\n')
    fileWriteStudy.write(studyTime(18, antXNameL[1] + 'TVTAvg'))
    fileWriteStudy.write(studyTime(19, antXNameL[1] + 'TVTMax'))
    fileWriteStudy.write( \
        '\n\n\n============================================================================\n')



def writeFileGalRaDecNear():
    # write velocity data array to Gal.npz file
    # Just like writeFileGal(), but different qualifier question for the samples,
    # and only gLonP180 = 0 is written. <<<<<< ??????????

    global antXNameL                    # list of strings
    global antXTVT                      # float 2d array
    global antLen                       # integer
    #global velGLonP180                  # float 2d array     creation
    #global velGLonP180Count             # integer array      creation
    #global velGLonP180CountSum          # integer            creation
    #global galDecP90GLonP180Count       # integer array      creation

    global freqMin                      # float
    global freqMax                      # float
    global freqBinQty                   # integer
    #global ezConGalCrossingGLatCenterL  # float list
    #global ezConGalCrossingGLatNear     # float
    global ezConGalRaDecNearNearL       # float list
    global fileNameLast                 # string

    # if ezConGalRaDecNearNearL not filled, then return
    if not ezConGalRaDecNearNearL:
        return(1)

    print()
    print('   writeFileGalRaDecNear ===============')

    # Velocity by Galactic Longitude (gLon) grid.
    # gLon is -180thru+180, adding 180, gives gLonP180 as 0thru360 which is more convenient.
    velGLonP180 = np.zeros([fileFreqBinQty, 361], dtype = float)    # fileFreqBinQty by 0thru360 gLonP180
    velGLonP180Count = np.zeros([361], dtype = int)                 # count of saved spectrums in velGLonP180
    # Declination (dec) is -90thru+90, adding 90, gives decP90 as 0thru180 which is more convenient.
    # galDecP90GLonP180Count is floats to allow mask replacement with np.nan later.
    galDecP90GLonP180Count = np.zeros([181, 361], dtype = int)      # 0thru180 decP90 by 0thru360 gLonP180

    # define RaDec span
    spanRaHMin    = ezConGalRaDecNearNearL[0] - ezConGalRaDecNearNearL[2]
    spanRaHMax    = ezConGalRaDecNearNearL[0] + ezConGalRaDecNearNearL[2]
    spanDecDegMin = ezConGalRaDecNearNearL[1] - ezConGalRaDecNearNearL[3]
    spanDecDegMax = ezConGalRaDecNearNearL[1] + ezConGalRaDecNearNearL[3]

    for n in range(antLen):
        raHThis    = ezConOut[n, 1]         # RaH is 0. thru 24.
        decDegThis = ezConOut[n, 2]         # DecDeg is -90. thru +90.

        # if n is within RaDec span, use spectrum
        if spanRaHMin <= raHThis and raHThis <= spanRaHMax \
            and spanDecDegMin <= decDegThis and decDegThis <= spanDecDegMax:
                #gLonP180 = int(ezConOut[n, 4]) + 180            # gLonP180 is RtoL from 0 thru 360
                #gLonP180 = 0        # wasteful, but RGal.npz file size is only 6.0K

                # sum the current antXTVT spectrum to the grid column, and increment the column count
                # but reverse the freqBin elements,
                #   because highest freqBin = highest freq = approaching fastest = most negative "velocity"
                #velGLonP180[:, gLonP180] += antXTV[:, n][::-1]
                ##velGLonP180[:, gLonP180] += antXTVT[:, n][::-1]
                ##velGLonP180Count[gLonP180] += 1
                velGLonP180[:, 0] += antXTVT[:, n][::-1]
                velGLonP180Count[0] += 1

                # For each declination, several gLat may be 'close enough' to count as a crossing.
                # Increment at each crossing's dec and gLon.
                #galDecP90GLonP180Count[int(ezConOut[n, 2] + 90), gLonP180] += 1     # declination + 90
                #galDecP90GLonP180Count[0, gLonP180] += 1

    #print('velGLonP180 = ')
    #print(velGLonP180)
    #print(velGLonP180.shape)
    #print()

    #print('velGLonP180Count = ')
    #print(velGLonP180Count)
    #print(velGLonP180Count.shape)
    #print()

    print()
    #print(f' ezConGalCrossingGLatCenter = {ezConGalCrossingGLatCenter:04.1f}')
    #print(' ezConGalCrossingGLatCenter =', ezConGalCrossingGLatCenter)
    velGLonP180CountSum = velGLonP180Count.sum()
    print(' velGLonP180CountSum =', velGLonP180CountSum)

    if velGLonP180CountSum:       # if anything in velGLonP180 to save or plot

        if ezConGalNormalize:
            # assuming this whole .txt data file has a similar system gain,
            #   normalize the whole .npz file data before writing it to file
                
            # divide the gLonP180 sum by the gLonP180 count for each nonempty gLonP180
            velGLonP180Avg = np.zeros_like(velGLonP180)
            for gLonP180 in range(180, 361):                 # for every column, RtoL, 180 thru 360
                if 1 < velGLonP180Count[gLonP180]:      # if gLon not empty and needs division
                    velGLonP180Avg[:,gLonP180] = velGLonP180[:,gLonP180] / velGLonP180Count[gLonP180]

            if ezConGalNormalize == 1:         # normalize whole velGLonP180 to the velGLonP180Avg Average
                velGLonP180 /= np.mean(velGLonP180Avg)
            if ezConGalNormalize == 2:         # normalize whole velGLonP180 to the velGLonP180Avg Maximum
                velGLonP180 /= np.max(velGLonP180Avg)
                print(' ================================= np.max(velGLonP180Avg) = ', np.max(velGLonP180Avg))

        # for fileNameLast of  data/2021_333_00.rad.txt  create fileGalWriteName as  data/2021_333_00.radGal.npz
        #fileGalWriteName = fileNameLast.split(os.path.sep)[-1].split('.')[-2] + 'Gal.npz'
        #fileGalWriteName = fileNameLast.split(os.path.sep)[-1][:-4] + 'Gal.npz'
        #if ezConGalCrossingGLatCenter < 0:
        #    # output filenames *Nxx.xGal.npz (N for Negative)
        #    fileGalWriteName = fileNameLast.split(os.path.sep)[-1][:-4] \
        #        + f'N{-ezConGalCrossingGLatCenter:04.1f}Gal.npz'
        #    # output filenames *Gal.npz (N for Negative)
        #    #fileGalWriteName = fileNameLast.split(os.path.sep)[-1][:-4] \
        #    #    + f'N{-ezConGalCrossingGLatCenter:02d}Gal.npz'
        #else:
        #    # output filenames *Pxx.xGal.npz (P for Negative)
        #    fileGalWriteName = fileNameLast.split(os.path.sep)[-1][:-4] \
        #        + f'P{ezConGalCrossingGLatCenter:04.1f}Gal.npz'
        #    # output filenames *PxxGal.npz (P for Positive)
        #    #fileGalWriteName = fileNameLast.split(os.path.sep)[-1][:-4] \
        #    #    + f'P{ezConGalCrossingGLatCenter:02d}Gal.npz'

        # output filename, 2025_061_00.rad_0.8_41.3_0.1_0.1RGal.npz
        fileGalWriteName = fileNameLast.split(os.path.sep)[-1][:-4] \
            + f'_{ezConGalRaDecNearNearL[0]:02.1f}_{ezConGalRaDecNearNearL[1]:02.1f}' \
            + f'_{ezConGalRaDecNearNearL[2]:02.1f}_{ezConGalRaDecNearNearL[3]:02.1f}RGal.npz'

        #print('   ezRAObsName = ', ezRAObsName)
        ezConGalCrossingGLatCenter = 999.   # silly flag for ezConGalRaDecNear
        ezConGalCrossingGLatNear   = 0.
        np.savez_compressed(fileGalWriteName,
            fileObsName=np.array(ezRAObsName),
            fileFreqMin=np.array(freqAntMin), 
            fileFreqMax=np.array(freqAntMax),
            fileFreqBinQty=np.array(freqBinQty),
            velGLonP180=velGLonP180,
            velGLonP180Count=velGLonP180Count,
            galDecP90GLonP180Count=galDecP90GLonP180Count,
            antXTVTName=antXNameL[1]+'TVT',
            ezConGalCrossingGLatCenter=ezConGalCrossingGLatCenter,
            ezConGalCrossingGLatNear=ezConGalCrossingGLatNear)
        # antXTVTName was added to file definition later, on 230401
        # ezConGalCrossingGLatCenter was added to file definition later, on 230623
        # ezConGalCrossingGLatNear was added to file definition later, on 230625

        #npzfile = np.load(directory + os.path.sep + fileReadName)
        #ezRAObsName = npzfile['ezRAObsName'] 
        #fileFreqMin    = npzfile['fileFreqMin'] 
        #fileFreqMax    = npzfile['fileFreqMax']
        #fileFreqBinQty = npzfile['fileFreqBinQty'] 
        #velGLonP180      = npzfile['velGLonP180']
        #velGLonP180Count = npzfile['velGLonP180Count']
        #galDecP90GLonP180Count = npzfile['galDecP90GLonP180Count']



def writeFileGal():
    # write velocity data arrays to Gal.npz file

    global antXNameL                    # list of strings
    global antXTVT                      # float 2d array
    global antLen                       # integer
    global velGLonP180                  # float 2d array     creation
    global velGLonP180Count             # integer array      creation
    global velGLonP180CountSum          # integer            creation
    global galDecP90GLonP180Count       # integer array      creation

    global freqAntMin                   # float
    global freqAntMax                   # float
    global freqBinQty                   # integer
    global ezConGalCrossingGLatCenterL  # float list
    global ezConGalCrossingGLatNear     # float
    global fileNameLast                 # string

    # if Galactic Latitude Crossings not wanted, then return
    if ezConGalCrossingGLatNear == 0.:
        return(1)

    print()
    print('   writeFileGal ===============')

    for ezConGalCrossingGLatCenter in ezConGalCrossingGLatCenterL:
        # Velocity by Galactic Longitude (gLon) grid.
        # gLon is -180thru+180, adding 180, gives gLonP180 as 0thru360 which is more convenient.
        velGLonP180 = np.zeros([freqBinQty, 361], dtype = float)        # freqBinQty by 0thru360 gLonP180
        velGLonP180Count = np.zeros([361], dtype = int)                 # count of saved spectrums in velGLonP180
        # Declination (dec) is -90thru+90, adding 90, gives decP90 as 0thru180 which is more convenient.
        # galDecP90GLonP180Count is floats to allow mask replacement with np.nan later.
        galDecP90GLonP180Count = np.zeros([181, 361], dtype = int)      # 0thru180 decP90 by 0thru360 gLonP180

        for n in range(antLen):
            gLatDegThis = ezConOut[n, 3]                        # gLatDeg is -90. thru +90.

            # if n is close enough to Galactic GLat, a Galactic crossing
            if abs(gLatDegThis - ezConGalCrossingGLatCenter) <= ezConGalCrossingGLatNear:
                gLonP180 = int(ezConOut[n, 4]) + 180            # gLonP180 is RtoL from 0 thru 360

                # sum the current antXTVT spectrum to the grid column, and increment the column count
                # but reverse the freqBin elements,
                #   because highest freqBin = highest freq = approaching fastest = most negative "velocity"
                #velGLonP180[:, gLonP180] += antXTV[:, n][::-1]
                velGLonP180[:, gLonP180] += antXTVT[:, n][::-1]
                velGLonP180Count[gLonP180] += 1

                # For each declination, several gLat may be 'close enough' to count as a crossing.
                # Increment at each crossing's dec and gLon.
                galDecP90GLonP180Count[int(ezConOut[n, 2] + 90), gLonP180] += 1     # declination + 90

        #print('velGLonP180 = ')
        #print(velGLonP180)
        #print(velGLonP180.shape)
        #print()

        #print('velGLonP180Count = ')
        #print(velGLonP180Count)
        #print(velGLonP180Count.shape)
        #print()

        print()
        print(f' ezConGalCrossingGLatCenter = {ezConGalCrossingGLatCenter:04.1f}')
        #print(' ezConGalCrossingGLatCenter =', ezConGalCrossingGLatCenter)
        velGLonP180CountSum = velGLonP180Count.sum()
        print(' velGLonP180CountSum =', velGLonP180CountSum)

        if velGLonP180CountSum:       # if anything in velGLonP180 to save or plot

            if ezConGalNormalize:
                # assuming this whole .txt data file has a similar system gain,
                #   normalize the whole .npz file data before writing it to file

                # divide the gLonP180 sum by the gLonP180 count for each nonempty gLonP180
                velGLonP180Avg = np.zeros_like(velGLonP180)
                for gLonP180 in range(180, 361):             # for every column, RtoL, 180 thru 360
                    if 1 < velGLonP180Count[gLonP180]:  # if gLon not empty and needs division
                        velGLonP180Avg[:,gLonP180] = velGLonP180[:,gLonP180] / velGLonP180Count[gLonP180]

                if ezConGalNormalize == 1:         # normalize whole velGLonP180 to the velGLonP180Avg Average
                    velGLonP180 /= np.mean(velGLonP180Avg)
                if ezConGalNormalize == 2:         # normalize whole velGLonP180 to the velGLonP180Avg Maximum
                    velGLonP180 /= np.max(velGLonP180Avg)

            # for fileNameLast of  data/2021_333_00.rad.txt  create fileGalWriteName as  data/2021_333_00.radGal.npz
            #fileGalWriteName = fileNameLast.split(os.path.sep)[-1].split('.')[-2] + 'Gal.npz'
            #fileGalWriteName = fileNameLast.split(os.path.sep)[-1][:-4] + 'Gal.npz'
            if ezConGalCrossingGLatCenter < 0:
                # output filenames *Nxx.xGal.npz (N for Negative)
                fileGalWriteName = fileNameLast.split(os.path.sep)[-1][:-4] \
                    + f'n{-ezConGalCrossingGLatCenter:04.1f}Gal.npz'
                # output filenames *Gal.npz (N for Negative)
                #fileGalWriteName = fileNameLast.split(os.path.sep)[-1][:-4] \
                #    + f'N{-ezConGalCrossingGLatCenter:02d}Gal.npz'
            else:
                # output filenames *Pxx.xGal.npz (P for Negative)
                fileGalWriteName = fileNameLast.split(os.path.sep)[-1][:-4] \
                    + f'p{ezConGalCrossingGLatCenter:04.1f}Gal.npz'
                # output filenames *PxxGal.npz (P for Positive)
                #fileGalWriteName = fileNameLast.split(os.path.sep)[-1][:-4] \
                #    + f'P{ezConGalCrossingGLatCenter:02d}Gal.npz'
            #fileGalWriteName = fileNameLast.split(os.path.sep)[-1][:-8] \
            #    + 'GalC.npz'   # ezGal combines .npz
            #print('   ezRAObsName = ', ezRAObsName)

            # *Gal.npz file definition from here, ezCon's writeFileGal()
            #   np.savez_compressed(fileGalWriteName,           # filename
            #       fileObsName=np.array(ezRAObsName),          # string
            #       fileFreqMin=np.array(fileFreqMin),          # float
            #       fileFreqMax=np.array(fileFreqMax),          # float
            #       fileFreqBinQty=np.array(fileFreqBinQty),    # float
            #       velGLonP180=velGLonP180,                    # float: fileFreqBinQty by 0thru360 gLonP180
            #       velGLonP180Count=velGLonP180Count,          # int:                     0thru360 gLonP180
            #       galDecP90GLonP180Count=galDecP90GLonP180Count,  # int: 0thru180 decP90 by 0thru360 gLonP180
            #       antXTVTName=antXNameL[1]+'TVT',                         # string
            #       ezConGalCrossingGLatCenter=ezConGalCrossingGLatCenter,  # float
            #       ezConGalCrossingGLatNear=ezConGalCrossingGLatNear)      # float

            np.savez_compressed(fileGalWriteName,
                fileObsName=np.array(ezRAObsName),
                fileFreqMin=np.array(freqAntMin), 
                fileFreqMax=np.array(freqAntMax),
                fileFreqBinQty=np.array(freqBinQty),
                velGLonP180=velGLonP180,
                velGLonP180Count=velGLonP180Count,
                galDecP90GLonP180Count=galDecP90GLonP180Count,
                antXTVTName=antXNameL[1]+'TVT',
                ezConGalCrossingGLatCenter=ezConGalCrossingGLatCenter,
                ezConGalCrossingGLatNear=ezConGalCrossingGLatNear)
            # antXTVTName was added to file definition later, on 230401
            # ezConGalCrossingGLatCenter was added to file definition later, on 230623
            # ezConGalCrossingGLatNear was added to file definition later, on 230625

            #npzfile = np.load(directory + os.path.sep + fileReadName)
            #ezRAObsName = npzfile['ezRAObsName'] 
            #fileFreqMin    = npzfile['fileFreqMin'] 
            #fileFreqMax    = npzfile['fileFreqMax']
            #fileFreqBinQty = npzfile['fileFreqBinQty'] 
            #velGLonP180      = npzfile['velGLonP180']
            #velGLonP180Count = npzfile['velGLonP180Count']
            #galDecP90GLonP180Count = npzfile['galDecP90GLonP180Count']

            # Prepare velGLonP180 for later ezCon plots.
            # velGLonP180 has been filled with sums of samples.
            #   Now for each column, convert to sum's average.
            for gLonP180 in range(361):
                if velGLonP180Count[gLonP180]:
                    velGLonP180[:, gLonP180] /= velGLonP180Count[gLonP180]

            if 0:
                # mask low values with Not-A-Number (np.nan) to not plot
                #maskOffBelowThis = 0.975    # N0RQVHC
                #maskOffBelowThis = 0.9      # WA6RSV
                maskOffBelowThis = 1.0      # LTO15HC
                print(' maskOffBelowThis = ', maskOffBelowThis)
                maskThisOff = (velGLonP180 < maskOffBelowThis)
                #velGLonP180[maskThisOff] = np.nan                   # maskOffBelowThis is the do not plot
                velGLonP180[maskThisOff] = maskOffBelowThis         # maskOffBelowThis is the minumum everywhere



def writeFileGLon():
    # write velocity data arrays to GLon.npz file

    global antXNameL                    # list of strings
    global antXTVT                      # float 2d array
    global antLen                       # integer
    #global velGLonP180                  # float 2d array     creation
    #global velGLonP180Count             # integer array      creation
    #global velGLonP180CountSum          # integer            creation

    global freqAntMin                   # float
    global freqAntMax                   # float
    global freqBinQty                   # integer
    global ezConGalCrossingGLonCenterL  # float list
    global ezConGalCrossingGLonNear     # float
    global fileNameLast                 # string

    # if Galactic Longitude Crossings not wanted, then return
    if not len(ezConGalCrossingGLonCenterL) or ezConGalCrossingGLonNear == 0.:
        return(1)

    print()
    print('   writeFileGLon ===============')

    # Velocity by Galactic Latitude (gLat) grid.
    # gLat is -90thru+90, adding 90, gives gLatP90 as 0thru180 which is more convenient.
    velGLatP90 = np.zeros([freqBinQty, 181], dtype = float)        # freqBinQty by 0thru180 gLatP90
    velGLatP90Count = np.zeros([181], dtype = int)                 # count of saved spectrums in velGLatP90

    for ezConGalCrossingGLonCenter in ezConGalCrossingGLonCenterL:
        for n in range(antLen):
            gLonDegThis = ezConOut[n, 4]                        # gLonDeg is -180. thru +180.

            # if n is close enough to Galactic Longitude, a GLon crossing
            if abs(gLonDegThis - ezConGalCrossingGLonCenter) <= ezConGalCrossingGLonNear:
                gLatP90 = int(ezConOut[n, 3]) + 90            # gLatP90 is from 0 thru 180

                # sum the current antXTVT spectrum to the grid column, and increment the column count
                # but reverse the freqBin elements,
                #   because highest freqBin = highest freq = approaching fastest = most negative "velocity"
                velGLatP90[:, gLatP90] += antXTVT[:, n][::-1]
                velGLatP90Count[gLatP90] += 1

        #print('velGLatP90 = ')
        #print(velGLatP90)
        #print(velGLonP90.shape)
        #print()

        #print('velGLatP90Count = ')
        #print(velGLatP90Count)
        #print(velGLatP90Count.shape)
        #print()

        print()
        print(' ezConGalCrossingGLonCenter =', ezConGalCrossingGLonCenter)
        velGLatP90CountSum = velGLatP90Count.sum()
        print(' velGLatP90CountSum =', velGLatP90CountSum)

        if velGLatP90CountSum:       # if anything in velGLatP90 to save or plot

            if ezConGalNormalize:
                # assuming this whole .txt data file has a similar system gain,
                #   normalize the whole .npz file data before writing it to file
                
                # divide the velGLatP90 sum by the velGLatP90 count for each nonempty velGLatP90
                velGLatP90Avg = np.zeros_like(velGLatP90)
                for gLatP90 in range(180):              # for every column, RtoL, 0 thru 179
                    if 1 < velGLatP90Count[gLatP90]:    # if gLon not empty and needs division
                        velGLatP90Avg[:,gLatP90] = velGLatP90[:,gLatP90] / velGLatP90Count[gLatP90]

                if ezConGalNormalize == 1:         # normalize whole velGLatP90 to the velGLatP90Avg Average
                    velGLatP90 /= np.mean(velGLatP90Avg)
                if ezConGalNormalize == 2:         # normalize whole velGLatP90 to the velGLatP90Avg Maximum
                    velGLatP90 /= np.max(velGLatP90Avg)


            if ezConGalCrossingGLonCenter < 0:
                # output filenames *Nxxx.xGLon.npz (N for Negative)
                fileGLonWriteName = fileNameLast.split(os.path.sep)[-1][:-4] \
                    + f'n{-ezConGalCrossingGLonCenter:05.1f}GLon.npz'
                # output filenames *NxxxGLon.npz (N for Negative)
                #fileGLonWriteName = fileNameLast.split(os.path.sep)[-1][:-4] \
                #    + f'N{-ezConGalCrossingGLonCenter:03d}GLon.npz'
            else:
                # output filenames *Pxxx.xGLon.npz (P for Positive)
                fileGLonWriteName = fileNameLast.split(os.path.sep)[-1][:-4] \
                    + f'p{ezConGalCrossingGLonCenter:05.1f}GLon.npz'
                # output filenames *PxxxGLon.npz (P for Positive)
                #fileGLonWriteName = fileNameLast.split(os.path.sep)[-1][:-4] \
                #    + f'P{ezConGalCrossingGLonCenter:03d}GLon.npz'
            #print('   ezRAObsName = ', ezRAObsName)
            np.savez_compressed(fileGLonWriteName,
                fileObsName=np.array(ezRAObsName),
                fileFreqMin=np.array(freqAntMin), 
                fileFreqMax=np.array(freqAntMax),
                fileFreqBinQty=np.array(freqBinQty),
                velGLatP90=velGLatP90,
                velGLatP90Count=velGLatP90Count,
                antXTVTName=antXNameL[1]+'TVT',
                ezConGalCrossingGLonCenter=ezConGalCrossingGLonCenter,
                ezConGalCrossingGLonNear=ezConGalCrossingGLonNear)
            #    fileFreqBinQty=np.array(fileFreqBinQty),



def studyTime(column, data1dName):
    # returns long string

    # column                                    # integer
    # data1dName                                # string

    global ezConOut                             # float and int 2d array
    global dataTimeUtc                          # 'astropy.time.core.Time' object array

    # '5 * str(column - 10)' below provides a (unique?) 5-character string.
    #  RefMax is .ezb file column 13, so later, in the large ezConStudyxxx.txt file,
    #  search for ' 33333' to easily find the RefMax section.
    OutString = f'\n  {fileNameLast}  ================================== ' \
        + f'{5 * str(column - 10)} Time study of {data1dName}\n'

    data1d = ezConOut[:, column]
    
    data1dMax = data1d.max()
    data1dMin = data1d.min()
    OutString += f'                         {data1dName}Max = {data1dMax}\n'
    OutString += f'                         {data1dName}Avg = {np.mean(data1d)}\n'
    OutString += f'                         {data1dName}Min = {data1dMin}\n'

    data1dSpanD100 = (data1dMax - data1dMin) / 100.
    # to allow division by data1dSpanD100
    if not data1dSpanD100:
        data1dSpanD100 = 1e-30

    if column == 18 or column == 19:
        pluckArgumentS = 'ezConAntXTVTPluck'
    else:
        pluckArgumentS = 'ezConAntPluck'

    OutString += f'\n Sample numbers of 20 highest-values of {data1dName}:\n'
    data1dIdxbyValueHigh = np.array(data1d).argsort()[::-1][:20]
    for i in range(len(data1dIdxbyValueHigh)):
        data1dIdxbyValueHighThis = data1dIdxbyValueHigh[i]
        #data1dThis = data1d[data1dIdxbyValueHigh[i]]
        data1dThis = data1d[data1dIdxbyValueHighThis]
        data1dThisPercent = (data1dThis - data1dMin) / data1dSpanD100
        # '2023-02-09 00:01:20.000'
        #  012345678901234567890123
        #             00:01
        #             123456
        timeThisS = dataTimeUtc[data1dIdxbyValueHighThis].iso[11:16]
        #OutString += f' i = {i}      sample {data1dIdxbyValueHigh[i]}' \
        #    + f'      {data1dName} = {data1dThis}       {data1dThisPercent} %'
        OutString += f' i = {i}      sample {data1dIdxbyValueHighThis}' \
            + f'   {timeThisS}   {data1dName} = {data1dThis}   {data1dThisPercent} %'
        if data1dThisPercent < 95:
            OutString += '  <=========== < 95%\n'
        else:
            OutString += '\n'
        if i == 4 or i == 9 or i == 14:
            OutString += '\n'
    OutString += f'                 Maybe try arguments like    -{pluckArgumentS} '\
        + f'{data1dIdxbyValueHigh[0]}\n'
    for i in range(len(data1dIdxbyValueHigh))[1:]:
        OutString += f'                                             -{pluckArgumentS} '\
            + f'{data1dIdxbyValueHigh[i]}\n'

    OutString += f'\n Sample numbers of 20 lowest-values of {data1dName}:\n'
    data1dIdxbyValueLow = np.array(data1d).argsort()[:20]
    for i in range(len(data1dIdxbyValueLow)):
        data1dIdxbyValueLowThis = data1dIdxbyValueLow[i]
        data1dThis = data1d[data1dIdxbyValueLowThis]
        data1dThisPercent = (data1dThis - data1dMin) / data1dSpanD100
        timeThisS = dataTimeUtc[data1dIdxbyValueHighThis].iso[11:16]
        OutString += f' i = {i}      sample {data1dIdxbyValueLowThis}' \
            + f'   {timeThisS}   {data1dName} = {data1dThis}   {data1dThisPercent} %'
        if 5 < data1dThisPercent:
            OutString += '  <=========== > 5%\n'
        else:
            OutString += '\n'
        if i == 4 or i == 9 or i == 14:
            OutString += '\n'
    OutString += f'                 Maybe try arguments like    -{pluckArgumentS} '\
        + f'{data1dIdxbyValueLow[0]}\n'

    OutString += f'\n Sample numbers of 20 largest change values of {data1dName}:\n'
    data1dIdxbyValueDeltaHighM1 = np.array(abs(data1d[1:] - data1d[:-1])).argsort()[::-1][:20]
    for i in range(len(data1dIdxbyValueDeltaHighM1)):
        data1dIdxbyValueDeltaHighM1This = data1dIdxbyValueDeltaHighM1[i]
        data1dDeltaThis = \
            data1d[data1dIdxbyValueDeltaHighM1This + 1] - data1d[data1dIdxbyValueDeltaHighM1This]
        timeThisS = dataTimeUtc[data1dIdxbyValueDeltaHighM1This + 1].iso[11:16]
        OutString += f' i = {i}      sample {data1dIdxbyValueDeltaHighM1This + 1}' \
            + f'   {timeThisS}   {data1dName}Delta = {data1dDeltaThis}' \
            + f'   {data1dDeltaThis / data1dSpanD100} %\n'
        if i == 4 or i == 9 or i == 14:
            OutString += '\n'
    OutString += f'                 Maybe try arguments like    -{pluckArgumentS} '\
        + f'{data1dIdxbyValueDeltaHighM1[0] + 1}\n'
        
    return(OutString)



def printGoodbye(startTime):

    global rawLen                   # integer
    global antLen                   # integer
    global refQty                   # integer
    global programRevision          # string
    global commandString            # string
    global ezConPlotRangeL          # integer list
    global OutFreqString            # string

    # print status
    if 0:
        print()
        print('   ezRAObsName =', ezRAObsName)
        print('   ezRAObsLat  =', ezRAObsLat)
        print('   ezRAObsLon  =', ezRAObsLon)
        print('   ezRAObsAmsl =', ezRAObsAmsl)
        print()
        print('   ezConAddMHz =', ezConAddMHz)
        print('   ezConAzDeg =', ezConAzDeg)
        print('   ezConElDeg =', ezConElDeg)
        print('   ezConAddAzDeg =', ezConAddAzDeg)
        print('   ezConAddElDeg =', ezConAddElDeg)
        print()
        print('   ezConInputdB  =', ezConInputdB)
        print()
        print('   ezConRawSamplesUseL   =', ezConRawSamplesUseL)
        print('   ezConRawFreqBinTrimL  =', ezConRawFreqBinTrimL)
        print('   ezConRawFreqTrimL     =', ezConRawFreqTrimL)
        print('   ezConRawFreqBinHideL  =', ezConRawFreqBinHideL)
        print('   ezConAntFreqBinHideL  =', ezConAntFreqBinHideL)
        print('   ezConRefFreqBinHideL  =', ezConRefFreqBinHideL)
        print()
        print('   ezConRefMode          =', ezConRefMode)
        print()
        print('   ezConAntMaxPluckValL  =', ezConAntMaxPluckValL)
        print('   ezConAntSamplesUseL   =', ezConAntSamplesUseL)
        print('   ezConAntPluckL        =', ezConAntPluckL)
        print('   ezConAntAvgPluckQtyL  =', ezConAntAvgPluckQtyL)
        print('   ezConAntAvgPluckFracL =', ezConAntAvgPluckFracL)
        print('   ezConAntFreqBinSmooth =', ezConAntFreqBinSmooth)
        print()
        print('   ezConRefAvgPluckQtyL  =', ezConRefAvgPluckQtyL)
        print('   ezConRefAvgPluckFracL =', ezConRefAvgPluckFracL)
        print()
        print('   ezConUseRefSub        =', ezConUseRefSub)
        print()
        print('   ezConAntBaselineFreqBinsFracL   =', ezConAntBaselineFreqBinsFracL)
        print('   ezConAntRABaselineFreqBinsFracL =', ezConAntRABaselineFreqBinsFracL)
        print()
        print('   ezConAntXInput                  =', ezConAntXInput)
        print('   ezConAntXTVTLevelL              =', ezConAntXTVTLevelL)
        print()
        print('   ezConAntXTFreqBinsFracL         =', ezConAntXTFreqBinsFracL)
        print('   ezConUseVlsr                    =', ezConUseVlsr)
        print('   ezConAntXTVTFreqBinsFracL       =', ezConAntXTVTFreqBinsFracL)
        print()
        print('   ezConAntXTVTMaxPluckQtyL        =', ezConAntXTVTMaxPluckQtyL)
        print('   ezConAntXTVTMaxPluckValL        =', ezConAntXTVTMaxPluckValL)
        print('   ezConAntXTVTAvgPluckQtyL        =', ezConAntXTVTAvgPluckQtyL)
        print('   ezConAntXTVTAvgPluckValL        =', ezConAntXTVTAvgPluckValL)
        print('   ezConAntXTVTPluckL              =', ezConAntXTVTPluckL)
        print('   ezConAntXTVTClipL               =', ezConAntXTVTClipL)
        print('   ezConAntXTVTSmooth              =', ezConAntXTVTSmooth)
        print('   ezConAntXTVTFreqBinsClipL       =', ezConAntXTVTFreqBinsClipL)
        print('   ezConAntXTVTIntegrate           =', ezConAntXTVTIntegrate)
        print('   ezConGalNormalize               =', ezConGalNormalize)
        print('   ezCon087Csv                     =', ezCon087Csv)
        print()
        print('   ezCon399SignalSampleByFreqBinL  =', ezCon399SignalSampleByFreqBinL)
        print()
        print('   ezConAstroMath        =', ezConAstroMath)
        print()
        print('   ezConGalCrossingGLat  =', ezConGalCrossingGLat)
        print('   ezConVelGLonEdgeFrac  =', ezConVelGLonEdgeFrac)
        print('   ezConVelGLonEdgeLevel =', ezConVelGLonEdgeLevel)
        print()
        print('   ezConHeatVMinMaxL     =', ezConHeatVMinMaxL)
        print('   ezConRawDispIndex     =', ezConRawDispIndex)
        print('   ezConDispGrid         =', ezConDispGrid)
        print('   ezConDispFreqBin      =', ezConDispFreqBin)
        print('   ezConPlotRangeL       =', ezConPlotRangeL)
        print()
        print(f'   rawLen = {rawLen:,}')
        print(f'   antLen = {antLen:,}')
        print(f'   rawLen / antLen = {rawLen / antLen:,}')
        print(f'   antLen / rawLen = {antLen / rawLen:,}')

    print('\n\n\n ezConPlotRangeL =', ezConPlotRangeL)

    fileWriteStudy.write(OutFreqString + '\n\n\n\n')

    stopTime = time.time()
    stopTimeS = time.ctime()
    #OutString = f'\n rawLen = {rawLen:,}\n'
    OutString = f'\n rawLen = {rawLen:,}\n'
    #OutString += f' refLen = {refLen}\n'
    OutString += f' refQty = {refQty:,}\n'
    OutString += f' antLen = {antLen:,}\n'
    OutString += f'\n That Python command,\n'
    OutString += f'   {commandString}\n'
    OutString += f' took {int(stopTime-startTime)} seconds = {(stopTime-startTime)/60.:1.1f} minutes\n'
    OutString += f' Now = {stopTimeS[:-5]}\n'
    OutString += f'\n programRevision = {programRevision}\n'
    print(OutString)
    fileWriteStudy.write(OutString + '\n')

    print()
    print()
    print()
    print()
    print()
    print('       The Society of Amateur Radio Astronomers (SARA)')
    print('                    radio-astronomy.org')
    print()
    print()
    print()
    print()
    print()



#A#####################################################################################



def plotEzCon1dByFreqBin(plotName, plotData1d, plotColorS, plotYLabel, freqRawPlot, plotNumber):

    # plotName                       # string
    # plotData1d                     # float 1d array
    # plotColorS                     # string
    # plotYLabel                     # string

    global byFreqBinRawX            # float array
    global byFreqBinX               # float array
    global ezConDispGrid            # integer
    global dopplerSpanRawD2         # float
    global dopplerSpanD2            # float
    global freqCenterRaw            # float
    global freqCenter               # float
    global freqCenterRef            # float
    global titleS                   # string

    plt.clf()

    if freqRawPlot: 
        plt.plot(byFreqBinRawX, plotData1d, plotColorS)
        plt.xlabel(f'Doppler MHz from {freqCenterRaw:.3f} MHz')
        plt.xlim(-dopplerSpanRawD2, dopplerSpanRawD2)
    else:
        plt.plot(byFreqBinX, plotData1d, plotColorS)
        if plotNumber == 327 or plotNumber == 337:
            plt.xlabel(f'Doppler MHz from {freqCenterRef:.3f} MHz')
        else:
            plt.xlabel(f'Doppler MHz from {freqCenter:.3f} MHz')
        plt.xlim(-dopplerSpanD2, dopplerSpanD2)

    plt.title(titleS)
    plt.grid(ezConDispGrid)

    #plt.xlabel('Doppler (MHz)')
    #plt.xlabel(f'Doppler MHz from {freqCenter:.3f} MHz')
    #plt.xlim(-dopplerSpanD2, dopplerSpanD2)

    plt.ylabel(plotYLabel)

    #if ezCon301B:
    if plotNumber == 3012:

        # ezCon301B
        plt.axvline(x = 1420.405 - freqCenterRaw, linewidth=0.5, color='green')

        xRefMin = freqCenterRef - dopplerSpanD2 - freqCenterRaw
        xRefMax = freqCenterRef + dopplerSpanD2 - freqCenterRaw
        #if ezConRefMode == 30:
        xAntMin = freqCenter - dopplerSpanD2 - freqCenterRaw
        xAntMax = freqCenter + dopplerSpanD2 - freqCenterRaw
        #else:
        #    xAntMin = 0          - dopplerSpanD2 - freqCenterRaw
        #    xAntMax = 0          + dopplerSpanD2 - freqCenterRaw

        plt.axvline(x = xRefMin, linewidth=0.5, color='violet')
        plt.axvline(x = xRefMax, linewidth=0.5, color='violet')
        plt.axvline(x = xAntMin, linewidth=0.5, color='blue')
        plt.axvline(x = xAntMax, linewidth=0.5, color='blue')

        yMin = plotData1d.min()
        yMax = plotData1d.max()
        yRef = 0.01 * (yMax - yMin) + yMin
        yAnt = 0.03 * (yMax - yMin) + yMin

        plt.plot(np.array([xRefMin, xRefMax]), np.array([yRef, yRef]), linewidth=0.5, color='violet')
        plt.plot(np.array([xAntMin, xAntMax]), np.array([yAnt, yAnt]), linewidth=0.5, color='blue')

    if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
        os.remove(plotName)
    plt.savefig(plotName, dpi=300, bbox_inches='tight')



def plotEzCon1dSamplesAnt(plotName, plotData1d, plotYLimL, plotColorS, plotYLabel):

    # plotName                                  # string
    # plotData1d                                # float 1d array
    # plotYLimL                                 # list
    # plotColorS                                # string
    # plotYLabel                                # string

    global fileNameLast                         # string
    global titleS                               # string
    global ezConDispGrid                        # integer
    global dataTimeUtc                          # 'astropy.time.core.Time' object array
    global ezConRawDispIndex                    # integer
    global antLenM1                             # integer
    global rawIndex                             # integer array

    global xTickLocsAnt                         # array         creation?
    global xTickLabelsAnt                       # list          creation?
    global xLabelSAnt                           # string        creation?

    plt.clf()

    plt.plot(plotData1d, plotColorS)

    plt.title(titleS)
    plt.grid(ezConDispGrid)
    
    if not len(xTickLocsAnt):
        xTickLocsAnt, xTickLabelsAnt = plt.xticks()
        # dataTimeUtcStrThis = dataTimeUtc[n].iso
        # https://docs.astropy.org/en/stable/time/#id3
        # iso   TimeISO   ‘2000-01-01 00:00:00.000’
        #                  01234567890123456
        # may remove silly values, and shorten lists, so process indices in decreasing order
        for i in range(len(xTickLocsAnt) - 1)[::-1]:
            xTickLocsAntIInt = int(xTickLocsAnt[i])
            if 0 <= xTickLocsAntIInt and xTickLocsAntIInt <= antLenM1:
                if ezConRawDispIndex:
                    xTickLabelsAnt[i] = f'{rawIndex[xTickLocsAntIInt]:,}  {xTickLocsAntIInt:,}  ' \
                        + dataTimeUtc[xTickLocsAntIInt].iso[11:16]
                else:
                    xTickLabelsAnt[i] = f'{xTickLocsAntIInt:,}  ' \
                        + dataTimeUtc[xTickLocsAntIInt].iso[11:16]
            else:       # remove silly values
                xTickLocsAnt = np.delete(xTickLocsAnt, i)
                xTickLabelsAnt = np.delete(xTickLabelsAnt, i)
        # fill xTickLabelsAnt[-1], samplesQtyM1 is usually less than xTickLocsAnt[-1]
        xTickLocsAnt[-1] = antLenM1
        if 0.975 < xTickLocsAnt[-2] / antLenM1:   # if last label overlaps, blank it
            xTickLabelsAnt[-1] = ''
        elif ezConRawDispIndex:
            xTickLabelsAnt[-1] = f'{rawIndex[-1]:,}  {antLenM1:,}  ' + dataTimeUtc[-1].iso[11:16]
        else:
            xTickLabelsAnt[-1] = f'{antLenM1:,}  ' + dataTimeUtc[-1].iso[11:16]
        if ezConRawDispIndex:
            xLabelSAnt = f'Raw Sample Number + Ant Sample Number (last={antLenM1:,}) with UTC Hour:Min (last=' \
                + dataTimeUtc[-1].iso[11:16] + ')'
        else:
            xLabelSAnt = f'Ant Sample Number (last={antLenM1:,}) with UTC Hour:Min (last=' \
                + dataTimeUtc[-1].iso[11:16] + ')'
    plt.xticks(xTickLocsAnt, xTickLabelsAnt, rotation=45, ha='right', rotation_mode='anchor')
    plt.xlabel(xLabelSAnt)
    plt.xlim(0, antLenM1)

    plt.ylabel(plotYLabel)
    if len(plotYLimL):
        plt.ylim(plotYLimL[0], plotYLimL[1])

    if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
        os.remove(plotName)
    plt.savefig(plotName, dpi=300, bbox_inches='tight')



def plotEzCon2dSamples(plotName, plotData2d, plotXLabel, plotXLast, plotYLabel, plotMax, freqRawPlot):

    # plotName                                  # string
    # plotData2d                                # float 2d array
    # plotXLabel                                # string
    # plotXLast                                 # integer
    # plotYLabel                                # string
    # plotNumberMax                             # integer

    global ezConHeatVMinMaxL                    # float list
    global titleS                               # string
    global ezConDispGrid                        # integer
    global ezConRawDispIndex                    # integer
    global dataTimeUtc                          # 'astropy.time.core.Time' object array

    global xTickLabelsHeatAntL                  # string list   creation?
    global xLabelSAnt                           # string        creation?
    global yTickHeatRawL                        # string list
    global yTickHeatL                           # string list

    global fileFreqBinQty                       # integer
    global freqBinQty                           # integer
    #global freqCenter                           # float

    # plot heat map of plotData2d
    heatVMin = ezConHeatVMinMaxL[0]             # minimum 3d value (color), <=0 for autoscale
    heatVMax = ezConHeatVMinMaxL[1]             # maximum 3d value (color), <=0 for autoscale

    plt.clf()

    if heatVMin <= 0:              # if should autoscale heatVMin
        if heatVMax <= 0:            # if should autoscale heatVMax
            # autoscale heatVMin and heatVMax
            heat_map = sb.heatmap(plotData2d,                               cmap='gnuplot')
        else:
            # only heatVMax available
            heat_map = sb.heatmap(plotData2d,                vmax=heatVMax, cmap='gnuplot')
    else:
        if heatVMax <= 0:            # if should autoscale heatVMax
            # only heatVMin available
            heat_map = sb.heatmap(plotData2d, vmin=heatVMin,                cmap='gnuplot')
        else:
            # heatVMin and heatVMax available
            heat_map = sb.heatmap(plotData2d, vmin=heatVMin, vmax=heatVMax, cmap='gnuplot')

    heat_map.set_title(titleS)
    if ezConDispGrid:
        heat_map.grid(b=True, which='major', color='black', linewidth=0.075)

    xTickLabelsHeatAntL = []
    # create xLabelSAnt
    if 'IRa.png' in plotName:       # ezCon089 and ezCon099
        #xTickLabelsHeatAntL = ['0', '2', '4', '6', '8', '10', '12', '14', '16', '18', '20', '22', '24']
        xticklabels = heat_map.get_xticklabels()
        #print(xticklabels)
        for label in xticklabels:
            labelTextInt = int(label.get_text())
            #xTickLabelsHeatAntL.append(f'{int(labelTextInt/30.):,}')
            #xTickLabelsHeatAntL.append(str(int(labelTextInt/30.)))
            xTickLabelsHeatAntL.append(f'{labelTextInt/30.:0.1f}')
        heat_map.set_xticklabels(xTickLabelsHeatAntL, rotation=90)
        #plt.xlim(0, 720)
        xLabelSAnt = 'Right Ascension (Hours)'
    elif 'IGLon.png' in plotName:   # ezCon089 and ezCon099
        #xTickLabelsHeatAntL = ['0', '30', '60', '90', '120', '150', '180', '-150', '-120', '-90', '-60', '-30', '0']
        #heat_map.set_xticklabels(xTickLabelsHeatAntL, rotation=0)
        xticklabels = heat_map.get_xticklabels()
        #print(xticklabels)
        for label in xticklabels:
            labelTextInt = int(label.get_text())
            #xTickLabelsHeatAntL.append(f'{int(labelTextInt/30.):,}')
            xTickLabelsHeatAntL.append(str(int(labelTextInt/2.)))
        heat_map.set_xticklabels(xTickLabelsHeatAntL, rotation=90)
        #plt.xlim(0, 720)
        xLabelSAnt = 'Galactic Longitude (Degrees)'
    else:
        #if not len(xTickLabelsHeatAntL):            # create xTickLabelsHeatAntL only if needed
        if 1:
            # create xTickLabelsHeatAntL
            xticklabels = heat_map.get_xticklabels()
            #print(xticklabels)
            for label in xticklabels:
                labelTextInt = int(label.get_text())
                #if 0 <= labelTextInt and labelTextInt < plotXLast:
                dataTimeUtcStrThis = dataTimeUtc[labelTextInt].iso[11:16]
                xTickLabelsHeatAntL.append(f'{labelTextInt:,}  ' + dataTimeUtcStrThis)
            heat_map.set_xticklabels(xTickLabelsHeatAntL, rotation=90)

        if ezConRawDispIndex and (plotXLabel != 'Raw'):
            xLabelSAnt = f'Raw Sample Number + Ant Sample Number (last={plotXLast:,}) with UTC Hour:Min (last=' \
                + dataTimeUtc[-1].iso[11:16] + ')'
        else:
            xLabelSAnt = f'{plotXLabel} Sample Number (last={plotXLast:,}) with UTC Hour:Min (last=' \
                + dataTimeUtc[-1].iso[11:16] + ')'

    #heat_map.set_xticklabels(xTickLabelsHeatAntL, rotation=90)
    heat_map.set_xlabel(xLabelSAnt)

    if freqRawPlot: 
        freqBinQtyThis = fileFreqBinQty
        yTickHeatLThis = yTickHeatRawL
    else:
        freqBinQtyThis = freqBinQty
        yTickHeatLThis = yTickHeatL

    heat_map.invert_yaxis()
    if ezConDispFreqBin == 1:
        heat_map.set_ylabel(plotYLabel + ':  Frequency Bin',
            rotation=90, verticalalignment='bottom')
        heat_map.yaxis.set_major_locator(matplotlib.ticker.MultipleLocator(32))
        antYtickFn = lambda x, pos: f'{x:0.0f}'
    elif ezConDispFreqBin == 2:
        heat_map.set_ylabel(plotYLabel + ':  Frequency Bandwidth Fraction',
            rotation=90, verticalalignment='bottom')
        # 31.9835 gets 991, but not 1023 !!!!
        heat_map.yaxis.set_major_locator(matplotlib.ticker.MultipleLocator(32.))
        antYtickFn = lambda x, pos: f'{x / freqBinQtyThis:0.2f}'
    else:
        #heat_map.set_ylabel(plotYLabel + f':  Doppler MHz from {freqCenter:.3f} MHz',
        #    rotation=90, verticalalignment='bottom')
        heat_map.set_ylabel(plotYLabel,
            rotation=90, verticalalignment='bottom')
        #  256 / 24 = 10.666666 freqBin per ytick
        #heat_map.yaxis.set_major_locator(matplotlib.ticker.MultipleLocator(10.666666))
        # 1024 / 24 = 42.666666 freqBin per ytick
        #heat_map.yaxis.set_major_locator(matplotlib.ticker.MultipleLocator(42.666666))
        heat_map.yaxis.set_major_locator(matplotlib.ticker.MultipleLocator(freqBinQtyThis / 24.))
        antYtickFn = lambda x, pos: yTickHeatLThis[int(pos) - 1]
    heat_map.yaxis.set_major_formatter(matplotlib.ticker.FuncFormatter(antYtickFn))

    if plotMax:
         # green dots for each sample's max
        plotData2dMaxY = np.argmax(plotData2d, axis=0)          # Y (=freqBin) for each sample's max
        plt.plot(plotData2dMaxY, 'go', markersize=2)

        #    # big violet dots on plot's max 1% values
        #    plotData2dSort = np.sort(plotData2d, axis=None)[::-1]   # flattened and sorted by decreasing value
        #    for n in range(1, int(0.01 * len(plotData2dSort))):
        #        plotData2dY, plotData2dX = np.where(plotData2d == plotData2dSort[n])
        #        plt.plot(plotData2dX, plotData2dY, 'o', c='violet', markersize=10)

        # big yellow dot on plot's max
        plotData2dMaxMaxY, plotData2dMaxMaxX = np.where(plotData2d == plotData2d.max())
        plt.plot(plotData2dMaxMaxX, plotData2dMaxMaxY, 'yo', markersize=10)
        #    plotData2dY, plotData2dX = np.where(plotData2d == plotData2dSort[0])
        #    plt.plot(plotData2dX, plotData2dY, 'yo', markersize=10)
        
    if plotYLabel[-2:] == 'TV':
        # add a thin black horizontal line at zero Doppler, for comparison
        plt.axhline(y=freqBinQtyThis/2, linewidth=0.5, color='black')
    
    if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
        os.remove(plotName)
    plt.savefig(plotName, dpi=300, bbox_inches='tight')



def plotEzCon000rawRaw():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list
    global xTickLabelsHeatAntL                  # string list

    global raw                                  # float 2d array
    global rawLen                               # integer
    global yTickHeatRawL                        # string list
    global freqCenterRaw                        # float


    plotCountdown -= 1

    if 0 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon000rawRaw.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    # force new xTickLabelsHeatAntL before and after plotting
    xTickLabelsHeatAntL = []
    #print('          ############################ freqCenterRaw =', freqCenterRaw)
    if freqCenterRaw:
        plotEzCon2dSamples(plotName, raw, 'RawRaw', rawLen-1, f'RawRaw:  Doppler MHz from {freqCenterRaw:.3f} MHz', 0, 1)
    else:
        ########################### why need this ????? ########################
        plotEzCon2dSamples(plotName, raw, 'RawRaw', rawLen-1, 'RawRaw:  Doppler MHz', 0, 1)
    xTickLabelsHeatAntL = []



def plotEzCon001raw():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list
    global xTickLabelsHeatAntL                  # string list

    global raw                                  # float 2d array
    global rawLen                               # integer
    global yTickHeatRawL                        # string list
    global freqCenterRaw                        # float

    plotCountdown -= 1

    if 1 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon001raw.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    # because Raw data, force new xTickLabelsHeatAntL before and after plotting
    xTickLabelsHeatAntL = []
    if freqCenterRaw:
        plotEzCon2dSamples(plotName, raw, 'Raw', rawLen-1, f'Raw:  Doppler MHz from {freqCenterRaw:.3f} MHz', 0, 1)
    else:
        plotEzCon2dSamples(plotName, raw, 'Raw', rawLen-1, 'Raw:  Doppler MHz', 0, 1)
    xTickLabelsHeatAntL = []



def plotEzCon002antRaw():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ant                                  # float 2d array
    global antMax                               # float array       creation
    global antLenM1                             # integer
    global freqCenter                           # float

    antMax = np.max(ant, axis=0)               # creation

    plotCountdown -= 1

    if 2 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon002antRaw.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon2dSamples(plotName, ant, 'Ant', antLenM1, f'AntRaw:  Doppler MHz from {freqCenter:.3f} MHz', 0, 0)



def plotEzCon007ant():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ant                                  # float 2d array
    global antLenM1                             # integer
    global freqCenter                           # float

    plotCountdown -= 1

    if 7 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon007ant.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon2dSamples(plotName, ant, 'Ant', antLenM1, f'Ant:  Doppler MHz from {freqCenter:.3f} MHz', 0, 0)



def plotEzCon017antMax2d():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ant                                  # float 2d array
    global antLenM1                             # integer
    global freqCenter                           # float

    plotCountdown -= 1

    if 17 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon017antMax.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon2dSamples(plotName, ant, 'Ant', antLenM1, f'AntMax:  Doppler MHz from {freqCenter:.3f} MHz', 1, 0)



def plotEzCon022refRaw():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ref                                  # float 2d array
    #global refLenM1                             # integer
    global antLenM1                             # integer
    global freqCenterRef                        # float

    plotCountdown -= 1

    if 22 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon022refRaw.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    if freqCenterRef:
        plotEzCon2dSamples(plotName, ref, 'Ref', antLenM1, f'RefRaw:  Doppler MHz from {freqCenterRef:.3f} MHz', 0, 0)
    else:
        plotEzCon2dSamples(plotName, ref, 'Ref', antLenM1, 'RefRaw:  Doppler MHz', 0, 0)



def plotEzCon027ref():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ref                                  # float 2d array
    #global refLenM1                             # integer
    global antLenM1                             # integer
    global freqCenterRef                        # float

    plotCountdown -= 1

    if 27 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon027ref.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    if freqCenterRef:
        plotEzCon2dSamples(plotName, ref, 'Ref', antLenM1, f'Ref:  Doppler MHz from {freqCenterRef:.3f} MHz', 0, 0)
    else:
        plotEzCon2dSamples(plotName, ref, 'Ref', antLenM1, 'Ref:  Doppler MHz', 0, 0)



def plotEzCon037refMax2d():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ref                                  # float 2d array
    #global refLenM1                             # integer
    global antLenM1                             # integer
    global freqCenterRef                        # float

    plotCountdown -= 1

    if 37 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon037refMax.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    if freqCenterRef:
        plotEzCon2dSamples(plotName, ref, 'Ref', antLenM1, f'RefMax:  Doppler MHz from {freqCenterRef:.3f} MHz', 1, 0)
    else:
        plotEzCon2dSamples(plotName, ref, 'Ref', antLenM1, 'RefMax:  Doppler MHz', 1, 0)



def plotEzCon047antB():

    # creates antB

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ant                                  # float 2d array
    global antBaseline                          # float array
    global antB                                 # float 2d array        creation
    global antLenM1                             # integer
    global freqCenter                           # float
    global ezConUseRefSub                       # integer

    if ezConUseRefSub:
        antB = ant - antBaseline                    # creation
    else:
        # before division, if any antBaseline is zero, then add tiny number to all antBaseline
        if not antBaseline.all():
            antBaseline += 1e-30
        #if ezConInputdB:
        #    antB = -ant / antBaseline
        #else:
        antB = ant / antBaseline

    plotCountdown -= 1

    if 47 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon047antB.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         antBAvgMax = ', antB.max())
    print('                         antBAvgAvg =', np.mean(antB))
    print('                         antBAvgMin = ', antB.min())

    plotEzCon2dSamples(plotName, antB, 'Ant', antLenM1, f'AntB:  Doppler MHz from {freqCenter:.3f} MHz', 0, 0)



def plotEzCon057antBMax2d():
    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global antB                                 # float 2d array
    global antLenM1                             # integer
    global freqCenter                           # float

    plotCountdown -= 1

    if 57 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon057antBMax.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon2dSamples(plotName, antB, 'Ant', antLenM1, f'AntBMax:  Doppler MHz from {freqCenter:.3f} MHz', 1, 0)



def plotEzCon061antRA():
    # creates antRA

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ant                                  # float 2d array
    global ref                                  # float 2d array
    global antRA                                # float 2d array        creation
    global antLenM1                             # integer
    global freqCenter                           # float
    global ezConUseRefSub                       # integer

    # create antRA
    if ezConUseRefSub:
        antRA = np.subtract(ant, ref)               # creation
    else:
        # before division, if any ref is zero, then add tiny number to all ref
        if not ref.all():
            ref += 1e-30
        antRA = np.true_divide(ant, ref)        # creation

    plotCountdown -= 1

    plotName = 'ezCon061antRA.png'

    if 61 not in ezConPlotRequestedL:
        return(1)

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon2dSamples(plotName, antRA, 'Ant', antLenM1, f'AntRA:  Doppler MHz from {freqCenter:.3f} MHz', 0, 0)



def plotEzCon067antRB():
    # creates antRB

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global antRA                                # float 2d array
    global antRABaseline                        # float array
    global antRB                                # float 2d array        creation
    global antLenM1                             # integer
    global freqCenter                           # float
    global ezConUseRefSub                       # integer

    if ezConUseRefSub:
        antRB = antRA - antRABaseline           # creation
    else:
        antRB = antRA / antRABaseline           # creation

    plotCountdown -= 1

    if 67 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon067antRB.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon2dSamples(plotName, antRB, 'Ant', antLenM1, f'AntRB:  Doppler MHz from {freqCenter:.3f} MHz', 0, 0)



def plotEzCon077antRBMax2d():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global antRB                                # float 2d array
    global antLenM1                             # integer
    global freqCenter                           # float

    plotCountdown -= 1

    if 77 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon077antRBMax.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon2dSamples(plotName, antRB, 'Ant', antLenM1, f'AntRBMax:  Doppler MHz from {freqCenter:.3f} MHz', 1, 0)



def plotEzCon081antXT():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global antX                                 # float 2d array
    global antXNameL                            # list of strings
    global antXT                                # float 2d array        creation
    global antLen                               # integer
    global antLenM1                             # integer
    global freqCenter                           # float
    global freqBinQty                           # integer

    # Each antX[:, n] is a spectrum, normally from Doppler -1.2 to +1.2 MHz.
    # The low and high frequency extremes, they rise up, and they mislead.
    # Because interested in HI emision, antXT will use only the center of that antXThis spectrum,
    # maybe Doppler -0.6 to +0.6 MHz.
    # Create an antXT spectrum with extremes with values adjusted to 1. .
    # So do not use maybe 1.2 - 0.6 = 0.6 MHz of the outer extremes.
    # So do not use a fraction of the whole, suggest maybe 0.6 of 2.4 MHz, of the outer extremes.
 



    print('==AAA============== antX =', antX)
    print('==AAA============== np.max(antX) =', np.max(antX))
    print('==AAA============== np.min(antX) =', np.min(antX))





    #antXT = np.empty_like(antX)
    antXT = np.ones_like(antX)
 
    # For each individual antX spectrum, fill antXT inside the FOR loop below.
    #   Using an average slope from antXByFreqBinAvg, want to fill antXT
    #   with a corresponding slope-flatten center section of antX.
    #   The center section has antXSlopeQty indicies, starting at index ezConAntXFreqBin0 .
    print('                         ezConAntXTFreqBinsFracL =', ezConAntXTFreqBinsFracL)
    #ezConAntXFreqBin0 = int(ezConAntXTFreqBinsFracL[0] * (fileFreqBinQty - 1))
    #ezConAntXFreqBin1 = int(ezConAntXTFreqBinsFracL[1] * (fileFreqBinQty - 1))
    ezConAntXFreqBin0 = int(ezConAntXTFreqBinsFracL[0] * (freqBinQty - 1))
    ezConAntXFreqBin1 = int(ezConAntXTFreqBinsFracL[1] * (freqBinQty - 1))
    ezConAntXFreqBin1P1 = ezConAntXFreqBin1 + 1
    print('                         ezConAntXFreqBin0 =', ezConAntXFreqBin0)
    print('                         ezConAntXFreqBin1 =', ezConAntXFreqBin1)

    antXUsedMin = antX[ezConAntXFreqBin0:ezConAntXFreqBin1P1, :].min()
    print('                         antXUsedMin =', antXUsedMin)

    if antXUsedMin < 1.:
       antX -= antXUsedMin

    antXSlopeQty = ezConAntXFreqBin1P1 - ezConAntXFreqBin0
    antXRange = range(antXSlopeQty)
    #antXTThis = np.ones(fileFreqBinQty)        # sets antXT extreme lows and highs to 1.0
    antXTThis = np.ones(freqBinQty)        # sets antXT extreme lows and highs to 1.0

    # create a level antX center sloped spectrum
    # set antXSlope from antXByFreqBinAvg
    antXByFreqBinAvg = np.mean(antX + 0., axis=1)
    print('==BBB1============== antXByFreqBinAvg =', antXByFreqBinAvg)
    print('==BBB1============== np.max(antXByFreqBinAvg) =', np.max(antXByFreqBinAvg))
    print('==BBB1============== np.min(antXByFreqBinAvg) =', np.min(antXByFreqBinAvg))
    antXSlopeValueStart = antXByFreqBinAvg[ezConAntXFreqBin0]
    print('==BBB1============== antXSlopeValueStart =', antXSlopeValueStart)
    antXSlopeValueStop  = antXByFreqBinAvg[ezConAntXFreqBin1]
    print('==BBB1============== antXSlopeValueStop =', antXSlopeValueStop)
    antXSlope = (antXSlopeValueStop - antXSlopeValueStart) / antXSlopeQty
    print('==BBB1============== antXSlope =', antXSlope)
    antXTThisDivisor = antXRange * antXSlope + antXSlopeValueStart
    print('==BBB1============== antXTThisDivisor =', antXTThisDivisor)
    # before division, if antXTThisDivisor is zero, then add tiny number to all antXTThisDivisor
    if not antXTThisDivisor.all():
        antXTThisDivisor += 1e-30
    print('==BBB1============== antXTThisDivisor =', antXTThisDivisor)


    print()
    print('==BBB2============== antXT =', antXT)
    print('==BBB2============== np.max(antXT) =', np.max(antXT))
    print('==BBB2============== np.min(antXT) =', np.min(antXT))

    for n in range(antLen):
        # want to slope-flatten the antX center section, which has antXSlopeQty indicies,
        #   inserting at index antXSlopeIndexStart
        antXTThis[ezConAntXFreqBin0:ezConAntXFreqBin1P1] \
            = antX[ezConAntXFreqBin0:ezConAntXFreqBin1P1, n] / antXTThisDivisor
        antXT[:, n] = antXTThis
        #print()
        #print('==BBB1============== antXT =', antXT)
        #print('==BBB1============== np.max(antXT) =', np.max(antXT))
        #print('==BBB1============== np.min(antXT) =', np.min(antXT))
        #print('====BBB2============== antXT =', antXT)
        #print('====BBB2============== np.max(antXT) =', np.max(antXT))
        #print('====BBB2============== np.min(antXT) =', np.min(antXT))

    print()
    print('==BBB3============== antXT =', antXT)
    print('==BBB3============== np.max(antXT) =', np.max(antXT))
    print('==BBB3============== np.min(antXT) =', np.min(antXT))



    # free antX global memory
    antX = []
    antX = None
    del antX

    plotCountdown -= 1

    if 81 not in ezConPlotRequestedL:
        return(1)

    #plotName = 'ezCon081antXT.png'
    plotName = 'ezCon081' + antXNameL[0] + 'T.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    #plotEzCon2dSamples(plotName, antXT, 'Ant', antLenM1, 'AntXT', 0)
    plotEzCon2dSamples(plotName, antXT, 'Ant', antLenM1, antXNameL[1]+f'T:  Doppler MHz from {freqCenter:.3f} MHz', 0, 0)



def createAntXTV():                             # creates antXTV and antXTVAvg

    global antXT                                # float 2d array
    global antXTV                               # float 2d array        creation
    global antLen                               # integer
    global freqCenter                           # float
    global freqBinQty                           # integer

    # create antXTV
    antXTV = np.empty_like(antXT)   # antXTV is like antXT but corrected by Vlsr

    # create array of ones to attach to low or high end of antXT spectrum as needed
    #freqBinVlsrOnes = np.ones(int(fileFreqBinQty / 2))
    freqBinVlsrOnes = np.ones(int(freqBinQty / 2))

    # speed of light = 299,792,458 meters per second
    # https://minerva.union.edu/marrj/radioastro/Instructions_MWrotationcurve.html
    # (fem - fobs) / fobs = Vrec / c
    # fem is the frequency that the radiation was emitted at, which is 1420.4 MHz, and fobs is the frequency that you observed [min freq value of possible H]
    # This velocity is, now, the Vmax along that line of sight,
    # -OK, but why the "/ fobs" here, vs the "/ fRest" below ?
    # ezCon chooses the astropy formula below

    # https://docs.astropy.org/en/stable/api/astropy.units.equivalencies.doppler_radio.html
    # V = c * (fRest - f) / fRest
    #                     V          = c * (fRest - f        ) / fRest
    #                     V / c      =     (fRest - f        ) / fRest
    #                     V / c      =     (1     - f / fRest) / 1
    #                     V / c      =      1     - f / fRest
    #                     V / c  - 1 =            - f / fRest
    #                 1 - V / c      =              f / fRest
    #        fRest * (1 - V / c)     =              f
    # f    = fRest * (1 - V / c)
    # f(V) = fRest * (1 - V / c)
    # f(VLSR) = fRest * (1 - VLSR / 299,792.458 km per second)
    # f(VLSR) = fRest * (1     -           VLSR          / 299,792.458 km per second)
    # f(VLSR) =          fRest - fRest *   VLSR          / 299,792.458 km per second
    # f(VLSR) =          fRest -           VLSR *  fRest / 299,792.458 km per second
    # f(VLSR) =          fRest -           VLSR * (fRest / 299,792.458 km per second)
    # f(VLSR) =          fRest -           VLSR * freqCenterDivC
    # f(VLSR) =          fRest +         (-VLSR * freqCenterDivC)
    # f(VLSR) = fRest + (-VLSR * freqCenterDivC)
    # f(VLSR) = fRest + freqVlsrThis
    # below, ezCon shifts each fRest spectrum by (-VLSR * freqCenterDivC)
    # below, ezCon shifts each fRest spectrum by (freqVlsrThis)

    #freqVlsrThis = -vlsr km/s * 1420.406 MHz / (299,792,458. m/s / 1000.)       # in MHz
    #freqVlsrThis = -vlsr      * freqCenter   / (299,792,458.     / 1000.)       # in MHz
    #freqVlsrThis = -vlsr      * freqCenterDivC                                  # in MHz
    #freqVlsrThis = -vlsrThis  * freqCenterDivC
    freqCenterDivC = freqCenter / (299792458. / 1000.)

    for n in range(antLen):
        # create antXTVThis
        #freqVlsrThis = -vlsrThis  * freqCenterDivC
        freqVlsrThis = -ezConOut[n, 5] * freqCenterDivC
        if 0. <= freqVlsrThis:
            freqBinVlsrThis = int((freqVlsrThis / freqStep) + 0.5)      # round to closest number of freqBins
            if freqBinVlsrThis == 0:
                # shift antXT[:, n] spectrum by 0 freqBin
                antXTVThis = antXT[:, n] + 0.
            else:
                # shift antXT[:, n] spectrum by -freqBinVlsrThis freqBin
                antXTVThis = np.concatenate([ antXT[freqBinVlsrThis:, n], 
                    freqBinVlsrOnes[:freqBinVlsrThis] ])
        else:
            freqBinVlsrThis = int((freqVlsrThis / freqStep) - 0.5)      # round to closest number of freqBins
            if freqBinVlsrThis == 0:
                # shift antXT[:, n] spectrum by 0 freqBin
                antXTVThis = antXT[:, n] + 0.
            else:
                # shift antXT[:, n] spectrum by +freqBinVlsrThis freqBin
                antXTVThis = np.concatenate([ freqBinVlsrOnes[:-freqBinVlsrThis],
                    antXT[:freqBinVlsrThis, n] ])

        antXTV[:, n] = antXTVThis



def plotEzCon082antXTV():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global antXNameL                            # list of strings
    global antXTV                               # float 2d array        creation
    global antLenM1                             # integer
    global freqCenter                           # float

    plotCountdown -= 1

    if 82 not in ezConPlotRequestedL:
        return(1)

    #plotName = 'ezCon082antXTV.png'
    plotName = 'ezCon082' + antXNameL[0] + 'TV.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    #plotEzCon2dSamples(plotName, antXTV, 'Ant', antLenM1, 'AntXTV', 0)
    plotEzCon2dSamples(plotName, antXTV, 'Ant', antLenM1, antXNameL[1]+f'TV:  Doppler MHz from {freqCenter:.3f} MHz', 0, 0)



def createAntXTVT():                            # creates antXTVT

    global antXTV                               # float 2d array
    global antXTVT                              # float 2d array        creation
    global antLen                               # integer
    global freqBinQty                           # integer

    # Each antXTV[:, n] is a spectrum, normally from Doppler -1.2 to +1.2 MHz.
    # The low and high frequency extremes, they rise up, and they mislead.
    # Because interested in HI emision, antXTVT will use only the center of that antXTVThis spectrum,
    # maybe Doppler -0.6 to +0.6 MHz.
    # Create an antXTVT spectrum with extremes with values adjusted to 1. .
    # So do not use 1.2 - 0.6 = 0.6 MHz of the outer extremes.
    # So do not use a fraction of the whole, suggest maybe 0.6 of 2.4 MHz, of the outer extremes.
 
    antXTVT = np.empty_like(antXTV)
 
    # For each individual antXTV spectrum, fill antXTVT inside the FOR loop below.
    #   Using an average slope from antXTVByFreqBinAvg, want to fill antXTVT
    #   with a corresponding slope-flatten center section of antXTV.
    #   The center section has antXTVSlopeQty indicies, starting at index ezConAntXTVFreqBin0 .
    print('                         ezConAntXTVTFreqBinsFracL =', ezConAntXTVTFreqBinsFracL)
    #ezConAntXTVFreqBin0 = int(ezConAntXTVTFreqBinsFracL[0] * (fileFreqBinQty - 1))
    #ezConAntXTVFreqBin1 = int(ezConAntXTVTFreqBinsFracL[1] * (fileFreqBinQty - 1))
    ezConAntXTVFreqBin0 = int(ezConAntXTVTFreqBinsFracL[0] * (freqBinQty - 1))
    ezConAntXTVFreqBin1 = int(ezConAntXTVTFreqBinsFracL[1] * (freqBinQty - 1))
    ezConAntXTVFreqBin1P1 = ezConAntXTVFreqBin1 + 1
    print('                         ezConAntXTVFreqBin0 =', ezConAntXTVFreqBin0)
    print('                         ezConAntXTVFreqBin1 =', ezConAntXTVFreqBin1)

    antXTVSlopeQty = ezConAntXTVFreqBin1P1 - ezConAntXTVFreqBin0
    antXTVRange = range(antXTVSlopeQty)
    #antXTVTThis = np.ones(fileFreqBinQty)        # sets antXTVT extreme lows and highs to 1.0
    antXTVTThis = np.ones(freqBinQty)        # sets antXTVT extreme lows and highs to 1.0

    # create a level antXTV center sloped spectrum
    # set antXTVSlope from antXTVByFreqBinAvg
    antXTVByFreqBinAvg = np.mean(antXTV, axis=1)
    antXTVSlopeValueStart = antXTVByFreqBinAvg[ezConAntXTVFreqBin0]
    antXTVSlopeValueStop  = antXTVByFreqBinAvg[ezConAntXTVFreqBin1]
    antXTVSlope = (antXTVSlopeValueStop - antXTVSlopeValueStart) / antXTVSlopeQty
    antXTVTThisDivisor = antXTVRange * antXTVSlope + antXTVSlopeValueStart
    # before division, if antXTVTThisDivisor is zero, then add tiny number to all antXTVTThisDivisor
    if not antXTVTThisDivisor.all():
        antXTVTThisDivisor += 1e-30

    for n in range(antLen):
        ## level antXTV center sloped spectrum
        # want to slope-flatten the antXTV center section, which has antXTVSlopeQty indicies,
        #   inserting at index antXTVSlopeIndexStart
        antXTVTThis[ezConAntXTVFreqBin0:ezConAntXTVFreqBin1P1] \
            = antXTV[ezConAntXTVFreqBin0:ezConAntXTVFreqBin1P1, n] / antXTVTThisDivisor
        antXTVT[:, n] = antXTVTThis



def plotEzCon086antXTVT():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global antXNameL                            # list of strings
    global antXTVT                              # float 2d array        creation
    global antLen                               # integer
    global antLenM1                             # integer
    global freqCenter                           # float
    global freqBinQty                           # integer
    global dopplerSpanD2                        # float

    plotCountdown -= 1

    if 86 not in ezConPlotRequestedL:
        return(1)

    #plotName = 'ezCon086antXTVT.png'
    plotName = 'ezCon086' + antXNameL[0] + 'TVT0.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    #plotEzCon2dSamples(plotName, antXTVT, 'Ant', antLenM1, 'AntXTVT', 0)
    plotEzCon2dSamples(plotName, antXTVT, 'Ant', antLenM1, antXNameL[1]+f'TVT:  Doppler MHz from {freqCenter:.3f} MHz', 0, 0)



def plotEzCon087antXTVT():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global antXNameL                            # list of strings
    global antXTVT                              # float 2d array        creation
    global antLen                               # integer
    global antLenM1                             # integer
    global freqCenter                           # float
    global freqBinQty                           # integer
    global ezCon087Csv                          # integer
    global dopplerSpanD2                        # float
    global freqAntMin                           # float
    global freqAntMax                           # float
    global titleS                               # string

    plotCountdown -= 1

    if 87 not in ezConPlotRequestedL:
        return(1)

    #plotName = 'ezCon087antXTVT.png'
    plotName = 'ezCon087' + antXNameL[0] + 'TVT.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    #plotEzCon2dSamples(plotName, antXTVT, 'Ant', antLenM1, 'AntXTVT', 0)
    plotEzCon2dSamples(plotName, antXTVT, 'Ant', antLenM1, antXNameL[1]+f'TVT:  Doppler MHz from {freqCenter:.3f} MHz', 0, 0)

    if ezCon087Csv:

        # create independent antXTVTCsv to allow downsampling for smaller CSV files
        antXTVTCsv = antXTVT + 0.

        if 0:
            # create antXTVTCsv to allow small study data
            if 0:
                antXTVTCsv = np.array([
                    [0, 1, 2, 3, 4, 5, 6, 7, 8, 9],
                    [0, 1, 2, 3, 4, 5, 6, 7, 8, 9],
                    [0, 1, 2, 10, 4, 5, 6, 7, 8, 9],
                    [0, 1, 2, 3, 4, 5, 6, 7, 8, 9],
                    [0, 1, 2, 3, 4, 5, 6, 7, 8, 9],
                    [0, 1, 2, 3, 4, 5, 6, 3, 8, 9],
                    [0, 1, 2, 3, 4, 5, 6, 7, 8, 9],
                    [0, 1, 2, 3, 4, 5, 6, 7, 8, 9] ])
            if 1: # ????????????????????
                antXTVTCsv = np.array([
                    [99999999, 0, 1, 2, 3, 4, 5, 6, 7],
                    [0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9],
                    [1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9],
                    [2, 0, 1, 2, 10, 4, 5, 6, 7, 8, 9],
                    [3, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9],
                    [4, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9],
                    [5, 0, 1, 2, 3, 4, 5, 6, 3, 8, 9],
                    [6, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9],
                    [7, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9] ])
            print(' ================== antXTVTCsv =', antXTVT)
            print(' ================== antXTVTCsv.shape =', antXTVT.shape)




        yLen, antXTVTCsvLen = antXTVTCsv.shape
        #if 0:
        if ezCon087Csv != 4:
            # downsample antXTVTCsv ?
            antXTVTCsvLenMax = 500      #######################################################
            antXTVTCsvLenMax = int(antXTVTCsvLen / 4)

            if antXTVTCsvLenMax < antXTVTCsvLen:
                # downsample antXTVTCsv by averaging groupLen samples together
                #   1999 // 500 = 3, so want groupLen as 4
                #   2000 // 500 = 4, so want groupLen as 5
                #   2001 // 500 = 4, so want groupLen as 5
                groupLen = (antXTVTCsvLen // antXTVTCsvLenMax) + 1
                print(' ================== groupLen =', groupLen)
                antXTVTCsvIdx = 0
                for n in range(0, antXTVTCsvLen, groupLen):
                    # downsample antXTVTCsv group by averaging groupLen samples together
                    antXTVTCsv[:,antXTVTCsvIdx] = np.mean(antXTVTCsv[:,n:n+groupLen], axis=1)
                    antXTVTCsvIdx += 1
                # downsample antXTVTCsv remaining group by averaging the samples together
                antXTVTCsv[:,antXTVTCsvIdx] = np.mean(antXTVTCsv[:,n:], axis=1)
                antXTVTCsv = antXTVTCsv[:,:antXTVTCsvIdx+1]     # trim off excess samples

        yLen, antXTVTCsvLen = antXTVTCsv.shape
        print('                         antXTVTCsvLen =', antXTVTCsvLen)
        
            
            
            
            

        if 0:
            # write 3 column CSV with file name like ezCon087antRBTVT.csv
            plotNameCsv = plotName[:-3] + 'csv'
            row_indices, col_indices = np.indices(np.transpose(antXTVTCsv).shape)
            #antXTVTCsv = np.column_stack((row_indices.ravel(), col_indices.ravel(), np.transpose(antXTVT).ravel()))
            #fileFreqBinQtyD2 = fileFreqBinQty / 2.
            freqBinQtyD2 = freqBinQty / 2.
            antXTVTCsv = np.column_stack(( \
                row_indices.ravel(),
                (col_indices.ravel()-freqBinQtyD2) * dopplerSpanD2 / freqBinQtyD2,
                np.transpose(antXTVTCsv).ravel() ))
            #    (col_indices.ravel()-fileFreqBinQtyD2) * dopplerSpanD2 / fileFreqBinQtyD2,
            np.savetxt(plotNameCsv, antXTVTCsv, delimiter=",")

            # free antXTVTCsv global memory
            antXTVTCsv = []
            antXTVTCsv = None
            del antXTVTCsv

            # free col_indices global memory
            col_indices = []
            col_indices = None
            del col_indices




        freqBinMin = 0
        #freqBinMaxP1 = freqBinQty
        freqBinMaxP1 = yLen
        sampleMin = 0
        sampleMaxP1 = antXTVTCsvLen
        # make antXTVTCsv smaller ?
        if 1:
            # 251205 antLen=6,212 x freqBinQty=1024 was too big, caused rinearn.com/en-us/graph3d "Memory Error"
            print('                         antXTVTCsv.shape =', antXTVTCsv.shape)

            # Use only middle of freqBin ?
            freqBinMin = int(freqBinQty / 4)
            freqBinMaxP1 = int(freqBinMin + (freqBinQty / 2))
            #sampleMin = int(sampleMaxP1 / 2)

            antXTVTCsv = antXTVTCsv[freqBinMin:freqBinMaxP1, sampleMin:sampleMaxP1]
            print('                         antXTVTCsv.shape =', antXTVTCsv.shape)
            print('                         antXTVTCsv.min() =', antXTVTCsv.min())
            print('                         antXTVTCsv.max() =', antXTVTCsv.max())




        # write mesh CSV with file name like ezCon087antRBTVTMsh.csv
        plotNameCsv = plotName[:-4] + 'Msh.csv'
        print('                         writing    ', plotNameCsv)
        fileWrite = open(plotNameCsv, 'w')

        #row_indices, _ = np.indices(np.transpose(antXTVTCsv).shape)
        row_indices, _ = np.indices(antXTVTCsv.shape)
        print('                         row_indices.shape =', row_indices.shape)
        # row_indices.shape = (908, 256)

        # write top line of sample number coordinates (X)
        #fileOutS = ',' + np.array2string(row_indices[:,0], separator=',',max_line_width=1e9)[1:-1].replace(' ', '')
        #fileOutS = np.array2string(row_indices[:,0], separator=',',max_line_width=1e13)[1:-1].replace(' ', '')
        fileOutS = ',' + ','.join(f'{i:d}' for i in row_indices[:,0].tolist())
        print(' ================== fileOutS =', fileOutS, '=')







        
        if ezCon087Csv != 4:
            fileWrite.write(fileOutS + '\n')





        # free row_indices global memory
        row_indices = []
        row_indices = None
        del row_indices

        #print(' ================== col_indices.shape =', col_indices.shape)
        # col_indices.shape = (908, 256)
        #print(' ================== col_indices[:,0] =', col_indices[:,0])
        #print(' ================== col_indices[0,:] =', col_indices[0,:])

        #freqBin = 0
        #for n in range(antLen):
        #for freqBin in range(4):
        #print(' ================== fileFreqBinQty =', fileFreqBinQty)
        #print(' ================== freqBinQty =', freqBinQty)
        # write each line of freqBin coordinate (Y) and all values for each freqBin
        #for freqBin in range(fileFreqBinQty):
        _, antXTVTCsvLen = antXTVTCsv.shape
        for n in range(antXTVTCsvLen):
            #fileOutS = str(col_indices[n,0]) + ',' + np.array2string(antXTVTCsv[:,n], separator=',',max_line_width=1e9)[1:-1].replace(' ', '')
            #fileOutS = str(n) + '.,' + np.array2string(antXTVTCsv[:,n],separator=',',max_line_width=1e9)[1:-1].replace(' ', '')
            #fileOutS = str(n) + '.,' + np.array2string(antXTVTCsv[:,n],separator=',',max_line_width=1e13)[1:-1].replace(' ', '')
            fileOutS = str(n) + '.,' + ','.join(f'{i:.3g}' for i in antXTVTCsv[:,n].tolist())





            if ezCon087Csv == 4:
                fileOutS = ','.join(f'{i:.3g}' for i in antXTVTCsv[:,n].tolist())






            #print(' ================== fileOutS =', fileOutS, '=')
            fileWrite.write(fileOutS + '\n')
        fileWrite.write('\n')
        fileWrite.close()

        # free fileOutS global memory
        fileOutS = []
        fileOutS = None
        del fileOutS

        #if 1 < ezCon087Csv:
        if ezCon087Csv == 2:
            # for each sample, write one file into the output directory, each with fileFreqBinQty+2 lines
            #fileOutFreqs = np.linspace(fileFreqMin, fileFreqMax, num=fileFreqBinQty, endpoint=True)
            fileOutFreqs = np.linspace(freqAntMin, freqAntMax, num=freqBinQty, endpoint=True)
            az_el_S = f'{int(ezConOut[0, 7] * 10.):04d}_{int(ezConOut[0, 8] * 10.):04d}_'

            # create antXTVTCsv
            antXTVTCsv = antXTVT + 0.

            #if 1:
            #if 2 < ezCon087Csv:
            if ezCon087Csv == 3:
                # downsample antXTVTCsv ?
                antXTVTCsvLenMax = 500
                if antXTVTCsvLenMax < antXTVTCsvLen:
                    # downsample antXTVTCsv by averaging groupLen samples together
                    #   1999 // 500 = 3, so want groupLen as 4
                    #   2000 // 500 = 4, so want groupLen as 5
                    #   2001 // 500 = 4, so want groupLen as 5
                    groupLen = (antXTVTCsvLen // antXTVTCsvLenMax) + 1
                    print(' ================== groupLen =', groupLen)
                    antXTVTCsvIdx = 0
                    for n in range(0, antXTVTCsvLen, groupLen):
                        # downsample antXTVTCsv group by averaging groupLen samples together
                        antXTVTCsv[:,antXTVTCsvIdx] = np.mean(antXTVTCsv[:,n:n+groupLen], axis=1)
                        antXTVTCsvIdx += 1
                    # downsample antXTVTCsv remaining group by averaging the samples together
                    antXTVTCsv[:,antXTVTCsvIdx] = np.mean(antXTVTCsv[:,n:], axis=1)
                    antXTVTCsv = antXTVTCsv[:,:antXTVTCsvIdx+1]     # trim off excess samples

            _, antXTVTCsvLen = antXTVTCsv.shape   # number of samples
            print(' ================== antXTVTCsvLen =', antXTVTCsvLen)
            for n in range(antXTVTCsvLen):
                #dataTimeUtcStrThis = ezConOut[n, 0].iso
                dataTimeUtcStrThis = Time(ezConOut[n, 0], format='mjd', scale='utc').iso
                #print(' ================== dataTimeUtcStrThis =', dataTimeUtcStrThis)
                # '2023-02-09 00:01:20.000'
                # '01234567890123456789
                yymmdd_ = dataTimeUtcStrThis[2:4] + dataTimeUtcStrThis[5:7] + dataTimeUtcStrThis[8:10] + '_'
                hhmmss  = dataTimeUtcStrThis[11:13] + dataTimeUtcStrThis[14:16] + dataTimeUtcStrThis[17:19]

                if not n:
                    # use filenameOutBase from first sample to create output directory name
                    filenameOutBase = az_el_S + yymmdd_
                    # use yymmdd_hhmmss from first sample to create output directory name,
                    #   Aaaa_Eeee_YYMMDD_HHMMSS
                    #dirOut = filenameOutBase + hhmmss
                    dirOut = titleS.split()[0][:-4]
                    # if does not exist - create new dirOut directory
                    print('\n   dirOut =', dirOut)
                    if not os.path.exists(dirOut):
                        os.makedirs(dirOut)
                        print('   Created new   ', dirOut, '   output directory')
                    print()

                # for each sample, write one file into the output directory, each with fileFreqBinQty+2 lines
                #   Aaaa_Eeee_YYMMDD_HHMMSS/Aaaa_Eeee_YYMMDD_Nnnn.txt
                # output all freqBin of current sample
                fileWriteName = dirOut + os.path.sep + filenameOutBase + f'{n:04d}.txt'
                print(' ================== writing    ', plotNameCsv)
                fileWrite = open(fileWriteName, 'w')

                # The "IF Average Plugin" .txt output radio spectrum data file looks like,
                #   4/28/2021 6:43:57 AM  Counts:451000
                #   1419.205000000  0.322551440
                #   1419.207343750  0.320824318
                #   1419.209687500  0.318060119
                #   ...
                ######## 123456789    123456789

                # assemble and write out fileOutLineTop first line
                #   5/3/2020 0:00:05 AM  Counts:451000
                # yymmdd_       hhmmss
                # 01234567      0123456
                fileOutLineTop = f'{int(yymmdd_[2:4]):d}/{int(yymmdd_[4:6]):d}/{dataTimeUtcStrThis[0:4]}' \
                    + f' {int(hhmmss[0:2]):d}:{hhmmss[2:4]}:{hhmmss[4:6]}'
                if int(hhmmss[0:2]) <= 12:
                    fileOutLineTop += ' AM  Counts:451000\n'
                else:
                    fileOutLineTop += ' PM  Counts:451000\n'
                fileWrite.write(fileOutLineTop)

                # output all freqBin of current sample
                #for freqBin in range(fileFreqBinQty):
                for freqBin in range(freqBinQty):
                    #fileWrite.write(f'{fileOutFreqs[freqBin]:0.9f}  {float(fileOutPowersS[freqBin])/1e7:0.9f}\n')
                    fileWrite.write(f'{fileOutFreqs[freqBin]:0.9f}  {antXTVTCsv[freqBin, n]/1e7:0.9f}\n')
                fileWrite.write('\n')
                fileWrite.close()



def plotEzCon088antXTVTByFreqBinAvgFall():

    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global antXNameL                # list of strings
    global antXTVT                  # float 2d array

    global byFreqBinX               # float array
    global ezConDispGrid            # integer
    global dopplerSpanD2            # float
    global freqBinQty               # integer
    global freqCenter               # float

    plotCountdown -= 1

    if 88 not in ezConPlotRequestedL:
        return(1)

    #plotName = 'ezCon088antXTVTByFreqAvgFall.png'
    plotName = 'ezCon088' + antXNameL[0] + 'TVTByFreqAvgFall.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plt.clf()

    #antXTVTDLen = 100                           # maximum quantity of spectra after downsampling
    antXTVTDLenMax = 100                        # maximum quantity of spectra after downsampling
    antXTVTDLen = min(antLen, antXTVTDLenMax)   # quantity of spectra after downsampling
    colorPenSL = ['black', 'brown', 'red', 'orange', 'yellow', 'green', 'blue', 'violet', 'grey']

    # true downsampling, using the slicing notation of start:stop:step ("Decimation" ?)
    #antXTVTD = antXTVT[:, ::downsamplingStep]

    # downsampling by averaging
    # (// is floor division)
    downsamplingStep = antLen // antXTVTDLen

    antXTVTD = np.empty_like(antXTVT[:, :antXTVTDLen])
    for n in range(antXTVTDLen):
        downsamplingIndex = n * downsamplingStep
        antXTVTD[:, n] = np.mean(antXTVT[:, downsamplingIndex:downsamplingIndex+downsamplingStep], axis=1)

    for n in range(len(antXTVTD[0, :])):
        #plt.plot(byFreqBinX, [y - n * 0.01 for y in antXTVTD[:, n]], colorPenSL[n % 9], linewidth=0.5)
        plt.plot(byFreqBinX, [y - n * 0.1 for y in antXTVTD[:, n]], colorPenSL[n % 9], linewidth=0.5)

    plt.title(titleS)
    plt.grid(ezConDispGrid)

    #plt.xlabel('Doppler (MHz)')
    plt.xlabel(f'Doppler MHz from {freqCenter:.3f} MHz')
    plt.xlim(-dopplerSpanD2, dopplerSpanD2)

    #get current axes
    ax = plt.gca()
    # set the ticks to an empty list:
    ax.get_yaxis().set_ticks([])
    # hide just the axis text keeping the grid lines:
    ax.yaxis.set_ticklabels([])

    #plt.ylabel(antXNameL[1]+'TVT Spectra (time increasing up)')
    plt.ylabel(antXNameL[1]+'TVT Spectra, Downsampled by Averaging\nTime Increasing Down, downsamplingStep=' + str(downsamplingStep))

    if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
        os.remove(plotName)
    plt.savefig(plotName, dpi=300, bbox_inches='tight')



def plotEzCon096antXTVTMax2d():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global antXNameL                            # list of strings
    global antXTVT                              # float 2d array
    global antLenM1                             # integer
    global freqCenter                           # float

    plotCountdown -= 1

    #plotName = 'ezCon096antXTVTMax.png'
    plotName = 'ezCon096' + antXNameL[0] + 'TVTMax0.png'

    if 96 not in ezConPlotRequestedL:
        return(1)

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon2dSamples(plotName, antXTVT, 'Ant', antLenM1, antXNameL[1]+f'TVTMax:  Doppler MHz from {freqCenter:.3f} MHz', 1, 0)



def plotEzCon097antXTVTMax2d():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global antXNameL                            # list of strings
    global antXTVT                              # float 2d array
    global antLenM1                             # integer
    global freqCenter                           # float

    plotCountdown -= 1

    if 97 not in ezConPlotRequestedL:
        return(1)

    #plotName = 'ezCon097antXTVTMax.png'
    plotName = 'ezCon097' + antXNameL[0] + 'TVTMax.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    #plotEzCon2dSamples(plotName, antXTVT, 'Ant', antLenM1, 'AntXTVTMax', 1)
    plotEzCon2dSamples(plotName, antXTVT, 'Ant', antLenM1, antXNameL[1]+f'TVTMax:  Doppler MHz from {freqCenter:.3f} MHz', 1, 0)



def plotEzCon098antXTVTByFreqBinMaxFall():

    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global antXNameL                # list of strings
    global antXTVT                  # float 2d array

    global byFreqBinX               # float array
    global ezConDispGrid            # integer
    global dopplerSpanD2            # float
    global freqCenter               # float

    plotCountdown -= 1

    if 98 not in ezConPlotRequestedL:
        return(1)

    #plotName = 'ezCon098antXTVTByFreqMaxFall.png'
    plotName = 'ezCon098' + antXNameL[0] + 'TVTByFreqMaxFall.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plt.clf()

    #antXTVTMaxDLen = 100                                # quantity of spectra after downsampling
    antXTVTMaxDLenMax = 100                             # maximum quantity of spectra after downsampling
    antXTVTMaxDLen = min(antLen, antXTVTMaxDLenMax)     # quantity of spectra after downsampling

    colorPenSL = ['black', 'brown', 'red', 'orange', 'yellow', 'green', 'blue', 'violet', 'grey']

    # true downsampling, using the slicing notation of start:stop:step ("Decimation" ?)
    #antXTVTD = antXTVT[:, ::downsamplingStep]

    # downsampling by maximizing
    # (// is floor division)
    downsamplingStep = antLen // antXTVTMaxDLen

    antXTVTMaxD = np.empty_like(antXTVT[:, :antXTVTMaxDLen])
    for n in range(antXTVTMaxDLen):
        downsamplingIndex = n * downsamplingStep
        antXTVTMaxD[:, n] = np.max(antXTVT[:, downsamplingIndex:downsamplingIndex+downsamplingStep], axis=1)

    for n in range(len(antXTVTMaxD[0, :])):
        #plt.plot(byFreqBinX, [y - n * 0.01 for y in antXTVTMaxD[:, n]], colorPenSL[n % 9], linewidth=0.5)
        plt.plot(byFreqBinX, [y - n * 0.1 for y in antXTVTMaxD[:, n]], colorPenSL[n % 9], linewidth=0.5)

    plt.title(titleS)
    plt.grid(ezConDispGrid)

    #plt.xlabel('Doppler (MHz)')
    plt.xlabel(f'Doppler MHz from {freqCenter:.3f} MHz')
    plt.xlim(-dopplerSpanD2, dopplerSpanD2)

    #get current axes
    ax = plt.gca()
    # set the ticks to an empty list:
    ax.get_yaxis().set_ticks([])
    # hide just the axis text keeping the grid lines:
    ax.yaxis.set_ticklabels([])

    #plt.ylabel(antXNameL[1]+'TVTMax Spectra (time increasing up)')
    plt.ylabel(antXNameL[1]+'TVTMax Spectra, Downsampled by Maximizing\nTime Increasing Down, downsamplingStep=' + str(downsamplingStep))

    if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
        os.remove(plotName)
    plt.savefig(plotName, dpi=300, bbox_inches='tight')



# one plot for each ezConOut column #########################################################

def plotEzCon100timeUtcMjd():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ezConOut                             # float and int 2d array
    global antLen                               # integer

    plotCountdown -= 1

    if 100 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon100timeUtcMjd.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    timeUtcMjdMax = ezConOut[:, 0].max()
    timeUtcMjdMin = ezConOut[:, 0].min()
    print('                         timeUtcMjdMax =', timeUtcMjdMax)
    print('                         timeUtcMjdAvg =', ezConOut[:, 0].sum() / antLen)
    print('                         timeUtcMjdMin =', timeUtcMjdMin)
    timeUtcMjdMaxS = Time(timeUtcMjdMax, format='mjd', scale='utc').iso
    #'2021-09-19 04:58:48.000'
    # 012345678901234567890123
    timeUtcMjdMaxS = timeUtcMjdMaxS[:10] + '   ' + timeUtcMjdMaxS[11:]
    timeUtcMjdMinS = Time(timeUtcMjdMin, format='mjd', scale='utc').iso
    timeUtcMjdMinS = timeUtcMjdMinS[:10] + '   ' + timeUtcMjdMinS[11:]

    plotEzCon1dSamplesAnt(plotName, ezConOut[:, 0] - int(ezConOut[0, 0]), [], 'green',
        'Relative UTC Time in Modified Julian Day' \
            + '\n\nMinimum = ' + timeUtcMjdMinS \
            + '\n\nMaximum = ' + timeUtcMjdMaxS)



def plotEzCon101raH():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ezConOut                             # float and int 2d array

    plotCountdown -= 1

    if 101 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon101raH.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         raHMax =', ezConOut[:, 1].max())
    print('                         raHAvg =', np.mean(ezConOut[:, 1]))
    print('                         raHMin =', ezConOut[:, 1].min())

    plotEzCon1dSamplesAnt(plotName, ezConOut[:, 1], [0., 24.], 'green',
        'Right Ascension (hours)')



def plotEzCon102decDeg():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ezConOut                             # float and int 2d array

    plotCountdown -= 1

    if 102 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon102decDeg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         decDegMax =', ezConOut[:, 2].max())
    print('                         decDegAvg =', np.mean(ezConOut[:, 2]))
    print('                         decDegMin =', ezConOut[:, 2].min())

    plotEzCon1dSamplesAnt(plotName, ezConOut[:, 2], [-90., 90.], 'green',
        'Declination (degrees)')



def plotEzCon103gLatDeg():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ezConOut                             # float and int 2d array

    plotCountdown -= 1

    if 103 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon103gLatDeg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         gLatDegMax =', ezConOut[:, 3].max())
    print('                         gLatDegAvg =', np.mean(ezConOut[:, 3]))
    print('                         gLatDegMin =', ezConOut[:, 3].min())

    plotEzCon1dSamplesAnt(plotName, ezConOut[:, 3], [-90., 90.], 'green',
        'Galactic Latitude (degrees)')



def plotEzCon104gLonDeg():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ezConOut                             # float and int 2d array

    plotCountdown -= 1

    if 104 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon104gLonDeg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         gLonDegMax =', ezConOut[:, 4].max())
    print('                         gLonDegAvg =', np.mean(ezConOut[:, 4]))
    print('                         gLonDegMin =', ezConOut[:, 4].min())

    plotEzCon1dSamplesAnt(plotName, ezConOut[:, 4], [-180., 180.], 'green',
        'Galactic Longitude (degrees)')



def plotEzCon105vlsr():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ezConOut                             # float and int 2d array

    plotCountdown -= 1

    if 105 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon105vlsr.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         vlsrMax =', ezConOut[:, 5].max())
    print('                         vlsrAvg =', np.mean(ezConOut[:, 5]))
    print('                         vlsrMin =', ezConOut[:, 5].min())

    plotEzCon1dSamplesAnt(plotName, ezConOut[:, 5], [], 'green',
        'receding Velocity of Local Standard of Rest (VLSR) (km/s)')



def plotEzCon106count():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ezConOut                             # float and int 2d array

    plotCountdown -= 1

    if 106 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon106count.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon1dSamplesAnt(plotName, ezConOut[:, 6], [], 'green',
        'Count')



def plotEzCon110antAvg():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ezConOut                             # float and int 2d array

    plotCountdown -= 1

    if 110 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon110antAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         antAvgMax =', ezConOut[:, 10].max())
    print('                         antAvgAvg =', np.mean(ezConOut[:, 10]))
    print('                         antAvgMin =', ezConOut[:, 10].min())

    plotEzCon1dSamplesAnt(plotName, ezConOut[:, 10], [], 'blue',
        'Ant Antenna Spectrum Average')



def plotEzCon112refAvg():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ezConOut                             # float and int 2d array

    plotCountdown -= 1

    if 112 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon112refAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         refAvgMax =', ezConOut[:, 12].max())
    print('                         refAvgAvg =', np.mean(ezConOut[:, 12]))
    print('                         refAvgMin =', ezConOut[:, 12].min())

    plotEzCon1dSamplesAnt(plotName, ezConOut[:, 12], [], 'violet',
        'Reference Spectrum Average')



def plotEzCon114antBAvg():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ezConOut                             # float and int 2d array

    plotCountdown -= 1

    if 114 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon114antBAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         antBAvgMax =', ezConOut[:, 14].max())
    print('                         antBAvgAvg =', np.mean(ezConOut[:, 14]))
    print('                         antBAvgMin =', ezConOut[:, 14].min())

    plotEzCon1dSamplesAnt(plotName, ezConOut[:, 14], [], 'red',
        'AntB Spectrum Average')



def plotEzCon116antRBAvg():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ezConOut                             # float and int 2d array

    plotCountdown -= 1

    if 116 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon116antRBAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         antRBAvgMax =', ezConOut[:, 16].max())
    print('                         antRBAvgAvg =', np.mean(ezConOut[:, 16]))
    print('                         antRBAvgMin =', ezConOut[:, 16].min())

    plotEzCon1dSamplesAnt(plotName, ezConOut[:, 16], [], 'orange',
        'AntRB Spectrum Average')



def plotEzCon118antXTVTAvg():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ezConOut                             # float and int 2d array

    plotCountdown -= 1

    if 118 not in ezConPlotRequestedL:
        return(1)

    #plotName = 'ezCon118antXTVTAvg.png'
    plotName = 'ezCon118' + antXNameL[0] + 'TVTAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         antXTVTAvgMax =', ezConOut[:, 18].max())
    print('                         antXTVTAvgAvg =', np.mean(ezConOut[:, 18]))
    print('                         antXTVTAvgMin =', ezConOut[:, 18].min())

    plotEzCon1dSamplesAnt(plotName, ezConOut[:, 18], [], 'green',
        antXNameL[1]+'TVT Spectrum Average')



def plotEzCon111antMax():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ezConOut                             # float and int 2d array

    plotCountdown -= 1

    if 111 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon111antMax.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         antMaxMax =', ezConOut[:, 11].max())
    print('                         antMaxAvg =', np.mean(ezConOut[:, 11]))
    print('                         antMaxMin =', ezConOut[:, 11].min())

    plotEzCon1dSamplesAnt(plotName, ezConOut[:, 11], [], 'blue',
        'Ant Antenna Spectrum Maximum')



def plotEzCon113refMax():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ezConOut                             # float and int 2d array

    plotCountdown -= 1

    if 113 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon113refMax.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         refMaxMax =', ezConOut[:, 13].max())
    print('                         refMaxAvg =', np.mean(ezConOut[:, 13]))
    print('                         refMaxMin =', ezConOut[:, 13].min())

    plotEzCon1dSamplesAnt(plotName, ezConOut[:, 13], [], 'violet',
        'Reference Spectrum Maximum')



def plotEzCon115antBMax():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ezConOut                             # float and int 2d array

    plotCountdown -= 1

    if 115 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon115antBMax.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         antBMaxMax =', ezConOut[:, 15].max())
    print('                         antBMaxAvg =', np.mean(ezConOut[:, 15]))
    print('                         antBMaxMin =', ezConOut[:, 15].min())

    plotEzCon1dSamplesAnt(plotName, ezConOut[:, 15], [], 'red',
        'AntB Spectrum Maximum')



def plotEzCon117antRBMax():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ezConOut                             # float and int 2d array

    plotCountdown -= 1

    if 117 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon117antRBMax.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         antBRMaxMax =', ezConOut[:, 17].max())
    print('                         antBRMaxAvg =', np.mean(ezConOut[:, 17]))
    print('                         antBRMaxMin =', ezConOut[:, 17].min())

    plotEzCon1dSamplesAnt(plotName, ezConOut[:, 17], [], 'orange',
        'AntRB Spectrum Maximum')



def plotEzCon119antXTVTMax():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list
    global ezConPlotRequestedL                  # integer list

    global ezConOut                             # float and int 2d array

    plotCountdown -= 1

    if 119 not in ezConPlotRequestedL:
        return(1)

    #plotName = 'ezCon119antXTVTMax.png'
    plotName = 'ezCon119' + antXNameL[0] + 'TVTMax.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         antXTVTMaxMax =', ezConOut[:, 19].max())
    print('                         antXTVTMaxAvg =', np.mean(ezConOut[:, 19]))
    print('                         antXTVTMaxMin =', ezConOut[:, 19].min())

    plotEzCon1dSamplesAnt(plotName, ezConOut[:, 19], [], 'green',
        antXNameL[1]+'TVT Spectrum Maximum')



def plotEzCon191sigProg():
    # deletes antRawAvg, antBaseline, refRawAvg, antRAAvg, antRABaseline, antXTVAvg

    global fileNameLast             # string
    global plotCountdown            # integer
    global ezConPlotRequestedL      # integer list
    global ezConPlotRequestedL      # integer list
    global titleS                   # string
    global ezConDispGrid            # integer

    global xLabelSAnt               # string
    global xTickLocsAnt
    global xTickLabelsAnt

    global antLenM1                 # integer
    global rawIndex                 # integer array

    global ezConOut                 # float and int 2d array
    global antRawAvg                # float array
    global antBaseline              # float array
    global refRawAvg                # float array
    global antRAAvg                 # float array
    global antRABaseline            # float array
    global antXTVAvg                # float array       creation
    global antXNameL                # list of strings

    plotCountdown -= 1

    if 191 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon191sigProg.png'     # Signal Computation Progression

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plt.clf()


    # using gLatDeg, calculate a gain to fit it within -100 to +100 of its average
    print()
    gLatDegMax = ezConOut[:, 3].max()
    print('                         gLatDegMax =', gLatDegMax)
    gLatDegAvg = np.mean(ezConOut[:, 3])
    print('                         gLatDegAvg =', gLatDegAvg)
    gLatDegAvg = 0.                                                 # center trace on zero
    gLatDegMin = ezConOut[:, 3].min()
    print('                         gLatDegMin =', gLatDegMin)
    if gLatDegMax == gLatDegMin:            # gLatDeg will not vary when ezConAstroMath == 0
        gLatDegGain = 0.
    elif gLatDegAvg - gLatDegMin < gLatDegMax - gLatDegAvg:
        gLatDegGain = 93. / (gLatDegMax  - gLatDegAvg)
    else:
        gLatDegGain = 93. / (gLatDegAvg - gLatDegMin)

    gLatDegY = gLatDegGain * (ezConOut[:, 3] - gLatDegAvg)

    # thin black horizontal line on center
    plt.axhline(y = 0., linewidth=0.5, color='black')

    # max of 19 thin black vertical lines, one on each Galactic Latitude zero-crossing (19 looked good)
    gLatDegYPos = 0. < gLatDegY                                 # true if gLatDegY is positive
    gLatDegVertLineX = []                                       # list of x for vertical lines
    x = 0
    while len(gLatDegVertLineX) <= 19 and x < antLenM1:         # but max of 19 vertical lines
        if gLatDegYPos[x] != gLatDegYPos[x + 1]:                # if gLatDegY changes from/to positive
            gLatDegVertLineX.append(x)                          #   remember x
        x += 1
    # now either len(gLatDegVertLineX) = 19 + 1, or successfully studied all of gLatDegYPos
    if gLatDegVertLineX and len(gLatDegVertLineX) <= 19:        # if 1 to 19 vertical lines
        for x in gLatDegVertLineX:
            plt.axvline(x = x, linewidth=0.5, color='black')
            
    #plt.plot(gLatDegY, c='blue')
    plt.plot(gLatDegY, c='red')


    # If Ant samples are pluck filtered (ignored), this unplucked antRawAvg will no longer align vertically on this plot.
    # No good solution, because comparing antRawLen samples to a now shorter antLen.
    # But usually hard to see, because only plucking a few samples compared to a large number of antLen.

    # using antRawAvg, calculate a gain to fit it within -100 to +100 of its average
    antRawAvgMax = antRawAvg.max()
    print('                         antRawAvgMax =', antRawAvgMax)
    antRawAvgAvg = np.mean(antRawAvg)
    print('                         antRawAvgAvg =', antRawAvgAvg)
    antRawAvgMin = antRawAvg.min()
    print('                         antRawAvgMin =', antRawAvgMin)
    if antRawAvgMax == antRawAvgMin:        # antRawAvg may not vary
        antRawAvgGain = 0.
    elif antRawAvgAvg - antRawAvgMin < antRawAvgMax - antRawAvgAvg:
        antRawAvgGain = 93. / (antRawAvgMax  - antRawAvgAvg)
    else:
        antRawAvgGain = 93. / (antRawAvgAvg - antRawAvgMin)
    #plt.plot(antRawAvgGain * (antRawAvg - antRawAvgAvg) + 3200., c='blue')
    plt.plot(antRawAvgGain * (antRawAvg - antRawAvgAvg) + 200., c='blue')
    # free antRawAvg global memory
    antRawAvg = []
    antRawAvg = None
    del antRawAvg


    # using antAvg, calculate a gain to fit it within -100 to +100 of its average
    print()
    antAvgMax = ezConOut[:, 10].max()
    print('                         antAvgMax =', antAvgMax)
    antAvgAvg = np.mean(ezConOut[:, 10])
    print('                         antAvgAvg =', antAvgAvg)
    antAvgMin = ezConOut[:, 10].min()
    print('                         antAvgMin =', antAvgMin)
    if antAvgMax == antAvgMin:              # antAvg may not vary
        antAvgGain = 0.
    elif antAvgAvg - antAvgMin < antAvgMax - antAvgAvg:
        antAvgGain = 93. / (antAvgMax  - antAvgAvg)
    else:
        antAvgGain = 93. / (antAvgAvg - antAvgMin)
    #plt.plot(antAvgGain * (ezConOut[:, 10] - antAvgAvg) + 3000., c='blue')
    plt.plot(antAvgGain * (ezConOut[:, 10] - antAvgAvg) + 400., c='blue')


    # using antMax, calculate a gain to fit it within -100 to +100 of its average
    print()
    antMaxMax = ezConOut[:, 11].max()
    print('                         antMaxMax =', antMaxMax)
    antMaxAvg = np.mean(ezConOut[:, 11])
    print('                         antMaxAvg =', antMaxAvg)
    antMaxMin = ezConOut[:, 11].min()
    print('                         antMaxMin =', antMaxMin)
    if antMaxMax == antMaxMin:              # antMax may not vary
        antMaxGain = 0.
    elif antMaxAvg - antMaxMin < antMaxMax - antMaxAvg:
        antMaxGain = 93. / (antMaxMax  - antMaxAvg)
    else:
        antMaxGain = 93. / (antMaxAvg - antMaxMin)
    #plt.plot(antMaxGain * (ezConOut[:, 11] - antMaxAvg) + 2800., c='blue')
    plt.plot(antMaxGain * (ezConOut[:, 11] - antMaxAvg) + 600., c='blue')


    # using antBaseline, calculate a gain to fit it within -100 to +100 of its average
    print()
    antBaselineMax = antBaseline.max()
    print('                         antBaselineMax =', antBaselineMax)
    antBaselineAvg = np.mean(antBaseline)
    print('                         antBaselineAvg =', antBaselineAvg)
    antBaselineMin = antBaseline.min()
    print('                         antBaselineMin =', antBaselineMin)
    if antBaselineMax == antBaselineMin:    # antBaseline may not vary
        antBaselineGain = 0.
    elif antBaselineAvg - antBaselineMin < antBaselineMax - antBaselineAvg:
        antBaselineGain = 93. / (antBaselineMax  - antBaselineAvg)
    else:
        antBaselineGain = 93. / (antBaselineAvg - antBaselineMin)
    #plt.plot(antBaselineGain * (antBaseline - antBaselineAvg) + 2600., c='red')
    plt.plot(antBaselineGain * (antBaseline - antBaselineAvg) + 800., c='red')
    # free antBaseline global memory
    antBaseline = []
    antBaseline = None
    del antBaseline


    # using antBAvg, calculate a gain to fit it within -100 to +100 of its average
    print()
    antBAvgMax = ezConOut[:, 14].max()
    print('                         antBAvgMax =', antBAvgMax)
    antBAvgAvg = np.mean(ezConOut[:, 14])
    print('                         antBAvgAvg =', antBAvgAvg)
    antBAvgMin = ezConOut[:, 14].min()
    print('                         antBAvgMin =', antBAvgMin)
    if antBAvgMax == antBAvgMin:            # antBAvg may not vary
        antBAvgGain = 0.
    elif antBAvgAvg - antBAvgMin < antBAvgMax - antBAvgAvg:
        antBAvgGain = 93. / (antBAvgMax  - antBAvgAvg)
    else:
        antBAvgGain = 93. / (antBAvgAvg - antBAvgMin)
    #plt.plot(antBAvgGain * (ezConOut[:, 14] - antBAvgAvg) + 2400., c='red')
    plt.plot(antBAvgGain * (ezConOut[:, 14] - antBAvgAvg) + 1000., c='red')


    # using antBMax, calculate a gain to fit it within -100 to +100 of its average
    print()
    antBMaxMax = ezConOut[:, 15].max()
    print('                         antBMaxMax =', antBMaxMax)
    antBMaxAvg = np.mean(ezConOut[:, 15])
    print('                         antBMaxAvg =', antBMaxAvg)
    antBMaxMin = ezConOut[:, 15].min()
    print('                         antBMaxMin =', antBMaxMin)
    if antBMaxMax == antBMaxMin:            # antBMax may not vary
        antBMaxGain = 0.
    elif antBMaxAvg - antBMaxMin < antBMaxMax - antBMaxAvg:
        antBMaxGain = 93. / (antBMaxMax  - antBMaxAvg)
    else:
        antBMaxGain = 93. / (antBMaxAvg - antBMaxMin)
    #plt.plot(antBMaxGain * (ezConOut[:, 15] - antBMaxAvg) + 2200., c='red')
    plt.plot(antBMaxGain * (ezConOut[:, 15] - antBMaxAvg) + 1200., c='red')


    # using refRawAvg, calculate a gain to fit it within -100 to +100 of its average
    print()
    refRawAvgMax = refRawAvg.max()
    print('                         refRawAvgMax =', refRawAvgMax)
    refRawAvgAvg = np.mean(refRawAvg)
    print('                         refRawAvgAvg =', refRawAvgAvg)
    refRawAvgMin = refRawAvg.min()
    print('                         refRawAvgMin =', refRawAvgMin)
    if refRawAvgMax == refRawAvgMin:        # refRawAvg may not vary
        refRawAvgGain = 0.
    elif refRawAvgAvg - refRawAvgMin < refRawAvgMax - refRawAvgAvg:
        refRawAvgGain = 93. / (refRawAvgMax  - refRawAvgAvg)
    else:
        refRawAvgGain = 93. / (refRawAvgAvg - refRawAvgMin)
    #plt.plot(refRawAvgGain * (refRawAvg - refRawAvgAvg) + 2000., c='violet')
    plt.plot(refRawAvgGain * (refRawAvg - refRawAvgAvg) + 1400., c='violet')
    # free refRawAvg global memory
    refRawAvg = []
    refRawAvg = None
    del refRawAvg


    # using refAvg, calculate a gain to fit it within -100 to +100 of its average
    print()
    refAvgMax = ezConOut[:, 12].max()
    print('                         refAvgMax =', refAvgMax)
    refAvgAvg = np.mean(ezConOut[:, 12])
    print('                         refAvgAvg =', refAvgAvg)
    refAvgMin = ezConOut[:, 12].min()
    print('                         refAvgMin =', refAvgMin)
    if refAvgMax == refAvgMin:              # refAvg may not vary
        refAvgGain = 0.
    elif refAvgAvg - refAvgMin < refAvgMax - refAvgAvg:
        refAvgGain = 93. / (refAvgMax  - refAvgAvg)
    else:
        refAvgGain = 93. / (refAvgAvg - refAvgMin)
    #plt.plot(refAvgGain * (ezConOut[:, 12] - refAvgAvg) + 1800., c='violet')
    plt.plot(refAvgGain * (ezConOut[:, 12] - refAvgAvg) + 1600., c='violet')


    # using refMax, calculate a gain to fit it within -100 to +100 of its average
    print()
    refMaxMax = ezConOut[:, 13].max()
    print('                         refMaxMax =', refMaxMax)
    refMaxAvg = np.mean(ezConOut[:, 13])
    print('                         refMaxAvg =', refMaxAvg)
    refMaxMin = ezConOut[:, 13].min()
    print('                         refMaxMin =', refMaxMin)
    if refMaxMax == refMaxMin:              # refMax may not vary
        refMaxGain = 0.
    elif refMaxAvg - refMaxMin < refMaxMax - refMaxAvg:
        refMaxGain = 93. / (refMaxMax  - refMaxAvg)
    else:
        refMaxGain = 93. / (refMaxAvg - refMaxMin)
    #plt.plot(refMaxGain * (ezConOut[:, 13] - refMaxAvg) + 1600., c='violet')
    plt.plot(refMaxGain * (ezConOut[:, 13] - refMaxAvg) + 1800., c='violet')


    # using antRAAvg, calculate a gain to fit it within -100 to +100 of its average
    antRAAvgMax = max(antRAAvg)
    print('                         antRAAvgMax =', antRAAvgMax)
    antRAAvgAvg = np.mean(antRAAvg)
    print('                         antRAAvgAvg =', antRAAvgAvg)
    antRAAvgMin = min(antRAAvg)
    print('                         antRAAvgMin =', antRAAvgMin)
    if antRAAvgMax == antRAAvgMin:          # antRAAvg may not vary
        antRAAvgGain = 0.
    elif antRAAvgAvg - antRAAvgMin < antRAAvgMax - antRAAvgAvg:
        antRAAvgGain = 93. / (antRAAvgMax  - antRAAvgAvg)
    else:
        antRAAvgGain = 93. / (antRAAvgAvg - antRAAvgMin)
    #plt.plot(antRAAvgGain * (antRAAvg - antRAAvgAvg) + 1400., c='orange')
    plt.plot(antRAAvgGain * (antRAAvg - antRAAvgAvg) + 2000., c='orange')
    # free antRAAvg global memory
    antRAAvg = []
    antRAAvg = None
    del antRAAvg


    # using antRABaseline, calculate a gain to fit it within -100 to +100 of its average
    print()
    antRABaselineMax = antRABaseline.max()
    print('                         antRABaselineMax =', antRABaselineMax)
    antRABaselineAvg = np.mean(antRABaseline)
    print('                         antRABaselineAvg =', antRABaselineAvg)
    antRABaselineMin = antRABaseline.min()
    print('                         antRABaselineMin =', antRABaselineMin)
    if antRABaselineMax == antRABaselineMin:    # antRABaseline may not vary
        antRABaselineGain = 0.
    elif antRABaselineAvg - antRABaselineMin < antRABaselineMax - antRABaselineAvg:
        antRABaselineGain = 93. / (antRABaselineMax  - antRABaselineAvg)
    else:
        antRABaselineGain = 93. / (antRABaselineAvg - antRABaselineMin)
    #plt.plot(antRABaselineGain * (antRABaseline - antRABaselineAvg) + 1200., c='orange')
    plt.plot(antRABaselineGain * (antRABaseline - antRABaselineAvg) + 2200., c='orange')
    # free antRABaseline global memory
    antRABaseline = []
    antRABaseline = None
    del antRABaseline


    # using antRBAvg, calculate a gain to fit it within -100 to +100 of its average
    print()
    antRBAvgMax = ezConOut[:, 16].max()
    print('                         antRBAvgMax =', antRBAvgMax)
    antRBAvgAvg = np.mean(ezConOut[:, 16])
    print('                         antRBAvgAvg =', antRBAvgAvg)
    antRBAvgMin = ezConOut[:, 16].min()
    print('                         antRBAvgMin =', antRBAvgMin)
    if antRBAvgMax == antRBAvgMin:          # antRBAvg may not vary
        antRBAvgGain = 0.
    elif antRBAvgAvg - antRBAvgMin < antRBAvgMax - antRBAvgAvg:
        antRBAvgGain = 93. / (antRBAvgMax  - antRBAvgAvg)
    else:
        antRBAvgGain = 93. / (antRBAvgAvg - antRBAvgMin)
    #plt.plot(antRBAvgGain * (ezConOut[:, 16] - antRBAvgAvg) + 1000., c='orange')
    plt.plot(antRBAvgGain * (ezConOut[:, 16] - antRBAvgAvg) + 2400., c='orange')


    # using antRBMax, calculate a gain to fit it within -100 to +100 of its average
    print()
    antRBMaxMax = ezConOut[:, 17].max()
    print('                         antRBMaxMax =', antRBMaxMax)
    antRBMaxAvg = np.mean(ezConOut[:, 17])
    print('                         antRBMaxAvg =', antRBMaxAvg)
    antRBMaxMin = ezConOut[:, 17].min()
    print('                         antRBMaxMin =', antRBMaxMin)
    if antRBMaxMax == antRBMaxMin:          # antRBMax may not vary
        antRBMaxGain = 0.
    elif antRBMaxAvg - antRBMaxMin < antRBMaxMax - antRBMaxAvg:
        antRBMaxGain = 93. / (antRBMaxMax  - antRBMaxAvg)
    else:
        antRBMaxGain = 93. / (antRBMaxAvg - antRBMaxMin)
    #plt.plot(antRBMaxGain * (ezConOut[:, 17] - antRBMaxAvg) + 800., c='orange')
    plt.plot(antRBMaxGain * (ezConOut[:, 17] - antRBMaxAvg) + 2600., c='orange')


    # using antXTVAvg, calculate a gain to fit it within -100 to +100 of its average
    print()
    antXTVAvgMax = antXTVAvg.max()
    print('                         antXTVAvgMax =', antXTVAvgMax)
    antXTVAvgAvg = np.mean(antXTVAvg)
    print('                         antXTVAvgAvg =', antXTVAvgAvg)
    antXTVAvgMin = antXTVAvg.min()
    print('                         antXTVAvgMin =', antXTVAvgMin)
    if antXTVAvgMax == antXTVAvgMin:        # antXTVAvg may not vary
        antXTVAvgGain = 0.
    elif antXTVAvgAvg - antXTVAvgMin < antXTVAvgMax - antXTVAvgAvg:
        antXTVAvgGain = 93. / (antXTVAvgMax  - antXTVAvgAvg)
    else:
        antXTVAvgGain = 93. / (antXTVAvgAvg - antXTVAvgMin)
    #plt.plot(antXTVAvgGain * (antXTVAvg - antXTVAvgAvg) + 600., c='green')
    plt.plot(antXTVAvgGain * (antXTVAvg - antXTVAvgAvg) + 2800., c='green')
    # free antXTVAvg global memory
    antXTVAvg = []
    antXTVAvg = None
    del antXTVAvg


    # using antXTVTAvg, calculate a gain to fit it within -100 to +100 of its average
    print()
    antXTVTAvgMax = ezConOut[:, 18].max()
    print('                         antXTVTAvgMax =', antXTVTAvgMax)
    antXTVTAvgAvg = np.mean(ezConOut[:, 18])
    print('                         antXTVTAvgAvg =', antXTVTAvgAvg)
    antXTVTAvgMin = ezConOut[:, 18].min()
    print('                         antXTVTAvgMin =', antXTVTAvgMin)
    if antXTVTAvgMax == antXTVTAvgMin:      # antXTVTAvg may not vary
        antXTVTAvgGain = 0.
    elif antXTVTAvgAvg - antXTVTAvgMin < antXTVTAvgMax - antXTVTAvgAvg:
        antXTVTAvgGain = 93. / (antXTVTAvgMax  - antXTVTAvgAvg)
    else:
        antXTVTAvgGain = 93. / (antXTVTAvgAvg - antXTVTAvgMin)
    #plt.plot(antXTVTAvgGain * (ezConOut[:, 18] - antXTVTAvgAvg) + 400., c='green')
    plt.plot(antXTVTAvgGain * (ezConOut[:, 18] - antXTVTAvgAvg) + 3000., c='green')


    # using antXTVTMax, calculate a gain to fit it within -100 to +100 of its average
    print()
    antXTVTMaxMax = ezConOut[:, 19].max()
    print('                         antXTVTMaxMax =', antXTVTMaxMax)
    antXTVTMaxAvg = np.mean(ezConOut[:, 19])
    print('                         antXTVTMaxAvg =', antXTVTMaxAvg)
    antXTVTMaxMin = ezConOut[:, 19].min()
    print('                         antXTVTMaxMin =', antXTVTMaxMin)
    if antXTVTMaxMax == antXTVTMaxMin:      # antXTVTMax may not vary
        antXTVTMaxGain = 0.
    elif antXTVTMaxAvg - antXTVTMaxMin < antXTVTMaxMax - antXTVTMaxAvg:
        antXTVTMaxGain = 93. / (antXTVTMaxMax  - antXTVTMaxAvg)
    else:
        antXTVTMaxGain = 93. / (antXTVTMaxAvg - antXTVTMaxMin)
    #plt.plot(antXTVTMaxGain * (ezConOut[:, 19] - antXTVTMaxAvg) + 200., c='green')
    plt.plot(antXTVTMaxGain * (ezConOut[:, 19] - antXTVTMaxAvg) + 3200., c='green')


    plt.title(titleS)
    plt.grid(ezConDispGrid)

    if not len(xTickLocsAnt):
        xTickLocsAnt, xTickLabelsAnt = plt.xticks()
        # dataTimeUtcStrThis = dataTimeUtc[n].iso
        # https://docs.astropy.org/en/stable/time/#id3
        # iso   TimeISO   ‘2000-01-01 00:00:00.000’
        #                  01234567890123456
        # may remove silly values, and shorten lists, so best to process indices in decreasing order
        for i in range(len(xTickLocsAnt) - 1)[::-1]:
            xTickLocsAntIInt = int(xTickLocsAnt[i])
            if 0 <= xTickLocsAntIInt and xTickLocsAntIInt <= antLenM1:
                if ezConRawDispIndex:
                    xTickLabelsAnt[i] = f'{rawIndex[xTickLocsAntIInt]:,}  {xTickLocsAntIInt:,}  ' \
                        + dataTimeUtc[xTickLocsAntIInt].iso[11:16]
                else:
                    xTickLabelsAnt[i] = f'{xTickLocsAntIInt:,}  ' \
                        + dataTimeUtc[xTickLocsAntIInt].iso[11:16]
            else:       # remove silly values
                xTickLocsAnt = np.delete(xTickLocsAnt, i)
                xTickLabelsAnt = np.delete(xTickLabelsAnt, i)
        # fill xTickLabelsAnt[-1], samplesQtyM1 is usually less than xTickLocsAnt[-1]
        xTickLocsAnt[-1] = antLenM1
        if 0.975 < xTickLocsAnt[-2] / antLenM1:   # if last label overlaps, blank it
            xTickLabelsAnt[-1] = ''
        elif ezConRawDispIndex:
            xTickLabelsAnt[-1] = f'{rawIndex[-1]:,}  {antLenM1:,}  ' \
                + dataTimeUtc[-1].iso[11:16]
        else:
            xTickLabelsAnt[-1] = f'{antLenM1:,}  ' + dataTimeUtc[-1].iso[11:16]
        if ezConRawDispIndex:
            xLabelSAnt = \
                f'Raw Sample Number + Ant Sample Number (last={antLenM1:,}) with UTC Hour:Min (last=' \
                + dataTimeUtc[-1].iso[11:16] + ')'
        else:
            xLabelSAnt = f'Ant Sample Number (last={antLenM1:,}) with UTC Hour:Min (last=' \
                + dataTimeUtc[-1].iso[11:16] + ')'
    plt.xticks(xTickLocsAnt, xTickLabelsAnt, rotation=45, ha='right', rotation_mode='anchor')
    plt.xlabel(xLabelSAnt)
    plt.xlim(0, antLenM1)

    plt.ylabel('Signal Computation Progression\nfrom AntRaw to '+antXNameL[1]+'TVTMax')
    plt.ylim(-150, 3350)
    #     3200.,     3000., 2800.,    2600.,    2400.,  2200.,     2000.,    1800., 1600.,
    #     1400.,   1200.,      1000.,   800.,       600.,     400.,      200.,         0.],
    plt.yticks([ \
        200.,      400.,  600.,     800.,     1000.,  1200.,     1400.,    1600., 1800.,
        2000.,   2200.,      2400.,   2600.,      2800.,             3000.,
        3200.,                 0.],
        ['AntRaw', 'Ant', 'AntMax', 'AntBas', 'AntB', 'AntBMax', 'RefRaw', 'Ref', 'RefMax',
        'AntRA', 'AntRABas', 'AntRB', 'AntRBMax', antXNameL[1]+'TV', antXNameL[1]+'TVT',
        antXNameL[1]+'TVTMax', 'GLat'])
    #    'AntRA', 'AntRABas', 'AntRB', 'AntRBMax', 'AntXTV', 'AntXTVT', 'AntXTVTMax', 'GLatDeg'])

    if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
        os.remove(plotName)
    plt.savefig(plotName, dpi=300, bbox_inches='tight')



def plotEzCon107azimuth():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    #global azimuthDeg                           # float array
    global ezConOut                             # float and int 2d array

    plotCountdown -= 1

    if 107 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon107azimuth.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    azimuthDeg = ezConOut[:, 7]
    print('                         azimuthDegMax =', azimuthDeg.max())
    print('                         azimuthDegAvg =', np.mean(azimuthDeg))
    print('                         azimuthDegMin =', azimuthDeg.min())

    plotEzCon1dSamplesAnt(plotName, azimuthDeg, [], 'green',
        'Azimuth (Degrees)')



#def plotEzCon199elevation():
def plotEzCon108elevation():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ezConOut                             # float and int 2d array

    plotCountdown -= 1

    if 108 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon108elevation.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    elevationDeg = ezConOut[:, 8]
    print('                         elevationDegMax =', elevationDeg.max())
    print('                         elevationDegAvg =', np.mean(elevationDeg))
    print('                         elevationDegMin =', elevationDeg.min())

    plotEzCon1dSamplesAnt(plotName, elevationDeg, [], 'green',
        'Elevation (Degrees)')



def plotEzCon109antXTVTCmDop():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ezConOut                             # float and int 2d array

    plotCountdown -= 1

    if 109 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon109antXTVTCmDop.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    antXTVTCmDop = ezConOut[:, 9]

    print('                         antXTVTCmDopMax =', antXTVTCmDop.max())
    print('                         antXTVTCmDopAvg =', np.mean(antXTVTCmDop))
    print('                         antXTVTCmDopMin =', antXTVTCmDop.min())

    plotEzCon1dSamplesAnt(plotName, antXTVTCmDop, [], 'green',
        'AntXTVT Center of Mass of Doppler (MHz)')



def plotEzCon200rawRawAvg():

    global raw                      # float 2d array

    global rawLenM1                 # integer

    global fileNameLast             # string
    global plotCountdown                # integer
    global titleS                   # string
    global ezConDispGrid            # integer
    global dataTimeUtc              # 'astropy.time.core.Time' object array

    global xLabelSRaw               # string        creation
    global xTickLocsRaw             # float array   creation
    global xTickLabelsRaw           # string list   creation
    global ezConPlotRequestedL      # integer list

    plotCountdown -= 1

    if 200 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon200rawRawAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    # create rawAvg array: for each raw sample, the average of that sample's spectrum values
    rawAvg = np.mean(raw, axis=0)
    print('                         rawRawAvgMax =', rawAvg.max())
    print('                         rawRawAvgAvg =', np.mean(rawAvg))
    print('                         rawRawAvgMin =', rawAvg.min())

    plt.clf()

    # plot all raw data as connected green dots
    plt.plot(rawAvg, 'go-')

    plt.title(titleS)
    plt.grid(ezConDispGrid)

    if ezConRawSamplesUseL:
        xLabelSRaw = f'RawRaw Sample Number (last={rawLenM1 + ezConRawSamplesUseL[0]:,})' \
            + ' with UTC Hour:Min (last=' + dataTimeUtc[-1].iso[11:16] + ')'
    else:
        xLabelSRaw = f'RawRaw Sample Number (last={rawLenM1:,})' \
            + ' with UTC Hour:Min (last=' + dataTimeUtc[-1].iso[11:16] + ')'
    plt.xlabel(xLabelSRaw)
    plt.xlim(0, rawLenM1)
    xTickLocsRaw, xTickLabelsRaw = plt.xticks()
    # dataTimeUtcStrThis = dataTimeUtc[n].iso
    # https://docs.astropy.org/en/stable/time/#id3
    # iso   TimeISO   ‘2000-01-01 00:00:00.000’
    #                  01234567890123456
    if ezConRawSamplesUseL:
        for i in range(len(xTickLocsRaw) - 1):
            xTickLabelsRaw[i] = f'{int(xTickLocsRaw[i] + ezConRawSamplesUseL[0]):,}  ' + \
                dataTimeUtc[int(xTickLocsRaw[i])].iso[11:16]
    else:
        for i in range(len(xTickLocsRaw) - 1):
            xTickLabelsRaw[i] = f'{int(xTickLocsRaw[i]):,}  ' + \
                dataTimeUtc[int(xTickLocsRaw[i])].iso[11:16]
    xTickLocsRaw[-1] = rawLenM1
    if 0.975 < xTickLocsRaw[-2] / rawLenM1:   # if last label overlaps, blank it
        xTickLabelsRaw[-1] = ''
    elif ezConRawSamplesUseL:
        xTickLabelsRaw[-1] = f'{rawLenM1 + ezConRawSamplesUseL[0]:,}  ' + dataTimeUtc[-1].iso[11:16]
    else:
        xTickLabelsRaw[-1] = f'{rawLenM1:,}  ' + dataTimeUtc[-1].iso[11:16]
    plt.xticks(xTickLocsRaw, xTickLabelsRaw, rotation=45, ha='right', rotation_mode='anchor')

    plt.ylabel('RawRaw Spectrum Average' \
        + '\n\n ezConRawSamplesUseL = ' + str(ezConRawSamplesUseL))

    if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
        os.remove(plotName)
    plt.savefig(plotName, dpi=300, bbox_inches='tight')



def plotEzCon201ArawAvg():

    global raw                      # float 2d array

    global rawLenM1                 # integer

    global fileNameLast             # string
    global plotCountdown                # integer
    global titleS                   # string
    global ezConDispGrid            # integer
    global dataTimeUtc              # 'astropy.time.core.Time' object array

    global xLabelSRaw               # string        creation
    global xTickLocsRaw             # float array   creation
    global xTickLabelsRaw           # string list   creation
    global ezConPlotRequestedL      # integer list

    plotCountdown -= 1

    if 201 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon201ArawAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    # create rawAvg array: for each raw sample, the average of that sample's spectrum values
    rawAvg = np.mean(raw, axis=0)
    print('                         rawAvgMax =', rawAvg.max())
    print('                         rawAvgAvg =', np.mean(rawAvg))
    print('                         rawAvgMin =', rawAvg.min())

    plt.clf()

    # plot all raw data as connected green dots
    plt.plot(rawAvg, 'go-')

    plt.title(titleS)
    plt.grid(ezConDispGrid)

    if ezConRawSamplesUseL:
        xLabelSRaw = f'Raw Sample Number (last={rawLenM1 + ezConRawSamplesUseL[0]:,})' \
            + ' with UTC Hour:Min (last=' + dataTimeUtc[-1].iso[11:16] + ')'
    else:
        xLabelSRaw = f'Raw Sample Number (last={rawLenM1:,})' \
            + ' with UTC Hour:Min (last=' + dataTimeUtc[-1].iso[11:16] + ')'
    plt.xlabel(xLabelSRaw)
    plt.xlim(0, rawLenM1)
    xTickLocsRaw, xTickLabelsRaw = plt.xticks()
    # dataTimeUtcStrThis = dataTimeUtc[n].iso
    # https://docs.astropy.org/en/stable/time/#id3
    # iso   TimeISO   ‘2000-01-01 00:00:00.000’
    #                  01234567890123456
    if ezConRawSamplesUseL:
        for i in range(len(xTickLocsRaw) - 1):
            xTickLabelsRaw[i] = f'{int(xTickLocsRaw[i] + ezConRawSamplesUseL[0]):,}  ' + \
                dataTimeUtc[int(xTickLocsRaw[i])].iso[11:16]
    else:
        for i in range(len(xTickLocsRaw) - 1):
            xTickLabelsRaw[i] = f'{int(xTickLocsRaw[i]):,}  ' + \
                dataTimeUtc[int(xTickLocsRaw[i])].iso[11:16]
    xTickLocsRaw[-1] = rawLenM1
    if 0.975 < xTickLocsRaw[-2] / rawLenM1:   # if last label overlaps, blank it
        xTickLabelsRaw[-1] = ''
    elif ezConRawSamplesUseL:
        xTickLabelsRaw[-1] = f'{rawLenM1 + ezConRawSamplesUseL[0]:,}  ' + dataTimeUtc[-1].iso[11:16]
    else:
        xTickLabelsRaw[-1] = f'{rawLenM1:,}  ' + dataTimeUtc[-1].iso[11:16]
    plt.xticks(xTickLocsRaw, xTickLabelsRaw, rotation=45, ha='right', rotation_mode='anchor')

    plt.ylabel('Raw Spectrum Average' \
        + '\n\n ezConRawSamplesUseL = ' + str(ezConRawSamplesUseL))

    if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
        os.remove(plotName)
    plt.savefig(plotName, dpi=300, bbox_inches='tight')



def plotEzCon201EsampleRefAgain():

    #global raw                      # float 2d array
    #global raw                      # float 2d array
    #global refRaw                   # float 2d array

    global sampleRefAgain           # float 2d array
    #global maskRawRef               # float 2d array

    global rawLen                   # integer
    #global antLen                   # integer

    global xLabelSRaw               # string
    global xTickLocsRaw             # float array
    global xTickLabelsRaw           # string list

    if 201 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon201EsampleRefAgain.png'

    print()
    print('   plotting ' + plotName + ' ================================')

    plt.clf()

    print('                         sampleRefAgainMax =', sampleRefAgain.max())
    #print('                         sampleRefAgain =', sampleRefAgain.sum() / rawLen)
    sampleRefAgainSum = sampleRefAgain.sum()
    print('                         sampleRefAgainAvg =', sampleRefAgainSum / rawLen)
    print('                         sampleRefAgainMin =', sampleRefAgain.min())

    plt.plot(sampleRefAgain, 'bo-')

    plt.title(titleS)
    plt.grid(ezConDispGrid)

    plt.xlabel(xLabelSRaw)
    plt.xlim(0, rawLenM1)
    plt.xticks(xTickLocsRaw, xTickLabelsRaw, rotation=45, ha='right', rotation_mode='anchor')

    #plt.ylabel('sampleRefAgain' \
    #    + '\n\n sampleRefAgain = ' + str(int(100. * sampleRefAgain.sum() / rawLen)) + ' %')
    plt.ylabel('sampleRefAgain = ' + str(sampleRefAgainSum) \
        + ' = ' + str(int(100. * sampleRefAgainSum / rawLen)) + ' %' \
        + '\n\n rawLen = ' + str(rawLen))
    #plt.ylim(-90, 90)

    if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
        os.remove(plotName)
    plt.savefig(plotName, dpi=300, bbox_inches='tight')



def plotEzCon201GrawAntRef():
    # plot rawAvg, then color Ant and Ref

    global fileNameLast             # string
    global plotCountdown            # integer
    global raw                      # float 2d array

    global maskRawAnt               # float 2d array
    global maskRawRef               # float 2d array

    global rawLenM1                 # integer
    global antLen                   # integer

    global xLabelSRaw               # string
    global xTickLocsRaw             # float array
    global xTickLabelsRaw           # string list

    plotCountdown -= 1

    if 201 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon201GrawAntRef.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    # create rawAvg array: for each raw sample, the average of that sample's spectrum values
    rawAvg = np.mean(raw, axis=0)
    print('                         rawAvgMax =', rawAvg.max())
    print('                         rawAvgAvg =', np.mean(rawAvg))
    print('                         rawAvgMin =', rawAvg.min())

    # create rawAvgAnt as the raw samples, but only where sample is an ANT
    # start with rawAvg
    rawAvgAnt = rawAvg + 0.
    # so as not to plot, where not an ANT sample, make np.nan
    rawAvgAnt[np.logical_not(maskRawAnt)] = np.nan
    print()
    print('                         rawAvgAntMax =', np.nanmax(rawAvgAnt))
    print('                         rawAvgAntAvg =', np.nansum(rawAvgAnt) / antLen)
    print('                         rawAvgAntMin =', np.nanmin(rawAvgAnt))

    # create rawAvgRef as the raw samples, but only where sample is a REF
    # start with rawAvg
    rawAvgRef = rawAvg + 0.
    # so as not to plot, where not a REF sample, make np.nan
    rawAvgRef[np.logical_not(maskRawRef)] = np.nan
    refQty = sum((maskRawRef + 0))      # might be different than antLen
    print(f'   refQty = {refQty:,}')
    if refQty:      # avoid division by zero
        print('                         rawAvgRefMax =', np.nanmax(rawAvgRef))
        print('                         rawAvgRefAvg =', np.nansum(rawAvgRef) / refQty)
        print('                         rawAvgRefMin =', np.nanmin(rawAvgRef))

    plt.clf()

    # plot all raw data as connected green dots
    plt.plot(rawAvg, 'go-')

    #print('             rawAvgRef =', rawAvgRef)
    # rawAvgRef = [ 1.15663404  nan  1.1568708  ...  1.13110415  nan  1.13264854 ]
    #print('             rawAvgAnt =', rawAvgAnt)
    # rawAvgAnt = [ nan  0.95682753  nan  ...  nan  0.94020758  nan ]
    if 0:
        # ref violet dots unconnected and ant blue dots unconnected
        # plot just ref data as violet dots
        plt.plot(rawAvgRef, 'o', c='violet')

        # plot just ant data as blue dots
        plt.plot(rawAvgAnt, 'bo')

    else:
        # ref violet dots connected and ant blue dots connected
        # create rawAvgRefNoGap like rawAvgRef, but without np.nan values
        rawAvgRefNoGap = rawAvgRef + 0
        if np.isnan(rawAvgRefNoGap[0]):
            # copy from future by 1
            rawAvgRefNoGap[0] = rawAvgRefNoGap[1]
        for i in range(1, rawLen):
            if np.isnan(rawAvgRefNoGap[i]):
                # copy from past by 1
                rawAvgRefNoGap[i] = rawAvgRefNoGap[i-1]
        # plot rawAvgRefNoGap as connected violet dots
        #plt.plot(rawAvgRefNoGap, 'vo-')
        plt.plot(rawAvgRefNoGap, 'o-', c='violet')

        # create rawAvgAntNoGap like rawAvgAnt, but without np.nan values
        rawAvgAntNoGap = rawAvgAnt + 0
        if np.isnan(rawAvgAntNoGap[0]):
            # copy from future by 1
            rawAvgAntNoGap[0] = rawAvgAntNoGap[1]
        for i in range(1, rawLen):
            if np.isnan(rawAvgAntNoGap[i]):
                # copy from past by 1
                rawAvgAntNoGap[i] = rawAvgAntNoGap[i-1]
        # plot rawAvgAntNoGap as connected blue dots
        plt.plot(rawAvgAntNoGap, 'bo-')

    plt.title(titleS)
    plt.grid(ezConDispGrid)

    plt.xlabel(xLabelSRaw)
    plt.xlim(0, rawLenM1)
    plt.xticks(xTickLocsRaw, xTickLabelsRaw, rotation=45, ha='right', rotation_mode='anchor')

    plt.ylabel('Last Raw Spectrum Average   (Ant = blue, Ref = violet)'
        + '\n\n ezConRawSamplesUseL = ' + str(ezConRawSamplesUseL))

    if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
        os.remove(plotName)
    plt.savefig(plotName, dpi=300, bbox_inches='tight')



def plotEzCon201HtimeUtcMjdDBetweenRaw():

    global fileNameLast             # string
    global plotCountdown            # integer
    global dataTimeUtc              # 'astropy.time.core.Time' object array

    global raw                      # float 2d array
    global rawLen                   # integer

    global xLabelSRaw               # string
    global xTickLocsRaw             # float array
    global xTickLabelsRaw           # string list

    plotCountdown -= 1

    if 201 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon201HtimeUtcMjdDBetweenRaw.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plt.clf()

    # 24 * 60 * 60 = 86400 seconds in one MJD Day
    timeUtcMjdDBetweenRaw = np.empty(rawLen)
    for i in range(rawLen):
        timeUtcMjdDBetweenRaw[i] = dataTimeUtc[i].mjd
    timeUtcMjdDBetweenRaw = (timeUtcMjdDBetweenRaw[1:] - timeUtcMjdDBetweenRaw[:-1]) * 86400
    timeUtcMjdDBetweenRawAvg = int(np.mean(timeUtcMjdDBetweenRaw) + 0.5)
    timeUtcMjdDBetweenRawSpan \
        = int((timeUtcMjdDBetweenRaw.max() - timeUtcMjdDBetweenRaw.min()) + 0.5)

    plt.plot(timeUtcMjdDBetweenRaw, 'go-')

    plt.title(titleS)
    plt.grid(ezConDispGrid)

    plt.xlim(0, rawLenM1 - 1)

    plt.ylabel('Seconds Between ' + str(rawLen) + ' Raw Samples' \
        + '\n\nMedian=' + str(int(np.median(timeUtcMjdDBetweenRaw) + 0.5)) \
        + '  Mean=' + str(timeUtcMjdDBetweenRawAvg) \
        + '  Span=' + str(timeUtcMjdDBetweenRawSpan))
    # truncate y axis if too large
    axes = plt.gca()
    y_min, y_max = axes.get_ylim()
    if 400 < y_max - y_min:
        plt.ylim(0, 400)

    if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
        os.remove(plotName)
    plt.savefig(plotName, dpi=300, bbox_inches='tight')



def plotEzCon201ItimeUtcMjdDBetweenAntRaw():

    global fileNameLast             # string
    global plotCountdown            # integer
    global dataTimeUtc              # 'astropy.time.core.Time' object array

    global rawLen                   # integer
    global antLen                   # integer
    global antLenM1                 # integer

    global maskRawAnt               # Boolean array

    plotCountdown -= 1

    timeUtcMjdRaw = np.empty(rawLen)
    for i in range(rawLen):
        timeUtcMjdRaw[i] = dataTimeUtc[i].mjd       # convert to MJD numbers

    if 201 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon201ItimeUtcMjdDBetweenAntRaw.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plt.clf()

    # mask off all but ANT samples
    timeUtcMjdRawAnt = timeUtcMjdRaw[maskRawAnt]

    # seconds per MJD day = 24 * 60 * 60 = 86400
    timeUtcMjdDBetweenRawAnt = (timeUtcMjdRawAnt[1:] - timeUtcMjdRawAnt[:-1]) * 86400.
    timeUtcMjdDBetweenRawAntAvg = int((timeUtcMjdDBetweenRawAnt.sum() / antLenM1) + 0.5)
    timeUtcMjdDBetweenRawAntSpan \
        = int((timeUtcMjdDBetweenRawAnt.max() - timeUtcMjdDBetweenRawAnt.min()) + 0.5)

    plt.plot(timeUtcMjdDBetweenRawAnt, 'bo-')

    plt.title(titleS)
    plt.grid(ezConDispGrid)

    plt.xlim(0, antLenM1 - 1)

    plt.ylabel('Seconds Between ' + str(antLen) + ' AntRaw Samples' \
        + '\n\nMedian=' + str(int(np.median(timeUtcMjdDBetweenRawAnt) + 0.5)) \
        + '  Mean=' + str(timeUtcMjdDBetweenRawAntAvg) \
        + '  Span=' + str(timeUtcMjdDBetweenRawAntSpan))

    if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
        os.remove(plotName)
    plt.savefig(plotName, dpi=300, bbox_inches='tight')



def plotEzCon201JtimeUtcMjdDBetweenRefRaw():

    global fileNameLast             # string
    global plotCountdown            # integer
    global dataTimeUtc              # 'astropy.time.core.Time' object array

    global rawLen                   # integer

    global maskRawRef               # Boolean array

    plotCountdown -= 1

    if 201 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon201JtimeUtcMjdDBetweenRefRaw.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plt.clf()

    refQty = np.sum((maskRawRef + 0))          # might be different than antLen
    if refQty < 2:
        print()
        print()
        print()
        print()
        print()
        print(' ========== Warning: Can not create this plot with less than 2 REF samples')
        print()
        print()
        print()
        print()
        print()

        plt.plot([0, 1], [0, 0], 'o-', c='violet')

        plt.xlim(0, 1)
        plt.ylim(0, 1)

        plt.ylabel('Seconds Between ' + str(refQty) + ' RefRaw Samples\n\n')

        plt.text(0, 0.5, '      Warning: Can not create this plot with less than 2 Ref samples')
        
    else:
        timeUtcMjdRaw = np.empty(rawLen)
        for i in range(rawLen):
            timeUtcMjdRaw[i] = dataTimeUtc[i].mjd       # convert to MJD numbers
        # mask off all but REF samples
        timeUtcMjdRawRef = timeUtcMjdRaw[maskRawRef]
        # seconds per MJD day = 24 * 60 * 60 = 86400
        timeUtcMjdDBetweenRawRef = (timeUtcMjdRawRef[1:] - timeUtcMjdRawRef[:-1]) * 86400.
        timeUtcMjdDBetweenRawRefAvg = int(np.mean(timeUtcMjdDBetweenRawRef) + 0.5)
        timeUtcMjdDBetweenRawRefSpan \
            = int((timeUtcMjdDBetweenRawRef.max() - timeUtcMjdDBetweenRawRef.min()) + 0.5)

        plt.plot(timeUtcMjdDBetweenRawRef, 'o-', c='violet')
        plt.xlim(0, refQty - 2)

        plt.ylabel('Seconds Between ' + str(refQty) + ' RefRaw Samples' \
            + '\n\nMedian=' + str(int(np.median(timeUtcMjdDBetweenRawRef) + 0.5)) \
            + '  Mean=' + str(timeUtcMjdDBetweenRawRefAvg) \
            + '  Span=' + str(timeUtcMjdDBetweenRawRefSpan))

    plt.title(titleS)
    plt.grid(ezConDispGrid)

    if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
        os.remove(plotName)
    plt.savefig(plotName, dpi=300, bbox_inches='tight')



def plotEzCon201ZantFileIndex():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global dataFileIdx                          # integer array

    plotCountdown -= 1

    if 201 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon201ZantFileIndex.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    #print('                         dataFileIdx =', dataFileIdx.tolist())
    #print()
    print('                         dataFileIdxMax =', dataFileIdx.max())
    print('                         dataFileIdxMin =', dataFileIdx.min())
    #print('                         len(dataFileIdx) =', len(dataFileIdx))

    plotEzCon1dSamplesAnt(plotName, dataFileIdx, [], 'blue',
        'Ant Antenna Data File Index')



def plotEzCon202antRawAvg():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ant                                  # float 2d array
    global antRawAvg                            # float array       creation

    antRawAvg = np.mean(ant, axis=0)            # creation

    plotCountdown -= 1

    if 202 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon202antRawAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         antRawAvgMax =', antRawAvg.max())
    print('                         antRawAvgAvg =', np.mean(antRawAvg))
    print('                         antRawAvgMin =', antRawAvg.min())

    plotEzCon1dSamplesAnt(plotName, antRawAvg, [], 'blue',
        'AntRaw Antenna Spectrum Average')



def plotEzCon207antAvg():
    # same as earlier plotEzCon110antAvg()

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ant                                  # float 2d array
    global antAvg                               # float array       creation

    antAvg = np.mean(ant, axis=0)               # creation

    plotCountdown -= 1

    if 207 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon207antAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         antAvgMax =', antAvg.max())
    print('                         antAvgAvg =', np.mean(antAvg))
    print('                         antAvgMin =', antAvg.min())

    plotEzCon1dSamplesAnt(plotName, antAvg, [], 'blue',
        'Ant Antenna Spectrum Average')



def plotEzCon217antMax():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ant                                  # float 2d array
    global antMax                               # float array       creation

    antMax = np.max(ant, axis=0)               # creation

    plotCountdown -= 1

    if 217 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon217antMax.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         antMaxMax =', antMax.max())
    print('                         antMaxAvg =', np.mean(antMax))
    print('                         antMaxMin =', antMax.min())

    plotEzCon1dSamplesAnt(plotName, antMax, [], 'blue',
        'Ant Antenna Spectrum Maximum')



def plotEzCon222refRawAvg():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ref                                  # float 2d array
    global refRawAvg                            # float array       creation

    plotCountdown -= 1

    if 222 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon222refRawAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         refRawAvgMax =', refRawAvg.max())
    print('                         refRawAvgAvg =', np.mean(refRawAvg))
    print('                         refRawAvgMin =', refRawAvg.min())

    plotEzCon1dSamplesAnt(plotName, refRawAvg, [], 'violet',
        'RefRaw Antenna Spectrum Average')



def plotEzCon227refAvg():
    # same as earlier plotEzCon112refAvg()
    
    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ref                                  # float 2d array
    global refAvg                               # float array       creation

    refAvg = np.mean(ref, axis=0)               # creation

    plotCountdown -= 1

    if 227 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon227refAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         refAvgMax =', refAvg.max())
    print('                         refAvgAvg =', np.mean(refAvg))
    print('                         refAvgMin =', refAvg.min())

    plotEzCon1dSamplesAnt(plotName, refAvg, [], 'violet',
        'Ref Antenna Spectrum Average')



def plotEzCon237refMax():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ref                                  # float 2d array
    global refMax                               # float array       creation

    refMax = np.max(ref, axis=0)               # creation

    plotCountdown -= 1

    if 237 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon237refMax.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         refMaxMax =', refMax.max())
    print('                         refMaxAvg =', np.mean(refMax))
    print('                         refMaxMin =', refMax.min())

    plotEzCon1dSamplesAnt(plotName, refMax, [], 'violet',
        'Ref Reference Spectrum Maximum')



def plotEzCon241antBaseline():
    # creates antBaseline

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global ant                                  # float 2d array
    global antBaseline                          # float array       creation
    global ezConAntBaselineFreqBinsFracL        # float list

    # In each ant sample spectrum, hydrogen appears in the center frequencies,
    # so average the low and high frequency values.
    # Create antBaseline with ant, and ezConAntBaselineFreqBinsFracL .
    ezConAntBaselineFreqBin = np.empty(4, dtype=int)
    for i in range(4):
        #ezConAntBaselineFreqBin[i] = int(ezConAntBaselineFreqBinsFracL[i] * (fileFreqBinQty - 1))
        ezConAntBaselineFreqBin[i] = int(ezConAntBaselineFreqBinsFracL[i] * (freqBinQty - 1))
    # for each sample, average the ant values (from [0] to [1]) and (from [2] to [3])
    antBaseline = (np.sum(ant[ezConAntBaselineFreqBin[0]:ezConAntBaselineFreqBin[1], :], axis=0) \
        + np.sum(ant[ezConAntBaselineFreqBin[2]:ezConAntBaselineFreqBin[3], :], axis=0)) \
        / ((ezConAntBaselineFreqBin[1] - ezConAntBaselineFreqBin[0]) \
        + (ezConAntBaselineFreqBin[3] - ezConAntBaselineFreqBin[2]))

    plotCountdown -= 1

    if 241 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon241antBaseline.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         antBasMax =', antBaseline.max())
    print('                         antBasAvg =', np.mean(antBaseline))
    print('                         antBasMin =', antBaseline.min())

    plotEzCon1dSamplesAnt(plotName, antBaseline, [], 'red',
        'Ant Baseline')



def plotEzCon247antBAvg():
    # same as earlier plotEzCon114antBAvg()

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global antB                                 # float 2d array
    global antBAvg                              # float array       creation

    antBAvg = np.mean(antB, axis=0)             # creation

    plotCountdown -= 1

    if 247 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon247antBAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    antBAvgMax = antBAvg.max()
    antBAvgMin = antBAvg.min()
    print('                         antBAvgMax =', antBAvgMax)
    print('                         antBAvgAvg =', np.mean(antBAvg))
    print('                         antBAvgMin =', antBAvgMin)

    plotEzCon1dSamplesAnt(plotName, antBAvg, [], 'red',
        'AntB Antenna Spectrum Average')



def plotEzCon257antBMax():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global antB                                 # float 2d array
    global antBMax                              # float array       creation

    antBMax = np.max(antB, axis=0)             # creation

    plotCountdown -= 1

    if 257 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon257antBMax.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         antBMaxMax =', antBMax.max())
    print('                         antBMaxAvg =', np.mean(antBMax))
    print('                         antBMaxMin =', antBMax.min())

    plotEzCon1dSamplesAnt(plotName, antBMax, [], 'red',
        'AntB Spectrum Maximum')



def plotEzCon261antRAAvg():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global antRA                                # float 2d array
    global antRAAvg                             # float array       creation

    antRAAvg = np.mean(antRA, axis=0)           # creation

    plotCountdown -= 1

    if 261 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon261antRAAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         antRAAvgMax =', antRAAvg.max())
    print('                         antRAAvgAvg =', np.mean(antRAAvg))
    print('                         antRAAvgMin =', antRAAvg.min())

    plotEzCon1dSamplesAnt(plotName, antRAAvg, [], 'orange',
        'AntRA Antenna Spectrum Average')



def plotEzCon262antRABaseline():
    # creates antRABaseline

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global antRA                                # float 2d array
    global antRABaseline                        # float array       creation
    global ezConAntRABaselineFreqBinsFracL      # float list
    global freqBinQty                           # integer

    # In each antRA sample spectrum, hydrogen appears in the center frequencies,
    # so average the low and high frequency values.
    # Create antRABaseline with antRA, and ezConAntRABaselineFreqBinsFracL .
    ezConAntRABaselineFreqBin = np.empty(4, dtype=int)
    for i in range(4):
        #ezConAntRABaselineFreqBin[i] = int(ezConAntRABaselineFreqBinsFracL[i] * (fileFreqBinQty - 1))
        ezConAntRABaselineFreqBin[i] = int(ezConAntRABaselineFreqBinsFracL[i] * (freqBinQty - 1))
    # for each sample, average the antRA values (from [0] to [1]) and (from [2] to [3])
    antRABaseline = (np.sum(antRA[ezConAntRABaselineFreqBin[0]:ezConAntRABaselineFreqBin[1], :], axis=0) \
        + np.sum(antRA[ezConAntRABaselineFreqBin[2]:ezConAntRABaselineFreqBin[3], :], axis=0)) \
        / ((ezConAntRABaselineFreqBin[1] - ezConAntRABaselineFreqBin[0]) \
        + (ezConAntRABaselineFreqBin[3] - ezConAntRABaselineFreqBin[2]))

    plotCountdown -= 1

    if 262 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon262antRABasAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         antRABasMax =', antRABaseline.max())
    print('                         antRABasAvg =', np.mean(antRABaseline))
    print('                         antRABasMin =', antRABaseline.min())

    plotEzCon1dSamplesAnt(plotName, antRABaseline, [], 'orange',
        'AntRA Baseline')



def plotEzCon267antRBAvg():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global antRB                                # float 2d array
    global antRBAvg                             # float array       creation

    antRBAvg = np.mean(antRB, axis=0)           # creation

    plotCountdown -= 1

    if 267 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon267antRBAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         antRBAvgMax =', antRBAvg.max())
    print('                         antRBAvgAvg =', np.mean(antRBAvg))
    print('                         antRBAvgMin =', antRBAvg.min())

    plotEzCon1dSamplesAnt(plotName, antRBAvg, [], 'orange',
        'AntRB Antenna Spectrum Average')



def plotEzCon277antRBMax():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global antRB                                # float 2d array
    global antRBMax                             # float array       creation

    antRBMax = np.max(antRB, axis=0)           # creation

    plotCountdown -= 1

    if 277 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon277antRBMax.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         antRBMaxMax =', antRBMax.max())
    print('                         antRBMaxAvg =', np.mean(antRBMax))
    print('                         antRBMaxMin =', antRBMax.min())

    plotEzCon1dSamplesAnt(plotName, antRBMax, [], 'orange',
        'AntRB Spectrum Maximum')



def plotEzCon281antXTAvg():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global antXNameL                            # list of strings
    global antXT                                # float 2d array
    global antXTAvg                             # float array       creation

    antXTAvg = np.mean(antXT, axis=0)           # creation

    plotCountdown -= 1

    if 281 not in ezConPlotRequestedL:
        return(1)

    #plotName = 'ezCon281antXTAvg.png'
    plotName = 'ezCon281' + antXNameL[0] + 'TAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         antXTAvgMax =', antXTAvg.max())
    print('                         antXTAvgAvg =', np.mean(antXTAvg))
    print('                         antXTAvgMin =', antXTAvg.min())

    plotEzCon1dSamplesAnt(plotName, antXTAvg, [], 'green',
        antXNameL[1]+'T Antenna Spectrum Average')



def plotEzCon282antXTVAvg():
    # same as earlier plotEzCon118antXTVAvg()

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global antXNameL                            # list of strings
    global antXTV                               # float 2d array
    global antXTVAvg                            # float array       creation

    antXTVAvg = np.mean(antXTV, axis=0)         # creation

    plotCountdown -= 1

    if 282 not in ezConPlotRequestedL:
        return(1)

    #plotName = 'ezCon282antXTVAvg.png'
    plotName = 'ezCon282' + antXNameL[0] + 'TVAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         antXTVAvgMax =', antXTVAvg.max())
    print('                         antXTVAvgAvg =', np.mean(antXTVAvg))
    print('                         antXTVAvgMin =', antXTVAvg.min())

    plotEzCon1dSamplesAnt(plotName, antXTVAvg, [], 'green',
        antXNameL[1]+'TV Antenna Spectrum Average')



def plotEzCon287antXTVTAvg():
    # creates antXTVTAvg into ezConOut[:, 18], antXTVTCmDop into ezConOut[:, 9]

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global antXNameL                            # list of strings
    global antXTVT                              # float 2d array
    global antLen                               # integer
    global freqStep                             # float
    global dopplerSpanD2                        # float

    global ezConAntXTVTLevelL                   # float list
    global ezConOut                             # float and int 2d array
    global freqBinQty                           # integer

    # creation of antXTVTAvg into ezConOut[:, 18]
    #ezConOut[:, 18] = ezConAntXTVTLevelL[0] * np.mean(antXTVT, axis=0) + ezConAntXTVTLevelL[1]
    ezConOut[:, 18] = np.mean(antXTVT, axis=0) \
        * ezConAntXTVTLevelL[0] / ezConAntXTVTLevelL[2] + ezConAntXTVTLevelL[1] - ezConAntXTVTLevelL[3]

    # creation of antXTVTCmDop into ezConOut[:, 9]
    for n in range(antLen):
        # calculate Center of Mass of AntXTVT spectrum
        # https://en.wikipedia.org/wiki/Center_of_mass#Definition
        ######antXTVTCmFreqBinFloat = sum([freqBin * antXTVT[freqBin, n] for freqBin in range(fileFreqBinQty)]) \
        ######    / antXTVTSum
        antXTVTThis = antXTVT[:, n] 
        #antXTVTCmFreqBinFloatThis = sum(antXTVTThis * range(fileFreqBinQty)) / antXTVTThis.sum()
        antXTVTCmFreqBinFloatThis = sum(antXTVTThis * range(freqBinQty)) / antXTVTThis.sum()
        antXTVTCmDopThis = antXTVTCmFreqBinFloatThis * freqStep - dopplerSpanD2
        ezConOut[n, 9] = antXTVTCmDopThis

    plotCountdown -= 1

    if 287 not in ezConPlotRequestedL:
        return(1)

    #plotName = 'ezCon287antXTVTAvg.png'
    plotName = 'ezCon287' + antXNameL[0] + 'TVTAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         antXTVTAvgMax =', ezConOut[:, 18].max())
    print('                         antXTVTAvgAvg =', np.mean(ezConOut[:, 18]))
    print('                         antXTVTAvgMin =', ezConOut[:, 18].min())

    plotEzCon1dSamplesAnt(plotName, ezConOut[:, 18], [], 'green',
        antXNameL[1]+'TVT Antenna Spectrum Average')



def plotEzCon297antXTVTMax():

    global fileNameLast                         # string
    global plotCountdown                        # integer
    global ezConPlotRequestedL                  # integer list

    global antXNameL                            # list of strings
    global antXTVT                              # float 2d array
    global ezConAntXTVTLevelL                   # float list
    global ezConOut                             # float and int 2d array

    # creation of antXTVTMax into ezConOut[:, 19]
    #ezConOut[:, 19] = ezConAntXTVTLevelL[0] * np.max(antXTVT, axis=0) + ezConAntXTVTLevelL[1]
    ezConOut[:, 19] = np.max(antXTVT, axis=0) \
        * ezConAntXTVTLevelL[0] / ezConAntXTVTLevelL[2] + ezConAntXTVTLevelL[1] - ezConAntXTVTLevelL[3]

    plotCountdown -= 1

    if 297 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon297' + antXNameL[0] + 'TVTMax.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    print('                         antXTVTMaxMax =', ezConOut[:, 19].max())
    print('                         antXTVTMaxAvg =', np.mean(ezConOut[:, 19]))
    print('                         antXTVTMaxMin =', ezConOut[:, 19].min())

    plotEzCon1dSamplesAnt(plotName, ezConOut[:, 19], [], 'green',
        antXNameL[1]+'TVT Spectrum Maximum')



def plotEzCon300rawRawByFreqBinAvg():

    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global raw                      # float 2d array

    plotCountdown -= 1

    if 300 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon300rawRawByFreqAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    # calculate average by Freq Bin and plot by Doppler
    plotEzCon1dByFreqBin(plotName, np.mean(raw, axis=1), 'green',
        'RawRaw Average Spectrum', 1, 300)



def plotEzCon301ArawByFreqBinAvg():

    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global raw                      # float 2d array

    plotCountdown -= 1

    if 301 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon301ArawByFreqAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    # calculate average by Freq Bin and plot by Doppler
    plotEzCon1dByFreqBin(plotName, np.mean(raw, axis=1), 'green',
        'Raw Average Spectrum', 1, 301)



def plotEzCon301BrawByFreqBinAvg():

    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global raw                      # float 2d array

    plotCountdown -= 1

    if 301 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon301BrawByFreqAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    # calculate average by Freq Bin and plot by Doppler
    plotEzCon1dByFreqBin(plotName, np.mean(raw, axis=1), 'green',
        'Raw Average Spectrum (Ant = blue, Ref = violet)', 1, 3012)



def plotEzCon302antRawByFreqBinAvg():

    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global ant                      # float 2d array

    plotCountdown -= 1

    if 302 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon302antRawByFreqAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon1dByFreqBin(plotName, np.mean(ant, axis=1), 'blue',
        'AntRaw Average Spectrum', 0, 302)



def plotEzCon307antByFreqBinAvg():
    # after antRfiRemoval()

    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global ant                      # float 2d array
    global OutFreqString            # string
    global antByFreqBinSumAvg       # float array       creation

    if 1:
        #print()
        #print(f'  {fileNameLast}  ======================================== Frequency study of Ant')
        OutFreqStringThis = \
            f'\n  {fileNameLast}  ======================================== Frequency study of Ant\n'

        antByFreqBinSumAvg = np.mean(ant, axis=1)
        antByFreqBinSumAvgMin = min(antByFreqBinSumAvg)
        antByFreqBinSumAvgMax = max(antByFreqBinSumAvg)
        antByFreqBinSumAvgSpanD100 \
            = (antByFreqBinSumAvgMax - antByFreqBinSumAvgMin) / 100.
        # to allow division by antByFreqBinSumAvgSpanD100
        if not antByFreqBinSumAvgSpanD100:
            antByFreqBinSumAvgSpanD100 = 1e-30

        #print()
        #print(' FreqBin indexes of 5 highest-values of Ant:')
        OutFreqStringThis += '\n FreqBin indexes of 20 highest-values of Ant:\n'
        #antByFreqBinSumAvgIdxbyValueHigh5 = np.array(antByFreqBinSumAvg).argsort()[::-1][:5]
        antByFreqBinSumAvgIdxbyValueHigh20 = np.array(antByFreqBinSumAvg).argsort()[::-1][:20]
        for i in range(len(antByFreqBinSumAvgIdxbyValueHigh20)):
            antByFreqBinSumAvgThis = \
                antByFreqBinSumAvg[antByFreqBinSumAvgIdxbyValueHigh20[i]]
            antByFreqBinSumAvgThisPercent = \
                (antByFreqBinSumAvgThis - antByFreqBinSumAvgMin) / antByFreqBinSumAvgSpanD100
            OutFreqStringThis += f' i = {i}' \
                + f'       FreqBin = {antByFreqBinSumAvgIdxbyValueHigh20[i]}' \
                + f'       antByFreqBinSumAvg = {antByFreqBinSumAvgThis}' \
                + f'       {(antByFreqBinSumAvgThis - antByFreqBinSumAvgMin) / antByFreqBinSumAvgSpanD100} %'
            if antByFreqBinSumAvgThisPercent < 95:
                #print(' i =', i,
                #    '      FreqBin =', antByFreqBinSumAvgIdxbyValueHigh5[i],
                #    '      antByFreqBinSumAvg =', antByFreqBinSumAvgThis,
                #    '      ', (antByFreqBinSumAvgThis - antByFreqBinSumAvgMin) \
                #    / antByFreqBinSumAvgSpanD100, '%  <=========== < 95%')
                OutFreqStringThis += '  <=========== < 95%\n'
            else:
                #print(' i =', i,
                #    '      FreqBin =', antByFreqBinSumAvgIdxbyValueHigh5[i],
                #    '      antByFreqBinSumAvg =', antByFreqBinSumAvgThis,
                #    '      ', (antByFreqBinSumAvgThis - antByFreqBinSumAvgMin) \
                #    / antByFreqBinSumAvgSpanD100, '%')
                OutFreqStringThis += '\n'
        #print('                 Maybe try arguments like    -ezConAntFreqBinHide',
        OutFreqStringThis += '                 Maybe try arguments like    -ezConAntFreqBinHide' \
            + f' {antByFreqBinSumAvgIdxbyValueHigh20[0]}\n'
        for i in range(len(antByFreqBinSumAvgIdxbyValueHigh20))[1:]:
            OutFreqStringThis += '                                             -ezConAntFreqBinHide' \
                + f' {antByFreqBinSumAvgIdxbyValueHigh20[i]}\n'

        #print()
        #print(' FreqBin indexes of 5 lowest-values of Ant:')
        OutFreqStringThis += '\n FreqBin indexes of 5 lowest-values of Ant:\n'
        antByFreqBinSumAvgIdxbyValueLow5 = np.array(antByFreqBinSumAvg).argsort()[:5]
        for i in range(len(antByFreqBinSumAvgIdxbyValueLow5)):
            antByFreqBinSumAvgThis = \
                antByFreqBinSumAvg[antByFreqBinSumAvgIdxbyValueLow5[i]]
            #print(' i =', i,
            #    '      FreqBin =', antByFreqBinSumAvgIdxbyValueLow5[i],
            #    '      antByFreqBinSumAvg =', antByFreqBinSumAvgThis,
            #    '      ', (antByFreqBinSumAvgThis - antByFreqBinSumAvgMin) \
            #    / antByFreqBinSumAvgSpanD100, '%')
            OutFreqStringThis += f' i = {i}' \
                + f'       FreqBin = {antByFreqBinSumAvgIdxbyValueLow5[i]}' \
                + f'       antByFreqBinSumAvg = {antByFreqBinSumAvgThis}' \
                + f'       {(antByFreqBinSumAvgThis - antByFreqBinSumAvgMin) / antByFreqBinSumAvgSpanD100} %\n'
        #print('                 Maybe try arguments like    -ezConAntFreqBinHide',
        #    antByFreqBinSumAvgIdxbyValueLow5[0])
        OutFreqStringThis += '                 Maybe try arguments like    -ezConAntFreqBinHide' \
            + f' {antByFreqBinSumAvgIdxbyValueLow5[0]}\n'

        #print()
        #print(' FreqBin indexes of 5 largest change values of Ant:')
        OutFreqStringThis += '\n FreqBin indexes of 5 largest change values of Ant:\n'
        antByFreqBinSumAvgIdxbyValueDeltaHigh5m1 \
            = np.array(abs(antByFreqBinSumAvg[1:] - antByFreqBinSumAvg[:-1])).argsort()[::-1][:5]
        for i in range(len(antByFreqBinSumAvgIdxbyValueDeltaHigh5m1)):
            antByFreqBinSumAvgDeltaThis = \
                antByFreqBinSumAvg[antByFreqBinSumAvgIdxbyValueDeltaHigh5m1[i] + 1] \
                - antByFreqBinSumAvg[antByFreqBinSumAvgIdxbyValueDeltaHigh5m1[i]]
            #print(' i =', i,
            #    '      FreqBin =', antByFreqBinSumAvgIdxbyValueDeltaHigh5m1[i] + 1,
            #    '      antByFreqBinSumAvgDelta =', antByFreqBinSumAvgDeltaThis,
            #    '      ', antByFreqBinSumAvgDeltaThis / antByFreqBinSumAvgSpanD100, '%')
            OutFreqStringThis += f' i = {i}' \
                + f'       FreqBin = {antByFreqBinSumAvgIdxbyValueDeltaHigh5m1[i] + 1}' \
                + f'       antByFreqBinSumAvgDelta = {antByFreqBinSumAvgDeltaThis}' \
                + f'       {antByFreqBinSumAvgDeltaThis / antByFreqBinSumAvgSpanD100} %\n'
        #print('                 Maybe try arguments like    -ezConAntFreqBinHide',
        #    antByFreqBinSumAvgIdxbyValueDeltaHigh5m1[0] + 1)
        OutFreqStringThis += '                 Maybe try arguments like    -ezConAntFreqBinHide' \
            + f' {antByFreqBinSumAvgIdxbyValueDeltaHigh5m1[0] + 1}'
        print(OutFreqStringThis)
        OutFreqString = '\n\n\n\n' \
            + '============================================================================\n' \
            + '============================================================================\n' \
            + '============================================================================\n' \
            + '\n\n\n' + OutFreqStringThis

    plotCountdown -= 1

    if 307 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon307antByFreqAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon1dByFreqBin(plotName, antByFreqBinSumAvg, 'blue',
        'Ant Average Spectrum', 0, 307)



def plotEzCon317antByFreqBinMax():
    # after antRfiRemoval()

    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global ant                      # float 2d array
    global OutFreqString            # string
    global antByFreqBinMax          # float array       creation

    if 1:
        #print()
        #print(f'  {fileNameLast}  ============================ Frequency study of AntByFreqBinMax')
        OutFreqStringThis = \
            f'\n  {fileNameLast}  ============================ Frequency study of AntByFreqBinMax\n'

        antByFreqBinMax = np.max(ant, axis=1)
        antByFreqBinMaxMin = min(antByFreqBinMax)
        antByFreqBinMaxMax = max(antByFreqBinMax)
        antByFreqBinMaxSpanD100 \
            = (antByFreqBinMaxMax - antByFreqBinMaxMin) / 100.
        # to allow division by antByFreqBinMaxSpanD100
        if not antByFreqBinMaxSpanD100:
            antByFreqBinMaxSpanD100 = 1e-30

        #print()
        #print(' FreqBin indexes of 5 highest-values of AntByFreqBinMax:')
        #OutFreqStringThis += '\n FreqBin indexes of 5 highest-values of AntByFreqBinMax:\n'
        OutFreqStringThis += '\n FreqBin indexes of 20 highest-values of AntByFreqBinMax:\n'
        antByFreqBinMaxIdxbyValueHigh20 = np.array(antByFreqBinMax).argsort()[::-1][:20]
        for i in range(len(antByFreqBinMaxIdxbyValueHigh20)):
            antByFreqBinMaxThis = \
                antByFreqBinMax[antByFreqBinMaxIdxbyValueHigh20[i]]
            antByFreqBinMaxThisPercent = \
                (antByFreqBinMaxThis - antByFreqBinMaxMin) / antByFreqBinMaxSpanD100
            OutFreqStringThis += f' i = {i}' \
                + f'       FreqBin = {antByFreqBinMaxIdxbyValueHigh20[i]}' \
                + f'       antByFreqBinMax = {antByFreqBinMaxThis}' \
                + f'       {(antByFreqBinMaxThis - antByFreqBinMaxMin) / antByFreqBinMaxSpanD100} %'
            if antByFreqBinMaxThisPercent < 95:
                #print(' i =', i,
                #    '      FreqBin =', antByFreqBinMaxIdxbyValueHigh5[i],
                #    '      antByFreqBinMax =', antByFreqBinMaxThis,
                #    '      ', (antByFreqBinMaxThis - antByFreqBinMaxMin) \
                #    / antByFreqBinMaxSpanD100, '%  <=========== < 95%')
                OutFreqStringThis += '  <=========== < 95%\n'
            else:
                #print(' i =', i,
                #    '      FreqBin =', antByFreqBinMaxIdxbyValueHigh5[i],
                #    '      antByFreqBinMax =', antByFreqBinMaxThis,
                #    '      ', (antByFreqBinMaxThis - antByFreqBinMaxMin) \
                #    / antByFreqBinMaxSpanD100, '%')
                OutFreqStringThis += '\n'
        #print('                 Maybe try arguments like    -ezConAntFreqBinHide',
        #    antByFreqBinMaxIdxbyValueHigh5[0])
        OutFreqStringThis += '                 Maybe try arguments like    -ezConAntFreqBinHide' \
            + f' {antByFreqBinMaxIdxbyValueHigh20[0]}\n'
        for i in range(len(antByFreqBinMaxIdxbyValueHigh20))[1:]:
            OutFreqStringThis += '                                             -ezConAntFreqBinHide' \
                + f' {antByFreqBinMaxIdxbyValueHigh20[i]}\n'

        #print()
        #print(' FreqBin indexes of 5 lowest-values of AntByFreqBinMax:')
        OutFreqStringThis += '\n FreqBin indexes of 5 lowest-values of AntByFreqBinMax:\n'
        antByFreqBinMaxIdxbyValueLow5 = np.array(antByFreqBinMax).argsort()[:5]
        for i in range(len(antByFreqBinMaxIdxbyValueLow5)):
            antByFreqBinMaxThis = \
                antByFreqBinMax[antByFreqBinMaxIdxbyValueLow5[i]]
            #print(' i =', i,
            #    '      FreqBin =', antByFreqBinMaxIdxbyValueLow5[i],
            #    '      antByFreqBinMax =', antByFreqBinMaxThis,
            #    '      ', (antByFreqBinMaxThis - antByFreqBinMaxMin) \
            #    / antByFreqBinMaxSpanD100, '%')
            OutFreqStringThis += f' i = {i}' \
                + f'       FreqBin = {antByFreqBinMaxIdxbyValueLow5[i]}' \
                + f'       antByFreqBinMax = {antByFreqBinMaxThis}' \
                + f'       {(antByFreqBinMaxThis - antByFreqBinMaxMin) / antByFreqBinMaxSpanD100} %\n'
        #print('                 Maybe try arguments like    -ezConAntFreqBinHide',
        #    antByFreqBinMaxIdxbyValueLow5[0])
        OutFreqStringThis += '                 Maybe try arguments like    -ezConAntFreqBinHide' \
            + f' {antByFreqBinMaxIdxbyValueLow5[0]}\n'

        #print()
        #print(' FreqBin indexes of 5 largest change values of AntByFreqBinMax:')
        OutFreqStringThis += '\n FreqBin indexes of 5 largest change values of AntByFreqBinMax:\n'
        antByFreqBinMaxIdxbyValueDeltaHigh5m1 \
            = np.array(abs(antByFreqBinMax[1:] - antByFreqBinMax[:-1])).argsort()[::-1][:5]
        for i in range(len(antByFreqBinMaxIdxbyValueDeltaHigh5m1)):
            antByFreqBinMaxDeltaThis = \
                antByFreqBinMax[antByFreqBinMaxIdxbyValueDeltaHigh5m1[i] + 1] \
                - antByFreqBinMax[antByFreqBinMaxIdxbyValueDeltaHigh5m1[i]]
            #print(' i =', i,
            #    '      FreqBin =', antByFreqBinMaxIdxbyValueDeltaHigh5m1[i] + 1,
            #    '      antByFreqBinMaxDelta =', antByFreqBinMaxDeltaThis,
            #    '      ', antByFreqBinMaxDeltaThis / antByFreqBinMaxSpanD100, '%')
            OutFreqStringThis += f' i = {i}' \
                + f'       FreqBin = {antByFreqBinMaxIdxbyValueDeltaHigh5m1[i] + 1}' \
                + f'       antByFreqBinMaxDelta = {antByFreqBinMaxDeltaThis}' \
                + f'       {antByFreqBinMaxDeltaThis / antByFreqBinMaxSpanD100} %\n'
        #print('                 Maybe try arguments like    -ezConAntFreqBinHide',
        #    antByFreqBinMaxIdxbyValueDeltaHigh5m1[0] + 1)
        OutFreqStringThis += '                 Maybe try arguments like    -ezConAntFreqBinHide' \
            + f' {antByFreqBinMaxIdxbyValueDeltaHigh5m1[0] + 1}'
        print(OutFreqStringThis)
        OutFreqString += '\n\n\n\n' + OutFreqStringThis

    plotCountdown -= 1

    if 317 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon317antByFreqMax.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon1dByFreqBin(plotName, antByFreqBinMax, 'blue',
        'Ant Maximum Spectrum', 0, 317)



def plotEzCon322refRawByFreqBinAvg():

    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global ref                      # float 2d array

    plotCountdown -= 1

    if 322 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon322refRawByFreqAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon1dByFreqBin(plotName, np.mean(ref, axis=1), 'violet',
        'RefRaw Average Spectrum', 0, 322)



def plotEzCon327refByFreqBinAvg():

    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global ref                      # float 2d array
    global OutFreqString            # string
    global refByFreqBinSumAvg       # float array       creation

    if 1:
        #print()
        #print(f'  {fileNameLast}  ======================================== Frequency study of Ref')
        OutFreqStringThis = \
            f'\n  {fileNameLast}  ======================================== Frequency study of Ref\n'

        refByFreqBinSumAvg = np.mean(ref, axis=1)
        refByFreqBinSumAvgMin = min(refByFreqBinSumAvg)
        refByFreqBinSumAvgMax = max(refByFreqBinSumAvg)
        refByFreqBinSumAvgSpanD100 \
            = (refByFreqBinSumAvgMax - refByFreqBinSumAvgMin) / 100.
        # to allow division by refByFreqBinSumAvgSpanD100
        if not refByFreqBinSumAvgSpanD100:
            refByFreqBinSumAvgSpanD100 = 1e-30

        #print()
        #print(' FreqBin indexes of 5 highest-values of Ref:')
        #OutFreqStringThis += '\n FreqBin indexes of 5 highest-values of Ref:\n'
        OutFreqStringThis += '\n FreqBin indexes of 20 highest-values of Ref:\n'
        refByFreqBinSumAvgIdxbyValueHigh20 = np.array(refByFreqBinSumAvg).argsort()[::-1][:20]
        for i in range(len(refByFreqBinSumAvgIdxbyValueHigh20)):
            refByFreqBinSumAvgThis = \
                refByFreqBinSumAvg[refByFreqBinSumAvgIdxbyValueHigh20[i]]
            refByFreqBinSumAvgThisPercent = \
                (refByFreqBinSumAvgThis - refByFreqBinSumAvgMin) / refByFreqBinSumAvgSpanD100
            OutFreqStringThis += f' i = {i}' \
                + f'       FreqBin = {refByFreqBinSumAvgIdxbyValueHigh20[i]}' \
                + f'       refByFreqBinSumAvg = {refByFreqBinSumAvgThis}' \
                + f'       {(refByFreqBinSumAvgThis - refByFreqBinSumAvgMin) / refByFreqBinSumAvgSpanD100} %'
            if refByFreqBinSumAvgThisPercent < 95:
                #print(' i =', i,
                #    '      FreqBin =', refByFreqBinSumAvgIdxbyValueHigh5[i],
                #    '      refByFreqBinSumAvg =', refByFreqBinSumAvgThis,
                #    '      ', (refByFreqBinSumAvgThis - refByFreqBinSumAvgMin) \
                #    / refByFreqBinSumAvgSpanD100, '%  <=========== < 95%')
                OutFreqStringThis += '  <=========== < 95%\n'
            else:
                #print(' i =', i,
                #    '      FreqBin =', refByFreqBinSumAvgIdxbyValueHigh5[i],
                #    '      refByFreqBinSumAvg =', refByFreqBinSumAvgThis,
                #    '      ', (refByFreqBinSumAvgThis - refByFreqBinSumAvgMin) \
                #    / refByFreqBinSumAvgSpanD100, '%')
                OutFreqStringThis += '\n'
        #print('                 Maybe try arguments like    -ezConRefFreqBinHide',
        #    refByFreqBinSumAvgIdxbyValueHigh5[0])
        OutFreqStringThis += '                 Maybe try arguments like    -ezConRefFreqBinHide' \
            + f' {refByFreqBinSumAvgIdxbyValueHigh20[0]}\n'
        for i in range(len(refByFreqBinSumAvgIdxbyValueHigh20))[1:]:
            OutFreqStringThis += '                                             -ezConRefFreqBinHide' \
                + f' {refByFreqBinSumAvgIdxbyValueHigh20[i]}\n'

        #print()
        #print(' FreqBin indexes of 5 lowest-values of Ref:')
        OutFreqStringThis += '\n FreqBin indexes of 5 lowest-values of Ref:\n'
        refByFreqBinSumAvgIdxbyValueLow5 = np.array(refByFreqBinSumAvg).argsort()[:5]
        for i in range(len(refByFreqBinSumAvgIdxbyValueLow5)):
            refByFreqBinSumAvgThis = \
                refByFreqBinSumAvg[refByFreqBinSumAvgIdxbyValueLow5[i]]
            #print(' i =', i,
            #    '      FreqBin =', refByFreqBinSumAvgIdxbyValueLow5[i],
            #    '      refByFreqBinSumAvg =', refByFreqBinSumAvgThis,
            #    '      ', (refByFreqBinSumAvgThis - refByFreqBinSumAvgMin) \
            #    / refByFreqBinSumAvgSpanD100, '%')
            OutFreqStringThis += f' i = {i}' \
                + f'       FreqBin = {refByFreqBinSumAvgIdxbyValueLow5[i]}' \
                + f'       refByFreqBinSumAvg = {refByFreqBinSumAvgThis}' \
                + f'       {(refByFreqBinSumAvgThis - refByFreqBinSumAvgMin) / refByFreqBinSumAvgSpanD100} %\n'
        #print('                 Maybe try arguments like    -ezConRefFreqBinHide',
        #    refByFreqBinSumAvgIdxbyValueLow5[0])
        OutFreqStringThis += '                 Maybe try arguments like    -ezConRefFreqBinHide' \
            + f' {refByFreqBinSumAvgIdxbyValueLow5[0]}\n'

        #print()
        #print(' FreqBin indexes of 5 largest change values of Ref:')
        OutFreqStringThis += '\n FreqBin indexes of 5 largest change values of Ref:\n'
        refByFreqBinSumAvgIdxbyValueDeltaHigh5m1 \
            = np.array(abs(refByFreqBinSumAvg[1:] - refByFreqBinSumAvg[:-1])).argsort()[::-1][:5]
        for i in range(len(refByFreqBinSumAvgIdxbyValueDeltaHigh5m1)):
            refByFreqBinSumAvgDeltaThis = \
                refByFreqBinSumAvg[refByFreqBinSumAvgIdxbyValueDeltaHigh5m1[i] + 1] \
                - refByFreqBinSumAvg[refByFreqBinSumAvgIdxbyValueDeltaHigh5m1[i]]
            #print(' i =', i,
            #    '      FreqBin =', refByFreqBinSumAvgIdxbyValueDeltaHigh5m1[i] + 1,
            #    '      refByFreqBinSumAvgDelta =', refByFreqBinSumAvgDeltaThis,
            #    '      ', refByFreqBinSumAvgDeltaThis / refByFreqBinSumAvgSpanD100, '%')
            OutFreqStringThis += f' i = {i}' \
                + f'       FreqBin = {refByFreqBinSumAvgIdxbyValueDeltaHigh5m1[i] + 1}' \
                + f'       refByFreqBinSumAvgDelta = {refByFreqBinSumAvgDeltaThis}' \
                + f'       {refByFreqBinSumAvgDeltaThis / refByFreqBinSumAvgSpanD100} %\n'
        #print('                 Maybe try arguments like    -ezConRefFreqBinHide',
        #    refByFreqBinSumAvgIdxbyValueDeltaHigh5m1[0] + 1)
        OutFreqStringThis += '                 Maybe try arguments like    -ezConRefFreqBinHide' \
            + f' {refByFreqBinSumAvgIdxbyValueDeltaHigh5m1[0] + 1}'
        print(OutFreqStringThis)
        OutFreqString += '\n\n\n\n' + OutFreqStringThis

    plotCountdown -= 1

    if 327 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon327refByFreqAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon1dByFreqBin(plotName, refByFreqBinSumAvg, 'violet',
        'Ref Average Spectrum', 0, 327)



def plotEzCon337refByFreqBinMax():

    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global ref                      # float 2d array
    global refByFreqBinMax          # float array       creation

    plotCountdown -= 1

    refByFreqBinMax = np.max(ref, axis=1)
    
    if 337 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon337refByFreqMax.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon1dByFreqBin(plotName, refByFreqBinMax, 'violet',
        'Ref Maximum Spectrum', 0, 337)



def plotEzCon347antBByFreqBinAvg():

    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global antB                     # float 2d array
    global antBByFreqBinSumAvg      # float array       creation

    plotCountdown -= 1

    antBByFreqBinSumAvg = np.mean(antB, axis=1)

    if 347 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon347antBByFreqAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon1dByFreqBin(plotName, antBByFreqBinSumAvg, 'red',
        'AntB Average Spectrum', 0, 347)



def plotEzCon357antBByFreqBinMax():

    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global antB                     # float 2d array
    global antBByFreqBinMax         # float array       creation

    plotCountdown -= 1

    antBByFreqBinMax = np.max(antB, axis=1)

    if 357 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon357antBByFreqMax.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon1dByFreqBin(plotName, antBByFreqBinMax, 'red',
        'AntB Maximum Spectrum', 0, 357)



def plotEzCon361antRAByFreqBinAvg():

    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global antRA                    # float 2d array

    plotCountdown -= 1

    if 361 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon361antRAByFreqAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon1dByFreqBin(plotName, np.mean(antRA, axis=1), 'orange',
        'AntRA Average Spectrum', 0, 361)



def plotEzCon367antRBByFreqBinAvg():

    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global antRB                    # float 2d array
    global antRBByFreqBinSumAvg     # float array       creation

    plotCountdown -= 1

    antRBByFreqBinSumAvg = np.mean(antRB, axis=1)

    if 367 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon367antRBByFreqAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon1dByFreqBin(plotName, antRBByFreqBinSumAvg, 'orange',
        'AntRB Average Spectrum', 0, 367)



def plotEzCon377antRBByFreqBinMax():

    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global antRB                    # float 2d array
    global antRBByFreqBinMax        # float array       creation

    plotCountdown -= 1

    antRBByFreqBinMax = np.max(antRB, axis=1)

    if 377 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon377antRBByFreqMax.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon1dByFreqBin(plotName, antRBByFreqBinMax, 'orange',
        'AntRB Maximum Spectrum', 0, 377)



def plotEzCon381antXTByFreqBinAvg():

    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global antXNameL                # list of strings
    global antXT                    # float 2d array
    global antXTByFreqBinSumAvg     # float array       creation

    plotCountdown -= 1

    antXTByFreqBinSumAvg = np.mean(antXT, axis=1)

    if 381 not in ezConPlotRequestedL:
        return(1)

    #plotName = 'ezCon381antXTByFreqAvg.png'
    plotName = 'ezCon381' + antXNameL[0] + 'TByFreqAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon1dByFreqBin(plotName, antXTByFreqBinSumAvg, 'green',
        antXNameL[1]+'T Average Spectrum', 0, 381)



def plotEzCon382antXTByFreqBinAvgRfi():

    global fileNameLast             # string
    global plotCountdown            # integer
    global titleS                   # string
    global ezConDispGrid            # integer
    global dopplerSpanD2            # float
    global freqAntMin               # float
    global freqAntMax               # float
    global freqBinQty               # integer
    global antXNameL                # list of strings
    global antXT                    # float 2d array
    global ezConPlotRequestedL      # integer list
    global OutFreqString            # string
    global antXTByFreqBinSumAvg     # float array       creation
    global freqCenter               # float

    # for RFI filtering, to help create ezDefaults.txt ezConHideFreqBin arguments, 
    # print freqBin indexes of 5 highest-values of antXTByFreqBinSum

    OutFreqStringThis = \
        f'\n  {fileNameLast}  ======================================== Frequency study of AntXT\n'

    #antXTByFreqBinSumAvg = np.mean(antXT, axis=1)
    antXTByFreqBinSumAvgMin = min(antXTByFreqBinSumAvg)
    antXTByFreqBinSumAvgMax = max(antXTByFreqBinSumAvg)
    antXTByFreqBinSumAvgSpanD100 = (antXTByFreqBinSumAvgMax - antXTByFreqBinSumAvgMin) / 100.
    if antXTByFreqBinSumAvgSpanD100:
        #print()
        #print(' FreqBin indexes of 5 highest-values of ' + antXNameL[1] + 'T:')
        #OutFreqStringThis += f'\n FreqBin indexes of 5 highest-values of {antXNameL[1]}T:\n'
        OutFreqStringThis += f'\n FreqBin indexes of 20 highest-values of {antXNameL[1]}T:\n'
        antXTByFreqBinSumAvgIdxbyValueHigh20 = np.array(antXTByFreqBinSumAvg).argsort()[::-1][:20]
        for i in range(len(antXTByFreqBinSumAvgIdxbyValueHigh20)):
            antXTByFreqBinSumAvgThis = \
                antXTByFreqBinSumAvg[antXTByFreqBinSumAvgIdxbyValueHigh20[i]]
            antXTByFreqBinSumAvgThisPercent = \
                (antXTByFreqBinSumAvgThis - antXTByFreqBinSumAvgMin) / antXTByFreqBinSumAvgSpanD100
            #print(' i =', i,
            #    '      FreqBin =', antXTByFreqBinSumAvgIdxbyValueHigh5[i],
            #    '      '+antXNameL[1]+'TByFreqBinSumAvg =', antXTByFreqBinSumAvgThis,
            #    '      ', (antXTByFreqBinSumAvgThis - antXTByFreqBinSumAvgMin) \
            #    / antXTByFreqBinSumAvgSpanD100, '%')
            OutFreqStringThis += f' i = {i}' \
                + f'       FreqBin = {antXTByFreqBinSumAvgIdxbyValueHigh20[i]}' \
                + f'       {antXNameL[1]}TByFreqBinSumAvg = {antXTByFreqBinSumAvgThis}' \
                + f'       ' \
                + f'{(antXTByFreqBinSumAvgThis - antXTByFreqBinSumAvgMin) / antXTByFreqBinSumAvgSpanD100} %'
            if antXTByFreqBinSumAvgThisPercent < 95:
                OutFreqStringThis += '  <=========== < 95%\n'
            else:
                OutFreqStringThis += '\n'
        #print('                 Maybe try arguments like    -ezConAntFreqBinHide',
        #    antXTByFreqBinSumAvgIdxbyValueHigh5[0])
        OutFreqStringThis += '                 Maybe try arguments like    -ezConAntFreqBinHide' \
            + f' {antXTByFreqBinSumAvgIdxbyValueHigh20[0]}\n'
        for i in range(len(antXTByFreqBinSumAvgIdxbyValueHigh20))[1:]:
            OutFreqStringThis += '                                             -ezConAntFreqBinHide' \
                + f' {antXTByFreqBinSumAvgIdxbyValueHigh20[i]}\n'

        #print()
        #print(' FreqBin indexes of 5 lowest-values of ' + antXNameL[1] + 'T:')
        OutFreqStringThis += f'\n FreqBin indexes of 5 lowest-values of {antXNameL[1]}T:\n'
        antXTByFreqBinSumAvgIdxbyValueLow5 = np.array(antXTByFreqBinSumAvg).argsort()[:5]
        for i in range(len(antXTByFreqBinSumAvgIdxbyValueLow5)):
            antXTByFreqBinSumAvgThis = \
                antXTByFreqBinSumAvg[antXTByFreqBinSumAvgIdxbyValueLow5[i]]
            #print(' i =', i,
            #    '      FreqBin =', antXTByFreqBinSumAvgIdxbyValueLow5[i],
            #    '      '+antXNameL[1]+'TByFreqBinSumAvg =', antXTByFreqBinSumAvgThis,
            #    '      ', (antXTByFreqBinSumAvgThis - antXTByFreqBinSumAvgMin) \
            #    / antXTByFreqBinSumAvgSpanD100, '%')
            OutFreqStringThis += f' i = {i}' \
                + f'       FreqBin = {antXTByFreqBinSumAvgIdxbyValueLow5[i]}' \
                + f'       {antXNameL[1]}TByFreqBinSumAvg = {antXTByFreqBinSumAvgThis}' \
                + f'       ' \
                + f'{(antXTByFreqBinSumAvgThis - antXTByFreqBinSumAvgMin) / antXTByFreqBinSumAvgSpanD100} %\n'
        #print('                 Maybe try arguments like    -ezConAntFreqBinHide',
        #    antXTByFreqBinSumAvgIdxbyValueLow5[0])
        OutFreqStringThis += '                 Maybe try arguments like    -ezConAntFreqBinHide' \
            + f' {antXTByFreqBinSumAvgIdxbyValueLow5[0]}\n'

        #print()
        #print(' FreqBin indexes of 5 largest change values of ' + antXNameL[1] + 'T:')
        OutFreqStringThis += f'\n FreqBin indexes of 5 largest change values of {antXNameL[1]}T:\n'
        antXTByFreqBinSumAvgIdxbyValueDeltaHigh5m1 \
            = np.array(abs(antXTByFreqBinSumAvg[1:] - antXTByFreqBinSumAvg[:-1])).argsort()[::-1][:5]
        for i in range(len(antXTByFreqBinSumAvgIdxbyValueDeltaHigh5m1)):
            antXTByFreqBinSumAvgDeltaThis = \
                antXTByFreqBinSumAvg[antXTByFreqBinSumAvgIdxbyValueDeltaHigh5m1[i] + 1] \
                - antXTByFreqBinSumAvg[antXTByFreqBinSumAvgIdxbyValueDeltaHigh5m1[i]]
            #print(' i =', i,
            #    '      FreqBin =', antXTByFreqBinSumAvgIdxbyValueDeltaHigh5m1[i] + 1,
            #    '      '+antXNameL[1]+'TByFreqBinSumAvgDelta =', antXTByFreqBinSumAvgDeltaThis,
            #    '      ', antXTByFreqBinSumAvgDeltaThis / antXTByFreqBinSumAvgSpanD100, '%')
            OutFreqStringThis += f' i = {i}' \
                + f'       FreqBin = {antXTByFreqBinSumAvgIdxbyValueDeltaHigh5m1[i] + 1}' \
                + f'       {antXNameL[1]}TByFreqBinSumAvgDelta = {antXTByFreqBinSumAvgDeltaThis}' \
                + f'       {antXTByFreqBinSumAvgDeltaThis / antXTByFreqBinSumAvgSpanD100} %\n'
        #print('                 Maybe try arguments like    -ezConAntFreqBinHide',
        #    antXTByFreqBinSumAvgIdxbyValueDeltaHigh5m1[0] + 1)
        OutFreqStringThis += '                 Maybe try arguments like    -ezConAntFreqBinHide' \
            + f' {antXTByFreqBinSumAvgIdxbyValueDeltaHigh5m1[0] + 1}'
    else:
        OutFreqStringThis += f'\n The frequency of {antXNameL[1]}T did not change.'
    print(OutFreqStringThis)
    OutFreqString += '\n\n\n\n' + OutFreqStringThis

    plotCountdown -= 1

    if 382 not in ezConPlotRequestedL:
        return(1)

    #plotName = 'ezCon382antXTByFreqAvgRfi.png'
    plotName = 'ezCon382' + antXNameL[0] + 'TByFreqAvgRfi.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plt.clf()

    # calculate average by Freq Bin and plot by Doppler
    #plt.plot(antXTByFreqBinSumAvg, range(fileFreqBinQty), 'green')
    #plt.plot(antXTByFreqBinSumAvg, range(freqBinQty), 'green')
    fig, ax = plt.subplots()
    ax.plot(antXTByFreqBinSumAvg, range(freqBinQty), 'green')

    plt.title(titleS)
    plt.grid(1)

    plt.xlabel(antXNameL[1]+f'T Average Spectrum  (Doppler MHz from {freqCenter:.3f} MHz)')
    # 2% of the data span as a spacing on each end
    #plt.xlim(antXTByFreqBinSumAvgMin - 2 * antXTByFreqBinSumAvgSpanD100,
    #    antXTByFreqBinSumAvgMax + 2 * antXTByFreqBinSumAvgSpanD100)
    #print('================= antXTByFreqBinSumAvgSpanD100 =', antXTByFreqBinSumAvgSpanD100)
    if antXTByFreqBinSumAvgSpanD100:
        plt.xlim(antXTByFreqBinSumAvgMax + 2 * antXTByFreqBinSumAvgSpanD100,
            antXTByFreqBinSumAvgMin - 2 * antXTByFreqBinSumAvgSpanD100)
    else:
        plt.xlim(-0.05, 0.05)

    yTick382Locs   = []
    yTick382Labels = []
    dopplerSpan = freqAntMax - freqAntMin
    dopplerSpanD2 = dopplerSpan / 2.
    for i in range(21):
        #yTick382LocsIInt = int(fileFreqBinQty * i / 20.)
        yTick382LocsIInt = int(freqBinQty * i / 20.)
        yTick382Locs.append(yTick382LocsIInt)
        # below widths assume dopplerSpan < 20 MHz
        # allow for width of negative Doppler '-' character
        dopplerThis = dopplerSpan * i / 20. - dopplerSpanD2
        if dopplerThis < 0.:
            #yTick382Labels.append(f'{yTick382LocsIInt:d}  {i / 20.:0.2f}  {dopplerThis:0.2f}')
            yTick382Labels.append(f'{dopplerThis:0.2f}  {i / 20.:0.2f}  {yTick382LocsIInt:04d}')
        else:
            #yTick382Labels.append(f'{yTick382LocsIInt:d}  {i / 20.:0.2f}   {dopplerThis:0.2f}')
            yTick382Labels.append(f' {dopplerThis:0.2f}  {i / 20.:0.2f}  {yTick382LocsIInt:04d}')

    plt.yticks(yTick382Locs, yTick382Labels)
    #plt.ylabel('Frequency Bin and Spectrum Fraction')
    #plt.ylabel('Frequency Bin, Spectrum Fraction, and Doppler')
    plt.ylabel('Doppler,  Spectrum Fraction,  and Frequency Bin')
    #plt.ylim(0, fileFreqBinQty)
    #plt.ylim(fileFreqBinQty * 1.001, 0)
    #plt.ylim(freqBinQty * 1.001, 0)
    plt.ylim(0, freqBinQty * 1.001)

    ax.yaxis.set_label_position("right")
    ax.yaxis.tick_right()

    if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
        os.remove(plotName)
    plt.savefig(plotName, dpi=300, bbox_inches='tight')



def plotEzCon383antXTVByFreqBinAvg():

    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global antXNameL                # list of strings
    global antXTV                   # float 2d array

    plotCountdown -= 1

    if 383 not in ezConPlotRequestedL:
        return(1)

    #plotName = 'ezCon383antXTVByFreqAvg.png'
    plotName = 'ezCon383' + antXNameL[0] + 'TVByFreqAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon1dByFreqBin(plotName, np.mean(antXTV, axis=1), 'green',
        antXNameL[1]+'TV Average Spectrum', 0, 383)



def plotEzCon386antXTVTByFreqBinAvg():
    # may be different than ezCon387 before running ezConAntXTVTFreqBinsClipDo()

    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global antXNameL                # list of strings
    global antXTVT                  # float 2d array
    global antXTVTByFreqBinSumAvg   # float array       creation

    plotCountdown -= 1

    antXTVTByFreqBinSumAvg = np.mean(antXTVT, axis=1)

    if 386 not in ezConPlotRequestedL:
        return(1)

    #plotName = 'ezCon386antXTVTByFreqAvg.png'
    plotName = 'ezCon386' + antXNameL[0] + 'TVTByFreqAvg0.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon1dByFreqBin(plotName, antXTVTByFreqBinSumAvg, 'green',
        antXNameL[1]+'TVT Average Spectrum', 0, 386)



def plotEzCon387antXTVTByFreqBinAvg():

    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global antXNameL                # list of strings
    global antXTVT                  # float 2d array
    global antXTVTByFreqBinSumAvg   # float array       creation

    plotCountdown -= 1

    antXTVTByFreqBinSumAvg = np.mean(antXTVT, axis=1)

    if 387 not in ezConPlotRequestedL:
        return(1)

    #plotName = 'ezCon387antXTVTByFreqAvg.png'
    plotName = 'ezCon387' + antXNameL[0] + 'TVTByFreqAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon1dByFreqBin(plotName, antXTVTByFreqBinSumAvg, 'green',
        antXNameL[1]+'TVT Average Spectrum', 0, 387)



def plotEzCon388antXTVTByFreqBinAvgAll():

    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global antXNameL                # list of strings
    global antXTVT                  # float 2d array
    global antLen                   # integer

    global byFreqBinX               # float array
    global ezConDispGrid            # integer
    global dopplerSpanD2            # float
    global freqCenter               # float

    plotCountdown -= 1

    if 388 not in ezConPlotRequestedL:
        return(1)

    #plotName = 'ezCon388antXTVTByFreqAvgAll.png'
    plotName = 'ezCon388' + antXNameL[0] + 'TVTByFreqAvgAll.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plt.clf()

    #antXTVTDLen = 100                           # maximum quantity of spectra after downsampling
    antXTVTDLenMax = 100                        # maximum quantity of spectra after downsampling
    antXTVTDLen = min(antLen, antXTVTDLenMax)   # quantity of spectra after downsampling
    colorPenSL = ['black', 'brown', 'red', 'orange', 'yellow', 'green', 'blue', 'violet', 'grey']

    # no downsampling
    #for n in range(antLen):
    #    plt.plot(byFreqBinX, antXTVT[:, n], colorPenSL[n % 9], linewidth=0.5)

    # true downsampling, using the slicing notation of start:stop:step ("Decimation" ?)
    #antXTVTD = antXTVT[:, ::downsamplingStep]

    # downsampling by averaging
    # (// is floor division)
    downsamplingStep = antLen // antXTVTDLen

    antXTVTD = np.empty_like(antXTVT[:, :antXTVTDLen])
    for n in range(antXTVTDLen):
        downsamplingIndex = n * downsamplingStep
        antXTVTD[:, n] = np.mean(antXTVT[:, downsamplingIndex:downsamplingIndex+downsamplingStep], axis=1)

    for n in range(len(antXTVTD[0, :])):
        plt.plot(byFreqBinX, antXTVTD[:, n], colorPenSL[n % 9], linewidth=0.5)

    plt.title(titleS)
    plt.grid(ezConDispGrid)

    #plt.xlabel('Doppler (MHz)')
    plt.xlabel(f'Doppler MHz from {freqCenter:.3f} MHz')
    plt.xlim(-dopplerSpanD2, dopplerSpanD2)

    plt.ylabel(antXNameL[1]+'TVT Spectra')
    plt.ylabel(antXNameL[1]+'TVT Spectra, Downsampled by Averaging')

    if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
        os.remove(plotName)
    plt.savefig(plotName, dpi=300, bbox_inches='tight')



def plotEzCon391ByFreqBinSumAvg():
    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global ant                      # float 2d array
    global ref                      # float 2d array
    global antB                     # float 2d array

    global byFreqBinX               # float array
    global antByFreqBinSumAvg       # float array
    global refByFreqBinSumAvg       # float array
    global antBByFreqBinSumAvg      # float array
    global antRBByFreqBinSumAvg     # float array
    global antXTByFreqBinSumAvg     # float array
    global antXTVTByFreqBinSumAvg   # float array

    global ezConDispGrid            # integer
    global dopplerSpanD2            # float
    global freqCenter               # float
    global ezConAntBaselineFreqBinsFracL        # float list

    plotCountdown -= 1

    if 391 not in ezConPlotRequestedL:
        return(1)

    #plotName = 'ezCon391' + antXNameL[0] + 'TVByFreqMax.png'
    plotName = 'ezCon391ByFreqAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plt.clf()

    spectrum = antByFreqBinSumAvg - np.min(antByFreqBinSumAvg)
    spectrumMax = np.max(spectrum)
    if not spectrumMax:
        spectrumMax = 1e-20
    plt.plot(byFreqBinX, spectrum / spectrumMax, 'blue')

    spectrum = refByFreqBinSumAvg - np.min(refByFreqBinSumAvg)
    spectrumMax = np.max(spectrum)
    if not spectrumMax:
        spectrumMax = 1e-20
    plt.plot(byFreqBinX, spectrum / spectrumMax, 'violet')

    spectrum = antBByFreqBinSumAvg - np.min(antBByFreqBinSumAvg)
    spectrumMax = np.max(spectrum)
    if not spectrumMax:
        spectrumMax = 1e-20
    plt.plot(byFreqBinX, spectrum / spectrumMax, 'red')

    spectrum = antRBByFreqBinSumAvg - np.min(antRBByFreqBinSumAvg)
    spectrumMax = np.max(spectrum)
    if not spectrumMax:
        spectrumMax = 1e-20
    plt.plot(byFreqBinX, spectrum / spectrumMax, 'orange')

    spectrum = antXTByFreqBinSumAvg - np.min(antXTByFreqBinSumAvg)
    spectrumMax = np.max(spectrum)
    if not spectrumMax:
        spectrumMax = 1e-20
    plt.plot(byFreqBinX, spectrum / spectrumMax, 'green')

    spectrum = antXTVTByFreqBinSumAvg - np.min(antXTVTByFreqBinSumAvg)
    spectrumMax = np.max(spectrum)
    if not spectrumMax:
        spectrumMax = 1e-20
    plt.plot(byFreqBinX, spectrum / spectrumMax, 'grey')

    plt.xlabel(f'Doppler MHz from {freqCenter:.3f} MHz')
    plt.xlim(-dopplerSpanD2, dopplerSpanD2)

    plt.title(titleS)
    plt.grid(ezConDispGrid)

    ylabel = 'Autoscaled ByFreqBinSumAvg:   Ant(blue), AntB(red),'
    ylabel += '\nref(violet), AntRB(orange), ' + antXNameL[0] + 'T(green), ' + antXNameL[0] + 'TVT(grey)'
    plt.ylabel(ylabel)

    if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
        os.remove(plotName)
    plt.savefig(plotName, dpi=300, bbox_inches='tight')



def plotEzCon392ByFreqBinMax():
    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global ant                      # float 2d array
    global ref                      # float 2d array
    global antB                     # float 2d array

    global byFreqBinX               # float array
    global antByFreqBinMax          # float array
    global refByFreqBinMax          # float array
    global antBByFreqBinMax         # float array
    global antRBByFreqBinMax        # float array
    global antXTByFreqBinMax        # float array
    global antXTVTByFreqBinMax      # float array

    global ezConDispGrid            # integer
    global dopplerSpanD2            # float
    global freqCenter               # float
    global ezConAntBaselineFreqBinsFracL        # float list

    plotCountdown -= 1

    if 392 not in ezConPlotRequestedL:
        return(1)

    #plotName = 'ezCon392' + antXNameL[0] + 'TVByFreqMax.png'
    plotName = 'ezCon392ByFreqAvg.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plt.clf()

    spectrum = antByFreqBinMax - np.min(antByFreqBinMax)
    spectrumMax = np.max(spectrum)
    if not spectrumMax:
        spectrumMax = 1e-20
    plt.plot(byFreqBinX, spectrum / spectrumMax, 'blue')

    spectrum = refByFreqBinMax - np.min(refByFreqBinMax)
    spectrumMax = np.max(spectrum)
    if not spectrumMax:
        spectrumMax = 1e-20
    plt.plot(byFreqBinX, spectrum / spectrumMax, 'violet')

    spectrum = antBByFreqBinMax - np.min(antBByFreqBinMax)
    spectrumMax = np.max(spectrum)
    if not spectrumMax:
        spectrumMax = 1e-20
    plt.plot(byFreqBinX, spectrum / spectrumMax, 'red')

    spectrum = antRBByFreqBinMax - np.min(antRBByFreqBinMax)
    spectrumMax = np.max(spectrum)
    if not spectrumMax:
        spectrumMax = 1e-20
    plt.plot(byFreqBinX, spectrum / spectrumMax, 'orange')

    spectrum = antXTByFreqBinMax - np.min(antXTByFreqBinMax)
    spectrumMax = np.max(spectrum)
    if not spectrumMax:
        spectrumMax = 1e-20
    plt.plot(byFreqBinX, spectrum / spectrumMax, 'green')

    spectrum = antXTVTByFreqBinMax - np.min(antXTVTByFreqBinMax)
    spectrumMax = np.max(spectrum)
    if not spectrumMax:
        spectrumMax = 1e-20
    plt.plot(byFreqBinX, spectrum / spectrumMax, 'grey')

    plt.xlabel(f'Doppler MHz from {freqCenter:.3f} MHz')
    plt.xlim(-dopplerSpanD2, dopplerSpanD2)

    plt.title(titleS)
    plt.grid(ezConDispGrid)

    ylabel = 'Autoscaled ByFreqBinMax:   Ant(blue), AntB(red),'
    ylabel += '\nref(violet), AntRB(orange), ' + antXNameL[0] + 'T(green), ' + antXNameL[0] + 'TVT(grey)'
    plt.ylabel(ylabel)

    if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
        os.remove(plotName)
    plt.savefig(plotName, dpi=300, bbox_inches='tight')



def plotEzCon393antXTByFreqBinMax():

    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global antXNameL                # list of strings
    global antXT                    # float 2d array
    global antXTByFreqBinMax        # float array

    plotCountdown -= 1

    antXTByFreqBinMax = np.max(antXT, axis=1)

    if 393 not in ezConPlotRequestedL:
        return(1)

    #plotName = 'ezCon393antXTByFreqMax.png'
    plotName = 'ezCon393' + antXNameL[0] + 'TByFreqMax.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon1dByFreqBin(plotName, antXTByFreqBinMax, 'green',
        antXNameL[1]+'T Maximum Spectrum', 0, 393)



def plotEzCon394antXTVByFreqBinMax():

    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global antXNameL                # list of strings
    global antXTV                   # float 2d array

    plotCountdown -= 1

    if 394 not in ezConPlotRequestedL:
        return(1)

    #plotName = 'ezCon394antXTVByFreqMax.png'
    plotName = 'ezCon394' + antXNameL[0] + 'TVByFreqMax.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon1dByFreqBin(plotName, np.max(antXTV, axis=1), 'green',
        antXNameL[1]+'TV Maximum Spectrum', 0, 394)



def plotEzCon396antXTVTByFreqBinMax():
    # may be different than ezCon397 before running ezConAntXTVTFreqBinsClipDo()

    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global antXNameL                # list of strings
    global antXTVT                  # float 2d array
    global antXTVTByFreqBinMax      # float array       creation

    plotCountdown -= 1

    antXTVTByFreqBinMax = np.max(antXTVT, axis=1)

    if 396 not in ezConPlotRequestedL:
        return(1)

    #plotName = 'ezCon396antXTVTByFreqMax.png'
    plotName = 'ezCon396' + antXNameL[0] + 'TVTByFreqMax0.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon1dByFreqBin(plotName, antXTVTByFreqBinMax, 'green',
        antXNameL[1]+'TVT Maximum Spectrum', 0, 396)



def plotEzCon397antXTVTByFreqBinMax():

    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global antXNameL                # list of strings
    global antXTVT                  # float 2d array
    global antXTVTByFreqBinMax      # float array       creation

    plotCountdown -= 1

    antXTVTByFreqBinMax = np.max(antXTVT, axis=1)

    if 397 not in ezConPlotRequestedL:
        return(1)

    #plotName = 'ezCon397antXTVTByFreqMax.png'
    plotName = 'ezCon397' + antXNameL[0] + 'TVTByFreqMax.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon1dByFreqBin(plotName, antXTVTByFreqBinMax, 'green',
        antXNameL[1]+'TVT Maximum Spectrum', 0, 397)



def plotEzCon398antXTVTByFreqBinMaxAll():

    global ezConPlotRequestedL      # integer list
    global fileNameLast             # string
    global plotCountdown            # integer
    global antXNameL                # list of strings
    global antXTVT                  # float 2d array

    global byFreqBinX               # float array
    global ezConDispGrid            # integer
    global dopplerSpanD2            # float
    global freqCenter               # float

    plotCountdown -= 1

    if 398 not in ezConPlotRequestedL:
        return(1)

    #plotName = 'ezCon398antXTVTByFreqMaxAll.png'
    plotName = 'ezCon398' + antXNameL[0] + 'TVTByFreqMaxAll.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plt.clf()

    #antXTVTMaxDLen = 100                                # quantity of spectra after downsampling
    antXTVTMaxDLenMax = 100                             # maximum quantity of spectra after downsampling
    antXTVTMaxDLen = min(antLen, antXTVTMaxDLenMax)     # quantity of spectra after downsampling

    colorPenSL = ['black', 'brown', 'red', 'orange', 'yellow', 'green', 'blue', 'violet', 'grey']

    # no downsampling
    #for n in range(antLen):
    #    plt.plot(byFreqBinX, antXTVT[:, n], colorPenSL[n % 9], linewidth=0.5)

    # true downsampling, using the slicing notation of start:stop:step ("Decimation" ?)
    #antXTVTD = antXTVT[:, ::downsamplingStep]

    # downsampling by maximizing
    # (// is floor division)
    downsamplingStep = antLen // antXTVTMaxDLen

    antXTVTMaxD = np.empty_like(antXTVT[:, :antXTVTMaxDLen])
    for n in range(antXTVTMaxDLen):
        downsamplingIndex = n * downsamplingStep
        antXTVTMaxD[:, n] = np.max(antXTVT[:, downsamplingIndex:downsamplingIndex+downsamplingStep], axis=1)

    for n in range(len(antXTVTMaxD[0, :])):
        plt.plot(byFreqBinX, antXTVTMaxD[:, n], colorPenSL[n % 9], linewidth=0.5)

    plt.title(titleS)
    plt.grid(ezConDispGrid)

    #plt.xlabel('Doppler (MHz)')
    plt.xlabel(f'Doppler MHz from {freqCenter:.3f} MHz')
    plt.xlim(-dopplerSpanD2, dopplerSpanD2)

    plt.ylabel(antXNameL[1]+'TVTMax Spectra, Downsampled by Maximizing')

    if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
        os.remove(plotName)
    plt.savefig(plotName, dpi=300, bbox_inches='tight')



def plotEzCon399SignalSampleByFreqBin():

    global ezConPlotRequestedL      # integer list
    global fileNameLast                     # string
    global plotCountdown                    # integer
    global ezCon399SignalSampleByFreqBinL   # integer list
    global ezCon399SignalSampleByFreqBin1d  # float list or numpy
    global antXNameL                        # list of strings

    plotCountdown -= 1

    if 399 not in ezConPlotRequestedL:
        return(1)

    ezCon399SignalSampleByFreqBinL[1] = min(ezCon399SignalSampleByFreqBinL[1], antLen)
    ezCon399SampleS = str(ezCon399SignalSampleByFreqBinL[1])

    if ezCon399SignalSampleByFreqBinL[0] == 10:
        plotName = 'ezCon399AntByFreq' + ezCon399SampleS + '.png'
        plotColorS = 'blue'
        plotYLabel = 'Ant Spectrum, Sample ' + ezCon399SampleS
    elif ezCon399SignalSampleByFreqBinL[0] == 12:
        plotName = 'ezCon399RefByFreq' + ezCon399SampleS + '.png'
        plotColorS = 'violet'
        plotYLabel = 'Ref Spectrum, Sample ' + ezCon399SampleS
    elif ezCon399SignalSampleByFreqBinL[0] == 14:
        plotName = 'ezCon399AntBByFreq' + ezCon399SampleS + '.png'
        plotColorS = 'red'
        plotYLabel = 'AntB Spectrum, Sample ' + ezCon399SampleS
    elif ezCon399SignalSampleByFreqBinL[0] == 16:
        plotName = 'ezCon399AntRBByFreq' + ezCon399SampleS + '.png'
        plotColorS = 'orange'
        plotYLabel = 'AntRB Spectrum, Sample ' + ezCon399SampleS
    else:
        # ezCon399SignalSampleByFreqBinL[0] == 18
        plotName = 'ezCon399' + antXNameL[1] + 'TVTByFreq' + ezCon399SampleS + '.png'
        plotColorS = 'green'
        plotYLabel = antXNameL[1] + 'TVT Spectrum, Sample ' + ezCon399SampleS

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plotEzCon1dByFreqBin(plotName, ezCon399SignalSampleByFreqBin1d, plotColorS, plotYLabel, 0, 399)

    # free ezCon399SignalSampleByFreqBin1d global memory
    ezCon399SignalSampleByFreqBin1d = []
    ezCon399SignalSampleByFreqBin1d = None
    del ezCon399SignalSampleByFreqBin1d



#A#################################################################################################



def plotEzCon510velGLon():

    global fileNameLast             # string
    global plotCountdown            # integer
    global velGLonP180              # float 2d array
    global velGLonP180Count         # integer array
    global velGLonP180CountSum      # integer
    global fileWriteNameEzb         # string

    global titleS                   # string
    global ezConDispGrid            # integer
    global freqBinQty               # integer
    global freqStep                 # float
    global ezConPlotRequestedL      # integer list

    plotCountdown -= 1

    # if anything in velGLonP180 to save or plot
    if not (510 in ezConPlotRequestedL and velGLonP180CountSum):
        return(1)

    plotName = 'ezCon510velGLon.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plt.clf()

    # if any Galactic plane crossings, velGLonP180 has been (partially?) filled with averages
    velGLonP180CountNonzero = np.count_nonzero(velGLonP180Count)
    print(' velGLonP180CountNonzero =', velGLonP180CountNonzero, 'of', len(velGLonP180Count) )
    print()

    xi = np.arange(-180, +181, 1)           # +180 thru -180 degrees in degrees, galaxy centered
    #yi = np.arange(0, fileFreqBinQty, 1)    # 0 to fileFreqBinQty in freqBins
    # speed of light = 299,792,458 meters per second
    #    rawPlotPrep ===============
    #       fileFreqMin = 1419.2
    #       fileFreqMax = 1421.6
    #       freqStep = 0.009411764705881818
    #       dopplerSpanD2 = 1.1999999999999318
    #       freqCenter = 1420.4
    # velocity = (fileFreqBin doppler MHz) * (299792458. m/s / 1420.406 MHz) / 1000. = km/s
    # velocity spans = -dopplerSpanD2 * (299792458. / freqCenter) thru
    #                  +dopplerSpanD2 * (299792458. / freqCenter)
    #velocitySpanMax = +1.1999999999999318 * (299792458. / 1420.406) / 1000.  # = 253.273324388 km/s
    velocitySpanMax = +dopplerSpanD2 * (299792458. / freqCenter) / 1000.  # = 253.273324388 km/s
    #yi = np.linspace(-velocitySpanMax, velocitySpanMax, fileFreqBinQty)
    yi = np.linspace(-velocitySpanMax, velocitySpanMax, freqBinQty)

    xi, yi = np.meshgrid(xi, yi)

    fig = plt.figure()
    ax = fig.add_subplot(111)

    #print('                         np.nanmax(velGLonP180) =', np.nanmax(velGLonP180))
    velPowerMax = np.nanmax(velGLonP180)
    print('                         np.nanmax(velGLonP180) =', velPowerMax)
    print('                         np.mean(velGLonP180[~np.isnan(velGLonP180)]) =',
        np.mean(velGLonP180[~np.isnan(velGLonP180)]))
    print('                         np.nanmin(velGLonP180) =', np.nanmin(velGLonP180))

    # write velPowerMax float value into filename
    ## rqv8ezb220218_00a.ezb
    #                   4321-
    ## rqv8ezb220218_00a_p0.0012.velPowerMax'
    if velPowerMax < 0:
        fileWriteVelPowerMaxName = f'{fileWriteNameEzb[:-4]}_n{velPowerMax:06f}.velPowerMax'
    else:
        fileWriteVelPowerMaxName = f'{fileWriteNameEzb[:-4]}_p{velPowerMax:06f}.velPowerMax'
    fileWriteVelPowerMax = open(fileWriteVelPowerMaxName, 'w')
    if not (fileWriteVelPowerMax.mode == 'w'):
        print()
        print()
        print()
        print()
        print()
        print(' ========== FATAL ERROR:  Can not open ')
        print(' ' + fileWriteVelPowerMaxName)
        print(' file to write out velPowerMax filename')
        print()
        print()
        print()
        print()
        print('\a')     # ring bell
        exit()
    # velPowerMax value already written in the filename
    fileWriteVelPowerMax.write('\n')
    fileWriteVelPowerMax.close()

    pts = plt.contourf(xi, yi, velGLonP180, 100, cmap=plt.get_cmap('gnuplot'))

    plt.axhline(y = 0, linewidth=0.5, color='black')
    plt.axvline(x =  90, linewidth=0.5, color='black')
    plt.axvline(x =   0, linewidth=0.5, color='black')
    plt.axvline(x = -90, linewidth=0.5, color='black')

    cbar = plt.colorbar(pts, orientation='vertical', pad=0.06)

    plt.title(titleS)
    #plt.grid(ezConDispGrid)
    plt.grid(0)

    plt.xlabel('Galactic Longitude (degrees)')
    plt.xlim(180, -180)        # in degrees
    plt.xticks([  180,   90,   0,   -90,   -180],
               [ '180', '90', '0', '-90', '-180'])

    plt.ylim(-velocitySpanMax, velocitySpanMax)        # in velocity

    plt.ylabel('Interpolated Velocity (km/s) by Galactic Longitude' \
        + f'\nVelocity Count: Sum={velGLonP180CountSum:,}' \
        + f' Nonzero = {velGLonP180CountNonzero} of {len(velGLonP180Count)}',
        rotation=90, verticalalignment='bottom')

    if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
        os.remove(plotName)
    plt.savefig(plotName, dpi=300, bbox_inches='tight')



def plotEzCon519velGLonCount():

    global fileNameLast             # string
    global plotCountdown            # integer
    global velGLonP180Count         # integer array
    global velGLonP180CountSum      # integer

    global titleS                   # string
    global ezConDispGrid            # integer
    global ezConPlotRequestedL      # integer list

    plotCountdown -= 1

    # if anything in velGLonP180 to plot
    if not (519 in ezConPlotRequestedL and velGLonP180CountSum):
        return(1)

    plotName = 'ezCon519velGLonCount.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plt.clf()
    plt.plot(np.arange(-180, +181, 1), velGLonP180Count)

    plt.title(titleS)
    #plt.grid(ezConDispGrid)
    plt.grid(0)

    plt.xlabel('Galactic Longitude (degrees)')
    plt.xlim(180, -180)        # in degrees
    plt.xticks([  180,   90,   0,   -90,   -180],
               [ '180', '90', '0', '-90', '-180'])

    # if any Galactic plane crossings, velGLonP180 has been (partially?) filled with averages
    velGLonP180CountNonzero = np.count_nonzero(velGLonP180Count)
    print(' velGLonP180CountNonzero =', velGLonP180CountNonzero, 'of', len(velGLonP180Count) )
    print()

    plt.ylabel('Velocity Data Counts by Galactic Longitude' \
        + f'\nVelocity Count: Sum={velGLonP180CountSum:,}' \
        + f' Nonzero={velGLonP180CountNonzero} of {len(velGLonP180Count)}')
    #    rotation=90, verticalalignment='bottom')

    if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
        os.remove(plotName)
    plt.savefig(plotName, dpi=300, bbox_inches='tight')


    # print out velGLonCount status
    fileWriteGLonName = 'ezCon519velGLonCount.txt'
    fileWriteGLon = open(fileWriteGLonName, 'w')
    if not (fileWriteGLon.mode == 'w'):
        print()
        print()
        print()
        print()
        print()
        print(' ========== FATAL ERROR:  Can not open ')
        print(' ' + fileWriteGLonName)
        print(' file to write out velGLonCount data')
        print()
        print()
        print()
        print()
        print('\a')     # ring bell
        exit()


    fileWriteGLonHashS = '########################################' \
        + '########################################'                        # 40 + 40 = 80 '#'

    fileWriteGLon.write('\ngLonDeg   velGLonCount   gLonDegForHaystackSrt.cmd        (RtoL)\n\n')

    for gLonP180 in range(180):                               # for every column, RtoL, 0 thru 179
        fileWriteGLonS = f'{gLonP180 - 180:4d}  {velGLonP180Count[gLonP180]:5d}  {gLonP180 + 180:4d}  ' \
            + fileWriteGLonHashS[:velGLonP180Count[gLonP180]] + '\n'
        fileWriteGLon.write(fileWriteGLonS)

    # for the gLonDeg == 0000 column
    fileWriteGLonS = f'0000  {velGLonP180Count[180]:5d}  0000  ' \
        + fileWriteGLonHashS[:velGLonP180Count[180]] + '\n'
    fileWriteGLon.write(fileWriteGLonS)

    for gLonP180 in range(181, 361):                          # for every column, RtoL, 181 thru 360
        fileWriteGLonS = f'{gLonP180 - 180:4d}  {velGLonP180Count[gLonP180]:5d}  {gLonP180 - 180:4d}  ' \
            + fileWriteGLonHashS[:velGLonP180Count[gLonP180]] + '\n'
        fileWriteGLon.write(fileWriteGLonS)


    # print out velGLonCount Things-To-Do for Haystack srt.cmd command file
    velGLonCountTrigger = 15
    fileWriteGLon.write( \
        '\n\n\n\n\n* velGLonCount Things-To-Do for Haystack srt.cmd command file    (RtoL)')
    fileWriteGLon.write('\n* velGLonCountTrigger = ' + str(velGLonCountTrigger))
    fileWriteGLon.write('\n\n:5              * short pause of 5 seconds')
    fileWriteGLon.write('\n: record')
    fileWriteGLon.write('\n* later, do not forget at the end,       : roff\n\n')
    fileWriteGLon.write( \
        '\n* 600 + 240 + 060 = 900 seconds = 10 + 4 + 1 minutes = 15 min data collection\n\n')

    for gLonP180 in range(180):                               # for every column, RtoL, 0 thru 179
        if velGLonP180Count[gLonP180] <= velGLonCountTrigger:
            fileWriteGLon.write(f': G{gLonP180 + 180:03d}    * have {velGLonP180Count[gLonP180]:5d}\n')
            fileWriteGLon.write(':600\n')
            fileWriteGLon.write(':240\n')
            fileWriteGLon.write(':060\n')
            fileWriteGLon.write('*\n')
    for gLonP180 in range(180, 361):                          # for every column, RtoL, 180 thru 360
        if velGLonP180Count[gLonP180] <= velGLonCountTrigger:
            fileWriteGLon.write(f': G{gLonP180 - 180:03d}    * have {velGLonP180Count[gLonP180]:5d}\n')
            fileWriteGLon.write(':600\n')
            fileWriteGLon.write(':240\n')
            fileWriteGLon.write(':060\n')
            fileWriteGLon.write('*\n')

    fileWriteGLon.close()   



def plotEzCon520velGLonPolar():

    global fileNameLast             # string
    global plotCountdown            # integer
    global velGLonP180              # float 2d array
    global velGLonP180CountSum      # integer

    global titleS                   # string
    global ezConDispGrid            # integer
    global freqBinQty               # integer
    global ezConPlotRequestedL      # integer list

    plotCountdown -= 1

    # if anything in velGLonP180 to plot
    if not (520 in ezConPlotRequestedL and velGLonP180CountSum):
        return(1)

    plotName = 'ezCon520velGLonPolar.png'     # Velocity by Galactic Longitude with pcolormesh

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plt.clf()
    
    #    # https://matplotlib.org/stable/gallery/pie_and_polar_charts/polar_demo.html
    #    # https://matplotlib.org/stable/gallery/pie_and_polar_charts/polar_scatter.html
    # https://stackoverflow.com/questions/36513312/polar-heatmaps-in-python
    fig = plt.figure()
    ax = fig.add_subplot(projection='polar')

    #rad = np.arange(0, fileFreqBinQty, 1)        # 0 to fileFreqBinQty in freqBins
    rad = np.arange(0, freqBinQty, 1)        # 0 to freqBinQty in freqBins
    azm = np.linspace(0, np.pi + np.pi, 361, endpoint=True)

    r, theta = np.meshgrid(rad, azm)
    plt.grid(0)
    im = plt.pcolormesh(theta, r, velGLonP180.T, cmap=plt.get_cmap('gnuplot'), shading='auto')

    fig.colorbar(im, ax=ax, pad=0.1)

    polarPlot = plt.plot(azm, r, color='black', linestyle='none')
    plt.grid(1)

    plt.title(titleS)

    #ax.set_rgrids((fileFreqBinQty/2.,), ('',))
    ax.set_rgrids((freqBinQty/2.,), ('',))
    ax.set_theta_zero_location('S', offset=0.)
    ax.set_thetagrids((90, 180, 270, 360), ('-90', '0', '90', '180 and -180'))

    ax.set_xlabel('Galactic Longitude (degrees) of Spectra')
    ax.set_ylabel('Radius Is Increasing "Velocity",\n\n' \
        + 'Radius Is Increasing Receding,\n\n' \
        + 'Radius Is Decreasing Doppler\n\n')

    if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
        os.remove(plotName)
    plt.savefig(plotName, dpi=300, bbox_inches='tight')



def plotEzCon529velGLonPolarCount():

    global fileNameLast             # string
    global plotCountdown            # integer
    global velGLonP180Count         # integer array
    global velGLonP180CountSum      # integer

    global titleS                   # string
    global ezConDispGrid            # integer
    global freqBinQty               # integer
    global ezConPlotRequestedL      # integer list

    plotCountdown -= 1

    # if anything in velGLonP180 to plot
    if not (529 in ezConPlotRequestedL and velGLonP180CountSum):
        return(1)

    plotName = 'ezCon529velGLonPolarCount.png'     # Velocity by Galactic Longitude with pcolormesh

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plt.clf()

    fig = plt.figure()
    ax = fig.add_subplot(projection='polar')

    #rad = np.arange(0, fileFreqBinQty, 1)        # 0 to fileFreqBinQty in freqBins
    rad = np.arange(0, freqBinQty, 1)        # 0 to freqBinQty in freqBins
    azm = np.linspace(0, np.pi + np.pi, 361, endpoint=True)
    r, theta = np.meshgrid(rad, azm)

    velGLonP180CountPolar = np.zeros_like(velGLonP180.T, dtype=int)
    for gLonP180 in range(361):
        if velGLonP180Count[gLonP180]:
            velGLonP180CountPolar[gLonP180, :] += velGLonP180Count[gLonP180]

    plt.grid(0)
    im = plt.pcolormesh(theta, r, velGLonP180CountPolar, cmap=plt.get_cmap('gnuplot'), shading='auto')

    fig.colorbar(im, ax=ax, pad=0.1)

    polarPlot = plt.plot(azm, r, color='black', linestyle='none')
    plt.grid(1)

    plt.title(titleS)

    #ax.set_rgrids((fileFreqBinQty/2.,), ('',))
    ax.set_rgrids((freqBinQty/2.,), ('',))
    ax.set_theta_zero_location('S', offset=0.)
    ax.set_thetagrids((90, 180, 270, 360), ('-90', '0', '90', '180 and -180'))

    ax.set_xlabel('Galactic Longitude (degrees) of Spectra')
    velGLonP180CountNonzero = np.count_nonzero(velGLonP180Count)
    ax.set_ylabel('Velocity Data Counts by Galactic Longitude' \
        + f'\nVelocity Count: Sum={velGLonP180CountSum:,}' \
        + f' Nonzero={velGLonP180CountNonzero} of {len(velGLonP180Count)}\n\n')
    #        ax.set_ylabel('Velocity Data Counts by Galactic Longitude' \
    #            + f'\nVelocity Count: Sum={velGLonP180CountSum:,}' \
    #            + f' Nonzero={velGLonP180CountNonzero} of {len(velGLonP180Count)}')
    #        #    rotation=90, verticalalignment='bottom')

    if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
        os.remove(plotName)
    plt.savefig(plotName, dpi=300, bbox_inches='tight')



def plotEzCon530galDecGLon():

    global fileNameLast             # string
    global plotCountdown            # integer
    global velGLonP180              # float 2d array
    global velGLonP180Count         # integer array
    global velGLonP180CountSum      # integer
    global galDecP90GLonP180Count   # integer array

    global titleS                   # string
    global ezConDispGrid            # integer
    global ezConPlotRequestedL      # integer list

    plotCountdown -= 1

    # if anything in velGLonP180 to plot
    if not (530 in ezConPlotRequestedL and velGLonP180CountSum):
        return(1)
    
    plotName = 'ezCon530galDecGLon.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plt.clf()

    xi = np.arange(-180, +181, 1)           # +180 thru -180 degrees in degrees, galaxy centered
    yi = np.arange(0, 181, 1)               # 0 thru 180 decP90

    xi, yi = np.meshgrid(xi, yi)

    fig = plt.figure()
    ax = fig.add_subplot(111)

    if 0:
        maskOffBelowThis = 0.975    # N0RQVHC
        maskOffBelowThis = 0.9      # WA6RSV
        maskOffBelowThis = -10
        print(' maskOffBelowThis = ', maskOffBelowThis)
        maskThisOff = (velGLonP180 < maskOffBelowThis)
        velGLonP180[maskThisOff] = np.nan

    pts = plt.contourf(xi, yi, galDecP90GLonP180Count, 20, cmap=plt.get_cmap('gnuplot'))

    plt.axhline(y =  90, linewidth=0.5, color='black')
    plt.axvline(x =  90, linewidth=0.5, color='black')
    plt.axvline(x =   0, linewidth=0.5, color='black')
    plt.axvline(x = -90, linewidth=0.5, color='black')

    cbar = plt.colorbar(pts, orientation='vertical', pad=0.06)

    plt.title(titleS)
    plt.grid(0)

    plt.xlabel('Galactic Longitude (degrees)')
    plt.xlim(180, -180)        # in degrees
    plt.xticks([  180,   90,   0,   -90,   -180],
               [ '180', '90', '0', '-90', '-180'])

    plt.ylabel('Velocity Counts on Declination by Galactic Longitude' \
        + f'\nVelocity Count Sum = {velGLonP180CountSum:,}',
        rotation=90, verticalalignment='bottom')
    plt.ylim(0, 180)                # in decP90
    plt.yticks([ 0,     30,    60,    90,  120,  150,  180],
               [ '-90', '-60', '-30', '0', '30', '60', '90'])

    if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
        os.remove(plotName)
    plt.savefig(plotName, dpi=300, bbox_inches='tight')



def plotEzCon541velGLonEdges():

    global fileNameLast             # string
    global plotCountdown            # integer
    global velGLonP180              # float 2d array
    global velGLonP180Count         # integer array
    global velGLonP180CountSum      # integer

    global ezConVelGLonEdgeFrac     # float
    global ezConVelGLonEdgeLevel    # float

    global titleS                   # string
    global ezConDispGrid            # integer
    global freqBinQty               # integer
    global dopplerSpanD2            # float
    global ezConPlotRequestedL      # integer list

    plotCountdown -= 1

    # If anything in velGLonP180 to plot.
    if 541 in ezConPlotRequestedL and velGLonP180CountSum:

        plotName = 'ezCon541velGLonEdges.png'

        print()
        print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

        plt.clf()

        print(' ezConVelGLonEdgeFrac  =', ezConVelGLonEdgeFrac)
        print(' ezConVelGLonEdgeLevel =', ezConVelGLonEdgeLevel)

        velGLonP180Max = velGLonP180.max()
        velGLonP180Min = velGLonP180.min()
        # if ezConVelGLonEdgeLevel not 0, then ezConVelGLonEdgeFrac ignored
        if ezConVelGLonEdgeLevel:
            velGLonEdgeLevel = ezConVelGLonEdgeLevel
        else:
            velGLonEdgeLevel = ezConVelGLonEdgeFrac * (velGLonP180Max - velGLonP180Min) + velGLonP180Min
        print('                         velGLonP180Max   =', velGLonP180Max)
        print('                         velGLonEdgeLevel =', velGLonEdgeLevel)
        print('                         velGLonP180Min   =', velGLonP180Min)

        velGLonUEdgeFreqBin = np.full(361, np.nan)      # unused nan will not plot
        velGLonLEdgeFreqBin = np.full(361, np.nan)      # unused nan will not plot
        
        # for Galactic plane crossings, velGLonUEdge will be the max velocity vs Galactic Longitude.
        # Page 46 of https://f1ehn.pagesperso-orange.fr/pages_radioastro/Images_Docs/
        #   Radioastro_21cm_2012b.pdf
        #   says the max Galactic velocity around Galactic center
        #   = galGalMax
        #   = velGLonUEdge + (earth Galactic rotation speed) * sin(gLon)
        #   = velGLonUEdge + (218 km/s)                      * sin(gLon)
        galGalMax = np.full(361, np.nan)      # unused nan will not plot

        for gLonP180 in range(361):
            if velGLonP180Count[gLonP180]:
                # calculate Upper and Lower Detection Doppler of this velGLonP180 spectrum
                # https://thispointer.com/find-the-index-of-a-value-in-numpy-array/
                # Tuple of arrays returned :  (array([ 4,  7, 11], dtype=int32),)
                # velGLonP180AboveLevelFreqBins are the freqBins with velGLonP180 >= velGLonEdgeLevel
                velGLonP180AboveLevelFreqBins = np.where(velGLonEdgeLevel <= velGLonP180[:, gLonP180])[0]

                if velGLonP180AboveLevelFreqBins.any():
                    velGLonUEdgeFreqBinThis = velGLonP180AboveLevelFreqBins[-1] # use last  element of list
                    velGLonLEdgeFreqBinThis = velGLonP180AboveLevelFreqBins[ 0] # use first element of list

                    # for the current gLonP180, ignoring nan,
                    #   remember the max velGLonUEdgeFreqBinThis and min velGLonLEdgeFreqBinThis
                    if np.isnan(velGLonUEdgeFreqBin[gLonP180]):
                        velGLonUEdgeFreqBin[gLonP180] = velGLonUEdgeFreqBinThis
                    else:
                        velGLonUEdgeFreqBin[gLonP180] = max(velGLonUEdgeFreqBin[gLonP180],
                        velGLonUEdgeFreqBinThis)

                    if np.isnan(velGLonLEdgeFreqBin[gLonP180]):
                        velGLonLEdgeFreqBin[gLonP180] = velGLonLEdgeFreqBinThis
                    else:
                        velGLonLEdgeFreqBin[gLonP180] = max(velGLonLEdgeFreqBin[gLonP180],
                        velGLonLEdgeFreqBinThis)

        # convert freqBin to velocity (km/s)
        velocityStep = freqStep * (299792458. / freqCenter) / 1000.                     # km/s
        #velGLonUEdge = (velGLonUEdgeFreqBin - int(fileFreqBinQty / 2)) * velocityStep   # km/s
        #velGLonLEdge = (velGLonLEdgeFreqBin - int(fileFreqBinQty / 2)) * velocityStep   # km/s
        velGLonUEdge = (velGLonUEdgeFreqBin - int(freqBinQty / 2)) * velocityStep   # km/s
        velGLonLEdge = (velGLonLEdgeFreqBin - int(freqBinQty / 2)) * velocityStep   # km/s

        # all used velGLonUEdgeFreqBin, are red  shifted
        plt.plot(np.arange(-180, +181, 1), velGLonUEdge, 'r.')

        # all used velGLonLEdgeFreqBin, are blue shifted
        plt.plot(np.arange(-180, +181, 1), velGLonLEdge, 'b.')


        plt.title(titleS)
        plt.grid(0)

        plt.xlabel('Galactic Longitude (degrees)')
        plt.xlim(180, -180)        # in degrees
        plt.xticks([  180,   90,   0,   -90,   -180],
                   [ '180', '90', '0', '-90', '-180'])

        ylabelS = 'Velocity Edge: Upper (Red) and Lower (Blue) (km/s)'
        # if ezConVelGLonEdgeLevel not 0, then ezConVelGLonEdgeFrac ignored
        if ezConVelGLonEdgeLevel:
            ylabelS += f'\nezConVelGLonEdgeLevel = {ezConVelGLonEdgeLevel:0.4f}'
        else:
            ylabelS += f'\nezConVelGLonEdge: Frac={ezConVelGLonEdgeFrac:0.4f}'
            ylabelS += f' Level={velGLonEdgeLevel:0.4f}'

        plt.ylabel(ylabelS)
        plt.ylim(-270, 270)

        if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
            os.remove(plotName)
        plt.savefig(plotName, dpi=300, bbox_inches='tight')


    # since need same velGLonUEdge, merged plotEzCon550galRot() into plotEzCon541velGLonEdges()
    #def plotEzCon550galRot():

    plotCountdown -= 1

    # If anything in velGLonP180 to plot.
    # This ezCon531galRot.png requires ezCon530velGLonEdges.png to run.
    if not (550 in ezConPlotRequestedL and velGLonP180CountSum):
        return(1)

    plotName = 'ezCon550galRot.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plt.clf()

    # Status: for Galactic plane crossings, velGLonUEdge are max velocities vs Galactic longitude.
    # Page 46 of https://f1ehn.pagesperso-orange.fr/pages_radioastro/Images_Docs/
    #   Radioastro_21cm_2012b.pdf
    #   says for 0 <= gLon <= 90, the max Galactic velocity around Galactic center
    #   = galGalMax
    #   = galGasGalMax + (earth Galactic rotation speed) * sin(gLon)
    #   = galGasGalMax + (218 km/s)                      * sin(gLon)
    galGasGalMax = np.add(velGLonUEdge[180:180 + 91], 218 * np.sin(np.radians(np.arange(91))))   # in km/s

    # Page 46 also
    #   says for 0 <= gLon <= 90, the Galactic gas radius from Galactic center
    #   = galGasRadius
    #   = (Solar radius from Galactic center)      * sin(gLon)
    #   = (2.6e17 km * (Light year / 9.461e+12 km) * sin(gLon)
    #   = 27481 light years                        * sin(gLon)
    #
    #   = (26000 light years says https://en.wikipedia.org/wiki/Galactic_Center) * sin(gLon)
    galGasRadius = 26000 * np.sin(np.radians(np.arange(91)))            # in light years

    plt.plot(galGasRadius, galGasGalMax, 'g.')

    plt.title(titleS)
    plt.grid(ezConDispGrid)
    plt.xlabel('Gas Radius from Galactic Center (Light Years)')
    plt.xlim(0, 26000)        # radius from 0 to Solar radius from Galactic center (=26000 light years)
    plt.xticks([0,      5000.,   10000.,   15000.,   20000.,   25000.],
               ['0', '5,000', '10,000', '15,000', '20,000', '25,000'])

    ylabelS = 'Gas Max Velocity around Galactic Center (km/s)'
    # if ezConVelGLonEdgeLevel not 0, then ezConVelGLonEdgeFrac ignored
    if ezConVelGLonEdgeLevel:
        ylabelS += f'\nezConVelGLonEdgeLevel = {ezConVelGLonEdgeLevel:0.4f}'
    else:
        ylabelS += f'\nezConVelGLonEdge: Frac={ezConVelGLonEdgeFrac:0.4f}'
        ylabelS += f' Level={velGLonEdgeLevel:0.4f}'
    plt.ylabel(ylabelS)

    if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
        os.remove(plotName)
    plt.savefig(plotName, dpi=300, bbox_inches='tight')



def plotEzCon800antXTVTMaxIdxGLon():

    global fileNameLast             # string
    global plotCountdown            # integer
    global antXTVT                  # float 2d array

    global titleS                   # string
    global ezConPlotRequestedL      # integer list

    plotCountdown -= 1

    if 800 not in ezConPlotRequestedL:
        return(1)

    plotName = 'ezCon800' + antXNameL[0] + 'TVTMaxIdxGLon.png'

    print()
    print(f'  {fileNameLast}  {plotCountdown} plotting {plotName} ================================')

    plt.clf()

    #velMaxIndex = np.empty(antLen, dtype=int)
    #for n in range(antLen):
    #    velMaxIndex[n] = np.maximum(antXTVT[:, n] = antXTVTThis)    # index of spectrum's max power

    antXTVTMaxIndex = np.argmax(antXTVT, axis=0)          # freqBin-like for each sample's max
    #velMaxIndexY, velMaxIndexX = np.where(antXTVT == velMax)

    # ezConOut[:, 4] is gLon is RtoL from -180 thru 180
    #pts = plt.scatter(ezConOut[:, 4], velMaxIndex-120,
    #    s=1, marker='|', c='green', cmap=plt.get_cmap('gnuplot'))
    #pts = plt.scatter(ezConOut[:, 4]+360., velMaxIndex-120,
    #    s=1, marker='|', c='violet', cmap=plt.get_cmap('gnuplot'))
    #pts = plt.scatter(ezConOut[:, 4], antXTVTMaxIndex,
    #    s=1, marker='|', c='green', cmap=plt.get_cmap('gnuplot'))
    #pts = plt.scatter(ezConOut[:, 4]+360., antXTVTMaxIndex,
    #    s=1, marker='|', c='violet', cmap=plt.get_cmap('gnuplot'))
    pts = plt.scatter(ezConOut[:, 4], antXTVTMaxIndex,
        s=1, marker='|', c='green')
    pts = plt.scatter(ezConOut[:, 4]+360., antXTVTMaxIndex,
        s=1, marker='|', c='red')

    plt.title(titleS)
    plt.grid(0)

    plt.xlabel('Galactic Longitude (degrees)')
    #plt.xlim(180, -180)        # in degrees
    #plt.xlim(-180, 180)        # in degrees
    #plt.xticks([  180,   90,   0,   -90,   -180],
    #           [ '180', '90', '0', '-90', '-180'])
    plt.xlim(0, 360)        # in degrees

    plt.ylabel('Index of ' + antXNameL[1] + 'TVT Spectrum Maximum (increasing freq)')
    #plt.ylim(-270, 270)
    plt.ylim(0, 400)

    if os.path.exists(plotName):    # to force plot file date update, if file exists, delete it
        os.remove(plotName)
    plt.savefig(plotName, dpi=300, bbox_inches='tight')



def plotEzCon690gLonDegByFreqAvg():

    global velGLonP180              # float 2d array
    global velGLonP180Count         # integer array
    global velGLonP180CountSum      # integer

    global fileNameLast             # string
    global plotCountdown            # integer
    global titleS                   # string
    global ezConDispGrid            # integer
    global byFreqBinX               # float array
    global ezConPlotRequestedL      # integer list
    global freqCenter               # float

    # if anything in velGLonP180 to plot
    if not (690 in ezConPlotRequestedL and velGLonP180CountSum):
        return(1)

    plotCountdown += np.count_nonzero(velGLonP180Count)

    print()
    print('   plotEzCon690gLonDegByFreqAvg ===============')

    if 1:
        # same ylim for all ezCon690GLonDegP180_nnnByFreqBinAvg plots
        ezCon690yLimMin = 0.95 * velGLonP180.min()
        print(' ezCon690yLimMin =', ezCon690yLimMin)
        # for small antLen, that ezCon690yLimMin may be nan

        ezCon690yLimMax = 1.05 * velGLonP180.max()
        print(' ezCon690yLimMax =', ezCon690yLimMax)
        # for small antLen, that ezCon690yLimMax may be nan

    for gLonP180 in range(361):                 # for every column, RtoL

        if velGLonP180Count[gLonP180]:      # if column used

            plotCountdown -= 1

            # create gLonDegS with form of '+nnn' or '-nnn' degrees
            ## create plotName with form of 'ezCon690GLonDegP180_nnnByFreqBinAvg.png'
            #plotName = f'ezCon690gLonDegP180_{gLonP180:03d}ByFreqAvg.png'
            # create plotName with form of 'ezCon690_nnnGLonDegPnnnByFreqAvg.png'
            #   or                         'ezCon690_nnnGLonDegMnnnByFreqAvg.png'
            if gLonP180 < 180:
                gLonDegS = f'-{180 - gLonP180:03d}'        # '-nnn' with leading zeros
                plotName = f'ezCon690_{gLonP180:03d}gLonDegM{gLonDegS[1:]}ByFreqAvg.png'
            else:
                gLonDegS = f'+{gLonP180 - 180:03d}'        # '+nnn' with leading zeros
                plotName = f'ezCon690_{gLonP180:03d}gLonDegP{gLonDegS[1:]}ByFreqAvg.png'

            print()
            print(f'  {fileNameLast}  {plotCountdown} plotting {plotName}' \
                + ' ================================')
            print(' gLonP180 =', gLonP180)
            print(' gLonP180 - 180 =', gLonP180 - 180)
            print(' velGLonP180Count[gLonP180] =', velGLonP180Count[gLonP180])
            plt.clf()
            
            # velGLonP180 stores increasing velocity, but X axis is increasing freq, so use -byFreqBinX
            plt.plot(-byFreqBinX, velGLonP180[:, gLonP180])

            plt.title(titleS)
            plt.grid(ezConDispGrid)

            #plt.xlabel('Doppler (MHz)')
            plt.xlabel(f'Doppler MHz from {freqCenter:.3f} MHz')
            plt.xlim(-dopplerSpanD2, dopplerSpanD2)

            if 0:
                # new ylim for each ezCon690GLonDegP180_nnnByFreqBinAvg plot
                ezCon690yLimMin = 0.95 * velGLonP180[:, gLonP180].min()
                print(' ezCon690yLimMin =', ezCon690yLimMin)
                # for small antLen, that ezCon690yLimMin may be nan

                ezCon690yLimMax = 1.05 * velGLonP180[:, gLonP180].max()
                print(' ezCon690yLimMax =', ezCon690yLimMax)
                # for small antLen, that ezCon690yLimMax may be nan

            if not np.isnan(ezCon690yLimMin) and not np.isnan(ezCon690yLimMax):
                plt.ylim(ezCon690yLimMin, ezCon690yLimMax)

            plt.ylabel('Average ' + antXNameL[1] + 'TV Spectrum' \
                + '\n\nGalactic Longitude = ' + gLonDegS + ' degrees', \
                rotation=90, verticalalignment='bottom')

            if os.path.exists(plotName): # to force plot file date update, if file exists, delete it
                os.remove(plotName)
            plt.savefig(plotName, dpi=300, bbox_inches='tight')



#A#################################################################################################



def main():

    global raw                      # float 2d array
    global ant                      # float 2d array
    global antB                     # float 2d array
    global ref                      # float 2d array
    global refQty                   # integer
    global antRA                    # float 2d array
    global antRB                    # float 2d array
    global antX                     # float 2d array
    global antXT                    # float 2d array
    global antXTV                   # float 2d array
    global antXTVT                  # float 2d array
    global antXNameL                # list of strings
    global ezCon399SignalSampleByFreqBinL   # integer list
    global ezCon399SignalSampleByFreqBin1d  # float list or numpy

    global refRawAvg                # float array

    global ezConAntXInput           # integer

    global ezConRawLog              # integer
    global ezConRawSamplesUseL      # integer list
    global ezConAntMaxPluckValL     # float list
    global ezConAntSamplesUseL      # integer list
    global ezConAntPluckL           # integer list
    global ezConRawFreqBinTrimL     # list of integer pairs
    global ezConRawFreqTrimL        # list of float pairs
    global ezConRawFreqBinHideL     # integer list
    global ezConAntFreqBinHideL     # integer list
    global ezConRefFreqBinHideL     # integer list
    global ezConAntFreqBinSmooth    # float - RFI spur limiter: max muliplier over 4 neighboring freqBin

    global ezConAntXTVTMaxPluckQtyL         # integer list
    global ezConAntXTVTMaxPluckValL         # float list
    global ezConAntXTVTAvgPluckQtyL         # integer list
    global ezConAntXTVTAvgPluckValL         # float list
    global ezConAntXTVTPluckL               # integer list
    global ezConAntXTVTClipL                # float list
    global ezConAntXTVTSmooth               # integer
    global ezConAntXTVTFreqBinsClipL        # float list
    global ezConAntXTVTIntegrate            # integer
    global ezCon087Csv                      # integer

    global xTickLabelsHeatAntL      # string list
    global xTickLocsAnt             # float array
    global ezConRefMode31           # float


    startTime = time.time()
    xTickLocsAnt = []               # force new xTickLocsAnt
    xTickLabelsHeatAntL = []        # force new xTickLabelsHeatAntL

    #################################################################################################
    #
    # Plot number system:
    #
    #   0xx         signal processing spectrum         by sample  = explain sig processing progression
    #   1xx .ezb file column                           by sample  = display .ezb file columns output
    #   2xx         signal processing spectrum average by sample  = display sig processing progression details
    #   3xx average signal processing spectrum         by Doppler = display sig spectrum   progression average
    #   4xx galactic plots                             by galactic longitude (mostly)
    #   5xx galactic longitude spectrum plots          by Doppler
    #
    # Trailing asterix (*) indicates plot displays rawLen samples
    # Numbers is parentheses indicates plot must be requested (default is 0-199).
    # Numbers is brackets    indicates plot is a duplicate of number in brackets.
    #
    #
    #                               2d      1d Column  Making  Signal        G Crossing
    #                      X Axis = Samples Samples    Samples FreqBins GLon FreqBins
    #    Y Axis                     0xx     1xx        2xx     3xx      4xx  5xx
    #    ================           ======= ========== ======= ======== ==== ==========
    #    rawRaw                     000*               200*    300
    #    raw                        001*               201A*   301
    #
    #    if ezConRefMode == 20:
    #      rawAntAvg                                   201B*
    #      rawAvgRecentFrac                            201C*
    #      sampleRef                                   201D*
    #      sampleRefAgain                              201E*
    #      sampleBad                                   201F*
    #
    #    rawAntRef                                     201G*
    #
    #    timeUtcMjdDBetweenRaw                         201H*
    #    timeUtcMjdDBetweenAntRaw                      201I
    #    timeUtcMjdDBetweenRefRaw                      201J
    #
    #    timeUtcMjd                         100
    #    raH                                101
    #    decDeg                             102
    #
    #    gLatDeg                            103
    #    gLonDeg                            104
    #
    #    vlsr                               105
    #
    #    count                             (106)
    #    azimuth                            107
    #    elevationDeg                       108
    #    spare3                            (109)
    #
    #
    #    antRaw                    (002)              (202)    302
    #    ant                        007     110[=207]  207     307
    #
    #    antMax                    (017)    111[=217]  217
    #
    #
    #    refRaw                    (022)              (222)    322
    #    ref                        027     112[=227]  227     327
    #
    #    refMax                    (037)    113[=237]  237
    #
    #
    #    antBas                                        241
    #    antB                       047     114[=247]  247     347
    #
    #    antBMax                   (057)    115[=257]  257
    #
    #
    #    antRA                      061                261     361
    #    antRABas                                      262
    #    antRB                      067     116[=267]  267     367
    #
    #    antRBMax                  (077)    117[=277]  277
    #
    #    antXT                      081                281     381
    #    antXTV                     082                282     382
    #    antXTVT                    087     118[=287]  287     387
    #    antXTRfi                                              388
    #
    #    antXTVTMax                (097)    119[=297]  297
    #
    #    sigProg                            191
    #
    #    velGLon                                                        410
    #    velGLonCount                                                   411
    #    velGLonPolar                                                   412
    #    galDecGLon                                                     420
    #
    #    velGLonEdges                                                   430
    #    galRot                                                         431
    #
    #    gLon_nnnByFreqBinAvg                                                590
    #
    #################################################################################################

    #################################################################################################
    # start with    ant[fileFreqBinQty, n]
    #               ref[fileFreqBinQty, n]
    #
    # end with      ant[fileFreqBinQty, n]     antAvg[n]     antMax[n]   antBaseline[n]
    #              antB[fileFreqBinQty, n]    antBAvg[n]    antBMax[n]
    #               ref[fileFreqBinQty, n]     refAvg[n]     refMax[n]
    #             antRA[fileFreqBinQty, n]   antRAAvg[n]               antRABaseline[n]
    #             antRB[fileFreqBinQty, n]   antRBAvg[n]   antRBMax[n]
    #             antXT[fileFreqBinQty, n]   antXTAvg[n]
    #            antXTV[fileFreqBinQty, n]  antXTVAvg[n]  antXTVMax[n]
    #################################################################################################
    #         antRBAvg[n]  vs   antXTAvg[n] ??????????????
    #################################################################################################
    # Status:
    # Also have dataTimeUtc[n] azimuthDeg[n] elevationDeg[n] 
    #   fileFreqMin fileFreqMax fileNameLast
    #   freqCenter dopplerSpanD2 freqStep ezConOut[n, 18]
    #################################################################################################

    #################################################################################################
    #
    #      Study of Global Data Array Lifetimes, to Reduce Memory Requirements
    #
    #                  ***  ***** * * = plots which display rawLen samples
    # a
    # r               r             t
    # r               e             i
    # a               a    c      r m                                                                      
    # y               d    r      a e                                    a       a e                      
    #                 D    e      w B       a                r           n       n z                       s
    # d               a    a      A e   a   n       a    r   e           t       t C                   a   i
    # i               t    t      n t   n   t       n    e   f       a   Ra   a  X o                   n   g
    # m               a    e      t w   t   H       ta   f   H       n   An   n  T n                   t   P
    # e               Dr   R      R e   R   i   a   Bn   R   i   r   t   Bt   t  R O                   X   r   v
    # n               ia   e      e e   a   d   n   at   a   d   e   R   aR   X  f u                   T   oae e
    # s               rw   f      f n   w   e   t   sB   w   e   f   A   sB   T  i t                   V   gzl l
    # i            {  |012 |11111 1 111 012 012 012 1012 012 012 012 012 1012 0122 |333333333333333333 012 144 |
    # o     plot # {  |000 |00000 0 000 111 111 111 2222 333 333 333 444 4444 4444 |000000000011111111 444 999 |
    # n            {  |111 |55555 8 999 000 111 222 3444 000 111 222 333 4555 6668 |012345678901234567 777 003 |
    # s               |    |ABCDE   ABC                                            |                           |
    #
    # 1 dataTimeUtc   *ooo oooooo o *XX ooo ooo ooo oooo ooo ooo ooo ooo oooo oooo Xoooooooooooooooooo ooo ooo o
    # 1 azimuth       *ooo *ooooo o ooo ooo ooo ooo oooo ooo ooo ooo ooo oooo oooo Xoooooooooooooooooo ooo oX. .
    # 1 elevation     *ooo *ooooo o ooo ooo ooo ooo oooo ooo ooo ooo ooo oooo oooo Xoooooooooooooooooo ooo ooX .
    # 1 rawIndex      .... *ooooo o ooo oX. ... ... .... ... ... ... ... .... .... ................... ... ... .
    #
    # 2 raw           *XXX XXXXXX X XXX ... ... ... .... ... ... ... ... o... .... ................... ... ... .
    # 1 rawAntAvg     .... *ooooo * ooo ooo ooo ooo oooo ooo ooo ooo ooo oooo oooo ooooooooooooooooooo ooo X.. .
    #
    # 1 maskRawAnt    .... *xxxxx X xX. ... ... ... .... ... ... ... ... .... .... ................... ... ... .
    # 1 maskRawRef    .... *xxxxx X xxX ... ... ... .... ... ... ... ... .... .... ................... ... ... .
    #
    # 2 ant           .... *ooooo o ooo *XX *XX *XX Xooo ooo ooo ooo X.. .... .... ................... ... ... .
    # 1 antRawAvg     .... ...... . ... .*o ooo ooo oooo ooo ooo ooo ooo oooo oooo ooooooooooooooooooo ooo X.. .
    # 1 antAvg        .... ...... . ... ... ... .*. .... ... ... ... *oo oooo oooo X.................. ... ... .
    # 1 antMax        .... ...... . ... ... ... ... .... ... ... ... *oo oooo oooo X.................. ... ... .
    # 1 antBaseline   .... ...... . ... ... ... ... *Xoo ooo ooo ooo ooo oooo oooo ooooooooooooooooooo ooo X.. .
    #
    # 2 antB          .... ...... . ... ... ... ... .*XX ... ... ... ... .... .... ................... ... ... .
    # 1 antBAvg       .... ...... . ... ... ... ... ..*o ooo ooo ooo ooo oooo oooo X.................. ... ... .
    # 1 antBMax       .... ...... . ... ... ... ... ...* ooo ooo ooo ooo oooo oooo X.................. ... ... .
    #
    # 2 ref           .... *ooooo o ooo ooo ooo ooo oooo ooo *oo *XX X.. .... .... ................... ... ... .
    # 1 refRawAvg     .... ...... . ... ... ... ... .... *oo ooo ooo ooo oooo oooo ooooooooooooooooooo ooo X.. .
    # 1 refAvg        .... ...... . ... ... ... ... .... .*. ... ... *oo oooo oooo X.................. ... ... .
    # 1 refMax        .... ...... . ... ... ... ... .... ... ... ... *oo oooo oooo X.................. ... ... .
    #
    # 2 antRA         .... ...... . ... ... ... ... .... ... ... ... *XX XX.. .... ................... ... ... .
    # 1 antRAAvg      .... ...... . ... ... ... ... .... ... ... ... ... .*Xo oooo ooooooooooooooooooo ooo X.. .
    #
    # 1 antRABaseline .... ...... . ... ... ... ... .... ... ... ... ... *Xoo oooo ooooooooooooooooooo ooo X.. .
    #
    # 2 antRB         .... ...... . ... ... ... ... .... ... ... ... ... .*XX X... ................... ... ... .
    # 1 antRBAvg      .... ...... . ... ... ... ... .... ... ... ... ... .... *ooo ooooooooooooooooooo ooo X.. .
    #
    # 2 antXT         .... ...... . ... ... ... ... .... ... ... ... ... .... *ooo X.................. ... ... .
    #
    # 2 ezConOut      .... ...... . ... ... ... ... .... ... ... ... ... .... .... *XXXXXXXXXXXXXXXXXX ooo Xoo o
    #
    # 2 antXTV        .... ...... . ... ... ... ... .... ... ... ... ... .... .... *oooooooooooooooooo XXX ooo o
    #
    #################################################################################################


    printHello()
    
    ezConArguments()

    print('\n Python sys.version =', sys.version)
    print('\n matplotlib.__version__ =', matplotlib.__version__)

    readDataDir()   # creates ezRAObsLat, ezRAObsLon, ezRAObsAmsl, ezRAObsName
                    #   fileFreqMin, fileFreqMax, fileFreqBinQty, 
                    #   azimuthDeg, elevationDeg, dataFileIdx, dataTimeUtc, raw, rawLen, fileNameLast

    #openFileSdre()          # In case it will eventually error.  Creates fileWriteNameSdre, fileWriteSdre
    openFileEzb()           # In case it will eventually error.  Creates fileWriteNameEzb, fileWriteEzb
    openFileStudy()         # In case it will eventually error.  Creates fileWriteNameStudy, fileWriteStudy

    rawPlotPrep()                       # creates rawLenM1, freqStep, dopplerSpanD2, freqCenter,
                                        #   titleS, yTickHeatL, byFreqBinX

    # Create signals and plot.
    # Full sized signal histories (used in heatmaps) are large, so delete them promptly.

    ezConRawLog = 0

    # if any raw filtering, plot rawRaw before the filtering
    #if ezConRawSamplesUseL or ezConRawSamplePluckL or ezConRawAvgTrimFracL or ezConRawFreqBinHideL \
    #    or ezConRawFreqBinSmooth:
    #if ezConRawFreqBinHideL:
    #if ezConRawFreqBinTrimL or ezConRawFreqTrimL or ezConRawFreqBinHideL:
    #if ezConRawFreqBinTrimL or ezConRawFreqTrimL or ezConRawFreqBinHideL or ezConRawLog or ezConHeatVMinMaxL.any():
    plotEzCon000rawRaw()                # rawRaw heatmap
    plotEzCon200rawRawAvg()
    plotEzCon300rawRawByFreqBinAvg()

    if ezConRawLog:
        ezConRawLogDo()

    if ezConRawFreqBinTrimL or ezConRawFreqTrimL:
        ezConRawFreqBinTrimLDo()

    #if ezConRawSamplesUseL or ezConRawSamplePluckL:
    #    ezConRawSamplesUseLDo()

    #if ezConRawAvgTrimFracL:
    #    ezConRawAvgTrimFracLDo()

    if ezConRawFreqBinHideL:
        ezConRawFreqBinHideLDo()

    #if ezConRawFreqBinSmooth:
    #    ezConRawFreqBinSmoothDo

    plotEzCon001raw()                           # raw heatmap
    plotEzCon201ArawAvg()
    plotEzCon301ArawByFreqBinAvg()
    plotEzCon301BrawByFreqBinAvg()

    # -createRef31 needs RaH, so create partial ezConOut in .ezb format
    # ezbMenu: TimeUtcMjd  RaH  DecDeg  GLatDeg  GLonDeg  VLSR  Count  AzimuthDeg  ElevationDeg  AntXTVTCmDop
    #          0           1    2       3        4        5     6      7           8             9
    #   AntAvg  AntMax    RefAvg  RefMax
    #   10      11        12      13
    #   AntBAvg  AntBMax    AntRBAvg  AntRBMax    AntXTVTAvg  AntXTVTMax
    #   14       15          16        17         18          19
    createEzConOutEzbA()                # using ezConAstroMath, creates partial ezConOut
                                        #   creates columns 0 through 8 in ezConOut[n, 20]

    # free azimuthDeg[] global memory
    azimuthDeg = []
    azimuthDeg = None
    del azimuthDeg

    # free elevationDeg[] global memory
    elevationDeg = []
    elevationDeg = None
    del elevationDeg

    createRef()                         # creates ant, ref, maskRawAnt, maskRawRef
    ####plotEzCon201BrawAntAvg()
    ####plotEzCon201BrawAntAvgRecentFrac()
    ####plotEzCon201DsampleRef()
    ####plotEzCon201EsampleRefAgain()
    ####plotEzCon201FsampleBad()
    ####plotEzCon201GrawAntRef()                    # using raw, maskRawAnt and maskRawRef
    ####plotEzCon201HtimeUtcMjdDBetweenRaw()        # using raw and dataTimeUtc
    ####plotEzCon201ItimeUtcMjdDBetweenAntRaw()     # using raw, dataTimeUtc, and maskRawAnt
    ####plotEzCon201JtimeUtcMjdDBetweenRefRaw()     # using raw, dataTimeUtc, and maskRawRef

    # free raw[] global memory
    raw = []
    raw = None
    del raw

    # free dataTimeUtc[] global memory
    dataTimeUtc = []
    dataTimeUtc = None
    del dataTimeUtc

    # free maskRawAnt[] global memory
    maskRawAnt = []
    maskRawAnt = None
    del maskRawAnt

    # free maskRawRef[] global memory
    maskRawRef = []
    maskRawRef = None
    del maskRawRef



    ####### ant

    # if any ant filtering, plot antRaw before the filtering
    #if ezConAntSamplesUseL or ezConAntPluckL or ezConAntAvgPluckFracL or ezConAntFreqBinHideL \
    #    or ezConAntFreqBinSmooth:
    if ezConAntSamplesUseL or ezConAntPluckL or ezConAntFreqBinSmooth or ezConAntAvgPluckQtyL or ezConAntAvgPluckFracL or ezConAntMaxPluckValL:
            plotEzCon002antRaw()
            plotEzCon202antRawAvg()
            plotEzCon302antRawByFreqBinAvg()

    if ezConAntMaxPluckValL:
        ezConAntMaxPluckValLDo()

    #if ezConAntSamplesUseL or ezConAntPluckL:
    if ezConAntSamplesUseL:
        ezConAntSamplesUseLDo()

    if ezConAntAvgPluckQtyL:
        ezConAntAvgPluckQtyLDo()

    if ezConAntAvgPluckFracL:
        ezConAntAvgPluckFracLDo()

    if ezConAntFreqBinHideL:
        ezConAntFreqBinHideLDo()

    if ezConAntFreqBinSmooth < 999998.:
        ezConAntFreqBinSmoothDo()

    if ezConAntPluckL:
        ezConAntPluckLDo()

    plotEzCon201ZantFileIndex()

    # free dataFileIdx[] global memory
    dataFileIdx = []
    dataFileIdx = None
    del dataFileIdx

    plotEzCon007ant()
    plotEzCon207antAvg()                # creates antAvg
    plotEzCon307antByFreqBinAvg()       # creates antByFreqBinSumAvg
    plotEzCon317antByFreqBinMax()       # creates antByFreqBinMax

    plotEzCon017antMax2d()
    plotEzCon217antMax()                # creates antMax


    ####### ref

    refRawAvg = np.mean(ref, axis=0)            # creation,  needed for plotEzCon191sigProg()

    # if any ref filtering, plot refRaw before the filtering
    #if ezConRefAvgPluckQtyL or ezConRefAvgPluckFracL or ezConRefFreqBinHideL or ezConRefFreqBinSmooth:
    if ezConRefAvgPluckQtyL or ezConRefAvgPluckFracL:
            plotEzCon022refRaw()
            plotEzCon222refRawAvg()
            plotEzCon322refRawByFreqBinAvg()

    if ezConRefFreqBinHideL:
        ezConRefFreqBinHideLDo()

    #if ezConRefFreqBinSmooth:
    #    ezConRefFreqBinSmoothDo()

    if ezConRefAvgPluckQtyL:
        ezConRefAvgPluckQtyLDo()

    if ezConRefAvgPluckFracL:
        ezConRefAvgPluckFracLDo()

    plotEzCon027ref()
    plotEzCon227refAvg()                # creates refAvg
    plotEzCon327refByFreqBinAvg()       # creates refByFreqBinSumAvg
    plotEzCon337refByFreqBinMax()       # creates refByFreqBinMax

    plotEzCon037refMax2d()
    plotEzCon237refMax()                # creates refMax


    ####### antB

    plotEzCon241antBaseline()           # creates antBaseline

    plotEzCon047antB()                  # creates antB
    plotEzCon247antBAvg()               # creates antBAvg
    plotEzCon347antBByFreqBinAvg()      # creates antBByFreqBinSumAvg
    plotEzCon357antBByFreqBinMax()      # creates antBByFreqBinMax

    plotEzCon057antBMax2d()
    plotEzCon257antBMax()               # creates antBMax

    # if automated setting of ezConAntXInput
    if ezConAntXInput == -1:
        #print('\n=========================== len(ref) =', len(ref))
        #if 1 < len(ref):
        if 1 < refQty:
            ezConAntXInput = 6
            print(f'\n     refQty = {refQty:,}  so ezConAntXInput changed to 6 for AntRB\n')
        else :
            ezConAntXInput = 4
            print(f'\n     refQty = {refQty:,}  so ezConAntXInput changed to 4 for AntB\n')

    # if antB not needed, free antB global memory
    if ezConAntXInput != 4:
        if ezCon399SignalSampleByFreqBinL[0] == 14:
            ezCon399SignalSampleByFreqBin1d = antB[:, ezCon399SignalSampleByFreqBinL[1]]
        antB = []
        antB = None
        del antB


    ####### antRB

    plotEzCon061antRA()                 # creates antRA
    # if ant not needed, free ant global memory
    if ezConAntXInput != 0:
        if ezCon399SignalSampleByFreqBinL[0] == 10:
            ezCon399SignalSampleByFreqBin1d = ant[:, ezCon399SignalSampleByFreqBinL[1]]
        ant = []
        ant = None
        del ant
    # if ref not needed, free ref global memory
    if ezConAntXInput != 2:
        if ezCon399SignalSampleByFreqBinL[0] == 12:
            ezCon399SignalSampleByFreqBin1d = ref[:, ezCon399SignalSampleByFreqBinL[1]]
        ref = []
        ref = None
        del ref
    plotEzCon261antRAAvg()
    plotEzCon361antRAByFreqBinAvg()

    plotEzCon262antRABaseline()         # creates antRABaseline

    plotEzCon067antRB()                 # creates antRB
    # if antRA not needed, free antRA global memory
    if ezConAntXInput != 5:
        antRA = []
        antRA = None
        del antRA
    plotEzCon267antRBAvg()              # creates antRBAvg
    plotEzCon367antRBByFreqBinAvg()     # creates antRBByFreqBinSumAvg
    plotEzCon377antRBByFreqBinMax()     # creates antRBByFreqBinMax

    plotEzCon077antRBMax2d()
    plotEzCon277antRBMax()              # creates antRBMax
    # if antRB not needed, free antRB global memory
    if ezConAntXInput != 6:
        if ezCon399SignalSampleByFreqBinL[0] == 16:
            ezCon399SignalSampleByFreqBin1d = antRB[:, ezCon399SignalSampleByFreqBinL[1]]
        antRB = []
        antRB = None
        del antRB


    if not len(ezCon399SignalSampleByFreqBin1d):        # if empty
        if ezCon399SignalSampleByFreqBinL[0] == 10:
            ezCon399SignalSampleByFreqBin1d = ant[:, ezCon399SignalSampleByFreqBinL[1]]
        elif ezCon399SignalSampleByFreqBinL[0] == 12:
            ezCon399SignalSampleByFreqBin1d = ref[:, ezCon399SignalSampleByFreqBinL[1]]
        elif ezCon399SignalSampleByFreqBinL[0] == 14:
            ezCon399SignalSampleByFreqBin1d = antB[:, ezCon399SignalSampleByFreqBinL[1]]
        elif ezCon399SignalSampleByFreqBinL[0] == 16:
            ezCon399SignalSampleByFreqBin1d = antRB[:, ezCon399SignalSampleByFreqBinL[1]]
        # antXTVT does not exist yet

    ####### antX

    # create antX
    if ezConAntXInput == 0:             # use Ant
        antX = ant
        # free ant global memory
        ant = []
        ant = None
        del ant
        antXNameL = ['ant', 'Ant']
    elif ezConAntXInput == 2:           # use Ref
        antX = ref
        # free ref global memory
        ref = []
        ref = None
        del ref
        antXNameL = ['ref', 'Ref']
    elif ezConAntXInput == 4:           # use AntRB
        antX = antB
        # free antB global memory
        antB = []
        antB = None
        del antB
        antXNameL = ['antB', 'AntB']
    elif ezConAntXInput == 5:           # use AntRA
        antX = antRA
        # free antRA global memory
        antRA = []
        antRA = None
        del antRA
        antXNameL = ['antRA', 'AntRA']
    elif ezConAntXInput == 6:           # use AntRB
        antX = antRB
        # free antRB global memory
        antRB = []
        antRB = None
        del antRB
        antXNameL = ['antRB', 'AntRB']

    plotEzCon081antXT()                 # creates antXT, deletes AntX
    plotEzCon281antXTAvg()              # creates antXTAvg
    plotEzCon381antXTByFreqBinAvg()     # creates antXTByFreqBinSumAvg

    plotEzCon382antXTByFreqBinAvgRfi()
    plotEzCon393antXTByFreqBinMax()

    # now need VLSR, so create partial ezConOut in .ezb format
    # ezbMenu: TimeUtcMjd  RaH  DecDeg  GLatDeg  GLonDeg  VLSR  Count  AzimuthDeg  ElevationDeg  AntXTVTCmDop
    #          0           1    2       3        4        5     6      7           8             9
    #   AntAvg  AntMax    RefAvg  RefMax
    #   10      11        12      13
    #   AntBAvg  AntBMax    AntRBAvg  AntRBMax    AntXTVTAvg  AntXTVTMax
    #   14       15          16        17         18          19
    #createEzConOutEzb()                 # using ezConAstroMath, creates partial ezConOut,
    #                                    # deletes antAvg, antMax, refAvg, refMax,
    #                                    #   antBAvg, antBMax, antRBAvg, antRBMax
    createEzConOutEzbB()                # writes over columns 10 through 17 in ezConOut[n, 20]
                                        # deletes antAvg, antMax, refAvg, refMax,
                                        #   antBAvg, antBMax, antRBAvg, antRBMax

    ####### antXTV

    createAntXTV()                      # creates antXTV

    ####### antXTVT

    createAntXTVT()                     # creates antXTVT, keeps antXTV for Galaxy crossing plots
    if ezConAntXTVTMaxPluckQtyL or ezConAntXTVTMaxPluckValL :
        ezConAntXTVTMaxPluckDo()        # thin ezConOut[:, :], antXTV, antXTVT, antLen, and antLenM1
    if ezConAntXTVTAvgPluckQtyL or ezConAntXTVTAvgPluckValL :
        ezConAntXTVTAvgPluckDo()        # thin ezConOut[:, :], antXTV, antXTVT, antLen, and antLenM1
    if ezConAntXTVTPluckL:
        ezConAntXTVTPluckDo()           # thin ezConOut[:, :], antXTV, antXTVT, antLen, and antLenM1

    # antXTV and antXTVT now filtered
    plotEzCon082antXTV()
    plotEzCon282antXTVAvg()             # creates antXTVAvg
    plotEzCon383antXTVByFreqBinAvg()
    plotEzCon394antXTVByFreqBinMax()

    if ezConAntXTVTClipL:
        ezConAntXTVTClipDo()            # enforce clip minimum and clip maximum limits upon antXTVT
    if ezConAntXTVTSmooth:
        ezConAntXTVTSmoothDo()          # smooth antXTVT heatmap image

    plotEzCon086antXTVT()
    plotEzCon096antXTVTMax2d()
    plotEzCon386antXTVTByFreqBinAvg()   # creates antXTVTByFreqBinSumAvg
    plotEzCon396antXTVTByFreqBinMax()   # creates antXTVTByFreqBinMax
    plotEzCon391ByFreqBinSumAvg()       # plots byFreqBinSumAvg of ant, ref, antB, antXT, antXTVT
    plotEzCon392ByFreqBinMax()          # plots byFreqBinMax    of ant, ref, antB, antXT, antXTVT

    # because ezConAntXTVTFreqBinsClipDo() may changes fileFreqBinQty
    if (not len(ezCon399SignalSampleByFreqBin1d)) and ezCon399SignalSampleByFreqBinL[1] < 18:
        ezCon399SignalSampleByFreqBin1d = antXTVT[:, ezCon399SignalSampleByFreqBinL[1]]
        plotEzCon399SignalSampleByFreqBin()

    if ezConAntXTVTFreqBinsClipL:
        ezConAntXTVTFreqBinsClipDo()    # reduce AntXTVT to only ezConAntXTVTFreqBinsClipL span FreqBin

    plotEzCon087antXTVT()
    plotEzCon088antXTVTByFreqBinAvgFall()
    plotEzCon287antXTVTAvg()    # creates antXTVTAvg into ezConOut[:, 18], antXTVTCmDop into ezConOut[:, 9]
    plotEzCon387antXTVTByFreqBinAvg()   # recreates antXTVTByFreqBinSumAvg
    plotEzCon388antXTVTByFreqBinAvgAll()

    plotEzCon097antXTVTMax2d()
    plotEzCon098antXTVTByFreqBinMaxFall()
    plotEzCon297antXTVTMax()            # creates antXTVTMax into ezConOut[:, 19]
    plotEzCon397antXTVTByFreqBinMax()   # recreates antXTVTByFreqBinMax
    plotEzCon398antXTVTByFreqBinMaxAll()
    plotEzCon800antXTVTMaxIdxGLon()

    if ezConAntXTVTIntegrate:
        ezConAntXTVTIntegrateDo()       # integrate into one day's drift-scan, RA or GLon 

    #plotEzCon097antXTVTMax2d()
    #plotEzCon098antXTVTByFreqBinMaxFall()
    #plotEzCon297antXTVTMax()            # creates antXTVTMax into ezConOut[:, 19]

    if (not len(ezCon399SignalSampleByFreqBin1d)) and 18 <= ezCon399SignalSampleByFreqBinL[1]:
        ezCon399SignalSampleByFreqBin1d = antXTVT[:, ezCon399SignalSampleByFreqBinL[1]]
        plotEzCon399SignalSampleByFreqBin()


    #writeFileSdre()
    writeFileEzb()


    # plot most ezConOut columns
    plotEzCon100timeUtcMjd()
    plotEzCon101raH()
    plotEzCon102decDeg()
    plotEzCon103gLatDeg()
    plotEzCon104gLonDeg()
    plotEzCon105vlsr()
    #plotEzCon106count()
    plotEzCon107azimuth()
    plotEzCon108elevation()
    plotEzCon109antXTVTCmDop()

    plotEzCon110antAvg()
    plotEzCon111antMax()

    plotEzCon112refAvg()
    plotEzCon113refMax()

    plotEzCon114antBAvg()
    plotEzCon115antBMax()

    plotEzCon116antRBAvg()
    plotEzCon117antRBMax()

    plotEzCon118antXTVTAvg()
    plotEzCon119antXTVTMax()


    plotEzCon191sigProg()

    # free antRawAvg global memory
    antRawAvg = []
    antRawAvg = None
    del antRawAvg

    # free antBaseline global memory
    antBaseline = []
    antBaseline = None
    del antBaseline

    # free refRawAvg global memory
    refRawAvg = []
    refRawAvg = None
    del refRawAvg

    # free antRAAvg global memory
    antRAAvg = []
    antRAAvg = None
    del antRAAvg

    # free antRABaseline global memory
    antRABaseline = []
    antRABaseline = None
    del antRABaseline

    # free antXTVAvg global memory
    antXTVAvg = []
    antXTVAvg = None
    del antXTVAvg

    # Global arrays remaining: dataTimeUtc, antXTV, ezConOut

    # save frequency spectrum of each qualifing sample
    writeFileGalRaDecNear() # save qualifing frequency spectra to RGal.npz (inside RaDecNearNearL span)

    writeFileGal()      # save qualifing frequency spectra to Gal.npz (parallel to Galactic plane)
                        # creates fileGalWriteName like 2021_333_00.radGal.npz, velGLonP180,
                        #   velGLonP180Count, velGLonP180CountSum, galDecP90GLonP180Count

    writeFileGLon()     # save qualifing frequency spectra to GLon.npz (perpendicular to Galactic plane)

    # free antXTVT global memory
    antXTVT = []
    antXTVT = None
    del antXTVT

    plotEzCon510velGLon()
    plotEzCon519velGLonCount()          # creates ezCon519velGLonCount.txt

    plotEzCon520velGLonPolar()
    plotEzCon529velGLonPolarCount()

    plotEzCon530galDecGLon()

    plotEzCon541velGLonEdges()          # and plotEzCon550galRot()

    #plotEzCon550galRot()

    plotEzCon690gLonDegByFreqAvg()
    writeFileStudy()

    printGoodbye(startTime)



if __name__== '__main__':
  main()

# python3 ../ezRA/ezCon230623a.py  ~/aaaEzRABase/lto16h/data/2021_285_00.rad.txt -exzConGalCrossingGLatCenter23.4 -exzConGalCrossingGLatCenter-43.4 -exzConGalCrossingGLatCenterL-5.015.0201 -ezConAstroMath 1 -ezRAObsName  LTO16  -ezRAObsLat  40.3  -ezRAObsLon  -105.1  -ezRAObsAmsl  1524 -ezConPlotRangeL 191 191

# python3 ../ezRA/ezCon230625a.py  ~/aaaEzRABase/lto16h/data/2021_285_00.rad.txt -exzConGalCrossingGLatCenter23 -exzConGalCrossingGLatCenter-43 -ezConGalCrossingGLonCenterL -5 16 -ezConAstroMath 1 -ezRAObsName  LTO16  -ezRAObsLat  40.3  -ezRAObsLon  -105.1  -ezRAObsAmsl  1524 -ezConPlotRangeL 191 191

# ls -lhtr

# python3 ../ezRA/ezCon230629a.py  /home/a/aaaEzRABase/lto16h/data/2021_171_00.rad.txt  -ezConAstroMath  1  -ezRAObsName  LTO16  -ezRAObsLat  40.3  -ezRAObsLon  -105.1  -ezRAObsAmsl  1524  -ezConPlotRangeL  191  191  -ezConRawFreqBinHide  91

# cat  ezCon240613a.py | grep 'def ' > ezConDef.txt

# a@u22-221222a:~/ezRABase/lto16h$
# python3 ../ezRA/ezCon241021a.py  data/2021_200_00.rad.txt  -ezConPlotRangeL 87 87 -ezCon087Csv 1
# ring3d ezCon087antBTVT.csv
# mv graph3d.png ezCon087antBTVTCsv.png

# a@u22-221222a:~/ezRABase/ifAvgEzCon087csv$
# python3  ../ezRA/ezCon250121a.py  data/2020_124_00.rad.txt  -ezConPlotRangeL 87 87  -ezCon087Csv 2
#  rawLen = 4,546
#  antLen = 2,273
#  refQty = 2,273
#  took 19 seconds = 0.3 minutes



# S:\D5\C\Users\B\Documents\Astronomy\Astronomy Radio\SARA\SARA ezRA\_ezRABase\h1SW>
# py  ..\..\ezCon250121a.py  "LRO-H1(Ptarmigan)_ezCol_SAWB_241003_00_El_54-4_Az_163.txt"  -ezConPlotRangeL 87 87  -ezCon087Csv 2  -ezConUseVlsr 0

# a@u22-221222a:~/ezRABase/hL3d$
# python3  ../ezRA/ezCon250123a.py  data/N0RQV-8230209_00.txt  -ezConAntXTFreqBinsFracL 0 1  -ezConUseVlsr 0  -ezConAntXTVTFreqBinsFracL 0 1  -ezConPlotRangeL 87 87  -ezCon087Csv 1
# ring3d  ezCon087antRBTVTMsh.csv


# S:\D5\C\Users\B\Documents\Astronomy\Astronomy Radio\SARA\SARA ezRA\_ezRABase\hL3d>
# CALL C:\Users\b\Downloads\rinearn_graph_3d_5_6_36b_en\rinearn_graph_3d_5_6_36b_en\bin\ring3d.bat  --config rot.ini  --overwrite  --saveimg rot%~1%.png  --quit  ezGLonAll580.csv

# CALL C:\Users\b\Downloads\rinearn_graph_3d_5_6_36b_en\rinearn_graph_3d_5_6_36b_en\bin\ring3d.bat  ezCon087antRBTVTMsh.csv

# py  ..\..\ezCon250124b.py  data\N0RQV-8230209_00.txt  -ezConUseVlsr 0  -exzConAntXTVTFreqBinsFracL01  -ezConAntXTVTSmooth 1  -ezConPlotRangeL 87 87  -ezCon087Csv 1

# CALL C:\Users\b\Downloads\rinearn_graph_3d_5_6_36b_en\rinearn_graph_3d_5_6_36b_en\bin\ring3d.bat  ezCon087antRBTVTMsh.csv  --config RinearnGraph3DSetting.ini

# python3  ../ezRA/ezCon250302a.py  data/2025_061_00.rad.txt -ezConAntXTFreqBinsFracL 0 1  -ezConAntXTVTFreqBinsFracL 0 1  -ezConPlotRangeL 382 999  -ezConGalRaDecNearNearL 0.8 41.3 1. 1.
# python3  ../ezRA/ezCon250302a.py  data/2025_061_00.rad.txt -ezConAntXTFreqBinsFracL 0 1  -ezConAntXTVTFreqBinsFracL 0 1  -ezConPlotRangeL 382 999  -ezConGalRaDecNearNearL 0.8 41.3 0.1 0.2

# python3  ../ezRA/ezGal250301a.py  *RGal.npz -ezGalPlotRangeL 710 710
# python3  ../ezRA/ezGal250301a.py  *RGal.npz -ezGalPlotRangeL 710 710  -ezGal710LimL -650 250 0.95 1.21


# S:\D5\C\Users\B\Documents\Astronomy\Astronomy Radio\SARA\SARA ezRA\_ezRABase\N0RQV-8>
# py  ..\ezRA\ezCon250326a.py  data\N0RQV-8230209_00.txt  -ezConRawFreqBinHide 128  -ezConAntXTVTFreqBinsFracL 0.35 0.65  -ezConAntXTVTSmooth 2  -ezConPlotRangeL 87 109

# S:\D5\C\Users\B\Documents\Astronomy\Astronomy Radio\SARA\SARA ezRA\_ezRABase\ezColS-LTO15>py  ..\..\ezCon251106a.py  data\LTO15ez251108_05e.txt  -ezConInputdB 1  -ezConRefMode30L 1420.405  1416.405  2.4  -ezConPlotRangeL 300 400

# a@LTO15a:~/ezRABase/ezColS$ python3  ../ezRA/ezCon251111a.py  -ezConInputdB 1  data/LTO15ez251111_05.txt  data/LTO15ez251112_00.txt  -exdata/LTO15ez251110_00.txt  -exdata/LTO15ez251103_00.txt  -exzConRefMode30L-1420.405-1416.405-2 -ezConPlotRangeL 0 9100  -ezConPlotRangeL 191 191  -ezConAntXTFreqBinsFracL .45 .55                                   -exzConAntFreqBinHideL1-120  -ezConAntXInput 4  -ezConAntXTVTAvgPluckValL 1.05 999   && python3  ../ezRA/ezSky251010b.py  -ezSkyInput  14  LTO15ez251112_00.ezb  && python3  ../ezRA/ezSky251010b.py  -ezSkyInput  18  LTO15ez251112_00.ezb 

# 251111 finally, some hydrogen from my SDRplay RSP2 with LTO15 and resistor, but very weak and very noisey:
# a@LTO15a:~/ezRABase/ezColS$ python3  ../ezRA/ezCon251111a.py  -ezConInputdB 1  data/LTO15ez251111_05.txt  data/LTO15ez251112_00.txt  -exdata/LTO15ez251110_00.txt  -exdata/LTO15ez251103_00.txt  -exzConRefMode30L-1420.405-1416.405-2 -ezConPlotRangeL 0 9100  -ezConPlotRangeL 191 191  -ezConAntXTFreqBinsFracL .45 .55                                   -exzConAntFreqBinHideL1-120  -ezConAntXInput 4  -ezConAntXTVTMaxPluckValL 1.05 999    && python3  ../ezRA/ezSky251010b.py  -ezSkyInput  19  LTO15ez251112_00.ezb     # && python3  ../ezRA/ezSky251010b.py  -ezSkyInput  18  LTO15ez251112_00.ezb 

# ... from
#a          99817   99791 89 Nov11 pts/0    21:02:35 python3 ../ezRA/ezColS251110aP.py -ezColBandWidth 5 -ezColReadBinQtyBits 8 -ezColFreqBinQtyBits 8 -ezColReadBinMin 0 -ezColUsbRelay 21 -ezColBiasTeeOn 0 -ezColSampleRate 10 -ezColCenterFreqAnt 1420.405 -exzColCenterFreqRef1418.405 -ezColGain 1 -ezColYLimL 0 1 -ezColIntegQty 1e6

# S:\D5\C\Users\B\Documents\Astronomy\Astronomy Radio\SARA\SARA ezRA\_ezRABase\dses>py  ..\..\ezCon251111a.py  -ezConInputdB 1  data\defaultKS251110_20b.txt  data\defaultKS251111_00.txt  data\defaultKS251112_00.txt  -exdata\LTO15ez251103_00.txt  -exzConRefMode30L-1420.405-1416.405-2 -ezConPlotRangeL 0 9100  -ezConPlotRangeL 191 191  -ezConAntXTFreqBinsFracL .5 1  -ezConAntXTVTFreqBinsFracL .5 1  -exzConAntFreqBinHideL1-120  -exzConAntXInput4  -exzConAntXTVTMaxPluckValL    # py  ..\..\ezSky251010b.py  -ezSkyInput  18  defaultKS251112_00.ezb         

# S:\D5\C\Users\B\Documents\Astronomy\Astronomy Radio\SARA\SARA ezRA\_ezRABase\ezColS-Andy>py  ..\..\ezCon251111a.py  -ezRAObsLat 52.7  -ezRAObsLon -1.8  -ezRAObsAmsl 81.0  -ezRAObsName LRO-H2  -ezConInputdB 1  data\LRO-H2_RSPduo_BandW8M_SampleR10_251114_21.txt   data\LRO-H2_RSPduo_BandW8M_SampleR10_251115_00.txt   data\LRO-H2_RSPduo_BandW8M_SampleR10_251116_00.txt  -ezConRefMode30L 1420.405 1416.405 2  -ezConAntXTFreqBinsFracL 0 .4  -ezConPlotRangeL 191 191





# 251116a LTO15

# a@u22-221222a:~/ezRABase/ezColS$ python3  ../ezRA/ezFix.py  -RT  R    data/LTO15ez251115_05f.txt  # data/LTO15ez251116_00.txt  data/LTO15ez251117_00.txt 
# a@u22-221222a:~/ezRABase/ezColS$ python3  ../ezRA/ezFix.py  -RT  R    data/LTO15ez251116_00.txt 
# a@u22-221222a:~/ezRABase/ezColS$ python3  ../ezRA/ezFix.py  -RT  R    data/LTO15ez251117_00.txt 

# a@u22-221222a:~/ezRABase/ezColS$ python3  ../ezRA/ezCon251116a.py  -exzRAObsLat52.7  -exzRAObsLon-1.8  -exzRAObsAmsl81.0  -exzRAObsNameLRO-H2  -ezConInputdB 1  -ezConAntXInput 4  data/LTO15ez251115_05fb.txt  data/LTO15ez251116_00b.txt  data/LTO15ez251117_00b.txt  -ezConRefMode30L 1420.405 1416.405 2  -ezConAntXTFreqBinsFracL .2 .5  -ezConAntXTVTFreqBinsFracL 0 1   -ezConPlotRangeL 0 400 

# a@u22-221222a:~/ezRABase/ezColS$ python3  ../ezRA/ezSky251010b.py  LTO15ez251117_00b.ezb   -ezSkyPlotRangeL 0 400  -ezSkyInput 19


# S:\D5\C\Users\B\Documents\Astronomy\Astronomy Radio\SARA\SARA ezRA\_ezRABase\ezColS-LTO15>py  ..\..\ezCon251117c.py  -exzRAObsLat52.7  -exzRAObsLon-1.8  -exzRAObsAmsl81.0  -exzRAObsNameLRO-H2  -ezConInputdB 1  -ezConAntXInput 4  data\LTO15ez251115_05fb.txt  data\LTO15ez251116_00b.txt  data\LTO15ez251117_00b.txt  -ezConRefMode30L 1420.405 1416.405 2  -ezConAntXTFreqBinsFracL 0 1  -ezConAntXTVTFreqBinsFracL 0 1   -ezConPlotRangeL 0 400 -ezConRawFreqTrimL 0 1419.7  -ezConRawFreqTrimL 1420.405 9999




#  py  ..\..\ezCon251117c.py  -ezRAObsLat 52.7  -ezRAObsLon -1.8  -ezRAObsAmsl 81.0  -ezRAObsName LRO-H2  -ezConInputdB 1  data\LRO-H2_RSPduo_BandW8M_SampleR10_251114_21.txt  data\LRO-H2_RSPduo_BandW8M_SampleR10_251115_00.txt  data\LRO-H2_RSPduo_BandW8M_SampleR10_251116_00.txt  -ezConAntXInput 4  -ezConAntFreqBinHide 256  -ezConAntFreqBinHide 257  -ezConRefMode30L 1420.405 1418.405 2  -ezConAntFreqBinHideL 512 1022  -ezConAntXTFreqBinsFracL .1 .35  -ezConAntXTFreqBinsFracL 0 1  -ezConPlotRangeL 0 400

# a@u22-221222a:~/ezRABase/ezColS$ python3  ../ezRA/ezCon251123a.py  -exzRAObsLat52.7-ezRAObsLon-1.8-ezRAObsAmsl81.0  -ezRAObsName N0RQV-GD  -ezConAzDeg 180 -ezConInputdB 1  data/N0RQV251122_22b.txt data/N0RQV251123_00.txt data/N0RQV251124_00.txt  -ezConAntXInput 4  -exzConAntFreqBinHide256-ezConAntFreqBinHide257  -ezConRefMode30L 1420.405 1418.405 2  -exzConAntFreqBinHideL512-1022-ezConAntXTFreqBinsFracL.1.35  -ezConAntXTFreqBinsFracL 0 1  -ezConAntXTVTFreqBinsFracL 0 1  -ezConPlotRangeL 0 400

# python3 ../ezRA/ezCon251123a.py -exzRAObsLat52.7-ezRAObsLon-1.8-ezRAObsAmsl81.0 -ezRAObsName N0RQV-GD -ezConAzDeg 170 -ezConInputdB 1 data/LTO15ez251121_00.txt data/LTO15ez251122_00.txt -ezConAntXInput 4 -exzConAntFreqBinHide256-ezConAntFreqBinHide257 -ezConRefMode30L 1420.405 1418.405 2 -exzConAntFreqBinHideL512-1022-ezConAntXTFreqBinsFracL.1.35 -ezConAntXTFreqBinsFracL 0 1 -ezConAntXTVTFreqBinsFracL 0 1 -ezConPlotRangeL 0 99999

# What Does Apollo 11 Look Like Through A Telescope? ... https://www.youtube.com/watch?v=TNT7SBm7mFk



# a@u22-221222a:~/ezRABase/StephenArbogast$ python3  ../ezRA/ezFix.py  -RT  R  data/Durango260106_00.txt  

#    ../ezRA/ezCon260107a.py data/Durango260105_18b.txt data/Durango260106_00b.txt -exzConRawSamplesUseL100-300 -ezConInputdB 1 -exzConRefMode -ex-1959-31 -ezConRefMode31 11.5 -ezConAntXTFreqBinsFracL 0.37 0.66 -ezConUseVlsr 1 -exzConUseRefSub0 -exzConAntXTVTClipL1.2-999 -ezConAntXInput 6 -exzConAntFreqBinHideL467-475 -ezConRawFreqBinHideL 467 475 -exzConRawFreqBinTrimL469-473-1.5151636743686142e-08 -exzConAntXTVTAvgPluckValL0.95-9999 -ezConAntXTVTClipL 1.3 999 -ezConPlotRangeL 80 100

 # python3  ../ezRA/ezCon260108a.py  data/Durango260105_18b.txt data/Durango260106_00b.txt  -exzConRawSamplesUseL100-300  -ezConInputdB 1  -exzConRefMode  -ezzConRefMode-1609 -ex-1959-31  -exzConRefMode30L1419.8-1421-1.  -ezConRefMode31 11.5  -ezConAntXTFreqBinsFracL 0.37 0.66  -ezConUseVlsr 1  -exzConUseRefSub0  -ezConAntXTVTClipL 1.5 999  -ezConAntXInput 6  -exzConAntFreqBinHideL467-475  -ezConRawFreqBinHideL 465 477  -exzConRawFreqBinTrimL469-473-1.5151636743686142e-08   -exzConAntXTVTAvgPluckValL0.95-9999  -ezConAntXTVTFreqBinsClipL 409 614  -exzConAntXTVTClipL1.3-999  -ezCon087Csv 1   -ezConPlotRangeL  87 87     # -ezConPlotRangeL 0 100  -ezConPlotRangeL 300 400    #300 400  #  #380 380 #400 #92 393 #87 87  #391 391 -h

# ring3d ezCon087antRBTVTMsh.csv

# a@u22-221222a:~/ezRABase/StephenArbogast$ python3  ../ezRA/ezCon260112b.py  data/Durango260105_18b.txt data/Durango260106_00b.txt  -exzConRawSamplesUseL100-300  -ezConInputdB 1  -exzConRefMode  -ezzConRefMode-1609 -ex-1959-31  -exzConRefMode30L1419.8-1421-1.  -ezConRefMode31 11.5  -ezConAntXTFreqBinsFracL 0.37 0.66  -ezConUseVlsr 1  -exzConUseRefSub0  -ezConAntXTVTClipL 1.5 999  -ezConAntXInput 6  -exzConAntFreqBinHideL467-475  -ezConRawFreqBinHideL 465 477  -exzConRawFreqBinTrimL469-473-1.5151636743686142e-08   -exzConAntXTVTAvgPluckValL0.95-9999  -ezConAntXTVTFreqBinsClipL 409 614  -exzConAntXTVTClipL1.3-999  -exzCon087Csv1  -ezConAntXTVTIntegrate 4       -ezConPlotRangeL  89 100    # 400 999    #  -ezConPlotRangeL 0 400  #  -ezConPlotRangeL 300 400    #300 400  #  #380 380 #400 #92 393 #87 87  #391 391 -h

# testing -ezConAntXTVTIntegrate, ezCon089
# a@u22-221222a:~/ezRABase/lto16h$ python3  ../ezRA/ezCon260114a.py  data/2021_360_00.rad.txt  data/2021_361_00.rad.txt  data/2021_362_00.rad.txt  data/2021_363_00.rad.txt   -exzConRawSamplesUseL100-300  -exzConInputdB1  -exzConRefMode  -exzConRefMode-1609 -ex-1959-31  -exzConRefMode30L1419.8-1421-1.  -ezConRefMode31 11.5  -exzConAntXTFreqBinsFracL0.37-0.66  -exzConUseVlsr1  -exzConUseRefSub0  -ezConAntXTVTClipL 1.2 999  -ezConAntXInput 6  -exzConAntFreqBinHideL467-475  -exzConRawFreqBinHideL465-477  -exzConRawFreqBinTrimL469-473-1.5151636743686142e-08   -exzConAntXTVTAvgPluckValL0.95-9999  -ezConAntXTVTFreqBinsClipL 64 192 -ex409-614  -exzConAntXTVTClipL1.3-999  -exzCon087Csv1  -ezConAntXTVTIntegrate 1       -ezConPlotRangeL  85 100    # 400 999    #  -ezConPlotRangeL 0 400  #  -ezConPlotRangeL 300 400    #300 400  #  #380 380 #400 #92 393 #87 87  #391 391 -h^C


# S:\D5\C\Users\B\Documents\Astronomy\Astronomy Radio\SARA\SARA ezRA\_ezRABase\RobertMeade>py  ..\..\ezCon260114a.py  data\DSDI_1420MHz_2048Ksps_FN20gf_70Alt_180Az_2026-01-03_22.18.36Z_data1_cu4_5_minute_avg_ezRA.txt  -exzConRawFreqBinTrimL0-512-60  -exzConRawFreqBinTrimL530-9999-60  -exzConInputdB1  -exzConHeatVMinMaxL1-4  -exzConRefMode30L1420.5-1420.5-1  -exzConRefMode-1 -ex31-11.5  -ezConAntXInput 6  -ezConAntXTFreqBinsFracL 0.5 1  -ezConAntXTVTFreqBinsFracL 0 1  -exzConAntXTVTFreqBinsClipL512-900  -exzConRawSamplesUseL  -exzConAntXTVTMaxPluckValL0-3  -ezConPlotRangeL 200 240   #87 87    # 67 200   -ezConRawSamplesUseL 0 104  -ezConRawSamplesUseL 141 9999

# python3  ../ezRA/ezCon260115a.py  data/DSDI_1420MHz_2048Ksps_FN20gf_70Alt_180Az_2026-01-03_22.18.36Z_data1_cu4_5_minute_avg_ezRA.txt  -exzConRawFreqBinTrimL0-512-60  -exzConRawFreqBinTrimL530-9999-60  -exzConInputdB1  -exzConHeatVMinMaxL1-4  -exzConRefMode30L1420.5-1420.5-1  -ezConRefMode -141 -ex31-11.5  -ezConAntXInput 6  -ezConAntXTFreqBinsFracL 0.55 0.85  -ezConAntXTVTFreqBinsFracL 0 1  -exzConAntXTVTFreqBinsClipL512-900  -exzConRawSamplesUseL  -ezConAntMaxPluckValL 0 87   -ezConAntXTVTAvgPluckQtyL 0 1    -ezConAntXTVTClipL 1.5 999   -ezConPlotRangeL 100 400   # 0 400   #87 87    # 67 200   -ezConRawSamplesUseL 0 104  -ezConRawSamplesUseL 141 9999

# py   ..\..\ezPlotly260214a.py  data -ezCon087Csv 4 -ezConPlotRangeL 87 87
# py   ..\..\ezPlotly260214a.py  -h
